/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.TestKt;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\u0007"}, d2={"Lorg/openrewrite/java/tree/WhileLoopTest;", "", "statementTerminatorForSingleLineWhileLoops", "", "jp", "Lorg/openrewrite/java/JavaParser;", "whileLoop", "rewrite-test"})
public interface WhileLoopTest {
    @Test
    public void whileLoop(@NotNull JavaParser var1);

    @Test
    public void statementTerminatorForSingleLineWhileLoops(@NotNull JavaParser var1);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void whileLoop(WhileLoopTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            public class A {\n                public void test() {\n                    while ( true ) { }\n                }\n            }\n        "}).get(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Statement statement = TestKt.firstMethodStatement(compilationUnit);
            if (statement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.WhileLoop");
            }
            J.WhileLoop whileLoop = (J.WhileLoop)statement;
            J.Parentheses parentheses2 = whileLoop.getCondition();
            Intrinsics.checkExpressionValueIsNotNull((Object)parentheses2, (String)"whileLoop.condition");
            Assertions.assertTrue((boolean)(parentheses2.getTree() instanceof J.Literal));
            Assertions.assertTrue((boolean)(whileLoop.getBody() instanceof J.Block));
            Assertions.assertEquals((Object)"while ( true ) { }", (Object)whileLoop.printTrimmed());
        }

        @Test
        public static void statementTerminatorForSingleLineWhileLoops(WhileLoopTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            public class A {\n                public void test() {\n                    while(true) test();\n                }\n            }\n        "}).get(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"a.classes[0]");
            Object e2 = ((J.ClassDecl)e).getMethods().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e2, (String)"a.classes[0].methods[0]");
            J.Block block = ((J.MethodDecl)e2).getBody();
            if (block == null) {
                Intrinsics.throwNpe();
            }
            Object e3 = block.getStatements().get(0);
            if (e3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.WhileLoop");
            }
            J.WhileLoop forLoop = (J.WhileLoop)e3;
            Assertions.assertEquals((Object)"while(true) test();", (Object)forLoop.printTrimmed());
        }
    }
}

