/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.TestKt;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\b"}, d2={"Lorg/openrewrite/java/tree/ReturnTest;", "", "format", "", "jp", "Lorg/openrewrite/java/JavaParser;", "returnValue", "returnVoid", "rewrite-test"})
public interface ReturnTest {
    @Test
    public void returnValue(@NotNull JavaParser var1);

    @Test
    public void returnVoid(@NotNull JavaParser var1);

    @Test
    public void format(@NotNull JavaParser var1);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void returnValue(ReturnTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            public class A {\n                public String test() {\n                    return \"\";\n                }\n            }\n        "}).get(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Statement statement = TestKt.firstMethodStatement(compilationUnit);
            if (statement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Return");
            }
            J.Return rtn = (J.Return)statement;
            Assertions.assertTrue((boolean)(rtn.getExpr() instanceof J.Literal));
        }

        @Test
        public static void returnVoid(ReturnTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            public class A {\n                public void test() {\n                    return;\n                }\n            }\n        "}).get(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Statement statement = TestKt.firstMethodStatement(compilationUnit);
            if (statement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Return");
            }
            J.Return rtn = (J.Return)statement;
            Assertions.assertNull((Object)rtn.getExpr());
        }

        @Test
        public static void format(ReturnTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            public class A {\n                public int test() {\n                    return 0;\n                }\n            }\n        "}).get(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Statement statement = TestKt.firstMethodStatement(compilationUnit);
            if (statement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Return");
            }
            J.Return rtn = (J.Return)statement;
            Assertions.assertEquals((Object)"return 0", (Object)rtn.printTrimmed());
        }
    }
}

