/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.TestKt;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.LiteralTest;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\u0011"}, d2={"Lorg/openrewrite/java/tree/LiteralTest;", "", "escapedCharacter", "", "jp", "Lorg/openrewrite/java/JavaParser;", "escapedString", "literalBinary", "literalCharacter", "literalField", "literalHex", "literalNumerics", "literalOctal", "nullLiteral", "transformLong", "transformString", "variationInSuffixCasing", "rewrite-test"})
public interface LiteralTest {
    @Test
    public void literalField(@NotNull JavaParser var1);

    @Test
    public void literalCharacter(@NotNull JavaParser var1);

    @Test
    public void literalNumerics(@NotNull JavaParser var1);

    @Test
    public void literalOctal(@NotNull JavaParser var1);

    @Test
    public void literalBinary(@NotNull JavaParser var1);

    @Test
    public void literalHex(@NotNull JavaParser var1);

    @Test
    public void transformString(@NotNull JavaParser var1);

    @Test
    public void nullLiteral(@NotNull JavaParser var1);

    @Test
    public void transformLong(@NotNull JavaParser var1);

    @Test
    public void variationInSuffixCasing(@NotNull JavaParser var1);

    @Test
    public void escapedString(@NotNull JavaParser var1);

    @Test
    public void escapedCharacter(@NotNull JavaParser var1);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void literalField(LiteralTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            public class A {\n                int n = 0;\n            }\n        "}).get(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"a.classes[0]");
            Object e2 = ((J.ClassDecl)e).getFields().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e2, (String)"a.classes[0].fields[0]");
            Object e3 = ((J.VariableDecls)e2).getVars().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e3, (String)"a.classes[0].fields[0].vars[0]");
            Expression expression = ((J.VariableDecls.NamedVar)e3).getInitializer();
            if (expression == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Literal");
            }
            J.Literal literal = (J.Literal)expression;
            Assertions.assertEquals((Object)0, (Object)literal.getValue());
            Assertions.assertEquals((Object)JavaType.Primitive.Int, (Object)literal.getType());
            Assertions.assertEquals((Object)"0", (Object)literal.printTrimmed());
        }

        @Test
        public static void literalCharacter(LiteralTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            public class A {\n                char c = 'a';\n            }\n        "}).get(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"a.classes[0]");
            Object e2 = ((J.ClassDecl)e).getFields().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e2, (String)"a.classes[0].fields[0]");
            Object e3 = ((J.VariableDecls)e2).getVars().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e3, (String)"a.classes[0].fields[0].vars[0]");
            Expression expression = ((J.VariableDecls.NamedVar)e3).getInitializer();
            if (expression == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Literal");
            }
            J.Literal literal = (J.Literal)expression;
            Assertions.assertEquals((Object)Character.valueOf('a'), (Object)literal.getValue());
            Assertions.assertEquals((Object)JavaType.Primitive.Char, (Object)literal.getType());
            Assertions.assertEquals((Object)"'a'", (Object)literal.printTrimmed());
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void literalNumerics(LiteralTest $this, @NotNull JavaParser jp) {
            void l1;
            void d2;
            void d1;
            List list;
            void $this$mapTo$iv$iv;
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            public class A {\n                double d1 = 1.0d;\n                double d2 = 1.0;\n                long l1 = 1L;\n                long l2 = 1;\n            }\n        "}).get(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            int n = 0;
            Iterable $this$map$iv = TestKt.fields(compilationUnit, new IntRange(n, 3));
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                J.VariableDecls variableDecls = (J.VariableDecls)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void v1 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
                Object e = v1.getVars().get(0);
                Intrinsics.checkExpressionValueIsNotNull(e, (String)"it.vars[0]");
                Expression expression = ((J.VariableDecls.NamedVar)e).getInitializer();
                if (expression == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Literal");
                }
                J.Literal literal = (J.Literal)expression;
                collection.add(literal);
            }
            List list2 = list = (List)destination$iv$iv;
            boolean bl = false;
            J.Literal literal = (J.Literal)list2.get(0);
            list2 = list;
            bl = false;
            J.Literal literal2 = (J.Literal)list2.get(1);
            list2 = list;
            bl = false;
            J.Literal literal3 = (J.Literal)list2.get(2);
            list2 = list;
            bl = false;
            J.Literal l2 = (J.Literal)list2.get(3);
            Assertions.assertEquals((Object)"1.0d", (Object)d1.printTrimmed());
            Assertions.assertEquals((Object)"1.0", (Object)d2.printTrimmed());
            Assertions.assertEquals((Object)"1L", (Object)l1.printTrimmed());
            Assertions.assertEquals((Object)"1", (Object)l2.printTrimmed());
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void literalOctal(LiteralTest $this, @NotNull JavaParser jp) {
            void $this$mapTo$iv$iv;
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            public class A {\n                long l = 01L;\n                byte b = 01;\n                short s = 01;\n                int i = 01;\n                double d = 01;\n                float f = 01;\n            }\n        "}).get(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            int n = 0;
            Iterable $this$map$iv = TestKt.fields(compilationUnit, new IntRange(n, 5));
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                J.VariableDecls variableDecls = (J.VariableDecls)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void v1 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
                Object e = v1.getVars().get(0);
                Intrinsics.checkExpressionValueIsNotNull(e, (String)"it.vars[0]");
                Expression expression = ((J.VariableDecls.NamedVar)e).getInitializer();
                if (expression == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Literal");
                }
                J.Literal literal = (J.Literal)expression;
                collection.add(literal);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                J.Literal it = (J.Literal)element$iv;
                boolean bl = false;
                String string = it.printTrimmed();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.printTrimmed()");
                Assertions.assertEquals((Object)"01", (Object)StringsKt.trimEnd((String)string, (char[])new char[]{'L'}), (String)("expected octal notation for " + it.getType()));
            }
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void literalBinary(LiteralTest $this, @NotNull JavaParser jp) {
            void $this$mapTo$iv$iv;
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            public class A {\n                long l = 0b10L;\n                byte b = 0b10;\n                short s = 0b10;\n                int i = 0b10;\n            }\n        "}).get(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            int n = 0;
            Iterable $this$map$iv = TestKt.fields(compilationUnit, new IntRange(n, 3));
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                J.VariableDecls variableDecls = (J.VariableDecls)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void v1 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
                Object e = v1.getVars().get(0);
                Intrinsics.checkExpressionValueIsNotNull(e, (String)"it.vars[0]");
                Expression expression = ((J.VariableDecls.NamedVar)e).getInitializer();
                if (expression == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Literal");
                }
                J.Literal literal = (J.Literal)expression;
                collection.add(literal);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                J.Literal it = (J.Literal)element$iv;
                boolean bl = false;
                String string = it.printTrimmed();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.printTrimmed()");
                Assertions.assertEquals((Object)"0b10", (Object)StringsKt.trimEnd((String)string, (char[])new char[]{'L'}), (String)("expected binary notation for " + it.getType()));
            }
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void literalHex(LiteralTest $this, @NotNull JavaParser jp) {
            void $this$mapTo$iv$iv;
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            public class A {\n                long l = 0xA0L;\n                byte b = 0xA0;\n                short s = 0xA0;\n                int i = 0xA0;\n            }\n        "}).get(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            int n = 0;
            Iterable $this$map$iv = TestKt.fields(compilationUnit, new IntRange(n, 3));
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                J.VariableDecls variableDecls = (J.VariableDecls)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void v1 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
                Object e = v1.getVars().get(0);
                Intrinsics.checkExpressionValueIsNotNull(e, (String)"it.vars[0]");
                Expression expression = ((J.VariableDecls.NamedVar)e).getInitializer();
                if (expression == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Literal");
                }
                J.Literal literal = (J.Literal)expression;
                collection.add(literal);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                J.Literal it = (J.Literal)element$iv;
                boolean bl = false;
                String string = it.printTrimmed();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.printTrimmed()");
                Assertions.assertEquals((Object)"0xA0", (Object)StringsKt.trimEnd((String)string, (char[])new char[]{'L'}), (String)("expected hex notation for " + it.getType()));
            }
        }

        @Test
        public static void transformString(LiteralTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            public class A {\n                String s = \"foo ''\";\n            }\n        "}).get(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"a.classes[0]");
            Object e2 = ((J.ClassDecl)e).getFields().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e2, (String)"a.classes[0].fields[0]");
            Object e3 = ((J.VariableDecls)e2).getVars().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e3, (String)"a.classes[0].fields[0].vars[0]");
            Expression expression = ((J.VariableDecls.NamedVar)e3).getInitializer();
            if (expression == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Literal");
            }
            J.Literal literal = (J.Literal)expression;
            Assertions.assertEquals((Object)"\"foo\"", (Object)literal.transformValue((Function)transformString.1.INSTANCE));
        }

        @Test
        public static void nullLiteral(LiteralTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            public class A {\n                String s = null;\n            }\n        "}).get(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"a.classes[0]");
            Object e2 = ((J.ClassDecl)e).getFields().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e2, (String)"a.classes[0].fields[0]");
            Object e3 = ((J.VariableDecls)e2).getVars().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e3, (String)"a.classes[0].fields[0].vars[0]");
            Expression expression = ((J.VariableDecls.NamedVar)e3).getInitializer();
            Assertions.assertEquals((Object)"null", (Object)(expression != null ? expression.printTrimmed() : null));
        }

        @Test
        public static void transformLong(LiteralTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            public class A {\n                Long l = 2L;\n            }\n        "}).get(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"a.classes[0]");
            Object e2 = ((J.ClassDecl)e).getFields().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e2, (String)"a.classes[0].fields[0]");
            Object e3 = ((J.VariableDecls)e2).getVars().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e3, (String)"a.classes[0].fields[0].vars[0]");
            Expression expression = ((J.VariableDecls.NamedVar)e3).getInitializer();
            if (expression == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Literal");
            }
            J.Literal literal = (J.Literal)expression;
            Assertions.assertEquals((Object)"4L", (Object)literal.transformValue((Function)transformLong.1.INSTANCE));
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void variationInSuffixCasing(LiteralTest $this, @NotNull JavaParser jp) {
            void lower;
            List list;
            void $this$mapTo$iv$iv;
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            public class A {\n                Long l = 0l;\n                Long m = 0L;\n            }\n        "}).get(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            int n = 0;
            Iterable $this$map$iv = TestKt.fields(compilationUnit, new IntRange(n, 1));
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                J.VariableDecls variableDecls = (J.VariableDecls)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void v1 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
                Object e = v1.getVars().get(0);
                Intrinsics.checkExpressionValueIsNotNull(e, (String)"it.vars[0]");
                Expression expression = ((J.VariableDecls.NamedVar)e).getInitializer();
                if (expression == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Literal");
                }
                J.Literal literal = (J.Literal)expression;
                collection.add(literal);
            }
            List list2 = list = (List)destination$iv$iv;
            boolean bl = false;
            J.Literal literal = (J.Literal)list2.get(0);
            list2 = list;
            bl = false;
            J.Literal upper = (J.Literal)list2.get(1);
            Assertions.assertEquals((Object)"0L", (Object)upper.printTrimmed());
            Assertions.assertEquals((Object)"0l", (Object)lower.printTrimmed());
        }

        @Test
        public static void escapedString(LiteralTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            public class A {\n                String s = \"\\\"\";\n            }\n        "}).get(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"a.classes[0]");
            Object e2 = ((J.ClassDecl)e).getFields().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e2, (String)"a.classes[0].fields[0]");
            Object e3 = ((J.VariableDecls)e2).getVars().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e3, (String)"a.classes[0].fields[0].vars[0]");
            Expression expression = ((J.VariableDecls.NamedVar)e3).getInitializer();
            if (expression == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Literal");
            }
            J.Literal s = (J.Literal)expression;
            Assertions.assertEquals((Object)"\"\\\"\"", (Object)s.printTrimmed());
        }

        @Test
        public static void escapedCharacter(LiteralTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            public class A {\n                char c = '\\'';\n            }\n        "}).get(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"a.classes[0]");
            Object e2 = ((J.ClassDecl)e).getFields().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e2, (String)"a.classes[0].fields[0]");
            Object e3 = ((J.VariableDecls)e2).getVars().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e3, (String)"a.classes[0].fields[0].vars[0]");
            Expression expression = ((J.VariableDecls.NamedVar)e3).getInitializer();
            if (expression == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Literal");
            }
            J.Literal s = (J.Literal)expression;
            Assertions.assertEquals((Object)"'\\''", (Object)s.printTrimmed());
        }
    }
}

