/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Assertions;
import org.openrewrite.Parser;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.TestKt;
import org.openrewrite.java.ChangeType;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.RemoveImport;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\u000f"}, d2={"Lorg/openrewrite/java/RemoveImportTest;", "", "leaveImportIfRemovedTypeIsStillReferredTo", "", "jp", "Lorg/openrewrite/java/JavaParser;", "leaveNamedStaticImportIfReferenceStillExists", "leaveNamedStaticImportOnFieldIfReferenceStillExists", "leaveStarImportInPlaceIfMoreThanTwoTypesStillReferredTo", "leaveStarStaticImportIfReferenceStillExists", "removeImportForChangedMethodArgument", "removeNamedImport", "removeStarImportIfNoTypesReferredTo", "removeStarStaticImport", "replaceStarImportWithNamedImportIfOnlyOneReferencedTypeRemains", "rewrite-test"})
public interface RemoveImportTest {
    @Test
    public void removeNamedImport(@NotNull JavaParser var1);

    @Test
    public void leaveImportIfRemovedTypeIsStillReferredTo(@NotNull JavaParser var1);

    @Test
    public void removeStarImportIfNoTypesReferredTo(@NotNull JavaParser var1);

    @Test
    public void replaceStarImportWithNamedImportIfOnlyOneReferencedTypeRemains(@NotNull JavaParser var1);

    @Test
    public void leaveStarImportInPlaceIfMoreThanTwoTypesStillReferredTo(@NotNull JavaParser var1);

    @Test
    public void removeStarStaticImport(@NotNull JavaParser var1);

    @Test
    public void leaveStarStaticImportIfReferenceStillExists(@NotNull JavaParser var1);

    @Test
    public void leaveNamedStaticImportIfReferenceStillExists(@NotNull JavaParser var1);

    @Test
    public void leaveNamedStaticImportOnFieldIfReferenceStillExists(@NotNull JavaParser var1);

    @Test
    public void removeImportForChangedMethodArgument(@NotNull JavaParser var1);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void removeNamedImport(RemoveImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            RemoveImport removeImport = new RemoveImport();
            Assertions.StringSourceFileAssert stringSourceFileAssert = TestKt.whenParsedBy("\n            import java.util.List;\n            class A {}\n        ", (Parser)jp);
            boolean bl = false;
            boolean bl2 = false;
            RemoveImport $this$apply = removeImport;
            boolean bl3 = false;
            $this$apply.setType("java.util.List");
            RemoveImport removeImport2 = removeImport;
            stringSourceFileAssert.whenVisitedBy((RefactorVisitor)removeImport2).isRefactoredTo("class A {}");
        }

        @Test
        public static void leaveImportIfRemovedTypeIsStillReferredTo(RemoveImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            RemoveImport removeImport = new RemoveImport();
            Assertions.StringSourceFileAssert stringSourceFileAssert = TestKt.whenParsedBy("\n            import java.util.List;\n            class A {\n               List list;\n            }\n        ", (Parser)jp);
            boolean bl = false;
            boolean bl2 = false;
            RemoveImport $this$apply = removeImport;
            boolean bl3 = false;
            $this$apply.setType("java.util.List");
            RemoveImport removeImport2 = removeImport;
            stringSourceFileAssert.whenVisitedBy((RefactorVisitor)removeImport2).isUnchanged();
        }

        @Test
        public static void removeStarImportIfNoTypesReferredTo(RemoveImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            RemoveImport removeImport = new RemoveImport();
            Assertions.StringSourceFileAssert stringSourceFileAssert = TestKt.whenParsedBy("\n            import java.util.*;\n            class A {}\n        ", (Parser)jp);
            boolean bl = false;
            boolean bl2 = false;
            RemoveImport $this$apply = removeImport;
            boolean bl3 = false;
            $this$apply.setType("java.util.List");
            RemoveImport removeImport2 = removeImport;
            stringSourceFileAssert.whenVisitedBy((RefactorVisitor)removeImport2).isRefactoredTo("class A {}");
        }

        @Test
        public static void replaceStarImportWithNamedImportIfOnlyOneReferencedTypeRemains(RemoveImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            RemoveImport removeImport = new RemoveImport();
            Assertions.StringSourceFileAssert stringSourceFileAssert = TestKt.whenParsedBy("\n            import java.util.*;\n            class A {\n               Collection c;\n            }\n        ", (Parser)jp);
            boolean bl = false;
            boolean bl2 = false;
            RemoveImport $this$apply = removeImport;
            boolean bl3 = false;
            $this$apply.setType("java.util.List");
            RemoveImport removeImport2 = removeImport;
            stringSourceFileAssert.whenVisitedBy((RefactorVisitor)removeImport2).isRefactoredTo("\n                    import java.util.Collection;\n                    class A {\n                       Collection c;\n                    }\n                ");
        }

        @Test
        public static void leaveStarImportInPlaceIfMoreThanTwoTypesStillReferredTo(RemoveImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            RemoveImport removeImport = new RemoveImport();
            Assertions.StringSourceFileAssert stringSourceFileAssert = TestKt.whenParsedBy("\n            import java.util.*;\n            class A {\n               Collection c;\n               Set s;\n            }\n        ", (Parser)jp);
            boolean bl = false;
            boolean bl2 = false;
            RemoveImport $this$apply = removeImport;
            boolean bl3 = false;
            $this$apply.setType("java.util.List");
            RemoveImport removeImport2 = removeImport;
            stringSourceFileAssert.whenVisitedBy((RefactorVisitor)removeImport2).isUnchanged();
        }

        @Test
        public static void removeStarStaticImport(RemoveImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            RemoveImport removeImport = new RemoveImport();
            Assertions.StringSourceFileAssert stringSourceFileAssert = TestKt.whenParsedBy("\n            import static java.util.Collections.*;\n            class A {}\n        ", (Parser)jp);
            boolean bl = false;
            boolean bl2 = false;
            RemoveImport $this$apply = removeImport;
            boolean bl3 = false;
            $this$apply.setType("java.util.Collections");
            RemoveImport removeImport2 = removeImport;
            stringSourceFileAssert.whenVisitedBy((RefactorVisitor)removeImport2).isRefactoredTo("class A {}");
        }

        @Test
        public static void leaveStarStaticImportIfReferenceStillExists(RemoveImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            RemoveImport removeImport = new RemoveImport();
            Assertions.StringSourceFileAssert stringSourceFileAssert = TestKt.whenParsedBy("\n            import static java.util.Collections.*;\n            class A {\n               Object o = emptyList();\n            }\n        ", (Parser)jp);
            boolean bl = false;
            boolean bl2 = false;
            RemoveImport $this$apply = removeImport;
            boolean bl3 = false;
            $this$apply.setType("java.util.Collections");
            RemoveImport removeImport2 = removeImport;
            stringSourceFileAssert.whenVisitedBy((RefactorVisitor)removeImport2).isUnchanged();
        }

        @Test
        public static void leaveNamedStaticImportIfReferenceStillExists(RemoveImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            RemoveImport removeImport = new RemoveImport();
            Assertions.StringSourceFileAssert stringSourceFileAssert = TestKt.whenParsedBy("\n            import static java.util.Collections.emptyList;\n            import static java.util.Collections.emptySet;\n            class A {\n               Object o = emptyList();\n            }\n        ", (Parser)jp);
            boolean bl = false;
            boolean bl2 = false;
            RemoveImport $this$apply = removeImport;
            boolean bl3 = false;
            $this$apply.setType("java.util.Collections");
            RemoveImport removeImport2 = removeImport;
            stringSourceFileAssert.whenVisitedBy((RefactorVisitor)removeImport2).isRefactoredTo("\n                    import static java.util.Collections.emptyList;\n                    class A {\n                       Object o = emptyList();\n                    }\n                ");
        }

        @Test
        public static void leaveNamedStaticImportOnFieldIfReferenceStillExists(RemoveImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            RemoveImport removeImport = new RemoveImport();
            Object object = TestKt.whenParsedBy("\n            import static foo.B.STRING;\n            import static foo.B.STRING2;\n            import static foo.C.*;\n            public class A {\n                String a = STRING;\n            }\n        ", (Parser)jp).whichDependsOn("\n                    package foo;\n                    public class B {\n                        public static final String STRING = \"string\";\n                        public static final String STRING2 = \"string2\";\n                    }\n                ").whichDependsOn("\n                    package foo;\n                    public class C {\n                        public static final String ANOTHER = \"string\";\n                    }\n                ");
            boolean bl = false;
            boolean bl2 = false;
            RemoveImport $this$apply = removeImport;
            boolean bl3 = false;
            $this$apply.setType("foo.B");
            RemoveImport removeImport2 = removeImport;
            removeImport = new RemoveImport();
            object = ((Assertions.StringSourceFileAssert)object).whenVisitedBy((RefactorVisitor)removeImport2);
            bl = false;
            bl2 = false;
            $this$apply = removeImport;
            boolean bl4 = false;
            $this$apply.setType("foo.C");
            removeImport2 = removeImport;
            ((Assertions.RefactoringAssert)object).whenVisitedBy((RefactorVisitor)removeImport2).isRefactoredTo("\n                    import static foo.B.STRING;\n                    public class A {\n                        String a = STRING;\n                    }\n                ");
        }

        @Test
        public static void removeImportForChangedMethodArgument(RemoveImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            ChangeType changeType = new ChangeType();
            Assertions.StringSourceFileAssert stringSourceFileAssert = TestKt.whenParsedBy("\n            import b.B;\n            \n            class A {\n                void foo(B arg) {\n                    arg.doSomething();\n                }\n            }\n        ", (Parser)jp).whichDependsOn("\n                    package b;\n                    public interface B {\n                        void doSomething();\n                    }\n                ").whichDependsOn("\n                    package c;\n                    public interface C {\n                        void doSomething();\n                    }\n                ");
            boolean bl = false;
            boolean bl2 = false;
            ChangeType $this$apply = changeType;
            boolean bl3 = false;
            $this$apply.setType("b.B");
            $this$apply.setTargetType("c.C");
            ChangeType changeType2 = changeType;
            stringSourceFileAssert.whenVisitedBy((RefactorVisitor)changeType2).isRefactoredTo("\n                    import c.C;\n                    \n                    class A {\n                        void foo(C arg) {\n                            arg.doSomething();\n                        }\n                    }\n                ");
        }
    }
}

