/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Assertions;
import org.openrewrite.Parser;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.TestKt;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.OrderImports;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\u0013"}, d2={"Lorg/openrewrite/java/OrderImportTest;", "", "blankLineThenEmptyBlockThenNonEmptyBlock", "", "jp", "Lorg/openrewrite/java/JavaParser;", "blankLinesNotFollowedByBlockArentAdded", "foldGroupOfStaticImportsThatAppearLast", "foldIntoExistingStar", "foldIntoStar", "idempotence", "importSorting", "orderImports", "packagePatternEscapesDots", "removeUnused", "springCloudFormat", "twoImportsFollowedByStar", "unfoldStar", "unfoldStaticStar", "rewrite-test"})
public interface OrderImportTest {
    @Test
    public void orderImports(@NotNull JavaParser var1);

    @Test
    public void blankLineThenEmptyBlockThenNonEmptyBlock(@NotNull JavaParser var1);

    @Test
    public void foldIntoStar(@NotNull JavaParser var1);

    @Test
    public void blankLinesNotFollowedByBlockArentAdded(@NotNull JavaParser var1);

    @Test
    public void foldIntoExistingStar(@NotNull JavaParser var1);

    @Test
    public void idempotence(@NotNull JavaParser var1);

    @Test
    public void unfoldStar(@NotNull JavaParser var1);

    @Test
    public void removeUnused(@NotNull JavaParser var1);

    @Test
    public void unfoldStaticStar(@NotNull JavaParser var1);

    @Test
    public void packagePatternEscapesDots(@NotNull JavaParser var1);

    @Test
    public void twoImportsFollowedByStar(@NotNull JavaParser var1);

    @Test
    public void springCloudFormat(@NotNull JavaParser var1);

    @Test
    public void importSorting(@NotNull JavaParser var1);

    @Test
    public void foldGroupOfStaticImportsThatAppearLast(@NotNull JavaParser var1);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void orderImports(OrderImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            OrderImports orderImports = new OrderImports();
            Assertions.StringSourceFileAssert stringSourceFileAssert = TestKt.whenParsedBy("\n            import static java.util.stream.Collectors.joining;\n            import java.util.ArrayList;\n            import java.util.regex.Pattern;\n            import java.util.Objects;\n            import java.util.Set;\n            import org.openrewrite.java.tree.JavaType;\n            import org.openrewrite.java.tree.TypeUtils;\n            \n            class A {}\n        ", (Parser)jp);
            boolean bl = false;
            boolean bl2 = false;
            OrderImports $this$apply = orderImports;
            boolean bl3 = false;
            $this$apply.setRemoveUnused(false);
            OrderImports orderImports2 = orderImports;
            stringSourceFileAssert.whenVisitedBy((RefactorVisitor)orderImports2).isRefactoredTo("import org.openrewrite.java.tree.JavaType;\nimport org.openrewrite.java.tree.TypeUtils;\n\nimport java.util.ArrayList;\nimport java.util.Objects;\nimport java.util.Set;\nimport java.util.regex.Pattern;\n\nimport static java.util.stream.Collectors.joining;\n\nclass A {}");
        }

        @Test
        public static void blankLineThenEmptyBlockThenNonEmptyBlock(OrderImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            OrderImports orderImports = new OrderImports();
            Assertions.StringSourceFileAssert stringSourceFileAssert = TestKt.whenParsedBy("\n            import java.util.ArrayList;\n            import java.util.Objects;\n\n            import org.openrewrite.java.tree.JavaType;\n            \n            class A {}\n        ", (Parser)jp);
            boolean bl = false;
            boolean bl2 = false;
            OrderImports $this$apply = orderImports;
            boolean bl3 = false;
            $this$apply.setRemoveUnused(false);
            OrderImports orderImports2 = orderImports;
            stringSourceFileAssert.whenVisitedBy((RefactorVisitor)orderImports2).isRefactoredTo("\n                    import org.openrewrite.java.tree.JavaType;\n                    \n                    import java.util.ArrayList;\n                    import java.util.Objects;\n                    \n                    class A {}\n                ");
        }

        @Test
        public static void foldIntoStar(OrderImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            OrderImports orderImports = new OrderImports();
            Assertions.StringSourceFileAssert stringSourceFileAssert = TestKt.whenParsedBy("\n            import java.util.List;\n            import java.util.ArrayList;\n            import java.util.regex.Pattern;\n            import java.util.Objects;\n            import java.util.Set;\n            import java.util.Map;\n            \n            class A {}\n        ", (Parser)jp);
            boolean bl = false;
            boolean bl2 = false;
            OrderImports $this$apply = orderImports;
            boolean bl3 = false;
            $this$apply.setRemoveUnused(false);
            OrderImports orderImports2 = orderImports;
            stringSourceFileAssert.whenVisitedBy((RefactorVisitor)orderImports2).isRefactoredTo("\n                    import java.util.*;\n                    import java.util.regex.Pattern;\n                    \n                    class A {}\n                ");
        }

        @Test
        public static void blankLinesNotFollowedByBlockArentAdded(OrderImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            OrderImports orderImports = new OrderImports();
            Assertions.StringSourceFileAssert stringSourceFileAssert = TestKt.whenParsedBy("\n            import java.util.List;\n            \n            import static java.util.Collections.*;\n            \n            class A {}\n        ", (Parser)jp);
            boolean bl = false;
            boolean bl2 = false;
            OrderImports $this$apply = orderImports;
            boolean bl3 = false;
            $this$apply.setRemoveUnused(false);
            OrderImports orderImports2 = orderImports;
            stringSourceFileAssert.whenVisitedBy((RefactorVisitor)orderImports2).isUnchanged();
        }

        @Test
        public static void foldIntoExistingStar(OrderImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            OrderImports orderImports = new OrderImports();
            Assertions.StringSourceFileAssert stringSourceFileAssert = TestKt.whenParsedBy("\n            import java.util.*;\n            import java.util.ArrayList;\n            import java.util.regex.Pattern;\n            import java.util.Objects;\n            \n            class A {}\n        ", (Parser)jp);
            boolean bl = false;
            boolean bl2 = false;
            OrderImports $this$apply = orderImports;
            boolean bl3 = false;
            $this$apply.setRemoveUnused(false);
            OrderImports orderImports2 = orderImports;
            stringSourceFileAssert.whenVisitedBy((RefactorVisitor)orderImports2).isRefactoredTo("\n                    import java.util.*;\n                    import java.util.regex.Pattern;\n                    \n                    class A {}\n                ");
        }

        @Test
        public static void idempotence(OrderImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            OrderImports orderImports = new OrderImports();
            Assertions.StringSourceFileAssert stringSourceFileAssert = TestKt.whenParsedBy("\n            import java.util.*;\n            import java.util.regex.Pattern;\n\n            class A {}\n        ", (Parser)jp);
            boolean bl = false;
            boolean bl2 = false;
            OrderImports $this$apply = orderImports;
            boolean bl3 = false;
            $this$apply.setRemoveUnused(false);
            OrderImports orderImports2 = orderImports;
            stringSourceFileAssert.whenVisitedBy((RefactorVisitor)orderImports2).isUnchanged();
        }

        @Test
        public static void unfoldStar(OrderImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            TestKt.whenParsedBy("\n            import java.util.*;\n            \n            class A {\n                List list;\n                List list2;\n            }\n        ", (Parser)jp).whenVisitedBy((RefactorVisitor)new OrderImports()).isRefactoredTo("\n                    import java.util.List;\n                    \n                    class A {\n                        List list;\n                        List list2;\n                    }\n                ");
        }

        @Test
        public static void removeUnused(OrderImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            TestKt.whenParsedBy("\n            import java.util.*;\n            \n            class A {\n            }\n        ", (Parser)jp).whenVisitedBy((RefactorVisitor)new OrderImports()).isRefactoredTo("\n                    class A {\n                    }\n                ");
        }

        @Test
        public static void unfoldStaticStar(OrderImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            TestKt.whenParsedBy("\n            import java.util.List;\n            \n            import static java.util.Collections.*;\n            \n            class A {\n                List list = emptyList();\n            }\n        ", (Parser)jp).whenVisitedBy((RefactorVisitor)new OrderImports()).isRefactoredTo("\n                    import java.util.List;\n                    \n                    import static java.util.Collections.emptyList;\n                    \n                    class A {\n                        List list = emptyList();\n                    }\n                ");
        }

        @Test
        public static void packagePatternEscapesDots(OrderImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            OrderImports orderImports = new OrderImports();
            Assertions.StringSourceFileAssert stringSourceFileAssert = TestKt.whenParsedBy("\n            import javax.annotation.Nonnull;\n            \n            class A {}\n        ", (Parser)jp);
            boolean bl = false;
            boolean bl2 = false;
            OrderImports $this$apply = orderImports;
            boolean bl3 = false;
            $this$apply.setRemoveUnused(false);
            OrderImports orderImports2 = orderImports;
            stringSourceFileAssert.whenVisitedBy((RefactorVisitor)orderImports2).isUnchanged();
        }

        @Test
        public static void twoImportsFollowedByStar(OrderImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            OrderImports orderImports = new OrderImports();
            Assertions.StringSourceFileAssert stringSourceFileAssert = TestKt.whenParsedBy("\n            import java.io.IOException;\n            import java.io.UncheckedIOException;\n            import java.nio.files.*;\n            \n            class A {}\n        ", (Parser)jp);
            boolean bl = false;
            boolean bl2 = false;
            OrderImports $this$apply = orderImports;
            boolean bl3 = false;
            $this$apply.setRemoveUnused(false);
            OrderImports orderImports2 = orderImports;
            stringSourceFileAssert.whenVisitedBy((RefactorVisitor)orderImports2).isUnchanged();
        }

        @Test
        public static void springCloudFormat(OrderImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            OrderImports orderImports = new OrderImports();
            Assertions.StringSourceFileAssert stringSourceFileAssert = TestKt.whenParsedBy("\n            import java.io.ByteArrayOutputStream;\n            import java.nio.charset.StandardCharsets;\n            import java.util.Collections;\n            import java.util.zip.GZIPOutputStream;\n            \n            import javax.servlet.ReadListener;\n            import javax.servlet.ServletInputStream;\n            import javax.servlet.ServletOutputStream;\n            \n            import com.fasterxml.jackson.databind.ObjectMapper;\n            import org.apache.commons.logging.Log;\n            import reactor.core.publisher.Mono;\n            \n            import org.springframework.core.io.buffer.DataBuffer;\n            import org.springframework.core.io.buffer.DataBufferFactory;\n            import org.springframework.http.HttpHeaders;\n            import org.springframework.util.MultiValueMap;\n            import org.springframework.web.bind.annotation.PathVariable;\n            import org.springframework.web.server.ServerWebExchange;\n            \n            import static java.util.Arrays.stream;\n            import static org.springframework.cloud.gateway.support.ServerWebExchangeUtils.toAsyncPredicate;\n            \n            class A {}\n        ", (Parser)jp);
            boolean bl = false;
            boolean bl2 = false;
            OrderImports $this$apply = orderImports;
            boolean bl3 = false;
            $this$apply.setLayout(OrderImports.Layout.builder((int)999, (int)999).importPackage("java.*").blankLine().importPackage("javax.*").blankLine().importAllOthers().blankLine().importPackage("org.springframework.*").blankLine().importStaticAllOthers().build());
            $this$apply.setRemoveUnused(false);
            OrderImports orderImports2 = orderImports;
            stringSourceFileAssert.whenVisitedBy((RefactorVisitor)orderImports2).isUnchanged();
        }

        @Test
        public static void importSorting(OrderImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            OrderImports orderImports = new OrderImports();
            Assertions.StringSourceFileAssert stringSourceFileAssert = TestKt.whenParsedBy("\n            import r.core.Flux;\n            import s.core.Flux;\n            import com.fasterxml.jackson.databind.ObjectMapper;\n            import org.apache.commons.logging.Log;\n            import reactor.core.publisher.Mono;\n            \n            class A {}\n        ", (Parser)jp);
            boolean bl = false;
            boolean bl2 = false;
            OrderImports $this$apply = orderImports;
            boolean bl3 = false;
            $this$apply.setRemoveUnused(false);
            OrderImports orderImports2 = orderImports;
            stringSourceFileAssert.whenVisitedBy((RefactorVisitor)orderImports2).isRefactoredTo("\n                    import com.fasterxml.jackson.databind.ObjectMapper;\n                    import org.apache.commons.logging.Log;\n                    import r.core.Flux;\n                    import reactor.core.publisher.Mono;\n                    import s.core.Flux;\n                    \n                    class A {}\n                ");
        }

        @Test
        public static void foldGroupOfStaticImportsThatAppearLast(OrderImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            OrderImports orderImports = new OrderImports();
            Assertions.StringSourceFileAssert stringSourceFileAssert = TestKt.whenParsedBy("\n            import static java.util.stream.Collectors.toList;\n            import static java.util.stream.Collectors.toMap;\n            import static java.util.stream.Collectors.toSet;\n            \n            class A {}\n        ", (Parser)jp);
            boolean bl = false;
            boolean bl2 = false;
            OrderImports $this$apply = orderImports;
            boolean bl3 = false;
            $this$apply.setRemoveUnused(false);
            OrderImports orderImports2 = orderImports;
            stringSourceFileAssert.whenVisitedBy((RefactorVisitor)orderImports2).isRefactoredTo("\n                    import static java.util.stream.Collectors.*;\n                    \n                    class A {}\n                ");
        }
    }
}

