/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Assertions;
import org.openrewrite.Parser;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.RefactorVisitorTest;
import org.openrewrite.SourceFile;
import org.openrewrite.TestKt;
import org.openrewrite.java.AddImport;
import org.openrewrite.java.AddImportTest;
import org.openrewrite.java.JavaParser;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\u000e"}, d2={"Lorg/openrewrite/java/AddImportTest;", "Lorg/openrewrite/RefactorVisitorTest;", "addMultipleImports", "", "jp", "Lorg/openrewrite/java/JavaParser;", "addNamedImport", "addNamedImportIfStarStaticImportExists", "addNamedStaticImport", "doNotAddImportIfAlreadyExists", "doNotAddImportIfCoveredByStarImport", "dontAddImportWhenClassHasNoPackage", "importsAddedInAlphabeticalOrder", "namedImportAddedAfterPackageDeclaration", "rewrite-test"})
public interface AddImportTest
extends RefactorVisitorTest {
    @Test
    public void addMultipleImports(@NotNull JavaParser var1);

    @Test
    public void addNamedImport(@NotNull JavaParser var1);

    @Test
    public void namedImportAddedAfterPackageDeclaration(@NotNull JavaParser var1);

    @Test
    public void importsAddedInAlphabeticalOrder(@NotNull JavaParser var1);

    @Test
    public void doNotAddImportIfAlreadyExists(@NotNull JavaParser var1);

    @Test
    public void doNotAddImportIfCoveredByStarImport(@NotNull JavaParser var1);

    @Test
    public void addNamedImportIfStarStaticImportExists(@NotNull JavaParser var1);

    @Test
    public void addNamedStaticImport(@NotNull JavaParser var1);

    @Test
    public void dontAddImportWhenClassHasNoPackage(@NotNull JavaParser var1);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void addMultipleImports(AddImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            AddImport addImport = new AddImport();
            Object object = TestKt.whenParsedBy("class A {}", (Parser)jp);
            boolean bl = false;
            boolean bl2 = false;
            AddImport $this$apply = addImport;
            boolean bl3 = false;
            $this$apply.setType("java.util.List");
            $this$apply.setOnlyIfReferenced(false);
            AddImport addImport2 = addImport;
            addImport = new AddImport();
            object = ((Assertions.StringSourceFileAssert)object).whenVisitedBy((RefactorVisitor)addImport2);
            bl = false;
            bl2 = false;
            $this$apply = addImport;
            boolean bl4 = false;
            $this$apply.setType("java.util.Set");
            $this$apply.setOnlyIfReferenced(false);
            addImport2 = addImport;
            ((Assertions.RefactoringAssert)object).whenVisitedBy((RefactorVisitor)addImport2).isRefactoredTo("\n                    import java.util.List;\n                    import java.util.Set;\n                    \n                    class A {}\n                ");
        }

        @Test
        public static void addNamedImport(AddImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            AddImport addImport = new AddImport();
            Assertions.StringSourceFileAssert stringSourceFileAssert = TestKt.whenParsedBy("class A {}", (Parser)jp);
            boolean bl = false;
            boolean bl2 = false;
            AddImport $this$apply = addImport;
            boolean bl3 = false;
            $this$apply.setType("java.util.List");
            $this$apply.setOnlyIfReferenced(false);
            AddImport addImport2 = addImport;
            stringSourceFileAssert.whenVisitedBy((RefactorVisitor)addImport2).isRefactoredTo("\n                    import java.util.List;\n                    \n                    class A {}\n                ");
        }

        @Test
        public static void namedImportAddedAfterPackageDeclaration(AddImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            AddImport addImport = new AddImport();
            Assertions.StringSourceFileAssert stringSourceFileAssert = TestKt.whenParsedBy("\n            package a;\n            class A {}\n        ", (Parser)jp);
            boolean bl = false;
            boolean bl2 = false;
            AddImport $this$apply = addImport;
            boolean bl3 = false;
            $this$apply.setType("java.util.List");
            $this$apply.setOnlyIfReferenced(false);
            AddImport addImport2 = addImport;
            stringSourceFileAssert.whenVisitedBy((RefactorVisitor)addImport2).isRefactoredTo("\n                    package a;\n                    \n                    import java.util.List;\n                    \n                    class A {}\n                ");
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void importsAddedInAlphabeticalOrder(AddImportTest $this, @NotNull JavaParser jp) {
            int n;
            boolean bl;
            Collection collection;
            void $this$mapIndexedTo$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            List otherPackages = CollectionsKt.listOf((Object[])new String[]{"c", "c.c", "c.c.c"});
            Iterable $this$mapIndexed$iv = otherPackages;
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void i2;
                void pkg;
                int n2 = index$iv$iv++;
                collection = destination$iv$iv;
                bl = false;
                if (n2 < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                n = n2;
                String string = (String)item$iv$iv;
                int n3 = n;
                Collection collection2 = collection;
                boolean bl2 = false;
                String string2 = "package " + (String)pkg + ";\npublic class C" + (int)i2 + " {}";
                collection2.add(string2);
            }
            List otherImports = (List)destination$iv$iv;
            Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])new Pair[]{TuplesKt.to((Object)"b", (Object)0), TuplesKt.to((Object)"c.b", (Object)1), TuplesKt.to((Object)"c.c.b", (Object)2)});
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$toTypedArray$iv;
                void pkg;
                Object object;
                Assertions.StringSourceFileAssert stringSourceFileAssert;
                void $this$mapIndexedTo$iv$iv2;
                Object item$iv$iv;
                Pair it = (Pair)element$iv;
                boolean bl3 = false;
                Pair pair = it;
                item$iv$iv = (String)pair.component1();
                int order = ((Number)pair.component2()).intValue();
                Iterable $this$mapIndexed$iv2 = otherPackages;
                boolean $i$f$mapIndexed2 = false;
                Iterable iterable2 = $this$mapIndexed$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv2, (int)10));
                boolean $i$f$mapIndexedTo2 = false;
                int index$iv$iv2 = 0;
                for (Object item$iv$iv2 : $this$mapIndexedTo$iv$iv2) {
                    void i3;
                    void otherPkg;
                    int n4 = index$iv$iv2++;
                    Collection collection3 = destination$iv$iv2;
                    boolean bl4 = false;
                    if (n4 < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    int n5 = n4;
                    String string = (String)item$iv$iv2;
                    int n6 = n5;
                    stringSourceFileAssert = collection3;
                    boolean bl5 = false;
                    object = (String)otherPkg + ".C" + (int)i3;
                    stringSourceFileAssert.add(object);
                }
                List expectedImports = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv2));
                expectedImports.add(order, (String)pkg + ".B");
                $this$mapIndexed$iv2 = otherImports;
                stringSourceFileAssert = TestKt.whenParsedBy("\n                package a;\n                \n                import c.C0;\n                import c.c.C1;\n                import c.c.c.C2;\n                \n                class A {}\n            ", (Parser)jp);
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                object = stringArray;
                collection = new AddImport();
                stringSourceFileAssert = stringSourceFileAssert.whichDependsOn(Arrays.copyOf(object, ((String[])object).length)).whichDependsOn("\n                        package " + (String)pkg + ";\n                        public class B {}\n                    ");
                bl = false;
                n = 0;
                Collection $this$apply = collection;
                boolean bl6 = false;
                $this$apply.setType((String)pkg + ".B");
                $this$apply.setOnlyIfReferenced(false);
                object = collection;
                stringSourceFileAssert.whenVisitedBy((RefactorVisitor)object).isRefactoredTo("package a;\n\n" + CollectionsKt.joinToString$default((Iterable)expectedImports, (CharSequence)"\n", null, null, (int)0, null, (Function1)importsAddedInAlphabeticalOrder.1.2.INSTANCE, (int)30, null) + "\n\nclass A {}");
                jp.reset();
            }
        }

        @Test
        public static void doNotAddImportIfAlreadyExists(AddImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            AddImport addImport = new AddImport();
            Assertions.StringSourceFileAssert stringSourceFileAssert = TestKt.whenParsedBy("\n            package a;\n            \n            import java.util.List;\n            class A {}\n        ", (Parser)jp);
            boolean bl = false;
            boolean bl2 = false;
            AddImport $this$apply = addImport;
            boolean bl3 = false;
            $this$apply.setType("java.util.List");
            $this$apply.setOnlyIfReferenced(false);
            AddImport addImport2 = addImport;
            stringSourceFileAssert.whenVisitedBy((RefactorVisitor)addImport2).isUnchanged();
        }

        @Test
        public static void doNotAddImportIfCoveredByStarImport(AddImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            AddImport addImport = new AddImport();
            Assertions.StringSourceFileAssert stringSourceFileAssert = TestKt.whenParsedBy("\n            package a;\n            \n            import java.util.*;\n            class A {}\n        ", (Parser)jp);
            boolean bl = false;
            boolean bl2 = false;
            AddImport $this$apply = addImport;
            boolean bl3 = false;
            $this$apply.setType("java.util.List");
            $this$apply.setOnlyIfReferenced(false);
            AddImport addImport2 = addImport;
            stringSourceFileAssert.whenVisitedBy((RefactorVisitor)addImport2).isUnchanged();
        }

        @Test
        public static void addNamedImportIfStarStaticImportExists(AddImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            AddImport addImport = new AddImport();
            Assertions.StringSourceFileAssert stringSourceFileAssert = TestKt.whenParsedBy("\n            package a;\n            \n            import static java.util.List.*;\n            class A {}\n        ", (Parser)jp);
            boolean bl = false;
            boolean bl2 = false;
            AddImport $this$apply = addImport;
            boolean bl3 = false;
            $this$apply.setType("java.util.List");
            $this$apply.setOnlyIfReferenced(false);
            AddImport addImport2 = addImport;
            stringSourceFileAssert.whenVisitedBy((RefactorVisitor)addImport2).isRefactoredTo("\n                    package a;\n                    \n                    import java.util.List;\n                    \n                    import static java.util.List.*;\n                    \n                    class A {}\n                ");
        }

        @Test
        public static void addNamedStaticImport(AddImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            AddImport addImport = new AddImport();
            Assertions.StringSourceFileAssert stringSourceFileAssert = TestKt.whenParsedBy("\n            import java.util.*;\n            class A {}\n        ", (Parser)jp);
            boolean bl = false;
            boolean bl2 = false;
            AddImport $this$apply = addImport;
            boolean bl3 = false;
            $this$apply.setType("java.util.Collections");
            $this$apply.setStaticMethod("emptyList");
            $this$apply.setOnlyIfReferenced(false);
            AddImport addImport2 = addImport;
            stringSourceFileAssert.whenVisitedBy((RefactorVisitor)addImport2).isRefactoredTo("\n                    import java.util.*;\n                    \n                    import static java.util.Collections.emptyList;\n                    \n                    class A {}\n                ");
        }

        @Test
        public static void dontAddImportWhenClassHasNoPackage(AddImportTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            AddImport addImport = new AddImport();
            Assertions.StringSourceFileAssert stringSourceFileAssert = TestKt.whenParsedBy("class A {}", (Parser)jp);
            boolean bl = false;
            boolean bl2 = false;
            AddImport $this$apply = addImport;
            boolean bl3 = false;
            $this$apply.setType("C");
            $this$apply.setOnlyIfReferenced(false);
            AddImport addImport2 = addImport;
            stringSourceFileAssert.whenVisitedBy((RefactorVisitor)addImport2).isUnchanged();
        }

        @NotNull
        public static Iterable<RefactorVisitor<?>> getVisitors(AddImportTest $this) {
            return RefactorVisitorTest.DefaultImpls.getVisitors($this);
        }

        public static <S extends SourceFile> void assertRefactored(AddImportTest $this, @NotNull Parser<S> parser, @NotNull Iterable<? extends RefactorVisitor<?>> visitors, @NotNull Iterable<? extends Function1<? super S, ? extends RefactorVisitor<? super S>>> visitorsMapped, @NotNull Iterable<? extends Function1<? super S, ? extends Iterable<? extends RefactorVisitor<? super S>>>> visitorsMappedToMany, @NotNull List<String> dependencies, @NotNull String before, @NotNull String after) {
            Intrinsics.checkParameterIsNotNull(parser, (String)"parser");
            Intrinsics.checkParameterIsNotNull(visitors, (String)"visitors");
            Intrinsics.checkParameterIsNotNull(visitorsMapped, (String)"visitorsMapped");
            Intrinsics.checkParameterIsNotNull(visitorsMappedToMany, (String)"visitorsMappedToMany");
            Intrinsics.checkParameterIsNotNull(dependencies, (String)"dependencies");
            Intrinsics.checkParameterIsNotNull((Object)before, (String)"before");
            Intrinsics.checkParameterIsNotNull((Object)after, (String)"after");
            RefactorVisitorTest.DefaultImpls.assertRefactored((RefactorVisitorTest)$this, parser, visitors, visitorsMapped, visitorsMappedToMany, dependencies, before, after);
        }

        public static <S extends SourceFile> void assertRefactored(AddImportTest $this, @NotNull Parser<S> parser, @NotNull Iterable<? extends RefactorVisitor<?>> visitors, @NotNull Iterable<? extends Function1<? super S, ? extends RefactorVisitor<? super S>>> visitorsMapped, @NotNull Iterable<? extends Function1<? super S, ? extends Iterable<? extends RefactorVisitor<? super S>>>> visitorsMappedToMany, @NotNull List<String> dependencies, @NotNull String before, @NotNull Function0<String> after) {
            Intrinsics.checkParameterIsNotNull(parser, (String)"parser");
            Intrinsics.checkParameterIsNotNull(visitors, (String)"visitors");
            Intrinsics.checkParameterIsNotNull(visitorsMapped, (String)"visitorsMapped");
            Intrinsics.checkParameterIsNotNull(visitorsMappedToMany, (String)"visitorsMappedToMany");
            Intrinsics.checkParameterIsNotNull(dependencies, (String)"dependencies");
            Intrinsics.checkParameterIsNotNull((Object)before, (String)"before");
            Intrinsics.checkParameterIsNotNull(after, (String)"after");
            RefactorVisitorTest.DefaultImpls.assertRefactored((RefactorVisitorTest)$this, parser, visitors, visitorsMapped, visitorsMappedToMany, dependencies, before, after);
        }

        public static <S extends SourceFile> void assertRefactored(AddImportTest $this, @NotNull Parser<S> parser, @NotNull Iterable<? extends RefactorVisitor<?>> visitors, @NotNull Iterable<? extends Function1<? super S, ? extends RefactorVisitor<? super S>>> visitorsMapped, @NotNull Iterable<? extends Function1<? super S, ? extends Iterable<? extends RefactorVisitor<? super S>>>> visitorsMappedToMany, @NotNull List<? extends File> dependencies, @NotNull File before, @NotNull String after) {
            Intrinsics.checkParameterIsNotNull(parser, (String)"parser");
            Intrinsics.checkParameterIsNotNull(visitors, (String)"visitors");
            Intrinsics.checkParameterIsNotNull(visitorsMapped, (String)"visitorsMapped");
            Intrinsics.checkParameterIsNotNull(visitorsMappedToMany, (String)"visitorsMappedToMany");
            Intrinsics.checkParameterIsNotNull(dependencies, (String)"dependencies");
            Intrinsics.checkParameterIsNotNull((Object)before, (String)"before");
            Intrinsics.checkParameterIsNotNull((Object)after, (String)"after");
            RefactorVisitorTest.DefaultImpls.assertRefactored((RefactorVisitorTest)$this, parser, visitors, visitorsMapped, visitorsMappedToMany, dependencies, before, after);
        }

        public static <S extends SourceFile> void assertUnchanged(AddImportTest $this, @NotNull Parser<S> parser, @NotNull Iterable<? extends RefactorVisitor<?>> visitors, @NotNull Iterable<? extends Function1<? super S, ? extends RefactorVisitor<? super S>>> visitorsMapped, @NotNull Iterable<? extends Function1<? super S, ? extends Iterable<? extends RefactorVisitor<? super S>>>> visitorsMappedToMany, @NotNull List<String> dependencies, @NotNull String before) {
            Intrinsics.checkParameterIsNotNull(parser, (String)"parser");
            Intrinsics.checkParameterIsNotNull(visitors, (String)"visitors");
            Intrinsics.checkParameterIsNotNull(visitorsMapped, (String)"visitorsMapped");
            Intrinsics.checkParameterIsNotNull(visitorsMappedToMany, (String)"visitorsMappedToMany");
            Intrinsics.checkParameterIsNotNull(dependencies, (String)"dependencies");
            Intrinsics.checkParameterIsNotNull((Object)before, (String)"before");
            RefactorVisitorTest.DefaultImpls.assertUnchanged((RefactorVisitorTest)$this, parser, visitors, visitorsMapped, visitorsMappedToMany, dependencies, before);
        }

        public static <S extends SourceFile> void assertUnchanged(AddImportTest $this, @NotNull Parser<S> parser, @NotNull Iterable<? extends RefactorVisitor<?>> visitors, @NotNull Iterable<? extends Function1<? super S, ? extends RefactorVisitor<? super S>>> visitorsMapped, @NotNull Iterable<? extends Function1<? super S, ? extends Iterable<? extends RefactorVisitor<? super S>>>> visitorsMappedToMany, @NotNull List<? extends File> dependencies, @NotNull File before) {
            Intrinsics.checkParameterIsNotNull(parser, (String)"parser");
            Intrinsics.checkParameterIsNotNull(visitors, (String)"visitors");
            Intrinsics.checkParameterIsNotNull(visitorsMapped, (String)"visitorsMapped");
            Intrinsics.checkParameterIsNotNull(visitorsMappedToMany, (String)"visitorsMappedToMany");
            Intrinsics.checkParameterIsNotNull(dependencies, (String)"dependencies");
            Intrinsics.checkParameterIsNotNull((Object)before, (String)"before");
            RefactorVisitorTest.DefaultImpls.assertUnchanged((RefactorVisitorTest)$this, parser, visitors, visitorsMapped, visitorsMappedToMany, dependencies, before);
        }
    }
}

