/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.TestKt;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\u0006"}, d2={"Lorg/openrewrite/java/tree/DoWhileLoopTest;", "", "doWhileLoop", "", "jp", "Lorg/openrewrite/java/JavaParser;", "rewrite-test"})
public interface DoWhileLoopTest {
    @Test
    public void doWhileLoop(@NotNull JavaParser var1);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void doWhileLoop(DoWhileLoopTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            public class A {\n                public void test() { do { } while ( true ) ; }\n            }\n        "}).get(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Statement statement = TestKt.firstMethodStatement(compilationUnit);
            if (statement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.DoWhileLoop");
            }
            J.DoWhileLoop whileLoop = (J.DoWhileLoop)statement;
            J.DoWhileLoop.While while_ = whileLoop.getWhileCondition();
            Intrinsics.checkExpressionValueIsNotNull((Object)while_, (String)"whileLoop.whileCondition");
            J.Parentheses parentheses2 = while_.getCondition();
            Intrinsics.checkExpressionValueIsNotNull((Object)parentheses2, (String)"whileLoop.whileCondition.condition");
            Assertions.assertTrue((boolean)(parentheses2.getTree() instanceof J.Literal));
            Assertions.assertTrue((boolean)(whileLoop.getBody() instanceof J.Block));
            Object e = a.getClasses().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"a.classes[0]");
            Object e2 = ((J.ClassDecl)e).getMethods().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e2, (String)"a.classes[0].methods[0]");
            J.Block block = ((J.MethodDecl)e2).getBody();
            if (block == null) {
                Intrinsics.throwNpe();
            }
            Assertions.assertEquals((Object)"{ do { } while ( true ) ; }", (Object)block.printTrimmed());
        }
    }
}

