/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Change;
import org.openrewrite.Refactor;
import org.openrewrite.SourceVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.OrderImports;
import org.openrewrite.java.TestKt;
import org.openrewrite.java.tree.J;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\u0012"}, d2={"Lorg/openrewrite/java/OrderImportTest;", "", "blankLineThenEmptyBlockThenNonEmptyBlock", "", "jp", "Lorg/openrewrite/java/JavaParser;", "blankLinesNotFollowedByBlockArentAdded", "foldIntoExistingStar", "foldIntoStar", "idempotence", "importSorting", "orderImports", "packagePatternEscapesDots", "removeUnused", "springCloudFormat", "twoImportsFollowedByStar", "unfoldStar", "unfoldStaticStar", "rewrite-test"})
public interface OrderImportTest {
    @Test
    public void orderImports(@NotNull JavaParser var1);

    @Test
    public void blankLineThenEmptyBlockThenNonEmptyBlock(@NotNull JavaParser var1);

    @Test
    public void foldIntoStar(@NotNull JavaParser var1);

    @Test
    public void blankLinesNotFollowedByBlockArentAdded(@NotNull JavaParser var1);

    @Test
    public void foldIntoExistingStar(@NotNull JavaParser var1);

    @Test
    public void idempotence(@NotNull JavaParser var1);

    @Test
    public void unfoldStar(@NotNull JavaParser var1);

    @Test
    public void removeUnused(@NotNull JavaParser var1);

    @Test
    public void unfoldStaticStar(@NotNull JavaParser var1);

    @Test
    public void packagePatternEscapesDots(@NotNull JavaParser var1);

    @Test
    public void twoImportsFollowedByStar(@NotNull JavaParser var1);

    @Test
    public void springCloudFormat(@NotNull JavaParser var1);

    @Test
    public void importSorting(@NotNull JavaParser var1);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void orderImports(OrderImportTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit fixed2;
            SourceVisitor[] sourceVisitorArray;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit a = jp.parse("import static java.util.stream.Collectors.joining;\nimport java.util.ArrayList;\nimport java.util.regex.Pattern;\nimport java.util.Objects;\nimport java.util.Set;\nimport org.openrewrite.java.tree.JavaType;\nimport org.openrewrite.java.tree.TypeUtils;\n\npublic class A {}", new String[0]);
            OrderImports orderImports = OrderImports.intellij();
            int n = 0;
            SourceVisitor[] sourceVisitorArray2 = sourceVisitorArray = new SourceVisitor[1];
            Refactor refactor = a.refactor();
            boolean bl = false;
            boolean bl2 = false;
            OrderImports $this$apply = orderImports;
            boolean bl3 = false;
            $this$apply.setRemoveUnused(false);
            OrderImports orderImports2 = orderImports;
            sourceVisitorArray[n] = (SourceVisitor)orderImports2;
            Change change = refactor.visit(sourceVisitorArray2).fix();
            Intrinsics.checkExpressionValueIsNotNull((Object)change, (String)"a.refactor().visit(Order\u2026d(false)\n        }).fix()");
            J.CompilationUnit compilationUnit = fixed2 = (J.CompilationUnit)change.getFixed();
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"fixed");
            TestKt.assertRefactored(compilationUnit, "import org.openrewrite.java.tree.JavaType;\nimport org.openrewrite.java.tree.TypeUtils;\n\nimport java.util.ArrayList;\nimport java.util.Objects;\nimport java.util.Set;\nimport java.util.regex.Pattern;\n\nimport static java.util.stream.Collectors.joining;\n\npublic class A {}");
        }

        @Test
        public static void blankLineThenEmptyBlockThenNonEmptyBlock(OrderImportTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit fixed2;
            SourceVisitor[] sourceVisitorArray;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit a = jp.parse("import java.util.ArrayList;\nimport java.util.Objects;\n\nimport org.openrewrite.java.tree.JavaType;\n\npublic class A {}", new String[0]);
            OrderImports orderImports = OrderImports.intellij();
            int n = 0;
            SourceVisitor[] sourceVisitorArray2 = sourceVisitorArray = new SourceVisitor[1];
            Refactor refactor = a.refactor();
            boolean bl = false;
            boolean bl2 = false;
            OrderImports $this$apply = orderImports;
            boolean bl3 = false;
            $this$apply.setRemoveUnused(false);
            OrderImports orderImports2 = orderImports;
            sourceVisitorArray[n] = (SourceVisitor)orderImports2;
            Change change = refactor.visit(sourceVisitorArray2).fix();
            Intrinsics.checkExpressionValueIsNotNull((Object)change, (String)"a.refactor().visit(Order\u2026d(false)\n        }).fix()");
            J.CompilationUnit compilationUnit = fixed2 = (J.CompilationUnit)change.getFixed();
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"fixed");
            TestKt.assertRefactored(compilationUnit, "import org.openrewrite.java.tree.JavaType;\n\nimport java.util.ArrayList;\nimport java.util.Objects;\n\npublic class A {}");
        }

        @Test
        public static void foldIntoStar(OrderImportTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit fixed2;
            SourceVisitor[] sourceVisitorArray;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit a = jp.parse("import java.util.List;\nimport java.util.ArrayList;\nimport java.util.regex.Pattern;\nimport java.util.Objects;\nimport java.util.Set;\nimport java.util.Map;\n\npublic class A {}", new String[0]);
            OrderImports orderImports = OrderImports.intellij();
            int n = 0;
            SourceVisitor[] sourceVisitorArray2 = sourceVisitorArray = new SourceVisitor[1];
            Refactor refactor = a.refactor();
            boolean bl = false;
            boolean bl2 = false;
            OrderImports $this$apply = orderImports;
            boolean bl3 = false;
            $this$apply.setRemoveUnused(false);
            OrderImports orderImports2 = orderImports;
            sourceVisitorArray[n] = (SourceVisitor)orderImports2;
            Change change = refactor.visit(sourceVisitorArray2).fix();
            Intrinsics.checkExpressionValueIsNotNull((Object)change, (String)"a.refactor().visit(Order\u2026d(false)\n        }).fix()");
            J.CompilationUnit compilationUnit = fixed2 = (J.CompilationUnit)change.getFixed();
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"fixed");
            TestKt.assertRefactored(compilationUnit, "import java.util.*;\nimport java.util.regex.Pattern;\n\npublic class A {}");
        }

        @Test
        public static void blankLinesNotFollowedByBlockArentAdded(OrderImportTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit fixed2;
            SourceVisitor[] sourceVisitorArray;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit a = jp.parse("import java.util.List;\n\nimport static java.util.Collections.*;\n\npublic class A {}", new String[0]);
            OrderImports orderImports = OrderImports.intellij();
            int n = 0;
            SourceVisitor[] sourceVisitorArray2 = sourceVisitorArray = new SourceVisitor[1];
            Refactor refactor = a.refactor();
            boolean bl = false;
            boolean bl2 = false;
            OrderImports $this$apply = orderImports;
            boolean bl3 = false;
            $this$apply.setRemoveUnused(false);
            OrderImports orderImports2 = orderImports;
            sourceVisitorArray[n] = (SourceVisitor)orderImports2;
            Change change = refactor.visit(sourceVisitorArray2).fix();
            Intrinsics.checkExpressionValueIsNotNull((Object)change, (String)"a.refactor().visit(Order\u2026d(false)\n        }).fix()");
            J.CompilationUnit compilationUnit = fixed2 = (J.CompilationUnit)change.getFixed();
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"fixed");
            TestKt.assertRefactored(compilationUnit, "import java.util.List;\n\nimport static java.util.Collections.*;\n\npublic class A {}");
        }

        @Test
        public static void foldIntoExistingStar(OrderImportTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit fixed2;
            SourceVisitor[] sourceVisitorArray;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit a = jp.parse("import java.util.*;\nimport java.util.ArrayList;\nimport java.util.regex.Pattern;\nimport java.util.Objects;\n\npublic class A {}", new String[0]);
            OrderImports orderImports = OrderImports.intellij();
            int n = 0;
            SourceVisitor[] sourceVisitorArray2 = sourceVisitorArray = new SourceVisitor[1];
            Refactor refactor = a.refactor();
            boolean bl = false;
            boolean bl2 = false;
            OrderImports $this$apply = orderImports;
            boolean bl3 = false;
            $this$apply.setRemoveUnused(false);
            OrderImports orderImports2 = orderImports;
            sourceVisitorArray[n] = (SourceVisitor)orderImports2;
            Change change = refactor.visit(sourceVisitorArray2).fix();
            Intrinsics.checkExpressionValueIsNotNull((Object)change, (String)"a.refactor().visit(Order\u2026d(false)\n        }).fix()");
            J.CompilationUnit compilationUnit = fixed2 = (J.CompilationUnit)change.getFixed();
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"fixed");
            TestKt.assertRefactored(compilationUnit, "import java.util.*;\nimport java.util.regex.Pattern;\n\npublic class A {}");
        }

        @Test
        public static void idempotence(OrderImportTest $this, @NotNull JavaParser jp) {
            Change fix;
            SourceVisitor[] sourceVisitorArray;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit a = jp.parse("import java.util.*;\nimport java.util.regex.Pattern;\n\npublic class A {}", new String[0]);
            Object object = OrderImports.intellij();
            int n = 0;
            SourceVisitor[] sourceVisitorArray2 = sourceVisitorArray = new SourceVisitor[1];
            Refactor refactor = a.refactor();
            boolean bl = false;
            boolean bl2 = false;
            OrderImports $this$apply = object;
            boolean bl3 = false;
            $this$apply.setRemoveUnused(false);
            OrderImports orderImports = object;
            sourceVisitorArray[n] = (SourceVisitor)orderImports;
            Change change = fix = refactor.visit(sourceVisitorArray2).fix();
            Intrinsics.checkExpressionValueIsNotNull((Object)change, (String)"fix");
            object = ((J.CompilationUnit)change.getFixed()).printTrimmed();
            bl = false;
            System.out.println(object);
            Assertions.assertThat((Iterable)fix.getRulesThatMadeChanges()).isEmpty();
        }

        @Test
        public static void unfoldStar(OrderImportTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit fixed2;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit a = jp.parse("import java.util.*;\n\npublic class A {\n    List list;\n    List list2;\n}", new String[0]);
            Change change = a.refactor().visit(new SourceVisitor[]{(SourceVisitor)OrderImports.intellij()}).fix();
            Intrinsics.checkExpressionValueIsNotNull((Object)change, (String)"a.refactor().visit(OrderImports.intellij()).fix()");
            J.CompilationUnit compilationUnit = fixed2 = (J.CompilationUnit)change.getFixed();
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"fixed");
            TestKt.assertRefactored(compilationUnit, "import java.util.List;\n\npublic class A {\n    List list;\n    List list2;\n}");
        }

        @Test
        public static void removeUnused(OrderImportTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit fixed2;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit a = jp.parse("import java.util.*;\n\npublic class A {\n}", new String[0]);
            Change change = a.refactor().visit(new SourceVisitor[]{(SourceVisitor)OrderImports.intellij()}).fix();
            Intrinsics.checkExpressionValueIsNotNull((Object)change, (String)"a.refactor().visit(OrderImports.intellij()).fix()");
            J.CompilationUnit compilationUnit = fixed2 = (J.CompilationUnit)change.getFixed();
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"fixed");
            TestKt.assertRefactored(compilationUnit, "\npublic class A {\n}");
        }

        @Test
        public static void unfoldStaticStar(OrderImportTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit fixed2;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit a = jp.parse("import java.util.List;\n\nimport static java.util.Collections.*;\n\npublic class A {\n    List list = emptyList();\n}", new String[0]);
            Change change = a.refactor().visit(new SourceVisitor[]{(SourceVisitor)OrderImports.intellij()}).fix();
            Intrinsics.checkExpressionValueIsNotNull((Object)change, (String)"a.refactor().visit(OrderImports.intellij()).fix()");
            J.CompilationUnit compilationUnit = fixed2 = (J.CompilationUnit)change.getFixed();
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"fixed");
            TestKt.assertRefactored(compilationUnit, "import java.util.List;\n\nimport static java.util.Collections.emptyList;\n\npublic class A {\n    List list = emptyList();\n}");
        }

        @Test
        public static void packagePatternEscapesDots(OrderImportTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit fixed2;
            SourceVisitor[] sourceVisitorArray;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit a = jp.parse("import javax.annotation.Nonnull;\n\npublic class A {}", new String[0]);
            OrderImports orderImports = OrderImports.intellij();
            int n = 0;
            SourceVisitor[] sourceVisitorArray2 = sourceVisitorArray = new SourceVisitor[1];
            Refactor refactor = a.refactor();
            boolean bl = false;
            boolean bl2 = false;
            OrderImports $this$apply = orderImports;
            boolean bl3 = false;
            $this$apply.setRemoveUnused(false);
            OrderImports orderImports2 = orderImports;
            sourceVisitorArray[n] = (SourceVisitor)orderImports2;
            Change change = refactor.visit(sourceVisitorArray2).fix();
            Intrinsics.checkExpressionValueIsNotNull((Object)change, (String)"a.refactor().visit(Order\u2026d(false)\n        }).fix()");
            J.CompilationUnit compilationUnit = fixed2 = (J.CompilationUnit)change.getFixed();
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"fixed");
            TestKt.assertRefactored(compilationUnit, "import javax.annotation.Nonnull;\n\npublic class A {}");
        }

        @Test
        public static void twoImportsFollowedByStar(OrderImportTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit fixed2;
            SourceVisitor[] sourceVisitorArray;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit a = jp.parse("import java.io.IOException;\nimport java.io.UncheckedIOException;\nimport java.nio.files.*;\n\npublic class A {}", new String[0]);
            OrderImports orderImports = OrderImports.intellij();
            int n = 0;
            SourceVisitor[] sourceVisitorArray2 = sourceVisitorArray = new SourceVisitor[1];
            Refactor refactor = a.refactor();
            boolean bl = false;
            boolean bl2 = false;
            OrderImports $this$apply = orderImports;
            boolean bl3 = false;
            $this$apply.setRemoveUnused(false);
            OrderImports orderImports2 = orderImports;
            sourceVisitorArray[n] = (SourceVisitor)orderImports2;
            Change change = refactor.visit(sourceVisitorArray2).fix();
            Intrinsics.checkExpressionValueIsNotNull((Object)change, (String)"a.refactor().visit(Order\u2026d(false)\n        }).fix()");
            J.CompilationUnit compilationUnit = fixed2 = (J.CompilationUnit)change.getFixed();
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"fixed");
            TestKt.assertRefactored(compilationUnit, "import java.io.IOException;\nimport java.io.UncheckedIOException;\nimport java.nio.files.*;\n\npublic class A {}");
        }

        @Test
        public static void springCloudFormat(OrderImportTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit fixed2;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit a = jp.parse("import java.io.ByteArrayOutputStream;\nimport java.nio.charset.StandardCharsets;\nimport java.util.Collections;\nimport java.util.zip.GZIPOutputStream;\n\nimport javax.servlet.ReadListener;\nimport javax.servlet.ServletInputStream;\nimport javax.servlet.ServletOutputStream;\n\nimport com.fasterxml.jackson.databind.ObjectMapper;\nimport org.apache.commons.logging.Log;\nimport reactor.core.publisher.Mono;\n\nimport org.springframework.core.io.buffer.DataBuffer;\nimport org.springframework.core.io.buffer.DataBufferFactory;\nimport org.springframework.http.HttpHeaders;\nimport org.springframework.util.MultiValueMap;\nimport org.springframework.web.bind.annotation.PathVariable;\nimport org.springframework.web.server.ServerWebExchange;\n\nimport static java.util.Arrays.stream;\nimport static org.springframework.cloud.gateway.support.ServerWebExchangeUtils.toAsyncPredicate;\n\npublic class A {}", new String[0]);
            OrderImports orderImports = new OrderImports();
            boolean bl = false;
            boolean bl2 = false;
            OrderImports $this$apply = orderImports;
            boolean bl3 = false;
            $this$apply.setLayout(OrderImports.Layout.builder((int)999, (int)999).importPackage("java.*").blankLine().importPackage("javax.*").blankLine().importAllOthers().blankLine().importPackage("org.springframework.*").blankLine().importStaticAllOthers().build());
            $this$apply.setRemoveUnused(false);
            OrderImports orderImports2 = orderImports;
            Change change = a.refactor().visit(new SourceVisitor[]{(SourceVisitor)orderImports2}).fix();
            Intrinsics.checkExpressionValueIsNotNull((Object)change, (String)"a.refactor().visit(orderImports).fix()");
            J.CompilationUnit compilationUnit = fixed2 = (J.CompilationUnit)change.getFixed();
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"fixed");
            TestKt.assertRefactored(compilationUnit, "import java.io.ByteArrayOutputStream;\nimport java.nio.charset.StandardCharsets;\nimport java.util.Collections;\nimport java.util.zip.GZIPOutputStream;\n\nimport javax.servlet.ReadListener;\nimport javax.servlet.ServletInputStream;\nimport javax.servlet.ServletOutputStream;\n\nimport com.fasterxml.jackson.databind.ObjectMapper;\nimport org.apache.commons.logging.Log;\nimport reactor.core.publisher.Mono;\n\nimport org.springframework.core.io.buffer.DataBuffer;\nimport org.springframework.core.io.buffer.DataBufferFactory;\nimport org.springframework.http.HttpHeaders;\nimport org.springframework.util.MultiValueMap;\nimport org.springframework.web.bind.annotation.PathVariable;\nimport org.springframework.web.server.ServerWebExchange;\n\nimport static java.util.Arrays.stream;\nimport static org.springframework.cloud.gateway.support.ServerWebExchangeUtils.toAsyncPredicate;\n\npublic class A {}");
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void importSorting(OrderImportTest $this, @NotNull JavaParser jp) {
            void $this$mapTo$iv$iv;
            J.CompilationUnit fixed2;
            SourceVisitor[] sourceVisitorArray;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit a = jp.parse("import r.core.Flux;\nimport s.core.Flux;\nimport com.fasterxml.jackson.databind.ObjectMapper;\nimport org.apache.commons.logging.Log;\nimport reactor.core.publisher.Mono;\n\npublic class A {}", new String[0]);
            OrderImports orderImports = OrderImports.intellij();
            int n = 0;
            Object object = sourceVisitorArray = new SourceVisitor[1];
            Object object2 = a.refactor();
            boolean bl = false;
            boolean bl2 = false;
            OrderImports $this$apply = orderImports;
            boolean bl3 = false;
            $this$apply.setRemoveUnused(false);
            OrderImports orderImports2 = orderImports;
            sourceVisitorArray[n] = (SourceVisitor)orderImports2;
            Change change = object2.visit(object).fix();
            Intrinsics.checkExpressionValueIsNotNull((Object)change, (String)"a.refactor().visit(Order\u2026d(false)\n        }).fix()");
            J.CompilationUnit compilationUnit = fixed2 = (J.CompilationUnit)change.getFixed();
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"fixed");
            List list = compilationUnit.getImports();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"fixed.imports");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                J.Import import_ = (J.Import)item$iv$iv;
                object2 = destination$iv$iv;
                boolean bl4 = false;
                void v3 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"it");
                String string = v3.getPackageName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.packageName");
                object = StringsKt.substringBefore$default((String)string, (char)'.', null, (int)2, null);
                object2.add(object);
            }
            Assertions.assertThat((List)((List)destination$iv$iv)).containsExactly((Object[])new String[]{"com", "org", "r", "reactor", "s"});
        }
    }
}

