/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.TestKt;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\r"}, d2={"Lorg/openrewrite/java/tree/VariableDeclsTest;", "", "fieldDefinition", "", "jp", "Lorg/openrewrite/java/JavaParser;", "fieldWithNoInitializer", "format", "formatArrayVariables", "localVariableDefinition", "modifierOrdering", "multipleDeclaration", "multipleDeclarationOneAssignment", "rewrite-test"})
public interface VariableDeclsTest {
    @Test
    public void fieldDefinition(@NotNull JavaParser var1);

    @Test
    public void localVariableDefinition(@NotNull JavaParser var1);

    @Test
    public void fieldWithNoInitializer(@NotNull JavaParser var1);

    @Test
    public void format(@NotNull JavaParser var1);

    @Test
    public void formatArrayVariables(@NotNull JavaParser var1);

    @Test
    public void multipleDeclarationOneAssignment(@NotNull JavaParser var1);

    @Test
    public void multipleDeclaration(@NotNull JavaParser var1);

    @Test
    public void modifierOrdering(@NotNull JavaParser var1);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void fieldDefinition(VariableDeclsTest $this, @NotNull JavaParser jp) {
            J.VariableDecls.NamedVar singleVar;
            J.VariableDecls varDecl;
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = jp.parse("\n            public class A {\n                public String a = \"\";\n            }\n        ", new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"a.classes[0]");
            J.VariableDecls variableDecls = varDecl = (J.VariableDecls)((J.ClassDecl)e).getFields().get(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)variableDecls, (String)"varDecl");
            Assertions.assertTrue((boolean)(variableDecls.getTypeExpr() instanceof J.Ident));
            J.VariableDecls.NamedVar namedVar = singleVar = (J.VariableDecls.NamedVar)varDecl.getVars().get(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)namedVar, (String)"singleVar");
            Assertions.assertEquals((Object)"a", (Object)namedVar.getSimpleName());
            JavaType.Class clazz = TestKt.asClass(singleVar.getType());
            Assertions.assertEquals((Object)"java.lang.String", (Object)(clazz != null ? clazz.getFullyQualifiedName() : null));
            TypeTree typeTree = varDecl.getTypeExpr();
            if (typeTree == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Ident");
            }
            Assertions.assertEquals((Object)((J.Ident)typeTree).getType(), (Object)singleVar.getType());
            Assertions.assertTrue((boolean)(singleVar.getInitializer() instanceof J.Literal));
            Assertions.assertTrue((boolean)varDecl.hasModifier("public"));
        }

        @Test
        public static void localVariableDefinition(VariableDeclsTest $this, @NotNull JavaParser jp) {
            J.VariableDecls.NamedVar singleVar;
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = jp.parse("\n            public class A {\n                public void test() {\n                    String a = \"\";\n                }\n            }\n        ", new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Statement statement = TestKt.firstMethodStatement(compilationUnit);
            if (statement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.VariableDecls");
            }
            J.VariableDecls varDecl = (J.VariableDecls)statement;
            J.VariableDecls.NamedVar namedVar = singleVar = (J.VariableDecls.NamedVar)varDecl.getVars().get(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)namedVar, (String)"singleVar");
            JavaType.Class clazz = TestKt.asClass(namedVar.getType());
            Assertions.assertEquals((Object)"java.lang.String", (Object)(clazz != null ? clazz.getFullyQualifiedName() : null));
            Assertions.assertEquals((Object)"a", (Object)singleVar.getSimpleName());
        }

        @Test
        public static void fieldWithNoInitializer(VariableDeclsTest $this, @NotNull JavaParser jp) {
            J.VariableDecls varDecl;
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = jp.parse("\n            public class A {\n                String a;\n            }\n        ", new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"a.classes[0]");
            J.VariableDecls variableDecls = varDecl = (J.VariableDecls)((J.ClassDecl)e).getFields().get(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)variableDecls, (String)"varDecl");
            Object e2 = variableDecls.getVars().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e2, (String)"varDecl.vars[0]");
            Assertions.assertNull((Object)((J.VariableDecls.NamedVar)e2).getInitializer());
        }

        @Test
        public static void format(VariableDeclsTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = jp.parse("\n            public class A {\n                public static int n = 0;\n            }\n        ", new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"a.classes[0]");
            J.VariableDecls varDecl = (J.VariableDecls)((J.ClassDecl)e).getFields().get(0);
            Assertions.assertEquals((Object)"public static int n = 0", (Object)varDecl.printTrimmed());
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void formatArrayVariables(VariableDeclsTest $this, @NotNull JavaParser jp) {
            void n2;
            void s;
            void n;
            List<J.VariableDecls> list;
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = jp.parse("\n            public class A {\n               int n [ ];\n               String s [ ] [ ];\n               int [ ] n2;\n               String [ ] [ ] s2;\n            }\n        ", new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            int n3 = 0;
            List<J.VariableDecls> list2 = list = TestKt.fields(compilationUnit, new IntRange(n3, 3));
            boolean bl = false;
            J.VariableDecls variableDecls = list2.get(0);
            list2 = list;
            bl = false;
            J.VariableDecls variableDecls2 = list2.get(1);
            list2 = list;
            bl = false;
            J.VariableDecls variableDecls3 = list2.get(2);
            list2 = list;
            bl = false;
            J.VariableDecls s2 = list2.get(3);
            Assertions.assertEquals((Object)"int n [ ]", (Object)n.printTrimmed());
            Assertions.assertEquals((Object)"String s [ ] [ ]", (Object)s.printTrimmed());
            Assertions.assertEquals((Object)"int [ ] n2", (Object)n2.printTrimmed());
            Assertions.assertEquals((Object)"String [ ] [ ] s2", (Object)s2.printTrimmed());
        }

        @Test
        public static void multipleDeclarationOneAssignment(VariableDeclsTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = jp.parse("\n            public class A {\n                int i, j = 0;\n            }\n        ", new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"a.classes[0]");
            Assertions.assertEquals((Object)"int i, j = 0", (Object)((J.VariableDecls)((J.ClassDecl)e).getFields().get(0)).printTrimmed());
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void multipleDeclaration(VariableDeclsTest $this, @NotNull JavaParser jp) {
            void localDecl;
            List list;
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = jp.parse("\n            public class A {\n                static {\n                    Integer[] m = { 0 }, n[] = { { 0 } };\n                    for(int i = 0, j = 0; i < 1; i++) { }\n                }\n\n                Integer m = 0, n = 0;\n            }\n        ", new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"a.classes[0]");
            Assertions.assertEquals((Object)"Integer m = 0, n = 0", (Object)((J.VariableDecls)((J.ClassDecl)e).getFields().get(0)).printTrimmed());
            Object e2 = a.getClasses().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e2, (String)"a.classes[0]");
            J.Block block = ((J.ClassDecl)e2).getBody();
            Intrinsics.checkExpressionValueIsNotNull((Object)block, (String)"a.classes[0].body");
            Object e3 = block.getStatements().get(0);
            if (e3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Block<org.openrewrite.java.tree.Statement>");
            }
            J.Block staticInit = (J.Block)e3;
            List list2 = list = staticInit.getStatements().subList(0, 2);
            boolean bl = false;
            Statement statement = (Statement)list2.get(0);
            list2 = list;
            bl = false;
            Statement forLoop = (Statement)list2.get(1);
            Assertions.assertEquals((Object)"Integer[] m = { 0 }, n[] = { { 0 } }", (Object)localDecl.printTrimmed());
            Assertions.assertEquals((Object)"for(int i = 0, j = 0; i < 1; i++) { }", (Object)forLoop.printTrimmed());
        }

        @Test
        public static void modifierOrdering(VariableDeclsTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = jp.parse("\n            public class A {\n                public /* static */ final static Integer n = 0;\n            }\n        ", new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"a.classes[0]");
            Assertions.assertEquals((Object)"public /* static */ final static Integer n = 0", (Object)((J.VariableDecls)((J.ClassDecl)e).getFields().get(0)).printTrimmed());
        }
    }
}

