/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.TestKt;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\u000b"}, d2={"Lorg/openrewrite/java/tree/TryCatchTest;", "", "formatMultiCatch", "", "jp", "Lorg/openrewrite/java/JavaParser;", "formatTryCatchFinally", "formatTryWithResources", "tryCatchNoFinally", "tryFinally", "tryWithResources", "rewrite-test"})
public interface TryCatchTest {
    @Test
    public void tryFinally(@NotNull JavaParser var1);

    @Test
    public void tryCatchNoFinally(@NotNull JavaParser var1);

    @Test
    public void tryWithResources(@NotNull JavaParser var1);

    @Test
    public void formatTryWithResources(@NotNull JavaParser var1);

    @Test
    public void formatMultiCatch(@NotNull JavaParser var1);

    @Test
    public void formatTryCatchFinally(@NotNull JavaParser var1);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void tryFinally(TryCatchTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = jp.parse("\n            public class A {\n                public void test() {\n                    try {\n                    }\n                    finally {\n                    }\n                }\n            }\n        ", new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Statement statement = TestKt.firstMethodStatement(compilationUnit);
            if (statement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Try");
            }
            J.Try tryable = (J.Try)statement;
            Assertions.assertEquals((int)0, (int)tryable.getCatches().size());
            Assertions.assertTrue((boolean)(tryable.getFinally() instanceof J.Try.Finally));
        }

        @Test
        public static void tryCatchNoFinally(TryCatchTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = jp.parse("\n            public class A {\n                public void test() {\n                    try {\n                    }\n                    catch(Throwable t) {\n                    }\n                }\n            }\n        ", new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Statement statement = TestKt.firstMethodStatement(compilationUnit);
            if (statement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Try");
            }
            J.Try tryable = (J.Try)statement;
            Assertions.assertEquals((int)1, (int)tryable.getCatches().size());
        }

        @Test
        public static void tryWithResources(TryCatchTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = jp.parse("\n            import java.io.*;\n            public class A {\n                File f;\n                public void test() {\n                    try(FileInputStream fis = new FileInputStream(f)) {\n                    }\n                    catch(IOException e) {\n                    }\n                }\n            }\n        ", new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Statement statement = TestKt.firstMethodStatement(compilationUnit);
            if (statement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Try");
            }
            J.Try tryable = (J.Try)statement;
            Object object = tryable.getResources();
            Assertions.assertEquals((int)1, (int)(object != null && (object = object.getDecls()) != null ? object.size() : -1));
        }

        @Test
        public static void formatTryWithResources(TryCatchTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = jp.parse("\n            import java.io.*;\n            public class A {\n                File f;\n                public void test() {\n                    try(FileInputStream fis = new FileInputStream(f)) { }\n                }\n            }\n        ", new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Statement statement = TestKt.firstMethodStatement(compilationUnit);
            if (statement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Try");
            }
            J.Try tryable = (J.Try)statement;
            Assertions.assertEquals((Object)"try(FileInputStream fis = new FileInputStream(f)) { }", (Object)tryable.printTrimmed());
        }

        @Test
        public static void formatMultiCatch(TryCatchTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = jp.parse("\n            import java.io.*;\n            public class A {\n                File f;\n                public void test() {\n                    try(FileInputStream fis = new FileInputStream(f)) {}\n                    catch(FileNotFoundException | RuntimeException e) {}\n                }\n            }\n        ", new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Statement statement = TestKt.firstMethodStatement(compilationUnit);
            if (statement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Try");
            }
            Object e = ((J.Try)statement).getCatches().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"(a.firstMethodStatement() as J.Try).catches[0]");
            J.Parentheses parentheses2 = ((J.Try.Catch)e).getParam();
            Intrinsics.checkExpressionValueIsNotNull((Object)parentheses2, (String)"(a.firstMethodStatement(\u2026s J.Try).catches[0].param");
            J j = parentheses2.getTree();
            Intrinsics.checkExpressionValueIsNotNull((Object)j, (String)"(a.firstMethodStatement(\u2026ry).catches[0].param.tree");
            TypeTree typeTree = ((J.VariableDecls)j).getTypeExpr();
            if (typeTree == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MultiCatch");
            }
            J.MultiCatch multiCatch = (J.MultiCatch)typeTree;
            Assertions.assertEquals((Object)"FileNotFoundException | RuntimeException", (Object)multiCatch.printTrimmed());
        }

        @Test
        public static void formatTryCatchFinally(TryCatchTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = jp.parse("\n            public class A {\n                public void test() {\n                    try {}\n                    catch(Exception e) {}\n                    catch(RuntimeException e) {}\n                    catch(Throwable t) {}\n                    finally {}\n                }\n            }\n        ", new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Statement statement = TestKt.firstMethodStatement(compilationUnit);
            if (statement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Try");
            }
            J.Try tryable = (J.Try)statement;
            Assertions.assertEquals((Object)"try {}\ncatch(Exception e) {}\ncatch(RuntimeException e) {}\ncatch(Throwable t) {}\nfinally {}", (Object)tryable.printTrimmed());
        }
    }
}

