/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\t"}, d2={"Lorg/openrewrite/java/tree/BinaryTest;", "", "arithmetic", "", "jp", "Lorg/openrewrite/java/JavaParser;", "endOfLineBreaks", "format", "formatFoldableStrings", "rewrite-test"})
public interface BinaryTest {
    @Test
    public void arithmetic(@NotNull JavaParser var1);

    @Test
    public void format(@NotNull JavaParser var1);

    @Test
    public void formatFoldableStrings(@NotNull JavaParser var1);

    @Test
    public void endOfLineBreaks(@NotNull JavaParser var1);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void arithmetic(BinaryTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = jp.parse("\n            public class A {\n                int n = 0 + 1;\n            }\n        ", new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"a.classes[0]");
            Object e2 = ((J.ClassDecl)e).getFields().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e2, (String)"a.classes[0].fields[0]");
            Object e3 = ((J.VariableDecls)e2).getVars().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e3, (String)"a.classes[0].fields[0].vars[0]");
            Expression expression = ((J.VariableDecls.NamedVar)e3).getInitializer();
            if (expression == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Binary");
            }
            J.Binary bin = (J.Binary)expression;
            Assertions.assertTrue((boolean)(bin.getOperator() instanceof J.Binary.Operator.Addition));
            Assertions.assertTrue((boolean)(bin.getLeft() instanceof J.Literal));
            Assertions.assertTrue((boolean)(bin.getRight() instanceof J.Literal));
        }

        @Test
        public static void format(BinaryTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = jp.parse("\n            public class A {\n                int n = 0 + 1;\n            }\n        ", new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"a.classes[0]");
            Object e2 = ((J.ClassDecl)e).getFields().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e2, (String)"a.classes[0].fields[0]");
            Object e3 = ((J.VariableDecls)e2).getVars().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e3, (String)"a.classes[0].fields[0].vars[0]");
            Expression expression = ((J.VariableDecls.NamedVar)e3).getInitializer();
            if (expression == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Binary");
            }
            J.Binary bin = (J.Binary)expression;
            Assertions.assertEquals((Object)"0 + 1", (Object)bin.printTrimmed());
        }

        @Test
        public static void formatFoldableStrings(BinaryTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            String a = "\n            public class A {\n                String s = \"a\" + \"b\";\n            }\n        ";
            J.CompilationUnit compilationUnit = jp.parse(a, new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"jp.parse(a)");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"jp.parse(a).classes[0]");
            Object e2 = ((J.ClassDecl)e).getFields().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e2, (String)"jp.parse(a).classes[0].fields[0]");
            Object e3 = ((J.VariableDecls)e2).getVars().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e3, (String)"jp.parse(a).classes[0].fields[0].vars[0]");
            Expression expression = ((J.VariableDecls.NamedVar)e3).getInitializer();
            Assertions.assertEquals((Object)"\"a\" + \"b\"", (Object)(expression != null ? expression.printTrimmed() : null));
        }

        @Test
        public static void endOfLineBreaks(BinaryTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            String aSource = "import java.util.Objects;\npublic class A {\n    {\n        boolean b = Objects.equals(1, 2) //\n            && Objects.equals(3, 4) //\n            && Objects.equals(4, 5);\n    }\n}";
            J.CompilationUnit a = jp.parse(aSource, new String[0]);
            Assertions.assertEquals((Object)aSource, (Object)a.print());
        }
    }
}

