/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.List;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Change;
import org.openrewrite.Refactor;
import org.openrewrite.SourceVisitor;
import org.openrewrite.java.ChangeLiteral;
import org.openrewrite.java.ChangeLiteralTest;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.TestKt;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u0000 \r2\u00020\u0001:\u0001\rJ\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\"\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\b*\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\bH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/openrewrite/java/ChangeLiteralTest;", "", "changeStringLiteralArgument", "", "jp", "Lorg/openrewrite/java/JavaParser;", "changeStringLiteralArgumentWithEscapableCharacters", "changeLiterals", "Lorg/openrewrite/java/tree/J$CompilationUnit;", "kotlin.jvm.PlatformType", "", "Lorg/openrewrite/java/tree/J$MethodInvocation;", "cu", "Companion", "rewrite-test"})
public interface ChangeLiteralTest {
    public static final Companion Companion = org.openrewrite.java.ChangeLiteralTest$Companion.$$INSTANCE;

    @Test
    public void changeStringLiteralArgument(@NotNull JavaParser var1);

    @Test
    public void changeStringLiteralArgumentWithEscapableCharacters(@NotNull JavaParser var1);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void changeStringLiteralArgument(ChangeLiteralTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit fixed2;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            String a = "import b.*;\nclass A {\n   public void test() {\n       String s = \"bar\";\n       new B().singleArg(\"foo (%s)\" + s + 0L);\n   }\n}";
            J.CompilationUnit cu = jp.parse(a, org.openrewrite.java.ChangeLiteralTest$Companion.access$getB$p(Companion));
            List list = cu.findMethodCalls("b.B singleArg(String)");
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"cu.findMethodCalls(\"b.B singleArg(String)\")");
            J.CompilationUnit compilationUnit = cu;
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"cu");
            J.CompilationUnit compilationUnit2 = fixed2 = DefaultImpls.changeLiterals($this, list, compilationUnit);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit2, (String)"fixed");
            TestKt.assertRefactored(compilationUnit2, "\n            import b.*;\n            class A {\n               public void test() {\n                   String s = \"bar\";\n                   new B().singleArg(\"foo ({})\" + s + 0L);\n               }\n            }\n        ");
        }

        @Test
        public static void changeStringLiteralArgumentWithEscapableCharacters(ChangeLiteralTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit fixed2;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            String a = "import b.*;\npublic class A {\n    B b;\n    public void test() {\n        b.singleArg(\"mystring '%s'\");\n    }\n}";
            J.CompilationUnit cu = jp.parse(a, org.openrewrite.java.ChangeLiteralTest$Companion.access$getB$p(Companion));
            List list = cu.findMethodCalls("b.B singleArg(..)");
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"cu.findMethodCalls(\"b.B singleArg(..)\")");
            J.CompilationUnit compilationUnit = cu;
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"cu");
            J.CompilationUnit compilationUnit2 = fixed2 = DefaultImpls.changeLiterals($this, list, compilationUnit);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit2, (String)"fixed");
            TestKt.assertRefactored(compilationUnit2, "\n            import b.*;\n            public class A {\n                B b;\n                public void test() {\n                    b.singleArg(\"mystring '{}'\");\n                }\n            }\n        ");
        }

        /*
         * WARNING - void declaration
         */
        private static J.CompilationUnit changeLiterals(ChangeLiteralTest $this, @NotNull List<? extends J.MethodInvocation> $this$changeLiterals, J.CompilationUnit cu) {
            void $this$fold$iv;
            Iterable iterable = $this$changeLiterals;
            Refactor initial$iv = cu.refactor();
            boolean $i$f$fold = false;
            Refactor accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void meth;
                J.MethodInvocation methodInvocation = (J.MethodInvocation)element$iv;
                Refactor acc = accumulator$iv;
                boolean bl = false;
                J.MethodInvocation.Arguments arguments = meth.getArgs();
                Intrinsics.checkExpressionValueIsNotNull((Object)arguments, (String)"meth.args");
                List list = arguments.getArgs();
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"meth.args.args");
                Iterable $this$fold$iv2 = list;
                boolean $i$f$fold2 = false;
                Refactor accumulator$iv2 = acc;
                for (Object element$iv2 : $this$fold$iv2) {
                    void exp;
                    Expression expression = (Expression)element$iv2;
                    Refactor acc2 = accumulator$iv2;
                    boolean bl2 = false;
                    accumulator$iv2 = acc2.visit(new SourceVisitor[]{(SourceVisitor)new ChangeLiteral((Expression)exp, (Function)changeLiterals.1.1.1.INSTANCE)});
                }
                accumulator$iv = accumulator$iv2;
            }
            Change change = accumulator$iv.fix();
            Intrinsics.checkExpressionValueIsNotNull((Object)change, (String)"fold(cu.refactor()) { ac\u2026           })\n    }.fix()");
            return (J.CompilationUnit)change.getFixed();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/openrewrite/java/ChangeLiteralTest$Companion;", "", "()V", "b", "", "rewrite-test"})
    public static final class Companion {
        private static final String b;
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        static {
            Companion companion;
            $$INSTANCE = companion = new Companion();
            b = "package b;\npublic class B {\n   public void singleArg(String s) {}\n}";
        }

        public static final /* synthetic */ String access$getB$p(Companion $this) {
            Companion companion = $this;
            return b;
        }
    }
}

