/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Change;
import org.openrewrite.Formatting;
import org.openrewrite.Refactor;
import org.openrewrite.SourceVisitor;
import org.openrewrite.Tree;
import org.openrewrite.java.AddField;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.TestKt;
import org.openrewrite.java.tree.J;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\t"}, d2={"Lorg/openrewrite/java/AddFieldTest;", "", "addFieldDefaultIndent", "", "jp", "Lorg/openrewrite/java/JavaParser;", "addFieldMatchSpaces", "addFieldMatchTabs", "Companion", "rewrite-test"})
public interface AddFieldTest {
    public static final Companion Companion = org.openrewrite.java.AddFieldTest$Companion.$$INSTANCE;

    @Test
    public void addFieldDefaultIndent(@NotNull JavaParser var1);

    @Test
    public void addFieldMatchSpaces(@NotNull JavaParser var1);

    @Test
    public void addFieldMatchTabs(@NotNull JavaParser var1);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void addFieldDefaultIndent(AddFieldTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit fixed2;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit a = jp.parse("class A {\n}", new String[0]);
            Refactor refactor = a.refactor();
            SourceVisitor[] sourceVisitorArray = new SourceVisitor[1];
            J.CompilationUnit compilationUnit = a;
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            sourceVisitorArray[0] = (SourceVisitor)new AddField.Scoped((J.ClassDecl)compilationUnit.getClasses().get(0), Companion.getPrivate(), "java.util.List", "list", "new ArrayList<>()");
            Change change = refactor.visit(sourceVisitorArray).fix();
            Intrinsics.checkExpressionValueIsNotNull((Object)change, (String)"a.refactor()\n           \u2026))\n                .fix()");
            J.CompilationUnit compilationUnit2 = fixed2 = (J.CompilationUnit)change.getFixed();
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit2, (String)"fixed");
            TestKt.assertRefactored(compilationUnit2, "\n            import java.util.List;\n            \n            class A {\n                private List list = new ArrayList<>();\n            }\n        ");
        }

        @Test
        public static void addFieldMatchSpaces(AddFieldTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit fixed2;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit a = jp.parse("import java.util.List;\n\nclass A {\n  List l;\n}", new String[0]);
            Refactor refactor = a.refactor();
            SourceVisitor[] sourceVisitorArray = new SourceVisitor[1];
            J.CompilationUnit compilationUnit = a;
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            sourceVisitorArray[0] = (SourceVisitor)new AddField.Scoped((J.ClassDecl)compilationUnit.getClasses().get(0), Companion.getPrivate(), "java.util.List", "list", null);
            Change change = refactor.visit(sourceVisitorArray).fix();
            Intrinsics.checkExpressionValueIsNotNull((Object)change, (String)"a.refactor()\n           \u2026))\n                .fix()");
            J.CompilationUnit compilationUnit2 = fixed2 = (J.CompilationUnit)change.getFixed();
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit2, (String)"fixed");
            TestKt.assertRefactored(compilationUnit2, "\n            import java.util.List;\n            \n            class A {\n              private List list;\n              List l;\n            }\n        ");
        }

        @Test
        public static void addFieldMatchTabs(AddFieldTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit fixed2;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit a = jp.parse("import java.util.List;\n\nclass A {\n           List l;\n}", new String[0]);
            Refactor refactor = a.refactor();
            SourceVisitor[] sourceVisitorArray = new SourceVisitor[1];
            J.CompilationUnit compilationUnit = a;
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            sourceVisitorArray[0] = (SourceVisitor)new AddField.Scoped((J.ClassDecl)compilationUnit.getClasses().get(0), Companion.getPrivate(), "java.util.List", "list", null);
            Change change = refactor.visit(sourceVisitorArray).fix();
            Intrinsics.checkExpressionValueIsNotNull((Object)change, (String)"a.refactor()\n           \u2026))\n                .fix()");
            J.CompilationUnit compilationUnit2 = fixed2 = (J.CompilationUnit)change.getFixed();
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit2, (String)"fixed");
            TestKt.assertRefactored(compilationUnit2, "\n            import java.util.List;\n            \n            class A {\n                       private List list;\n                       List l;\n            }\n        ");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/openrewrite/java/AddFieldTest$Companion;", "", "()V", "private", "", "Lorg/openrewrite/java/tree/J$Modifier;", "getPrivate", "()Ljava/util/List;", "rewrite-test"})
    public static final class Companion {
        @NotNull
        private static final List<J.Modifier> private;
        static final /* synthetic */ Companion $$INSTANCE;

        @NotNull
        public final List<J.Modifier> getPrivate() {
            return private;
        }

        private Companion() {
        }

        static {
            Companion companion;
            $$INSTANCE = companion = new Companion();
            List<J.Modifier> list = Collections.singletonList((J.Modifier)new J.Modifier.Private(Tree.randomId(), Formatting.EMPTY));
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"singletonList(J.Modifier\u2026(), EMPTY) as J.Modifier)");
            private = list;
        }
    }
}

