/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.template.processor;

import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import org.openrewrite.java.template.internal.Permit;
import org.openrewrite.java.template.internal.permit.Parent;
import org.openrewrite.java.template.processor.RefasterTemplateProcessor;
import sun.misc.Unsafe;

public abstract class TypeAwareProcessor
extends AbstractProcessor {
    protected JavacProcessingEnvironment javacProcessingEnv;
    protected Trees trees;

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.processingEnv = processingEnv;
        this.javacProcessingEnv = this.getJavacProcessingEnvironment(processingEnv);
        if (this.javacProcessingEnv == null) {
            return;
        }
        this.trees = Trees.instance(this.javacProcessingEnv);
    }

    protected JCTree.JCCompilationUnit toUnit(Element element) {
        TreePath path = null;
        if (this.trees != null) {
            try {
                path = this.trees.getPath(element);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if (path == null) {
            return null;
        }
        return (JCTree.JCCompilationUnit)path.getCompilationUnit();
    }

    public JavacProcessingEnvironment getJavacProcessingEnvironment(Object procEnv) {
        TypeAwareProcessor.addOpens();
        if (procEnv instanceof JavacProcessingEnvironment) {
            return (JavacProcessingEnvironment)procEnv;
        }
        for (Class<?> procEnvClass = procEnv.getClass(); procEnvClass != null; procEnvClass = procEnvClass.getSuperclass()) {
            Object delegate = this.tryGetDelegateField(procEnvClass, procEnv);
            if (delegate == null) {
                delegate = this.tryGetProxyDelegateToField(procEnv);
            }
            if (delegate == null) {
                delegate = this.tryGetProcessingEnvField(procEnvClass, procEnv);
            }
            if (delegate == null) continue;
            return this.getJavacProcessingEnvironment(delegate);
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Can't get the delegate of the gradle IncrementalProcessingEnvironment. OpenRewrite's template processor won't work.");
        return null;
    }

    protected static void addOpens() {
        Class<?> cModule;
        try {
            cModule = Class.forName("java.lang.Module");
        }
        catch (ClassNotFoundException e) {
            return;
        }
        Unsafe unsafe = TypeAwareProcessor.getUnsafe();
        Object jdkCompilerModule = TypeAwareProcessor.getJdkCompilerModule();
        Object ownModule = TypeAwareProcessor.getOwnModule();
        String[] allPkgs = new String[]{"com.sun.tools.javac.code", "com.sun.tools.javac.comp", "com.sun.tools.javac.file", "com.sun.tools.javac.main", "com.sun.tools.javac.model", "com.sun.tools.javac.parser", "com.sun.tools.javac.processing", "com.sun.tools.javac.tree", "com.sun.tools.javac.util", "com.sun.tools.javac.jvm"};
        try {
            Method m = cModule.getDeclaredMethod("implAddOpens", String.class, cModule);
            long firstFieldOffset = TypeAwareProcessor.getFirstFieldOffset(unsafe);
            unsafe.putBooleanVolatile(m, firstFieldOffset, true);
            for (String p : allPkgs) {
                m.invoke(jdkCompilerModule, p, ownModule);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static long getFirstFieldOffset(Unsafe unsafe) {
        try {
            return unsafe.objectFieldOffset(Parent.class.getDeclaredField("first"));
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    protected static Unsafe getUnsafe() {
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            return (Unsafe)theUnsafe.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected static Object getOwnModule() {
        try {
            Method m = Permit.getMethod(Class.class, "getModule", new Class[0]);
            return m.invoke(RefasterTemplateProcessor.class, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected static Object getJdkCompilerModule() {
        try {
            Class<?> cModuleLayer = Class.forName("java.lang.ModuleLayer");
            Method mBoot = cModuleLayer.getDeclaredMethod("boot", new Class[0]);
            Object bootLayer = mBoot.invoke(null, new Object[0]);
            Class<?> cOptional = Class.forName("java.util.Optional");
            Method mFindModule = cModuleLayer.getDeclaredMethod("findModule", String.class);
            Object oCompilerO = mFindModule.invoke(bootLayer, "jdk.compiler");
            return cOptional.getDeclaredMethod("get", new Class[0]).invoke(oCompilerO, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected Object tryGetDelegateField(Class<?> delegateClass, Object instance) {
        try {
            return Permit.getField(delegateClass, "delegate").get(instance);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected Object tryGetProcessingEnvField(Class<?> delegateClass, Object instance) {
        try {
            return Permit.getField(delegateClass, "processingEnv").get(instance);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected Object tryGetProxyDelegateToField(Object instance) {
        try {
            InvocationHandler handler = Proxy.getInvocationHandler(instance);
            return Permit.getField(handler.getClass(), "val$delegateTo").get(handler);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected String getBoxedPrimitive(String paramType) {
        switch (paramType) {
            case "boolean": {
                return "Boolean";
            }
            case "byte": {
                return "Byte";
            }
            case "char": {
                return "Character";
            }
            case "double": {
                return "Double";
            }
            case "float": {
                return "Float";
            }
            case "int": {
                return "Integer";
            }
            case "long": {
                return "Long";
            }
            case "short": {
                return "Short";
            }
            case "void": {
                return "Void";
            }
        }
        return paramType;
    }
}

