/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.template.processor;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.template.internal.FQNPretty;
import org.openrewrite.java.template.internal.ImportDetector;
import org.openrewrite.java.template.internal.JavacResolution;
import org.openrewrite.java.template.internal.UsedMethodDetector;
import org.openrewrite.java.template.processor.TypeAwareProcessor;

@SupportedAnnotationTypes(value={"com.google.errorprone.refaster.annotation.BeforeTemplate", "com.google.errorprone.refaster.annotation.AfterTemplate"})
public class RefasterTemplateProcessor
extends TypeAwareProcessor {
    static final String BEFORE_TEMPLATE = "com.google.errorprone.refaster.annotation.BeforeTemplate";
    static final String AFTER_TEMPLATE = "com.google.errorprone.refaster.annotation.AfterTemplate";
    static Set<String> UNSUPPORTED_ANNOTATIONS = Stream.of("com.google.errorprone.refaster.annotation.AlsoNegation", "com.google.errorprone.refaster.annotation.AllowCodeBetweenLines", "com.google.errorprone.refaster.annotation.Matches", "com.google.errorprone.refaster.annotation.MayOptionallyUse", "com.google.errorprone.refaster.annotation.NoAutoboxing", "com.google.errorprone.refaster.annotation.NotMatches", "com.google.errorprone.refaster.annotation.OfKind", "com.google.errorprone.refaster.annotation.Placeholder", "com.google.errorprone.refaster.annotation.Repeated").collect(Collectors.toSet());
    static ClassValue<java.util.List<String>> LST_TYPE_MAP = new ClassValue<java.util.List<String>>(){

        @Override
        protected java.util.List<String> computeValue(Class<?> type) {
            if (JCTree.JCUnary.class.isAssignableFrom(type)) {
                return Collections.singletonList("J.Unary");
            }
            if (JCTree.JCBinary.class.isAssignableFrom(type)) {
                return Collections.singletonList("J.Binary");
            }
            if (JCTree.JCMethodInvocation.class.isAssignableFrom(type)) {
                return Collections.singletonList("J.MethodInvocation");
            }
            if (JCTree.JCFieldAccess.class.isAssignableFrom(type)) {
                return Arrays.asList("J.FieldAccess", "J.Identifier");
            }
            if (JCTree.JCConditional.class.isAssignableFrom(type)) {
                return Collections.singletonList("J.Ternary");
            }
            if (JCTree.JCNewClass.class.isAssignableFrom(type)) {
                return Collections.singletonList("J.NewClass");
            }
            if (JCTree.JCExpression.class.isAssignableFrom(type)) {
                return Collections.singletonList("Expression");
            }
            if (JCTree.JCStatement.class.isAssignableFrom(type)) {
                return Collections.singletonList("Statement");
            }
            throw new IllegalArgumentException(type.toString());
        }
    };
    private final Map<String, Integer> printedMessages = new TreeMap<String, Integer>();

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getRootElements()) {
            JCTree.JCCompilationUnit jcCompilationUnit = this.toUnit(element);
            if (jcCompilationUnit == null) continue;
            this.maybeGenerateTemplateSources(jcCompilationUnit);
        }
        return false;
    }

    void maybeGenerateTemplateSources(final JCTree.JCCompilationUnit cu) {
        final Context context = this.javacProcessingEnv.getContext();
        new TreeScanner(){
            final Map<JCTree.JCMethodDecl, Set<String>> imports = new HashMap<JCTree.JCMethodDecl, Set<String>>();
            final Map<JCTree.JCMethodDecl, Set<String>> staticImports = new HashMap<JCTree.JCMethodDecl, Set<String>>();
            final Map<String, String> recipes = new LinkedHashMap<String, String>();

            /*
             * WARNING - void declaration
             */
            @Override
            public void visitClassDef(JCTree.JCClassDecl classDecl) {
                super.visitClassDef(classDecl);
                TemplateDescriptor descriptor = RefasterTemplateProcessor.this.getTemplateDescriptor(classDecl, context, cu);
                if (descriptor != null) {
                    TreeMaker treeMaker = TreeMaker.instance(context).forToplevel(cu);
                    java.util.List membersWithoutConstructor = classDecl.getMembers().stream().filter(m -> !(m instanceof JCTree.JCMethodDecl) || !((JCTree.JCMethodDecl)m).name.contentEquals("<init>")).collect(Collectors.toList());
                    JCTree.JCClassDecl copy = treeMaker.ClassDef(classDecl.mods, classDecl.name, classDecl.typarams, classDecl.extending, classDecl.implementing, List.from(membersWithoutConstructor));
                    String templateFqn = classDecl.sym.fullname.toString() + "Recipe";
                    String templateCode = copy.toString().trim();
                    for (JCTree.JCMethodDecl jCMethodDecl : descriptor.beforeTemplates) {
                        for (Symbol symbol : ImportDetector.imports(jCMethodDecl)) {
                            if (symbol instanceof Symbol.ClassSymbol) {
                                this.imports.computeIfAbsent(jCMethodDecl, k -> new TreeSet()).add(symbol.getQualifiedName().toString().replace('$', '.'));
                                continue;
                            }
                            if (symbol instanceof Symbol.VarSymbol || symbol instanceof Symbol.MethodSymbol) {
                                this.staticImports.computeIfAbsent(jCMethodDecl, k -> new TreeSet()).add(symbol.owner.getQualifiedName().toString().replace('$', '.') + '.' + symbol.flatName().toString());
                                continue;
                            }
                            throw new AssertionError(symbol.getClass());
                        }
                    }
                    for (Symbol symbol : ImportDetector.imports(descriptor.afterTemplate)) {
                        if (symbol instanceof Symbol.ClassSymbol) {
                            this.imports.computeIfAbsent(descriptor.afterTemplate, k -> new TreeSet()).add(symbol.getQualifiedName().toString().replace('$', '.'));
                            continue;
                        }
                        if (symbol instanceof Symbol.VarSymbol || symbol instanceof Symbol.MethodSymbol) {
                            this.staticImports.computeIfAbsent(descriptor.afterTemplate, k -> new TreeSet()).add(symbol.owner.getQualifiedName().toString().replace('$', '.') + '.' + symbol.flatName().toString());
                            continue;
                        }
                        throw new AssertionError(symbol.getClass());
                    }
                    for (Set set : this.imports.values()) {
                        set.removeIf(i -> {
                            int endIndex = i.lastIndexOf(46);
                            return endIndex < 0 || "java.lang".equals(i.substring(0, endIndex));
                        });
                        set.remove(RefasterTemplateProcessor.BEFORE_TEMPLATE);
                        set.remove(RefasterTemplateProcessor.AFTER_TEMPLATE);
                    }
                    LinkedHashMap<void, JCTree.JCMethodDecl> beforeTemplates = new LinkedHashMap<void, JCTree.JCMethodDecl>();
                    for (JCTree.JCMethodDecl templ : descriptor.beforeTemplates) {
                        void var11_26;
                        String string = templ.getName().toString();
                        if (beforeTemplates.containsKey(string)) {
                            String string2;
                            String base = string;
                            int i2 = 0;
                            while (beforeTemplates.containsKey(string2 = base + i2)) {
                                ++i2;
                            }
                        }
                        beforeTemplates.put(var11_26, templ);
                    }
                    String string = descriptor.afterTemplate.getName().toString();
                    Iterator recipe = new StringBuilder();
                    Symbol.PackageSymbol packageSymbol = classDecl.sym.packge();
                    String typeName = classDecl.sym.fullname.toString();
                    String refasterRuleClassName = packageSymbol.isUnnamed() ? typeName : typeName.substring(packageSymbol.fullname.length() + 1);
                    ((StringBuilder)((Object)recipe)).append("/**\n * OpenRewrite recipe created for Refaster template {@code ").append(refasterRuleClassName).append("}.\n */\n");
                    String recipeName = templateFqn.substring(templateFqn.lastIndexOf(46) + 1);
                    ((StringBuilder)((Object)recipe)).append("@SuppressWarnings(\"all\")\n");
                    ((StringBuilder)((Object)recipe)).append("@NonNullApi\n");
                    ((StringBuilder)((Object)recipe)).append(descriptor.classDecl.sym.outermostClass() == descriptor.classDecl.sym ? "public class " : "public static class ").append(recipeName).append(" extends Recipe {\n\n");
                    ((StringBuilder)((Object)recipe)).append("    /**\n");
                    ((StringBuilder)((Object)recipe)).append("     * Instantiates a new instance.\n");
                    ((StringBuilder)((Object)recipe)).append("     */\n");
                    ((StringBuilder)((Object)recipe)).append("    public ").append(recipeName).append("() {}\n\n");
                    ((StringBuilder)((Object)recipe)).append(this.recipeDescriptor(classDecl, "Refaster template `" + refasterRuleClassName + '`', "Recipe created for the following Refaster template:\\n```java\\n" + RefasterTemplateProcessor.this.escape(templateCode) + "\\n```\\n."));
                    ((StringBuilder)((Object)recipe)).append("    @Override\n");
                    ((StringBuilder)((Object)recipe)).append("    public TreeVisitor<?, ExecutionContext> getVisitor() {\n");
                    ((StringBuilder)((Object)recipe)).append("        JavaVisitor<ExecutionContext> javaVisitor = new AbstractRefasterJavaVisitor() {\n");
                    for (Map.Entry entry : beforeTemplates.entrySet()) {
                        ((StringBuilder)((Object)recipe)).append("            final JavaTemplate ").append((String)entry.getKey()).append(" = Semantics.").append(RefasterTemplateProcessor.this.statementType((JCTree.JCMethodDecl)entry.getValue())).append("(this, \"").append((String)entry.getKey()).append("\", ").append(RefasterTemplateProcessor.this.toLambda((JCTree.JCMethodDecl)entry.getValue())).append(").build();\n");
                    }
                    ((StringBuilder)((Object)recipe)).append("            final JavaTemplate ").append(string).append(" = Semantics.").append(RefasterTemplateProcessor.this.statementType(descriptor.afterTemplate)).append("(this, \"").append(string).append("\", ").append(RefasterTemplateProcessor.this.toLambda(descriptor.afterTemplate)).append(").build();\n");
                    ((StringBuilder)((Object)recipe)).append("\n");
                    java.util.List<String> lstTypes = LST_TYPE_MAP.get(RefasterTemplateProcessor.this.getType(descriptor.beforeTemplates.get(0)));
                    String parameters = RefasterTemplateProcessor.this.parameters(descriptor);
                    for (String lstType : lstTypes) {
                        String methodSuffix = lstType.startsWith("J.") ? lstType.substring(2) : lstType;
                        ((StringBuilder)((Object)recipe)).append("            @Override\n");
                        ((StringBuilder)((Object)recipe)).append("            public J visit").append(methodSuffix).append("(").append(lstType).append(" elem, ExecutionContext ctx) {\n");
                        if (lstType.equals("Statement")) {
                            ((StringBuilder)((Object)recipe)).append("                if (elem instanceof J.Block) {;\n");
                            ((StringBuilder)((Object)recipe)).append("                    // FIXME workaround\n");
                            ((StringBuilder)((Object)recipe)).append("                    return elem;\n");
                            ((StringBuilder)((Object)recipe)).append("                }\n");
                        }
                        ((StringBuilder)((Object)recipe)).append("                JavaTemplate.Matcher matcher;\n");
                        for (Map.Entry entry : beforeTemplates.entrySet()) {
                            ((StringBuilder)((Object)recipe)).append("                if ((matcher = ").append((String)entry.getKey()).append(".matcher(getCursor())).find()").append(") {\n");
                            java.util.List jcVariableDecls = ((JCTree.JCMethodDecl)entry.getValue()).getParameters();
                            for (int i3 = 0; i3 < ((List)jcVariableDecls).size(); ++i3) {
                                JCTree.JCVariableDecl param = (JCTree.JCVariableDecl)((List)jcVariableDecls).get(i3);
                                java.util.List annotations = param.getModifiers().getAnnotations();
                                for (JCTree.JCAnnotation jcAnnotation : annotations) {
                                    String matcher;
                                    String annotationType = jcAnnotation.attribute.type.tsym.getQualifiedName().toString();
                                    if (annotationType.equals("org.openrewrite.java.template.NotMatches")) {
                                        matcher = ((Type.ClassType)((Attribute)jcAnnotation.attribute.getValue().values.get((int)0).snd).getValue()).tsym.getQualifiedName().toString();
                                        ((StringBuilder)((Object)recipe)).append("                    if (new ").append(matcher).append("().matches((Expression) matcher.parameter(").append(i3).append("))) {\n");
                                        ((StringBuilder)((Object)recipe)).append("                        return super.visit").append(methodSuffix).append("(elem, ctx);\n");
                                        ((StringBuilder)((Object)recipe)).append("                    }\n");
                                        continue;
                                    }
                                    if (!annotationType.equals("org.openrewrite.java.template.Matches")) continue;
                                    matcher = ((Type.ClassType)((Attribute)jcAnnotation.attribute.getValue().values.get((int)0).snd).getValue()).tsym.getQualifiedName().toString();
                                    ((StringBuilder)((Object)recipe)).append("                    if (!new ").append(matcher).append("().matches((Expression) matcher.parameter(").append(i3).append("))) {\n");
                                    ((StringBuilder)((Object)recipe)).append("                        return super.visit").append(methodSuffix).append("(elem, ctx);\n");
                                    ((StringBuilder)((Object)recipe)).append("                    }\n");
                                }
                            }
                            this.maybeRemoveImports(this.imports, (StringBuilder)((Object)recipe), (JCTree.JCMethodDecl)entry.getValue(), descriptor.afterTemplate);
                            this.maybeRemoveImports(this.staticImports, (StringBuilder)((Object)recipe), (JCTree.JCMethodDecl)entry.getValue(), descriptor.afterTemplate);
                            ArrayList<String> embedOptions = new ArrayList<String>();
                            JCTree.JCExpression afterReturn = RefasterTemplateProcessor.this.getReturnExpression(descriptor.afterTemplate);
                            if (afterReturn instanceof JCTree.JCParens || afterReturn instanceof JCTree.JCUnary && ((JCTree.JCUnary)afterReturn).getExpression() instanceof JCTree.JCParens) {
                                embedOptions.add("REMOVE_PARENS");
                            }
                            embedOptions.add("SHORTEN_NAMES");
                            if (this.simplifyBooleans(descriptor.afterTemplate)) {
                                embedOptions.add("SIMPLIFY_BOOLEANS");
                            }
                            ((StringBuilder)((Object)recipe)).append("                    return embed(\n");
                            ((StringBuilder)((Object)recipe)).append("                            ").append(string).append(".apply(getCursor(), elem.getCoordinates().replace()");
                            if (!parameters.isEmpty()) {
                                ((StringBuilder)((Object)recipe)).append(", ").append(parameters);
                            }
                            ((StringBuilder)((Object)recipe)).append("),\n");
                            ((StringBuilder)((Object)recipe)).append("                            getCursor(),\n");
                            ((StringBuilder)((Object)recipe)).append("                            ctx,\n");
                            ((StringBuilder)((Object)recipe)).append("                            ").append(String.join((CharSequence)", ", embedOptions)).append("\n");
                            ((StringBuilder)((Object)recipe)).append("                    );\n");
                            ((StringBuilder)((Object)recipe)).append("                }\n");
                        }
                        ((StringBuilder)((Object)recipe)).append("                return super.visit").append(methodSuffix).append("(elem, ctx);\n");
                        ((StringBuilder)((Object)recipe)).append("            }\n");
                        ((StringBuilder)((Object)recipe)).append("\n");
                    }
                    ((StringBuilder)((Object)recipe)).append("        };\n");
                    String preconditions = this.generatePreconditions(descriptor.beforeTemplates, this.imports, 16);
                    if (preconditions == null) {
                        ((StringBuilder)((Object)recipe)).append("        return javaVisitor;\n");
                    } else {
                        ((StringBuilder)((Object)recipe)).append("        return Preconditions.check(\n");
                        ((StringBuilder)((Object)recipe)).append("                ").append(preconditions).append(",\n");
                        ((StringBuilder)((Object)recipe)).append("                javaVisitor\n");
                        ((StringBuilder)((Object)recipe)).append("        );\n");
                    }
                    ((StringBuilder)((Object)recipe)).append("    }\n");
                    ((StringBuilder)((Object)recipe)).append("}\n");
                    this.recipes.put(recipeName, ((StringBuilder)((Object)recipe)).toString());
                }
                if (classDecl.sym != null && classDecl.sym.getNestingKind() == NestingKind.TOP_LEVEL && !this.recipes.isEmpty()) {
                    boolean outerClassRequired = descriptor == null;
                    try {
                        Symbol.PackageSymbol pkg = classDecl.sym.packge();
                        String inputOuterFQN = outerClassRequired ? classDecl.sym.fullname.toString() : descriptor.classDecl.sym.fullname.toString();
                        String className = inputOuterFQN + (outerClassRequired ? "Recipes" : "Recipe");
                        JavaFileObject builderFile = RefasterTemplateProcessor.this.processingEnv.getFiler().createSourceFile(className, new Element[0]);
                        Throwable throwable = null;
                        try (BufferedWriter out = new BufferedWriter(builderFile.openWriter());){
                            if (!pkg.isUnnamed()) {
                                out.write("package " + pkg.fullname + ";\n");
                                out.write("\n");
                            }
                            out.write("import org.openrewrite.ExecutionContext;\n");
                            out.write("import org.openrewrite.Preconditions;\n");
                            out.write("import org.openrewrite.Recipe;\n");
                            out.write("import org.openrewrite.TreeVisitor;\n");
                            out.write("import org.openrewrite.internal.lang.NonNullApi;\n");
                            out.write("import org.openrewrite.java.JavaTemplate;\n");
                            out.write("import org.openrewrite.java.JavaVisitor;\n");
                            out.write("import org.openrewrite.java.search.*;\n");
                            out.write("import org.openrewrite.java.template.Primitive;\n");
                            out.write("import org.openrewrite.java.template.Semantics;\n");
                            out.write("import org.openrewrite.java.template.function.*;\n");
                            out.write("import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;\n");
                            out.write("import org.openrewrite.java.tree.*;\n");
                            out.write("\n");
                            out.write("import java.util.*;\n");
                            out.write("\n");
                            out.write("import static org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor.EmbeddingOption.*;\n");
                            out.write("\n");
                            if (!this.imports.isEmpty()) {
                                for (String string : this.imports.values().stream().flatMap(Collection::stream).collect(Collectors.toSet())) {
                                    out.write("import " + string + ";\n");
                                }
                                out.write("\n");
                            }
                            if (!this.staticImports.isEmpty()) {
                                for (String string : this.staticImports.values().stream().flatMap(Collection::stream).collect(Collectors.toSet())) {
                                    out.write("import static " + string + ";\n");
                                }
                                out.write("\n");
                            }
                            if (outerClassRequired) {
                                out.write("/**\n * OpenRewrite recipes created for Refaster template {@code " + inputOuterFQN + "}.\n */\n");
                                String outerClassName = className.substring(className.lastIndexOf(46) + 1);
                                out.write("@SuppressWarnings(\"all\")\n");
                                out.write("public class " + outerClassName + " extends Recipe {\n");
                                out.write("    /**\n");
                                out.write("     * Instantiates a new instance.\n");
                                out.write("     */\n");
                                out.write("    public " + outerClassName + "() {}\n\n");
                                out.write(this.recipeDescriptor(classDecl, String.format("`%s` Refaster recipes", inputOuterFQN.substring(inputOuterFQN.lastIndexOf(46) + 1)), String.format("Refaster template recipes for `%s`.", inputOuterFQN)));
                                String string = this.recipes.keySet().stream().map(r -> "                new " + r.substring(r.lastIndexOf(46) + 1) + "()").collect(Collectors.joining(",\n"));
                                out.write("    @Override\n    public List<Recipe> getRecipeList() {\n        return Arrays.asList(\n" + string + '\n' + "        );\n    }\n\n");
                                for (String r2 : this.recipes.values()) {
                                    out.write(r2.replaceAll("(?m)^(.+)$", "    $1"));
                                    ((Writer)out).write(10);
                                }
                                out.write("}\n");
                            } else {
                                for (String string : this.recipes.values()) {
                                    out.write(string);
                                    ((Writer)out).write(10);
                                }
                            }
                        }
                        catch (Throwable throwable2) {
                            Throwable throwable3 = throwable2;
                            throw throwable2;
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }

            private boolean simplifyBooleans(JCTree.JCMethodDecl template) {
                if (template.getReturnType().type.getTag() == TypeTag.BOOLEAN) {
                    return true;
                }
                return new TreeScanner(){
                    boolean found;

                    boolean find(JCTree tree) {
                        this.scan(tree);
                        return this.found;
                    }

                    @Override
                    public void visitBinary(JCTree.JCBinary jcBinary) {
                        this.found |= jcBinary.type.getTag() == TypeTag.BOOLEAN;
                        super.visitBinary(jcBinary);
                    }

                    @Override
                    public void visitUnary(JCTree.JCUnary jcUnary) {
                        this.found |= jcUnary.type.getTag() == TypeTag.BOOLEAN;
                        super.visitUnary(jcUnary);
                    }
                }.find(template.getBody());
            }

            private String recipeDescriptor(JCTree.JCClassDecl classDecl, String defaultDisplayName, String defaultDescription) {
                String displayName = defaultDisplayName;
                String description = defaultDescription;
                LinkedHashSet<String> tags = new LinkedHashSet<String>();
                Tokens.Comment comment = cu.docComments.getComment(classDecl);
                if (comment != null && comment.getText() != null && !comment.getText().isEmpty()) {
                    String commentText = comment.getText().replaceAll("\\{@\\S+\\s+(.*?)}", "`$1`").replace("\\", "\\\\").replace("\"", "\\\"").replace("\b", "\\b").replace("\t", "\\t").replace("\f", "\\f").replace("\r", "\\r");
                    String[] lines = commentText.split("\\.\\R+", 2);
                    displayName = lines[0].trim().replace("\n", "");
                    if (displayName.endsWith(".")) {
                        displayName = displayName.substring(0, displayName.length() - 1);
                    }
                    if (lines.length > 1 && !lines[1].trim().isEmpty() && !(description = lines[1].trim().replace("\n", "\\n")).endsWith(".")) {
                        description = description + '.';
                    }
                }
                for (JCTree.JCAnnotation annotation : classDecl.getModifiers().getAnnotations()) {
                    if (!annotation.type.toString().equals("org.openrewrite.java.template.RecipeDescriptor")) continue;
                    for (JCTree.JCExpression argExpr : annotation.getArguments()) {
                        JCTree.JCAssign arg = (JCTree.JCAssign)argExpr;
                        switch (arg.lhs.toString()) {
                            case "name": {
                                displayName = RefasterTemplateProcessor.escapeJava(((JCTree.JCLiteral)arg.rhs).getValue().toString());
                                break;
                            }
                            case "description": {
                                description = RefasterTemplateProcessor.escapeJava(((JCTree.JCLiteral)arg.rhs).getValue().toString());
                                break;
                            }
                            case "tags": {
                                if (arg.rhs instanceof JCTree.JCLiteral) {
                                    tags.add(RefasterTemplateProcessor.escapeJava(((JCTree.JCLiteral)arg.rhs).getValue().toString()));
                                    break;
                                }
                                if (!(arg.rhs instanceof JCTree.JCNewArray)) break;
                                for (JCTree.JCExpression e : ((JCTree.JCNewArray)arg.rhs).elems) {
                                    tags.add(RefasterTemplateProcessor.escapeJava(((JCTree.JCLiteral)e).getValue().toString()));
                                }
                                break;
                            }
                        }
                    }
                }
                String recipeDescriptor = "    @Override\n    public String getDisplayName() {\n        return \"" + displayName + "\";\n    }\n\n    @Override\n    public String getDescription() {\n        return \"" + description + "\";\n    }\n\n";
                if (tags.size() == 1) {
                    recipeDescriptor = recipeDescriptor + "    @Override\n    public Set<String> getTags() {\n        return Collections.singleton(\"" + String.join((CharSequence)"\", \"", tags) + "\");\n    }\n\n";
                } else if (tags.size() > 1) {
                    recipeDescriptor = recipeDescriptor + "    @Override\n    public Set<String> getTags() {\n        return new HashSet<>(Arrays.asList(\"" + String.join((CharSequence)"\", \"", tags) + "\"));\n    }\n\n";
                }
                return recipeDescriptor;
            }

            private void maybeRemoveImports(Map<JCTree.JCMethodDecl, Set<String>> importsByTemplate, StringBuilder recipe, JCTree.JCMethodDecl beforeTemplate, JCTree.JCMethodDecl afterTemplate) {
                Set<String> beforeImports = this.getBeforeImportsAsStrings(importsByTemplate, beforeTemplate);
                beforeImports.removeAll(this.getImportsAsStrings(importsByTemplate, afterTemplate));
                beforeImports.removeIf(i -> i.startsWith("java.lang."));
                beforeImports.forEach(anImport -> recipe.append("                    maybeRemoveImport(\"").append((String)anImport).append("\");\n"));
            }

            private Set<String> getBeforeImportsAsStrings(Map<JCTree.JCMethodDecl, Set<String>> importsByTemplate, JCTree.JCMethodDecl templateMethod) {
                final Set<String> beforeImports = this.getImportsAsStrings(importsByTemplate, templateMethod);
                for (JCTree.JCMethodDecl beforeTemplate : importsByTemplate.keySet()) {
                    new TreeScanner(){

                        @Override
                        public void scan(JCTree tree) {
                            if (tree instanceof JCTree.JCFieldAccess && ((JCTree.JCFieldAccess)tree).sym instanceof Symbol.ClassSymbol && tree.toString().equals(((JCTree.JCFieldAccess)tree).sym.toString())) {
                                beforeImports.add(((JCTree.JCFieldAccess)tree).sym.toString());
                            }
                            super.scan(tree);
                        }
                    }.scan(beforeTemplate.getBody());
                }
                return beforeImports;
            }

            private Set<String> getImportsAsStrings(Map<JCTree.JCMethodDecl, Set<String>> importsByTemplate, JCTree.JCMethodDecl templateMethod) {
                return importsByTemplate.entrySet().stream().filter(e -> templateMethod == e.getKey()).map(Map.Entry::getValue).flatMap(Collection::stream).collect(Collectors.toSet());
            }

            @Nullable
            private String generatePreconditions(java.util.List<JCTree.JCMethodDecl> beforeTemplates, Map<JCTree.JCMethodDecl, Set<String>> imports, int indent) {
                LinkedHashMap preconditions = new LinkedHashMap();
                for (JCTree.JCMethodDecl jCMethodDecl : beforeTemplates) {
                    LinkedHashSet<String> usesVisitors = new LinkedHashSet<String>();
                    Set localImports = imports.getOrDefault(jCMethodDecl, Collections.emptySet());
                    for (String anImport : localImports) {
                        usesVisitors.add("new UsesType<>(\"" + anImport + "\", true)");
                    }
                    java.util.List<Symbol.MethodSymbol> usedMethods = UsedMethodDetector.usedMethods(jCMethodDecl);
                    for (Symbol.MethodSymbol method : usedMethods) {
                        String methodName = method.name.toString();
                        methodName = methodName.equals("<init>") ? "<constructor>" : methodName;
                        usesVisitors.add("new UsesMethod<>(\"" + method.owner.getQualifiedName().toString() + ' ' + methodName + "(..)\")");
                    }
                    preconditions.put(jCMethodDecl, usesVisitors);
                }
                if (preconditions.size() == 1) {
                    return this.joinPreconditions((Collection)preconditions.values().iterator().next(), "and", indent + 4);
                }
                if (preconditions.size() > 1) {
                    LinkedHashSet<String> common = new LinkedHashSet<String>();
                    for (String dep2 : (Set)preconditions.values().iterator().next()) {
                        if (!preconditions.values().stream().allMatch(v -> v.contains(dep2))) continue;
                        common.add(dep2);
                    }
                    common.forEach(dep -> preconditions.values().forEach(v -> v.remove(dep)));
                    preconditions.values().removeIf(Collection::isEmpty);
                    if (common.isEmpty()) {
                        return this.joinPreconditions(preconditions.values().stream().map(v -> this.joinPreconditions((Collection<String>)v, "and", indent + 4)).collect(Collectors.toList()), "or", indent + 4);
                    }
                    if (!preconditions.isEmpty()) {
                        String string = this.joinPreconditions(preconditions.values().stream().map(v -> this.joinPreconditions((Collection<String>)v, "and", indent + 12)).collect(Collectors.toList()), "or", indent + 8);
                        common.add(string);
                    }
                    return this.joinPreconditions(common, "and", indent + 4);
                }
                return null;
            }

            private String joinPreconditions(Collection<String> preconditions, String op, int indent) {
                if (preconditions.isEmpty()) {
                    return null;
                }
                if (preconditions.size() == 1) {
                    return preconditions.iterator().next();
                }
                char[] indentChars = new char[indent];
                Arrays.fill(indentChars, ' ');
                String indentStr = new String(indentChars);
                return "Preconditions." + op + "(\n" + indentStr + String.join((CharSequence)(",\n" + indentStr), preconditions) + "\n" + indentStr.substring(0, indent - 4) + ')';
            }
        }.scan(cu);
    }

    private String escape(String string) {
        return string.replace("\\", "\\\\").replace("\"", "\\\"").replaceAll("\\R", "\\\\n");
    }

    private String parameters(TemplateDescriptor descriptor) {
        final ArrayList afterParams = new ArrayList();
        final HashSet seenParams = new HashSet();
        new TreeScanner(){

            @Override
            public void scan(JCTree jcTree) {
                if (jcTree instanceof JCTree.JCIdent) {
                    JCTree.JCIdent jcIdent = (JCTree.JCIdent)jcTree;
                    if (jcIdent.sym instanceof Symbol.VarSymbol && jcIdent.sym.owner instanceof Symbol.MethodSymbol && ((Symbol.MethodSymbol)jcIdent.sym.owner).params.contains(jcIdent.sym) && seenParams.add(jcIdent.sym)) {
                        afterParams.add(((Symbol.MethodSymbol)jcIdent.sym.owner).params.indexOf(jcIdent.sym));
                    }
                }
                super.scan(jcTree);
            }
        }.scan(descriptor.afterTemplate.body);
        StringJoiner joiner = new StringJoiner(", ");
        for (Integer param : afterParams) {
            joiner.add("matcher.parameter(" + param + ")");
        }
        return joiner.toString();
    }

    private Class<? extends JCTree> getType(JCTree.JCMethodDecl method) {
        JCTree.JCExpression returnExpression = this.getReturnExpression(method);
        return returnExpression != null ? returnExpression.getClass() : ((JCTree.JCStatement)((List)method.getBody().getStatements()).last()).getClass();
    }

    @Nullable
    private JCTree.JCExpression getReturnExpression(JCTree.JCMethodDecl method) {
        JCTree.JCStatement statement = (JCTree.JCStatement)((List)method.getBody().getStatements()).last();
        if (statement instanceof JCTree.JCReturn) {
            return ((JCTree.JCReturn)statement).expr;
        }
        if (statement instanceof JCTree.JCExpressionStatement) {
            return ((JCTree.JCExpressionStatement)statement).expr;
        }
        return null;
    }

    private String statementType(JCTree.JCMethodDecl method) {
        Class<? extends JCTree> type;
        Set expressionStatementTypes = Stream.of(JCTree.JCMethodInvocation.class, JCTree.JCNewClass.class).collect(Collectors.toSet());
        if (expressionStatementTypes.contains(type = this.getType(method))) {
            if (type == JCTree.JCMethodInvocation.class && ((List)method.getBody().getStatements()).last() instanceof JCTree.JCExpressionStatement && !(method.getReturnType().type instanceof Type.JCVoidType)) {
                return "expression";
            }
            if (method.restype.type instanceof Type.JCVoidType || !JCTree.JCExpression.class.isAssignableFrom(type)) {
                return "statement";
            }
        }
        return "expression";
    }

    private String toLambda(JCTree.JCMethodDecl method) {
        String string;
        StringBuilder builder = new StringBuilder();
        StringJoiner joiner = new StringJoiner(", ", "(", ")");
        for (JCTree.JCVariableDecl parameter : method.getParameters()) {
            String paramType = parameter.getType().type.toString();
            if (!this.getBoxedPrimitive(paramType).equals(paramType)) {
                paramType = "@Primitive " + this.getBoxedPrimitive(paramType);
            } else if (paramType.startsWith("java.lang.")) {
                paramType = paramType.substring("java.lang.".length());
            }
            joiner.add(paramType + " " + parameter.getName());
        }
        builder.append(joiner);
        builder.append(" -> ");
        JCTree.JCStatement statement = (JCTree.JCStatement)((List)method.getBody().getStatements()).get(0);
        if (statement instanceof JCTree.JCReturn) {
            builder.append(FQNPretty.toString(((JCTree.JCReturn)statement).getExpression()));
        } else if (statement instanceof JCTree.JCThrow) {
            string = FQNPretty.toString(statement);
            builder.append("{ ").append(string).append(" }");
        } else {
            string = FQNPretty.toString(statement);
            builder.append(string);
        }
        return builder.toString();
    }

    @Nullable
    private TemplateDescriptor getTemplateDescriptor(JCTree.JCClassDecl tree, Context context, JCTree.JCCompilationUnit cu) {
        TemplateDescriptor result = new TemplateDescriptor(tree);
        for (JCTree member : tree.getMembers()) {
            if (!(member instanceof JCTree.JCMethodDecl)) continue;
            JCTree.JCMethodDecl method = (JCTree.JCMethodDecl)member;
            java.util.List<JCTree.JCAnnotation> annotations = RefasterTemplateProcessor.getTemplateAnnotations(method, BEFORE_TEMPLATE::equals);
            if (!annotations.isEmpty()) {
                result.beforeTemplate(method);
            }
            if ((annotations = RefasterTemplateProcessor.getTemplateAnnotations(method, AFTER_TEMPLATE::equals)).isEmpty()) continue;
            result.afterTemplate(method);
        }
        return result.validate(context, cu);
    }

    private void printNoteOnce(String message, Symbol.ClassSymbol symbol) {
        if (this.printedMessages.compute(message, (k, v) -> v == null ? 1 : v + 1) == 1) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, message, symbol);
        }
    }

    private static java.util.List<JCTree.JCAnnotation> getTemplateAnnotations(MethodTree method, Predicate<String> typePredicate) {
        ArrayList<JCTree.JCAnnotation> result = new ArrayList<JCTree.JCAnnotation>();
        for (AnnotationTree annotationTree : method.getModifiers().getAnnotations()) {
            Tree type = annotationTree.getAnnotationType();
            if (type.getKind() == Tree.Kind.IDENTIFIER && ((JCTree.JCIdent)type).sym != null && typePredicate.test(((JCTree.JCIdent)type).sym.getQualifiedName().toString())) {
                result.add((JCTree.JCAnnotation)annotationTree);
                continue;
            }
            if (type.getKind() == Tree.Kind.IDENTIFIER && ((JCTree.JCAnnotation)annotationTree).attribute != null && ((JCTree.JCAnnotation)annotationTree).attribute.type instanceof Type.ClassType && ((JCTree.JCAnnotation)annotationTree).attribute.type.tsym != null && typePredicate.test(((JCTree.JCAnnotation)annotationTree).attribute.type.tsym.getQualifiedName().toString())) {
                result.add((JCTree.JCAnnotation)annotationTree);
                continue;
            }
            if (type.getKind() != Tree.Kind.MEMBER_SELECT || !(type instanceof JCTree.JCFieldAccess) || ((JCTree.JCFieldAccess)type).sym == null || !typePredicate.test(((JCTree.JCFieldAccess)type).sym.getQualifiedName().toString())) continue;
            result.add((JCTree.JCAnnotation)annotationTree);
        }
        return result;
    }

    private static java.util.List<JCTree.JCAnnotation> getTemplateAnnotations(VariableTree parameter, Predicate<String> typePredicate) {
        ArrayList<JCTree.JCAnnotation> result = new ArrayList<JCTree.JCAnnotation>();
        for (AnnotationTree annotationTree : parameter.getModifiers().getAnnotations()) {
            Tree type = annotationTree.getAnnotationType();
            if (type.getKind() == Tree.Kind.IDENTIFIER && ((JCTree.JCIdent)type).sym != null && typePredicate.test(((JCTree.JCIdent)type).sym.getQualifiedName().toString())) {
                result.add((JCTree.JCAnnotation)annotationTree);
                continue;
            }
            if (type.getKind() != Tree.Kind.MEMBER_SELECT || !(type instanceof JCTree.JCFieldAccess) || ((JCTree.JCFieldAccess)type).sym == null || !typePredicate.test(((JCTree.JCFieldAccess)type).sym.getQualifiedName().toString())) continue;
            result.add((JCTree.JCAnnotation)annotationTree);
        }
        return result;
    }

    private static String escapeJava(String input) {
        return input.replace("\\", "\\\\").replace("\"", "\\\"").replace("\b", "\\b").replace("\n", "\\n").replace("\t", "\\t").replace("\f", "\\f").replace("\r", "\\r");
    }

    class TemplateDescriptor {
        final JCTree.JCClassDecl classDecl;
        final java.util.List<JCTree.JCMethodDecl> beforeTemplates = new ArrayList<JCTree.JCMethodDecl>();
        JCTree.JCMethodDecl afterTemplate;

        public TemplateDescriptor(JCTree.JCClassDecl classDecl) {
            this.classDecl = classDecl;
        }

        @Nullable
        private TemplateDescriptor validate(Context context, JCTree.JCCompilationUnit cu) {
            if (this.beforeTemplates.isEmpty() || this.afterTemplate == null) {
                return null;
            }
            if (this.classDecl.typarams != null && !this.classDecl.typarams.isEmpty()) {
                RefasterTemplateProcessor.this.printNoteOnce("Generic type parameters are currently not supported", this.classDecl.sym);
                return null;
            }
            for (JCTree member : this.classDecl.getMembers()) {
                if (!(member instanceof JCTree.JCMethodDecl) || this.beforeTemplates.contains(member) || member == this.afterTemplate) continue;
                Iterator iterator = RefasterTemplateProcessor.getTemplateAnnotations((JCTree.JCMethodDecl)member, (Predicate<String>)UNSUPPORTED_ANNOTATIONS::contains).iterator();
                if (!iterator.hasNext()) continue;
                JCTree.JCAnnotation annotation = (JCTree.JCAnnotation)iterator.next();
                RefasterTemplateProcessor.this.printNoteOnce("@" + annotation.annotationType + " is currently not supported", this.classDecl.sym);
                return null;
            }
            boolean valid = this.resolve(context, cu);
            if (valid) {
                for (JCTree.JCMethodDecl template : this.beforeTemplates) {
                    valid = valid && this.validateTemplateMethod(template);
                }
                valid = valid && this.validateTemplateMethod(this.afterTemplate);
            }
            return valid ? this : null;
        }

        private boolean validateTemplateMethod(JCTree.JCMethodDecl template) {
            if (template.typarams != null && !template.typarams.isEmpty()) {
                RefasterTemplateProcessor.this.printNoteOnce("Generic type parameters are currently not supported", this.classDecl.sym);
                return false;
            }
            Iterator<Object> iterator = RefasterTemplateProcessor.getTemplateAnnotations(template, (Predicate<String>)UNSUPPORTED_ANNOTATIONS::contains).iterator();
            if (iterator.hasNext()) {
                JCTree.JCAnnotation annotation = (JCTree.JCAnnotation)iterator.next();
                RefasterTemplateProcessor.this.printNoteOnce("@" + annotation.annotationType + " is currently not supported", this.classDecl.sym);
                return false;
            }
            for (JCTree.JCVariableDecl parameter : template.getParameters()) {
                Iterator iterator2 = RefasterTemplateProcessor.getTemplateAnnotations(parameter, (Predicate<String>)UNSUPPORTED_ANNOTATIONS::contains).iterator();
                if (iterator2.hasNext()) {
                    JCTree.JCAnnotation annotation = (JCTree.JCAnnotation)iterator2.next();
                    RefasterTemplateProcessor.this.printNoteOnce("@" + annotation.annotationType + " is currently not supported", this.classDecl.sym);
                    return false;
                }
                if (!(parameter.vartype.type instanceof Type.TypeVar)) continue;
                RefasterTemplateProcessor.this.printNoteOnce("Generic type parameters are currently not supported", this.classDecl.sym);
                return false;
            }
            if (template.restype.type instanceof Type.TypeVar) {
                RefasterTemplateProcessor.this.printNoteOnce("Generic type parameters are currently not supported", this.classDecl.sym);
                return false;
            }
            if (template.body.stats.get(0) instanceof JCTree.JCIf) {
                RefasterTemplateProcessor.this.printNoteOnce("If statements are currently not supported", this.classDecl.sym);
                return false;
            }
            if (template.body.stats.get(0) instanceof JCTree.JCReturn) {
                JCTree.JCExpression expr = ((JCTree.JCReturn)template.body.stats.get((int)0)).expr;
                if (expr instanceof JCTree.JCLambda) {
                    RefasterTemplateProcessor.this.printNoteOnce("Lambdas are currently not supported", this.classDecl.sym);
                    return false;
                }
                if (expr instanceof JCTree.JCMemberReference) {
                    RefasterTemplateProcessor.this.printNoteOnce("Method references are currently not supported", this.classDecl.sym);
                    return false;
                }
            }
            return new TreeScanner(){
                boolean valid = true;

                boolean validate(JCTree tree) {
                    this.scan(tree);
                    return this.valid;
                }

                @Override
                public void visitIdent(JCTree.JCIdent jcIdent) {
                    if (this.valid && jcIdent.sym != null && jcIdent.sym.packge().getQualifiedName().contentEquals("com.google.errorprone.refaster")) {
                        RefasterTemplateProcessor.this.printNoteOnce(jcIdent.type.tsym.getQualifiedName() + " is currently not supported", TemplateDescriptor.this.classDecl.sym);
                        this.valid = false;
                    }
                }
            }.validate(template.getBody());
        }

        public void beforeTemplate(JCTree.JCMethodDecl method) {
            this.beforeTemplates.add(method);
        }

        public void afterTemplate(JCTree.JCMethodDecl method) {
            this.afterTemplate = method;
        }

        private boolean resolve(Context context, JCTree.JCCompilationUnit cu) {
            try {
                JavacResolution res = new JavacResolution(context);
                this.beforeTemplates.replaceAll(key -> {
                    Map<JCTree, JCTree> resolved = res.resolveAll(context, cu, Collections.singletonList(key));
                    return (JCTree.JCMethodDecl)resolved.get(key);
                });
                Map<JCTree, JCTree> resolved = res.resolveAll(context, cu, Collections.singletonList(this.afterTemplate));
                this.afterTemplate = (JCTree.JCMethodDecl)resolved.get(this.afterTemplate);
            }
            catch (Throwable t) {
                RefasterTemplateProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Had trouble type attributing the template.");
                return false;
            }
            return true;
        }
    }
}

