/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.template.internal;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jspecify.annotations.Nullable;

public final class Permit {
    private Permit() {
    }

    public static <T extends AccessibleObject> T setAccessible(T accessor) {
        accessor.setAccessible(true);
        return accessor;
    }

    public static Method getMethod(Class<?> c, String mName, Class<?> ... parameterTypes) throws NoSuchMethodException {
        Method m = null;
        Class<?> oc = c;
        while (c != null) {
            try {
                m = c.getDeclaredMethod(mName, parameterTypes);
                break;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                c = c.getSuperclass();
            }
        }
        if (m == null) {
            throw new NoSuchMethodException(oc.getName() + " :: " + mName + "(args)");
        }
        return Permit.setAccessible(m);
    }

    public static Field getField(Class<?> c, String fName) throws NoSuchFieldException {
        Field f = null;
        Class<?> oc = c;
        while (c != null) {
            try {
                f = c.getDeclaredField(fName);
                break;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                c = c.getSuperclass();
            }
        }
        if (f == null) {
            throw new NoSuchFieldException(oc.getName() + " :: " + fName);
        }
        return Permit.setAccessible(f);
    }

    public static @Nullable Field permissiveGetField(Class<?> c, String fName) {
        try {
            return Permit.getField(c, fName);
        }
        catch (Exception ignore) {
            return null;
        }
    }

    public static <T> @Nullable T permissiveReadField(Class<T> type, Field f, Object instance) {
        try {
            return type.cast(f.get(instance));
        }
        catch (Exception ignore) {
            return null;
        }
    }

    public static <T> Constructor<T> getConstructor(Class<T> c, Class<?> ... parameterTypes) throws NoSuchMethodException {
        return Permit.setAccessible(c.getDeclaredConstructor(parameterTypes));
    }

    private static Object reflectiveStaticFieldAccess(Class<?> c, String fName) {
        try {
            Field f = c.getDeclaredField(fName);
            f.setAccessible(true);
            return f.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isDebugReflection() {
        return !"false".equals(System.getProperty("lombok.debug.reflection", "false"));
    }

    public static void handleReflectionDebug(Throwable t, @Nullable Throwable initError) {
        if (!Permit.isDebugReflection()) {
            return;
        }
        System.err.println("** LOMBOK REFLECTION exception: " + t.getClass() + ": " + (t.getMessage() == null ? "(no message)" : t.getMessage()));
        t.printStackTrace(System.err);
        if (initError != null) {
            System.err.println("*** ADDITIONALLY, exception occurred setting up reflection: ");
            initError.printStackTrace(System.err);
        }
    }

    public static Object invoke(Method m, Object receiver, Object ... args) throws IllegalAccessException, InvocationTargetException {
        return Permit.invoke(null, m, receiver, args);
    }

    public static Object invoke(Throwable initError, Method m, Object receiver, Object ... args) throws IllegalAccessException, InvocationTargetException {
        try {
            return m.invoke(receiver, args);
        }
        catch (IllegalAccessException e) {
            Permit.handleReflectionDebug(e, initError);
            throw e;
        }
        catch (RuntimeException e) {
            Permit.handleReflectionDebug(e, initError);
            throw e;
        }
        catch (Error e) {
            Permit.handleReflectionDebug(e, initError);
            throw e;
        }
    }

    public static @Nullable Object invokeSneaky(Method m, Object receiver, Object ... args) {
        return Permit.invokeSneaky(null, m, receiver, args);
    }

    public static @Nullable Object invokeSneaky(Throwable initError, Method m, Object receiver, Object ... args) {
        try {
            return m.invoke(receiver, args);
        }
        catch (NoClassDefFoundError e) {
            Permit.handleReflectionDebug(e, initError);
            return null;
        }
        catch (NullPointerException e) {
            Permit.handleReflectionDebug(e, initError);
            return null;
        }
        catch (IllegalAccessException e) {
            Permit.handleReflectionDebug(e, initError);
            throw Permit.sneakyThrow(e);
        }
        catch (InvocationTargetException e) {
            throw Permit.sneakyThrow(e.getCause());
        }
        catch (RuntimeException e) {
            Permit.handleReflectionDebug(e, initError);
            throw e;
        }
        catch (Error e) {
            Permit.handleReflectionDebug(e, initError);
            throw e;
        }
    }

    public static <T> T newInstance(Constructor<T> c, Object ... args) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        return Permit.newInstance(null, c, args);
    }

    public static <T> T newInstance(Throwable initError, Constructor<T> c, Object ... args) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        try {
            return c.newInstance(args);
        }
        catch (IllegalAccessException e) {
            Permit.handleReflectionDebug(e, initError);
            throw e;
        }
        catch (InstantiationException e) {
            Permit.handleReflectionDebug(e, initError);
            throw e;
        }
        catch (RuntimeException e) {
            Permit.handleReflectionDebug(e, initError);
            throw e;
        }
        catch (Error e) {
            Permit.handleReflectionDebug(e, initError);
            throw e;
        }
    }

    public static <T> @Nullable T newInstanceSneaky(Constructor<T> c, Object ... args) {
        return Permit.newInstanceSneaky(null, c, args);
    }

    public static <T> @Nullable T newInstanceSneaky(Throwable initError, Constructor<T> c, Object ... args) {
        try {
            return c.newInstance(args);
        }
        catch (NoClassDefFoundError e) {
            Permit.handleReflectionDebug(e, initError);
            return null;
        }
        catch (NullPointerException e) {
            Permit.handleReflectionDebug(e, initError);
            return null;
        }
        catch (IllegalAccessException e) {
            Permit.handleReflectionDebug(e, initError);
            throw Permit.sneakyThrow(e);
        }
        catch (InstantiationException e) {
            Permit.handleReflectionDebug(e, initError);
            throw Permit.sneakyThrow(e);
        }
        catch (InvocationTargetException e) {
            throw Permit.sneakyThrow(e.getCause());
        }
        catch (RuntimeException e) {
            Permit.handleReflectionDebug(e, initError);
            throw e;
        }
        catch (Error e) {
            Permit.handleReflectionDebug(e, initError);
            throw e;
        }
    }

    public static Object get(Field f, Object receiver) throws IllegalAccessException {
        try {
            return f.get(receiver);
        }
        catch (IllegalAccessException e) {
            Permit.handleReflectionDebug(e, null);
            throw e;
        }
        catch (RuntimeException e) {
            Permit.handleReflectionDebug(e, null);
            throw e;
        }
        catch (Error e) {
            Permit.handleReflectionDebug(e, null);
            throw e;
        }
    }

    public static void set(Field f, Object receiver, Object newValue) throws IllegalAccessException {
        try {
            f.set(receiver, newValue);
        }
        catch (IllegalAccessException e) {
            Permit.handleReflectionDebug(e, null);
            throw e;
        }
        catch (RuntimeException e) {
            Permit.handleReflectionDebug(e, null);
            throw e;
        }
        catch (Error e) {
            Permit.handleReflectionDebug(e, null);
            throw e;
        }
    }

    public static void reportReflectionProblem(@Nullable Throwable initError, String msg) {
        if (!Permit.isDebugReflection()) {
            return;
        }
        System.err.println("** REFLECTION issue: " + msg);
        if (initError != null) {
            System.err.println("*** ADDITIONALLY, exception occurred setting up reflection: ");
            initError.printStackTrace(System.err);
        }
    }

    public static RuntimeException sneakyThrow(@Nullable Throwable t) {
        if (t == null) {
            throw new NullPointerException("t");
        }
        return (RuntimeException)Permit.sneakyThrow0(t);
    }

    private static <T extends Throwable> T sneakyThrow0(Throwable t) throws T {
        throw t;
    }

    static class Fake {
        boolean override;
        Object accessCheckCache;

        Fake() {
        }
    }
}

