/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.template.processor;

import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.openrewrite.java.template.internal.JavacResolution;
import org.openrewrite.java.template.internal.StringUtils;
import org.openrewrite.java.template.internal.TemplateCode;
import org.openrewrite.java.template.processor.TypeAwareProcessor;

@SupportedAnnotationTypes(value={"*"})
public class TemplateProcessor
extends TypeAwareProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getRootElements()) {
            JCTree.JCCompilationUnit jcCompilationUnit = this.toUnit(element);
            if (jcCompilationUnit == null) continue;
            this.maybeGenerateTemplateSources(jcCompilationUnit);
        }
        return true;
    }

    private void maybeGenerateTemplateSources(final JCTree.JCCompilationUnit cu) {
        final Context context = this.javacProcessingEnv.getContext();
        final JavacResolution res = new JavacResolution(context);
        new TreeScanner(){

            /*
             * WARNING - void declaration
             */
            @Override
            public void visitApply(JCTree.JCMethodInvocation tree) {
                JCTree.JCMethodInvocation resolvedMethod;
                Map<JCTree, JCTree> resolved;
                JCTree.JCExpression jcSelect = tree.getMethodSelect();
                String name = jcSelect instanceof JCTree.JCFieldAccess ? ((JCTree.JCFieldAccess)jcSelect).name.toString() : ((JCTree.JCIdent)jcSelect).getName().toString();
                int numberOfArguments = ((List)tree.getArguments()).size();
                if (!"expression".equals(name) && !"statement".equals(name)) {
                    super.visitApply(tree);
                    return;
                }
                if (numberOfArguments < 3 || 4 < numberOfArguments) {
                    return;
                }
                boolean classpathFromResources = numberOfArguments == 4;
                try {
                    resolved = res.resolveAll(context, cu, Collections.singletonList(tree));
                    resolvedMethod = (JCTree.JCMethodInvocation)resolved.get(tree);
                }
                catch (Throwable t) {
                    TemplateProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Had trouble type attributing the template.");
                    return;
                }
                JCTree.JCExpression arg2 = (JCTree.JCExpression)((List)tree.getArguments()).get(2 + (classpathFromResources ? 1 : 0));
                if (TemplateProcessor.isOfClassType(resolvedMethod.type, "org.openrewrite.java.JavaTemplate.Builder") && (arg2 instanceof JCTree.JCLambda || arg2 instanceof JCTree.JCTypeCast && ((JCTree.JCTypeCast)arg2).getExpression() instanceof JCTree.JCLambda)) {
                    void var13_17;
                    java.util.List<JCTree.JCVariableDecl> parameters;
                    JCTree.JCLambda template;
                    JCTree.JCLambda jCLambda = template = arg2 instanceof JCTree.JCLambda ? (JCTree.JCLambda)arg2 : (JCTree.JCLambda)((JCTree.JCTypeCast)arg2).getExpression();
                    if (template.getParameters().isEmpty()) {
                        parameters = Collections.emptyList();
                    } else {
                        Map<JCTree, JCTree> parameterResolution = res.resolveAll(context, cu, template.getParameters());
                        parameters = new ArrayList(template.getParameters().size());
                        for (VariableTree variableTree : template.getParameters()) {
                            parameters.add((JCTree.JCVariableDecl)parameterResolution.get((JCTree)((Object)variableTree)));
                        }
                    }
                    JCTree.JCLiteral templateName = (JCTree.JCLiteral)((List)tree.getArguments()).get(1 + (classpathFromResources ? 1 : 0));
                    if (templateName.value == null) {
                        TemplateProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Can't compile a template with a null name.");
                        return;
                    }
                    JCTree.JCClassDecl classDecl = TemplateProcessor.cursor(cu, template).stream().filter(JCTree.JCClassDecl.class::isInstance).map(JCTree.JCClassDecl.class::cast).reduce((next, acc) -> next).orElseThrow(() -> new IllegalStateException("Expected to find an enclosing class"));
                    if (TemplateProcessor.isOfClassType(classDecl.type, "org.openrewrite.java.JavaVisitor")) {
                        String string = classDecl.sym.fullname.toString() + "_" + templateName.getValue().toString();
                    } else {
                        JCTree.JCNewClass visitorClass = TemplateProcessor.cursor(cu, template).stream().filter(JCTree.JCNewClass.class::isInstance).map(JCTree.JCNewClass.class::cast).reduce((next, acc) -> next).orElse(null);
                        JCTree.JCNewClass resolvedVisitorClass = (JCTree.JCNewClass)resolved.get(visitorClass);
                        if (resolvedVisitorClass != null && TemplateProcessor.isOfClassType(resolvedVisitorClass.clazz.type, "org.openrewrite.java.JavaVisitor")) {
                            String string = ((Symbol.ClassSymbol)resolvedVisitorClass.type.tsym).flatname.toString() + "_" + templateName.getValue().toString();
                        } else {
                            TemplateProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Can't compile a template outside of a visitor or recipe.");
                            return;
                        }
                    }
                    String templateCode = TemplateCode.process(resolved.get(template.getBody()), null, parameters, Collections.emptyList(), 0, "statement".equals(name), false, classpathFromResources);
                    this.writeClass(classDecl, (String)var13_17, classpathFromResources, templateCode, templateName);
                }
                super.visitApply(tree);
            }

            private void writeClass(JCTree.JCClassDecl classDecl, String templateFqn, boolean classpathFromResources, String templateCode, JCTree.JCLiteral templateName) {
                try {
                    Symbol.PackageSymbol pkg = classDecl.sym.packge();
                    JavaFileObject builderFile = TemplateProcessor.this.processingEnv.getFiler().createSourceFile(templateFqn, new Element[0]);
                    try (BufferedWriter out = new BufferedWriter(builderFile.openWriter());){
                        if (!pkg.isUnnamed()) {
                            out.write("package " + pkg.fullname + ";\n\n");
                        }
                        if (classpathFromResources) {
                            out.write("import org.openrewrite.ExecutionContext;\n");
                        }
                        if (templateCode.contains("JavaParser")) {
                            out.write("import org.openrewrite.java.JavaParser;\n");
                        }
                        out.write("import org.openrewrite.java.JavaTemplate;\n\n");
                        out.write("/**\n * OpenRewrite `" + templateName.getValue() + "` template created for {@code " + templateFqn.split("_")[0] + "}.\n */\n");
                        String templateClassName = templateFqn.substring(templateFqn.lastIndexOf(46) + 1);
                        out.write("@SuppressWarnings(\"all\")\n");
                        out.write("public class " + templateClassName + " {\n");
                        out.write("    /**\n");
                        out.write("     * Instantiates a new instance.\n");
                        out.write("     */\n");
                        out.write("    public " + templateClassName + "() {}\n\n");
                        out.write("    /**\n");
                        out.write("     * Get the {@code JavaTemplate.Builder} to match or replace.\n");
                        out.write("     * @return the JavaTemplate builder.\n");
                        out.write("     */\n");
                        out.write("    public static JavaTemplate.Builder getTemplate(" + (classpathFromResources ? "ExecutionContext ctx" : "") + ") {\n");
                        out.write("        return " + StringUtils.indentNewLine(templateCode, 12) + ";\n");
                        out.write("    }\n");
                        out.write("}\n");
                        ((Writer)out).flush();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }.scan(cu);
    }

    private static boolean isOfClassType(Type type, String fqn) {
        return type instanceof Type.ClassType && (((Symbol.ClassSymbol)type.tsym).fullname.contentEquals(fqn) || TemplateProcessor.isOfClassType(((Type.ClassType)type).supertype_field, fqn));
    }

    private static Stack<Tree> cursor(JCTree.JCCompilationUnit cu, final Tree t) {
        final AtomicReference matching = new AtomicReference();
        new TreePathScanner<Stack<Tree>, Stack<Tree>>(){

            @Override
            public Stack<Tree> scan(Tree tree, Stack<Tree> parent) {
                Stack<Tree> cursor = new Stack<Tree>();
                cursor.addAll(parent);
                cursor.push(tree);
                if (tree == t) {
                    matching.set(cursor);
                    return cursor;
                }
                return (Stack)super.scan(tree, cursor);
            }
        }.scan((Tree)cu, new Stack<Tree>());
        return (Stack)matching.get();
    }
}

