/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.properties.tree;

import java.lang.ref.SoftReference;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Pattern;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Checksum;
import org.openrewrite.Cursor;
import org.openrewrite.FileAttributes;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.SourceFile;
import org.openrewrite.SourceFileWithReferences;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.marker.Markers;
import org.openrewrite.properties.PropertiesVisitor;
import org.openrewrite.properties.internal.PropertiesPrinter;

public interface Properties
extends Tree {
    default public <R extends Tree, P> R accept(TreeVisitor<R, P> v, P p) {
        return (R)this.acceptProperties((PropertiesVisitor)v.adapt(PropertiesVisitor.class), p);
    }

    default public <P> boolean isAcceptable(TreeVisitor<?, P> v, P p) {
        return v.isAdaptableTo(PropertiesVisitor.class);
    }

    default public <P> @Nullable Properties acceptProperties(PropertiesVisitor<P> v, P p) {
        return (Properties)v.defaultValue(this, p);
    }

    public String getPrefix();

    public Properties withPrefix(String var1);

    public static class Continuation {
        private static final Pattern LINE_CONTINUATION_PATTERN = Pattern.compile("\\\\\\R\\s*");

        static String getValue(String input) {
            return LINE_CONTINUATION_PATTERN.matcher(input).replaceAll("");
        }
    }

    public static final class Comment
    implements Content {
        private final UUID id;
        private final String prefix;
        private final Markers markers;
        private final Delimiter delimiter;
        private final String message;

        @Override
        public <P> Properties acceptProperties(PropertiesVisitor<P> v, P p) {
            return v.visitComment(this, p);
        }

        @Generated
        public Comment(UUID id, String prefix, Markers markers, Delimiter delimiter, String message) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.delimiter = delimiter;
            this.message = message;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public String getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public Delimiter getDelimiter() {
            return this.delimiter;
        }

        @Generated
        public String getMessage() {
            return this.message;
        }

        @NonNull
        @Generated
        public String toString() {
            return "Properties.Comment(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", delimiter=" + (Object)((Object)this.getDelimiter()) + ", message=" + this.getMessage() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Comment)) {
                return false;
            }
            Comment other = (Comment)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public Comment withId(UUID id) {
            return this.id == id ? this : new Comment(id, this.prefix, this.markers, this.delimiter, this.message);
        }

        @Override
        @NonNull
        @Generated
        public Comment withPrefix(String prefix) {
            return this.prefix == prefix ? this : new Comment(this.id, prefix, this.markers, this.delimiter, this.message);
        }

        @NonNull
        @Generated
        public Comment withMarkers(Markers markers) {
            return this.markers == markers ? this : new Comment(this.id, this.prefix, markers, this.delimiter, this.message);
        }

        @NonNull
        @Generated
        public Comment withDelimiter(Delimiter delimiter) {
            return this.delimiter == delimiter ? this : new Comment(this.id, this.prefix, this.markers, delimiter, this.message);
        }

        @NonNull
        @Generated
        public Comment withMessage(String message) {
            return this.message == message ? this : new Comment(this.id, this.prefix, this.markers, this.delimiter, message);
        }

        public static enum Delimiter {
            HASH_TAG(Character.valueOf('#')),
            EXCLAMATION_MARK(Character.valueOf('!'));

            private final Character character;

            private Delimiter(Character character) {
                this.character = character;
            }

            @Generated
            public Character getCharacter() {
                return this.character;
            }
        }
    }

    public static final class Value {
        private final UUID id;
        private final String prefix;
        private final Markers markers;
        private final String text;

        public String getText() {
            return Continuation.getValue(this.text);
        }

        public String getSource() {
            return this.text;
        }

        @Generated
        public Value(UUID id, String prefix, Markers markers, String text) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.text = text;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public String getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public String toString() {
            return "Properties.Value(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", text=" + this.getText() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Value)) {
                return false;
            }
            Value other = (Value)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public Value withId(UUID id) {
            return this.id == id ? this : new Value(id, this.prefix, this.markers, this.text);
        }

        @NonNull
        @Generated
        public Value withPrefix(String prefix) {
            return this.prefix == prefix ? this : new Value(this.id, prefix, this.markers, this.text);
        }

        @NonNull
        @Generated
        public Value withMarkers(Markers markers) {
            return this.markers == markers ? this : new Value(this.id, this.prefix, markers, this.text);
        }

        @NonNull
        @Generated
        public Value withText(String text) {
            return this.text == text ? this : new Value(this.id, this.prefix, this.markers, text);
        }
    }

    public static final class Entry
    implements Content {
        private final UUID id;
        private final String prefix;
        private final Markers markers;
        private final String key;
        private final String beforeEquals;
        private final @Nullable Delimiter delimiter;
        private final Value value;

        public String getKey() {
            return Continuation.getValue(this.key);
        }

        public String getKeySource() {
            return this.key;
        }

        public Delimiter getDelimiter() {
            return this.delimiter == null ? Delimiter.EQUALS : this.delimiter;
        }

        @Override
        public <P> Properties acceptProperties(PropertiesVisitor<P> v, P p) {
            return v.visitEntry(this, p);
        }

        @Generated
        public Entry(UUID id, String prefix, Markers markers, String key, String beforeEquals, @Nullable Delimiter delimiter, Value value) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.key = key;
            this.beforeEquals = beforeEquals;
            this.delimiter = delimiter;
            this.value = value;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public String getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public String getBeforeEquals() {
            return this.beforeEquals;
        }

        @Generated
        public Value getValue() {
            return this.value;
        }

        @NonNull
        @Generated
        public String toString() {
            return "Properties.Entry(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", key=" + this.getKey() + ", beforeEquals=" + this.getBeforeEquals() + ", delimiter=" + (Object)((Object)this.getDelimiter()) + ", value=" + this.getValue() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public Entry withId(UUID id) {
            return this.id == id ? this : new Entry(id, this.prefix, this.markers, this.key, this.beforeEquals, this.delimiter, this.value);
        }

        @Override
        @NonNull
        @Generated
        public Entry withPrefix(String prefix) {
            return this.prefix == prefix ? this : new Entry(this.id, prefix, this.markers, this.key, this.beforeEquals, this.delimiter, this.value);
        }

        @NonNull
        @Generated
        public Entry withMarkers(Markers markers) {
            return this.markers == markers ? this : new Entry(this.id, this.prefix, markers, this.key, this.beforeEquals, this.delimiter, this.value);
        }

        @NonNull
        @Generated
        public Entry withKey(String key) {
            return this.key == key ? this : new Entry(this.id, this.prefix, this.markers, key, this.beforeEquals, this.delimiter, this.value);
        }

        @NonNull
        @Generated
        public Entry withBeforeEquals(String beforeEquals) {
            return this.beforeEquals == beforeEquals ? this : new Entry(this.id, this.prefix, this.markers, this.key, beforeEquals, this.delimiter, this.value);
        }

        @NonNull
        @Generated
        public Entry withDelimiter(@Nullable Delimiter delimiter) {
            return this.delimiter == delimiter ? this : new Entry(this.id, this.prefix, this.markers, this.key, this.beforeEquals, delimiter, this.value);
        }

        @NonNull
        @Generated
        public Entry withValue(Value value) {
            return this.value == value ? this : new Entry(this.id, this.prefix, this.markers, this.key, this.beforeEquals, this.delimiter, value);
        }

        public static enum Delimiter {
            COLON(Character.valueOf(':')),
            EQUALS(Character.valueOf('=')),
            NONE(Character.valueOf('\u0000'));

            private final Character character;

            private Delimiter(Character character) {
                this.character = character;
            }

            public static Delimiter getDelimiter(String value) {
                return "=".equals(value.trim()) ? EQUALS : (":".equals(value.trim()) ? COLON : ("".equals(value.trim()) ? NONE : EQUALS));
            }

            @Generated
            public Character getCharacter() {
                return this.character;
            }
        }
    }

    public static interface Content
    extends Properties {
    }

    public static final class File
    implements Properties,
    SourceFileWithReferences {
        private final UUID id;
        private final String prefix;
        private final Markers markers;
        private final Path sourcePath;
        private final List<Content> content;
        private final String eof;
        private final @Nullable String charsetName;
        private final boolean charsetBomMarked;
        private final @Nullable FileAttributes fileAttributes;
        private final @Nullable Checksum checksum;
        private transient @Nullable SoftReference<// Could not load outer class - annotation placement on inner may be incorrect
        SourceFileWithReferences.References> references;

        public Charset getCharset() {
            return this.charsetName == null ? StandardCharsets.UTF_8 : Charset.forName(this.charsetName);
        }

        public SourceFile withCharset(Charset charset) {
            return this.withCharsetName(charset.name());
        }

        @Override
        public <P> Properties acceptProperties(PropertiesVisitor<P> v, P p) {
            return v.visitFile(this, p);
        }

        public <P> TreeVisitor<?, PrintOutputCapture<P>> printer(Cursor cursor) {
            return new PropertiesPrinter();
        }

        public SourceFileWithReferences.References getReferences() {
            this.references = this.build(this.references);
            return Objects.requireNonNull(this.references.get());
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public String getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public Path getSourcePath() {
            return this.sourcePath;
        }

        @Generated
        public List<Content> getContent() {
            return this.content;
        }

        @Generated
        public String getEof() {
            return this.eof;
        }

        @Generated
        public @Nullable String getCharsetName() {
            return this.charsetName;
        }

        @Generated
        public boolean isCharsetBomMarked() {
            return this.charsetBomMarked;
        }

        @Generated
        public @Nullable FileAttributes getFileAttributes() {
            return this.fileAttributes;
        }

        @Generated
        public @Nullable Checksum getChecksum() {
            return this.checksum;
        }

        @NonNull
        @Generated
        public String toString() {
            return "Properties.File(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", sourcePath=" + this.getSourcePath() + ", content=" + this.getContent() + ", eof=" + this.getEof() + ", charsetName=" + this.getCharsetName() + ", charsetBomMarked=" + this.isCharsetBomMarked() + ", fileAttributes=" + this.getFileAttributes() + ", checksum=" + this.getChecksum() + ", references=" + this.getReferences() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof File)) {
                return false;
            }
            File other = (File)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public File(UUID id, String prefix, Markers markers, Path sourcePath, List<Content> content, String eof, @Nullable String charsetName, boolean charsetBomMarked, @Nullable FileAttributes fileAttributes, @Nullable Checksum checksum) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.sourcePath = sourcePath;
            this.content = content;
            this.eof = eof;
            this.charsetName = charsetName;
            this.charsetBomMarked = charsetBomMarked;
            this.fileAttributes = fileAttributes;
            this.checksum = checksum;
        }

        @Generated
        private File(UUID id, String prefix, Markers markers, Path sourcePath, List<Content> content, String eof, @Nullable String charsetName, boolean charsetBomMarked, @Nullable FileAttributes fileAttributes, @Nullable Checksum checksum, @Nullable SoftReference<// Could not load outer class - annotation placement on inner may be incorrect
        SourceFileWithReferences.References> references) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.sourcePath = sourcePath;
            this.content = content;
            this.eof = eof;
            this.charsetName = charsetName;
            this.charsetBomMarked = charsetBomMarked;
            this.fileAttributes = fileAttributes;
            this.checksum = checksum;
            this.references = references;
        }

        @NonNull
        @Generated
        public File withId(UUID id) {
            return this.id == id ? this : new File(id, this.prefix, this.markers, this.sourcePath, this.content, this.eof, this.charsetName, this.charsetBomMarked, this.fileAttributes, this.checksum, this.references);
        }

        @Override
        @NonNull
        @Generated
        public File withPrefix(String prefix) {
            return this.prefix == prefix ? this : new File(this.id, prefix, this.markers, this.sourcePath, this.content, this.eof, this.charsetName, this.charsetBomMarked, this.fileAttributes, this.checksum, this.references);
        }

        @NonNull
        @Generated
        public File withMarkers(Markers markers) {
            return this.markers == markers ? this : new File(this.id, this.prefix, markers, this.sourcePath, this.content, this.eof, this.charsetName, this.charsetBomMarked, this.fileAttributes, this.checksum, this.references);
        }

        @NonNull
        @Generated
        public File withSourcePath(Path sourcePath) {
            return this.sourcePath == sourcePath ? this : new File(this.id, this.prefix, this.markers, sourcePath, this.content, this.eof, this.charsetName, this.charsetBomMarked, this.fileAttributes, this.checksum, this.references);
        }

        @NonNull
        @Generated
        public File withContent(List<Content> content) {
            return this.content == content ? this : new File(this.id, this.prefix, this.markers, this.sourcePath, content, this.eof, this.charsetName, this.charsetBomMarked, this.fileAttributes, this.checksum, this.references);
        }

        @NonNull
        @Generated
        public File withEof(String eof) {
            return this.eof == eof ? this : new File(this.id, this.prefix, this.markers, this.sourcePath, this.content, eof, this.charsetName, this.charsetBomMarked, this.fileAttributes, this.checksum, this.references);
        }

        @NonNull
        @Generated
        private File withCharsetName(@Nullable String charsetName) {
            return this.charsetName == charsetName ? this : new File(this.id, this.prefix, this.markers, this.sourcePath, this.content, this.eof, charsetName, this.charsetBomMarked, this.fileAttributes, this.checksum, this.references);
        }

        @NonNull
        @Generated
        public File withCharsetBomMarked(boolean charsetBomMarked) {
            return this.charsetBomMarked == charsetBomMarked ? this : new File(this.id, this.prefix, this.markers, this.sourcePath, this.content, this.eof, this.charsetName, charsetBomMarked, this.fileAttributes, this.checksum, this.references);
        }

        @NonNull
        @Generated
        public File withFileAttributes(@Nullable FileAttributes fileAttributes) {
            return this.fileAttributes == fileAttributes ? this : new File(this.id, this.prefix, this.markers, this.sourcePath, this.content, this.eof, this.charsetName, this.charsetBomMarked, fileAttributes, this.checksum, this.references);
        }

        @NonNull
        @Generated
        public File withChecksum(@Nullable Checksum checksum) {
            return this.checksum == checksum ? this : new File(this.id, this.prefix, this.markers, this.sourcePath, this.content, this.eof, this.charsetName, this.charsetBomMarked, this.fileAttributes, checksum, this.references);
        }
    }
}

