/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.properties;

import org.jspecify.annotations.Nullable;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.properties.tree.Properties;

public class PropertiesVisitor<P>
extends TreeVisitor<Properties, P> {
    public boolean isAcceptable(SourceFile sourceFile, P p) {
        return sourceFile instanceof Properties.File;
    }

    public String getLanguage() {
        return "properties";
    }

    public Properties visitFile(Properties.File file, P p) {
        Properties.File f = file;
        f = f.withMarkers(this.visitMarkers(f.getMarkers(), p));
        return f.withContent(ListUtils.map(f.getContent(), c -> (Properties.Content)this.visit((Tree)c, p)));
    }

    public Properties visitEntry(Properties.Entry entry, P p) {
        Properties.Entry e = entry;
        if ((e = e.withMarkers(this.visitMarkers(e.getMarkers(), p))).getValue() != null) {
            e = e.withValue(this.visitValue(e.getValue(), p));
        }
        return e;
    }

    public @Nullable Properties.Value visitValue(Properties.Value value, P p) {
        return value.withMarkers(this.visitMarkers(value.getMarkers(), p));
    }

    public Properties visitComment(Properties.Comment comment, P p) {
        Properties.Comment c = comment;
        return c.withMarkers(this.visitMarkers(c.getMarkers(), p));
    }
}

