/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.properties.tree;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.openrewrite.Formatting;
import org.openrewrite.Metadata;
import org.openrewrite.Refactor;
import org.openrewrite.SourceFile;
import org.openrewrite.SourceVisitor;
import org.openrewrite.Tree;
import org.openrewrite.properties.PropertiesSourceVisitor;
import org.openrewrite.properties.internal.PrintProperties;

@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class, property="@ref")
public interface Properties
extends Serializable,
Tree {
    default public String print() {
        return (String)new PrintProperties().visit(this);
    }

    default public <R> R accept(SourceVisitor<R> v) {
        return (R)(v instanceof PropertiesSourceVisitor ? this.acceptProperties((PropertiesSourceVisitor)v) : v.defaultTo(null));
    }

    default public <R> R acceptProperties(PropertiesSourceVisitor<R> v) {
        return (R)v.defaultTo(null);
    }

    default public String getTreeType() {
        return "properties";
    }

    public static class Comment
    implements Content {
        private final UUID id;
        private final String message;
        private final Formatting formatting;

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Comment)) {
                return false;
            }
            Comment other = (Comment)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Comment;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Comment(UUID id, String message, Formatting formatting) {
            this.id = id;
            this.message = message;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public String getMessage() {
            return this.message;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public String toString() {
            return "Properties.Comment(id=" + this.getId() + ", message=" + this.getMessage() + ", formatting=" + this.getFormatting() + ")";
        }

        public Comment withMessage(String message) {
            return this.message == message ? this : new Comment(this.id, message, this.formatting);
        }

        public Comment withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Comment(this.id, this.message, formatting);
        }
    }

    public static class Entry
    implements Content {
        private final UUID id;
        private final String key;
        private final String value;
        private final Formatting equalsFormatting;
        private final Formatting formatting;

        @Override
        public <R> R acceptProperties(PropertiesSourceVisitor<R> v) {
            return v.visitEntry(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Entry;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Entry(UUID id, String key, String value, Formatting equalsFormatting, Formatting formatting) {
            this.id = id;
            this.key = key;
            this.value = value;
            this.equalsFormatting = equalsFormatting;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public Formatting getEqualsFormatting() {
            return this.equalsFormatting;
        }

        public Formatting getFormatting() {
            return this.formatting;
        }

        public String toString() {
            return "Properties.Entry(id=" + this.getId() + ", key=" + this.getKey() + ", value=" + this.getValue() + ", equalsFormatting=" + this.getEqualsFormatting() + ", formatting=" + this.getFormatting() + ")";
        }

        public Entry withKey(String key) {
            return this.key == key ? this : new Entry(this.id, key, this.value, this.equalsFormatting, this.formatting);
        }

        public Entry withValue(String value) {
            return this.value == value ? this : new Entry(this.id, this.key, value, this.equalsFormatting, this.formatting);
        }

        public Entry withEqualsFormatting(Formatting equalsFormatting) {
            return this.equalsFormatting == equalsFormatting ? this : new Entry(this.id, this.key, this.value, equalsFormatting, this.formatting);
        }

        public Entry withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new Entry(this.id, this.key, this.value, this.equalsFormatting, formatting);
        }
    }

    public static interface Content
    extends Properties {
    }

    public static class File
    implements Properties,
    SourceFile {
        private final UUID id;
        private final String sourcePath;
        private final Map<Metadata, String> metadata;
        private final List<Content> content;
        private final Formatting formatting;

        public Formatting getFormatting() {
            return this.formatting;
        }

        public Refactor<File> refactor() {
            return new Refactor((Tree)this);
        }

        @Override
        public <R> R acceptProperties(PropertiesSourceVisitor<R> v) {
            return v.visitFile(this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof File)) {
                return false;
            }
            File other = (File)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof File;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public File(UUID id, String sourcePath, Map<Metadata, String> metadata, List<Content> content, Formatting formatting) {
            this.id = id;
            this.sourcePath = sourcePath;
            this.metadata = metadata;
            this.content = content;
            this.formatting = formatting;
        }

        public UUID getId() {
            return this.id;
        }

        public String getSourcePath() {
            return this.sourcePath;
        }

        public Map<Metadata, String> getMetadata() {
            return this.metadata;
        }

        public List<Content> getContent() {
            return this.content;
        }

        public String toString() {
            return "Properties.File(id=" + this.getId() + ", sourcePath=" + this.getSourcePath() + ", metadata=" + this.getMetadata() + ", content=" + this.getContent() + ", formatting=" + this.getFormatting() + ")";
        }

        public File withMetadata(Map<Metadata, String> metadata) {
            return this.metadata == metadata ? this : new File(this.id, this.sourcePath, metadata, this.content, this.formatting);
        }

        public File withContent(List<Content> content) {
            return this.content == content ? this : new File(this.id, this.sourcePath, this.metadata, content, this.formatting);
        }

        public File withFormatting(Formatting formatting) {
            return this.formatting == formatting ? this : new File(this.id, this.sourcePath, this.metadata, this.content, formatting);
        }
    }
}

