/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.properties;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.openrewrite.Formatting;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.properties.tree.Properties;

public class PropertiesParser {
    public Properties.File parse(String source) {
        return this.parseFromInput(Paths.get("unknown.properties", new String[0]), new ByteArrayInputStream(source.getBytes()));
    }

    public List<Properties.File> parse(List<Path> sourceFiles, @Nullable Path relativeTo) {
        return sourceFiles.stream().map(source -> this.parse((Path)source, relativeTo)).collect(Collectors.toList());
    }

    public Properties.File parse(Path sourceFile, @Nullable Path relativeTo) {
        Properties.File file;
        FileInputStream fis = new FileInputStream(sourceFile.toFile());
        try {
            file = this.parseFromInput(relativeTo == null ? sourceFile : relativeTo.relativize(sourceFile), fis);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        fis.close();
        return file;
    }

    private Properties.File parseFromInput(Path sourceFile, InputStream source) {
        ArrayList<Properties.Content> contents = new ArrayList<Properties.Content>();
        StringBuilder prefix = new StringBuilder();
        Scanner scanner = new Scanner(source);
        scanner.useDelimiter(Pattern.compile("\n"));
        while (scanner.hasNext()) {
            String line = scanner.next();
            Properties.Content content = null;
            if (line.trim().startsWith("#")) {
                content = this.commentFromLine(line);
            } else if (line.contains("=")) {
                content = this.entryFromLine(line);
            } else {
                prefix.append(line).append("\n");
            }
            if (content == null) continue;
            content = (Properties.Content)content.withFormatting(Formatting.format((String)prefix.toString(), (String)(content.getFormatting().getSuffix() + "\n")));
            prefix = new StringBuilder();
            contents.add(content);
        }
        String suffix = "";
        try {
            int nRead;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[1024];
            while ((nRead = source.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
            String line = new String(buffer.toByteArray());
            if (line.trim().startsWith("#")) {
                contents.add(this.commentFromLine(line));
            } else if (line.contains("=")) {
                contents.add(this.entryFromLine(line));
            } else {
                suffix = line;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return new Properties.File(Tree.randomId(), sourceFile.toFile().getPath(), Collections.emptyMap(), contents, Formatting.format((String)"", (String)suffix));
    }

    private Properties.Comment commentFromLine(String line) {
        StringBuilder prefix = new StringBuilder();
        StringBuilder message = new StringBuilder();
        StringBuilder suffix = new StringBuilder();
        int state = 0;
        block5: for (char c : line.toCharArray()) {
            switch (state) {
                case 0: {
                    if (Character.isWhitespace(c)) {
                        prefix.append(c);
                        continue block5;
                    }
                    ++state;
                }
                case 1: {
                    if (c == '#') continue block5;
                    if (!Character.isWhitespace(c)) {
                        message.append(c);
                        continue block5;
                    }
                    ++state;
                }
                case 2: {
                    if (!Character.isWhitespace(c)) {
                        message.append((CharSequence)suffix);
                        message.append(c);
                        suffix = new StringBuilder();
                        --state;
                        continue block5;
                    }
                    suffix.append(c);
                }
            }
        }
        return new Properties.Comment(Tree.randomId(), message.toString(), Formatting.format((String)prefix.toString(), (String)suffix.toString()));
    }

    private Properties.Entry entryFromLine(String line) {
        StringBuilder prefix = new StringBuilder();
        StringBuilder key = new StringBuilder();
        StringBuilder equalsPrefix = new StringBuilder();
        StringBuilder equalsSuffix = new StringBuilder();
        StringBuilder value = new StringBuilder();
        StringBuilder suffix = new StringBuilder();
        int state = 0;
        block8: for (char c : line.toCharArray()) {
            switch (state) {
                case 0: {
                    if (Character.isWhitespace(c)) {
                        prefix.append(c);
                        continue block8;
                    }
                    ++state;
                }
                case 1: {
                    if (c == '=') {
                        state += 2;
                    } else {
                        if (!Character.isWhitespace(c)) {
                            key.append(c);
                            continue block8;
                        }
                        ++state;
                    }
                }
                case 2: {
                    if (Character.isWhitespace(c)) {
                        equalsPrefix.append(c);
                        continue block8;
                    }
                    ++state;
                }
                case 3: {
                    if (c == '=') continue block8;
                    if (Character.isWhitespace(c)) {
                        equalsSuffix.append(c);
                        continue block8;
                    }
                    ++state;
                }
                case 4: {
                    if (!Character.isWhitespace(c)) {
                        value.append(c);
                        continue block8;
                    }
                    ++state;
                }
                case 5: {
                    if (!Character.isWhitespace(c)) {
                        value.append((CharSequence)suffix);
                        value.append(c);
                        suffix = new StringBuilder();
                        --state;
                        continue block8;
                    }
                    suffix.append(c);
                }
            }
        }
        return new Properties.Entry(Tree.randomId(), key.toString(), value.toString(), Formatting.format((String)equalsPrefix.toString(), (String)equalsSuffix.toString()), Formatting.format((String)prefix.toString(), (String)suffix.toString()));
    }
}

