/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.graph;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;

public class DependencyGraph {
    @Nullable Node root;
    int size = 0;

    public void append(String configOrScope, Collection<ResolvedDependency> path) {
        if (path.isEmpty()) {
            return;
        }
        Iterator<ResolvedDependency> iterator = path.iterator();
        ResolvedDependency dependency = iterator.next();
        String id = DependencyGraph.formatDependency(dependency.getGav());
        if (this.root == null) {
            this.root = this.createEmptyNode(id);
        } else if (!this.root.getId().equals(id)) {
            throw new IllegalStateException("Dependency path is for a different root");
        }
        ++this.size;
        Node parent = this.root;
        while (iterator.hasNext()) {
            dependency = iterator.next();
            id = DependencyGraph.formatDependency(dependency.getGav());
            Node child = null;
            for (Node node : parent.getChildren()) {
                if (!node.getId().equals(id)) continue;
                child = node;
                break;
            }
            if (child == null) {
                child = this.createEmptyNode(id);
                parent.getChildren().add(child);
            }
            parent = child;
        }
        parent.getChildren().add(new ConfigurationNode(configOrScope));
    }

    public @Nullable String print() {
        if (this.root == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.root.getId()).append("\n");
        HashSet<Node> visited = new HashSet<Node>();
        int i = 0;
        for (Node child : this.root.getChildren()) {
            this.print0(sb, new StringBuilder(), child, visited, i++ == this.root.getChildren().size() - 1);
        }
        return sb.toString();
    }

    private void print0(StringBuilder sb, StringBuilder prefix, Node node, Set<Node> visited, boolean lastChild) {
        boolean alreadySeen = !visited.add(node);
        sb.append((CharSequence)prefix).append(lastChild ? "\\--- " : "+--- ").append(node.getId());
        if (alreadySeen) {
            sb.append(" (*)\n");
            return;
        }
        sb.append("\n");
        prefix.append(lastChild ? "     " : "|    ");
        int i = 0;
        for (Node child : node.getChildren()) {
            this.print0(sb, prefix, child, visited, i++ == node.getChildren().size() - 1);
        }
        if (prefix.length() > 0) {
            prefix.setLength(prefix.length() - 5);
        }
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    private static String formatDependency(ResolvedGroupArtifactVersion gav) {
        return gav.getGroupId() + ":" + gav.getArtifactId() + ":" + gav.getVersion();
    }

    private DependencyNode createEmptyNode(String id) {
        return new DependencyNode(id, new TreeSet<Node>());
    }

    @Generated
    public DependencyGraph() {
    }

    @Generated
    public int getSize() {
        return this.size;
    }

    private static interface Node
    extends Comparable<Node> {
        public String getId();

        public Set<Node> getChildren();

        @Override
        default public int compareTo(Node other) {
            if (this instanceof ConfigurationNode && other instanceof ConfigurationNode) {
                return this.getId().compareTo(other.getId());
            }
            if (this instanceof ConfigurationNode) {
                return -1;
            }
            if (other instanceof ConfigurationNode) {
                return 1;
            }
            return this.getId().compareTo(other.getId());
        }
    }

    private static final class DependencyNode
    implements Node {
        private final String id;
        private final Set<Node> children;

        @Generated
        public DependencyNode(String id, Set<Node> children) {
            this.id = id;
            this.children = children;
        }

        @Override
        @Generated
        public String getId() {
            return this.id;
        }

        @Override
        @Generated
        public Set<Node> getChildren() {
            return this.children;
        }

        @NonNull
        @Generated
        public String toString() {
            return "DependencyGraph.DependencyNode(id=" + this.getId() + ", children=" + this.getChildren() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DependencyNode)) {
                return false;
            }
            DependencyNode other = (DependencyNode)o;
            String this$id = this.getId();
            String other$id = other.getId();
            return !(this$id == null ? other$id != null : !this$id.equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            return result;
        }
    }

    private static class ConfigurationNode
    implements Node {
        final String id;
        Set<Node> children = Collections.emptySet();

        @Generated
        public ConfigurationNode(String id) {
            this.id = id;
        }

        @Override
        @Generated
        public String getId() {
            return this.id;
        }

        @Override
        @Generated
        public Set<Node> getChildren() {
            return this.children;
        }
    }
}

