/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.maven.AddManagedDependency;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.table.MavenMetadataFailures;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.semver.Semver;
import org.openrewrite.xml.tree.Xml;

public final class UpgradeTransitiveDependencyVersion
extends ScanningRecipe<AddManagedDependency.Scanned> {
    private final transient MavenMetadataFailures metadataFailures = new MavenMetadataFailures((Recipe)this);
    @Option(displayName="Group", description="The first part of a dependency coordinate 'org.apache.logging.log4j:ARTIFACT_ID:VERSION'.", example="org.apache.logging.log4j")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate 'org.apache.logging.log4j:log4j-bom:VERSION'.", example="log4j-bom")
    private final String artifactId;
    @Option(displayName="Version", description="An exact version number or node-style semver selector used to select the version number.", example="latest.release")
    private final String version;
    @Option(displayName="Scope", description="An optional scope to use for the dependency management tag.", example="import", valid={"import", "runtime", "provided", "test"}, required=false)
    private final @Nullable String scope;
    @Option(displayName="Type", description="An optional type to use for the dependency management tag.", valid={"jar", "pom", "war"}, example="pom", required=false)
    private final @Nullable String type;
    @Option(displayName="Classifier", description="An optional classifier to use for the dependency management tag", example="test", required=false)
    private final @Nullable String classifier;
    @Option(displayName="Version pattern", description="Allows version selection to be extended beyond the original Node Semver semantics. So for example,Setting 'version' to \"25-29\" can be paired with a metadata pattern of \"-jre\" to select 29.0-jre", example="-jre", required=false)
    private final @Nullable String versionPattern;
    @Option(displayName="Releases only", description="Whether to exclude snapshots from consideration when using a semver selector", required=false)
    private final @Nullable Boolean releasesOnly;
    @Option(displayName="Only if using glob expression for group:artifact", description="Only add managed dependencies to projects having a dependency matching the expression.", example="org.apache.logging.log4j:log4j*", required=false)
    private final @Nullable String onlyIfUsing;
    @Option(displayName="Add to the root pom", description="Add to the root pom where root is the eldest parent of the pom within the source set.", required=false)
    private final @Nullable Boolean addToRootPom;
    @Option(displayName="Because", description="The reason for upgrading the transitive dependency. This will be added as an XML comment preceding the managed dependency.", required=false, example="CVE-2021-1234")
    private final @Nullable String because;

    public String getDisplayName() {
        return "Upgrade transitive Maven dependencies";
    }

    public String getDescription() {
        return "Upgrades the version of a transitive dependency in a Maven pom file. Leaves direct dependencies unmodified. Can be paired with the regular Upgrade Dependency Version recipe to upgrade a dependency everywhere, regardless of whether it is direct or transitive.";
    }

    @Deprecated
    public UpgradeTransitiveDependencyVersion(String groupId, String artifactId, String version, @Nullable String scope, @Nullable String type, @Nullable String classifier, @Nullable String versionPattern, @Nullable Boolean releasesOnly, @Nullable String onlyIfUsing, @Nullable Boolean addToRootPom) {
        this(groupId, artifactId, version, scope, type, classifier, versionPattern, releasesOnly, onlyIfUsing, addToRootPom, null);
    }

    @JsonCreator
    public UpgradeTransitiveDependencyVersion(String groupId, String artifactId, String version, @Nullable String scope, @Nullable String type, @Nullable String classifier, @Nullable String versionPattern, @Nullable Boolean releasesOnly, @Nullable String onlyIfUsing, @Nullable Boolean addToRootPom, @Nullable String because) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.scope = scope;
        this.type = type;
        this.classifier = classifier;
        this.versionPattern = versionPattern;
        this.releasesOnly = releasesOnly;
        this.onlyIfUsing = onlyIfUsing;
        this.addToRootPom = addToRootPom;
        this.because = because;
    }

    public Validated<Object> validate() {
        return super.validate().and(Semver.validate((String)this.version, (String)this.versionPattern));
    }

    public AddManagedDependency.Scanned getInitialValue(ExecutionContext ctx) {
        return this.addManagedDependency().getInitialValue(ctx);
    }

    public TreeVisitor<?, ExecutionContext> getScanner(AddManagedDependency.Scanned acc) {
        return this.addManagedDependency().getScanner(acc);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final AddManagedDependency.Scanned acc) {
        return new MavenIsoVisitor<ExecutionContext>(){

            @Override
            public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
                Set matchingDependencies = this.getResolutionResult().findDependencies(UpgradeTransitiveDependencyVersion.this.groupId, UpgradeTransitiveDependencyVersion.this.artifactId, null).stream().filter(ResolvedDependency::isTransitive).collect(Collectors.toCollection(LinkedHashSet::new));
                if (matchingDependencies.isEmpty()) {
                    return document;
                }
                Xml.Document d = document;
                for (ResolvedDependency matchingDependency : matchingDependencies) {
                    d = (Xml.Document)UpgradeTransitiveDependencyVersion.this.addManagedDependency(matchingDependency.getGroupId(), matchingDependency.getArtifactId()).getVisitor(acc).visitNonNull((Tree)d, (Object)ctx);
                }
                return d;
            }
        };
    }

    private AddManagedDependency addManagedDependency() {
        return this.addManagedDependency(this.groupId, this.artifactId);
    }

    private AddManagedDependency addManagedDependency(String groupId, String artifactId) {
        return new AddManagedDependency(groupId, artifactId, this.version, this.scope, this.type, this.classifier, this.versionPattern, this.releasesOnly, this.onlyIfUsing, this.addToRootPom, this.because);
    }

    @Generated
    public MavenMetadataFailures getMetadataFailures() {
        return this.metadataFailures;
    }

    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Generated
    public String getArtifactId() {
        return this.artifactId;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public @Nullable String getScope() {
        return this.scope;
    }

    @Generated
    public @Nullable String getType() {
        return this.type;
    }

    @Generated
    public @Nullable String getClassifier() {
        return this.classifier;
    }

    @Generated
    public @Nullable String getVersionPattern() {
        return this.versionPattern;
    }

    @Generated
    public @Nullable Boolean getReleasesOnly() {
        return this.releasesOnly;
    }

    @Generated
    public @Nullable String getOnlyIfUsing() {
        return this.onlyIfUsing;
    }

    @Generated
    public @Nullable Boolean getAddToRootPom() {
        return this.addToRootPom;
    }

    @Generated
    public @Nullable String getBecause() {
        return this.because;
    }

    @NonNull
    @Generated
    public String toString() {
        return "UpgradeTransitiveDependencyVersion(metadataFailures=" + (Object)((Object)this.getMetadataFailures()) + ", groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ", scope=" + this.getScope() + ", type=" + this.getType() + ", classifier=" + this.getClassifier() + ", versionPattern=" + this.getVersionPattern() + ", releasesOnly=" + this.getReleasesOnly() + ", onlyIfUsing=" + this.getOnlyIfUsing() + ", addToRootPom=" + this.getAddToRootPom() + ", because=" + this.getBecause() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpgradeTransitiveDependencyVersion)) {
            return false;
        }
        UpgradeTransitiveDependencyVersion other = (UpgradeTransitiveDependencyVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$releasesOnly = this.getReleasesOnly();
        Boolean other$releasesOnly = other.getReleasesOnly();
        if (this$releasesOnly == null ? other$releasesOnly != null : !((Object)this$releasesOnly).equals(other$releasesOnly)) {
            return false;
        }
        Boolean this$addToRootPom = this.getAddToRootPom();
        Boolean other$addToRootPom = other.getAddToRootPom();
        if (this$addToRootPom == null ? other$addToRootPom != null : !((Object)this$addToRootPom).equals(other$addToRootPom)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$classifier = this.getClassifier();
        String other$classifier = other.getClassifier();
        if (this$classifier == null ? other$classifier != null : !this$classifier.equals(other$classifier)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        if (this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern)) {
            return false;
        }
        String this$onlyIfUsing = this.getOnlyIfUsing();
        String other$onlyIfUsing = other.getOnlyIfUsing();
        if (this$onlyIfUsing == null ? other$onlyIfUsing != null : !this$onlyIfUsing.equals(other$onlyIfUsing)) {
            return false;
        }
        String this$because = this.getBecause();
        String other$because = other.getBecause();
        return !(this$because == null ? other$because != null : !this$because.equals(other$because));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof UpgradeTransitiveDependencyVersion;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $releasesOnly = this.getReleasesOnly();
        result = result * 59 + ($releasesOnly == null ? 43 : ((Object)$releasesOnly).hashCode());
        Boolean $addToRootPom = this.getAddToRootPom();
        result = result * 59 + ($addToRootPom == null ? 43 : ((Object)$addToRootPom).hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $classifier = this.getClassifier();
        result = result * 59 + ($classifier == null ? 43 : $classifier.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        String $onlyIfUsing = this.getOnlyIfUsing();
        result = result * 59 + ($onlyIfUsing == null ? 43 : $onlyIfUsing.hashCode());
        String $because = this.getBecause();
        result = result * 59 + ($because == null ? 43 : $because.hashCode());
        return result;
    }
}

