/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.marker.Markup;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.xml.XmlIsoVisitor;
import org.openrewrite.xml.tree.Xml;

public class MavenDownloadingExceptions
extends Exception {
    private final List<MavenDownloadingException> exceptions = new ArrayList<MavenDownloadingException>();

    public static MavenDownloadingExceptions append(@Nullable MavenDownloadingExceptions current, MavenDownloadingException exception) {
        if (current == null) {
            current = new MavenDownloadingExceptions();
        }
        current.addSuppressed(exception);
        current.exceptions.add(exception);
        return current;
    }

    public static MavenDownloadingExceptions append(@Nullable MavenDownloadingExceptions current, MavenDownloadingExceptions exceptions) {
        if (current == null) {
            current = new MavenDownloadingExceptions();
        }
        exceptions.getExceptions().forEach(current::addSuppressed);
        current.exceptions.addAll(exceptions.getExceptions());
        return current;
    }

    public Xml.Document warn(Xml.Document document) {
        final HashMap<GroupArtifact, List> byGav = new HashMap<GroupArtifact, List>();
        for (MavenDownloadingException exception : this.exceptions) {
            byGav.computeIfAbsent(new GroupArtifact(exception.getRoot().getGroupId(), exception.getRoot().getArtifactId()), ga -> new ArrayList()).add(exception);
        }
        return (Xml.Document)new XmlIsoVisitor<Integer>(){

            public boolean isAcceptable(SourceFile sourceFile, Integer integer) {
                return sourceFile instanceof Xml.Document;
            }

            public Xml.Tag visitTag(Xml.Tag tag, Integer integer) {
                Xml.Tag t = tag;
                for (GroupArtifact ga : byGav.keySet()) {
                    boolean hasException = (MavenVisitor.DEPENDENCY_MATCHER.matches(this.getCursor()) || MavenVisitor.MANAGED_DEPENDENCY_MATCHER.matches(this.getCursor()) || MavenVisitor.PARENT_MATCHER.matches(this.getCursor())) && tag.getChildValue("groupId").map(a -> ga.getGroupId().equals(a)).orElse(false) != false && tag.getChildValue("artifactId").map(a -> ga.getArtifactId().equals(a)).orElse(false) != false;
                    if (!hasException) continue;
                    for (MavenDownloadingException exception : (List)byGav.get(ga)) {
                        t = (Xml.Tag)Markup.warn((Tree)t, (Throwable)exception);
                    }
                }
                return super.visitTag(t, (Object)integer);
            }
        }.visitNonNull((Tree)document, (Object)0);
    }

    @Generated
    public List<MavenDownloadingException> getExceptions() {
        return this.exceptions;
    }
}

