/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.tree;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.io.File;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class, property="@ref")
public class MavenRepository {
    public static final MavenRepository MAVEN_LOCAL_USER_NEUTRAL = new MavenRepository("local", new File("~/.m2/repository").toString(), true, true, true, null, null);
    public static final MavenRepository MAVEN_LOCAL = new MavenRepository("local", new File(System.getProperty("user.home") + "/.m2/repository").toURI().toString(), true, true, true, null, null);
    public static final MavenRepository MAVEN_CENTRAL = new MavenRepository("central", "https://repo.maven.apache.org/maven2", true, false, true, null, null);
    @Nullable
    private final String id;
    private final String uri;
    private final boolean releases;
    private final boolean snapshots;
    private boolean knownToExist;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @Nullable
    private final String username;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    @Nullable
    private final String password;

    @JsonIgnore
    public MavenRepository(@Nullable String id, String uri, boolean releases, boolean snapshots, boolean knownToExist, @Nullable String username, @Nullable String password) {
        this.id = id;
        this.uri = uri;
        this.releases = releases;
        this.snapshots = snapshots;
        this.knownToExist = knownToExist;
        this.username = username;
        this.password = password;
    }

    public boolean acceptsVersion(String version) {
        if (version.endsWith("-SNAPSHOT")) {
            return this.snapshots;
        }
        if ("https://repo.spring.io/milestone".equalsIgnoreCase(this.uri)) {
            return version.matches(".*(M|RC)\\d+$");
        }
        return this.releases;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MavenRepository)) {
            return false;
        }
        MavenRepository other = (MavenRepository)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isReleases() != other.isReleases()) {
            return false;
        }
        if (this.isSnapshots() != other.isSnapshots()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$uri = this.getUri();
        String other$uri = other.getUri();
        return !(this$uri == null ? other$uri != null : !this$uri.equals(other$uri));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof MavenRepository;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isReleases() ? 79 : 97);
        result = result * 59 + (this.isSnapshots() ? 79 : 97);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
        return result;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public String getUri() {
        return this.uri;
    }

    public boolean isReleases() {
        return this.releases;
    }

    public boolean isSnapshots() {
        return this.snapshots;
    }

    public boolean isKnownToExist() {
        return this.knownToExist;
    }

    @Nullable
    public String getUsername() {
        return this.username;
    }

    @Nullable
    public String getPassword() {
        return this.password;
    }

    public void setKnownToExist(boolean knownToExist) {
        this.knownToExist = knownToExist;
    }

    @NonNull
    public String toString() {
        return "MavenRepository(id=" + this.getId() + ", uri=" + this.getUri() + ", releases=" + this.isReleases() + ", snapshots=" + this.isSnapshots() + ", knownToExist=" + this.isKnownToExist() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ")";
    }

    public MavenRepository(@Nullable String id, String uri, boolean releases, boolean snapshots, @Nullable String username, @Nullable String password) {
        this.id = id;
        this.uri = uri;
        this.releases = releases;
        this.snapshots = snapshots;
        this.username = username;
        this.password = password;
    }

    @NonNull
    public MavenRepository withId(@Nullable String id) {
        return this.id == id ? this : new MavenRepository(id, this.uri, this.releases, this.snapshots, this.knownToExist, this.username, this.password);
    }

    @NonNull
    public MavenRepository withUri(String uri) {
        return this.uri == uri ? this : new MavenRepository(this.id, uri, this.releases, this.snapshots, this.knownToExist, this.username, this.password);
    }

    @NonNull
    public MavenRepository withReleases(boolean releases) {
        return this.releases == releases ? this : new MavenRepository(this.id, this.uri, releases, this.snapshots, this.knownToExist, this.username, this.password);
    }

    @NonNull
    public MavenRepository withSnapshots(boolean snapshots) {
        return this.snapshots == snapshots ? this : new MavenRepository(this.id, this.uri, this.releases, snapshots, this.knownToExist, this.username, this.password);
    }

    @NonNull
    public MavenRepository withUsername(@Nullable String username) {
        return this.username == username ? this : new MavenRepository(this.id, this.uri, this.releases, this.snapshots, this.knownToExist, username, this.password);
    }

    @NonNull
    public MavenRepository withPassword(@Nullable String password) {
        return this.password == password ? this : new MavenRepository(this.id, this.uri, this.releases, this.snapshots, this.knownToExist, this.username, password);
    }
}

