/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.internal.MavenXmlMapper;
import org.openrewrite.maven.internal.RawRepositories;
import org.openrewrite.maven.tree.ProfileActivation;

public class MavenSettings {
    @Nullable
    private final Profiles profiles;
    @Nullable
    private final ActiveProfiles activeProfiles;
    @Nullable
    private final Mirrors mirrors;
    @Nullable
    private final Servers servers;

    @Nullable
    public static MavenSettings parse(Parser.Input source, ExecutionContext ctx) {
        try {
            return (MavenSettings)MavenXmlMapper.readMapper().readValue((InputStream)source.getSource(), MavenSettings.class);
        }
        catch (IOException e) {
            ctx.getOnError().accept(new IOException("Failed to parse " + source.getPath(), e));
            return null;
        }
    }

    public List<RawRepositories.Repository> getActiveRepositories(Iterable<String> activeProfiles) {
        ArrayList<RawRepositories.Repository> activeRepositories = new ArrayList<RawRepositories.Repository>();
        if (this.profiles != null) {
            for (Profile profile : this.profiles.getProfiles()) {
                if (!profile.isActive(activeProfiles) && (this.activeProfiles == null || !profile.isActive(this.activeProfiles.getActiveProfiles())) || profile.repositories == null) continue;
                activeRepositories.addAll(profile.repositories.getRepositories());
            }
        }
        return activeRepositories;
    }

    @NonNull
    public String toString() {
        return "MavenSettings()";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MavenSettings)) {
            return false;
        }
        MavenSettings other = (MavenSettings)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof MavenSettings;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public MavenSettings(@Nullable Profiles profiles, @Nullable ActiveProfiles activeProfiles, @Nullable Mirrors mirrors, @Nullable Servers servers) {
        this.profiles = profiles;
        this.activeProfiles = activeProfiles;
        this.mirrors = mirrors;
        this.servers = servers;
    }

    @Nullable
    public Profiles getProfiles() {
        return this.profiles;
    }

    @Nullable
    public ActiveProfiles getActiveProfiles() {
        return this.activeProfiles;
    }

    @Nullable
    public Mirrors getMirrors() {
        return this.mirrors;
    }

    @Nullable
    public Servers getServers() {
        return this.servers;
    }

    @NonNull
    public MavenSettings withServers(@Nullable Servers servers) {
        return this.servers == servers ? this : new MavenSettings(this.profiles, this.activeProfiles, this.mirrors, servers);
    }

    public static class Profiles {
        @JacksonXmlProperty(localName="profile")
        @JacksonXmlElementWrapper(useWrapping=false)
        private List<Profile> profiles = Collections.emptyList();

        public List<Profile> getProfiles() {
            return this.profiles;
        }

        @JacksonXmlProperty(localName="profile")
        @JacksonXmlElementWrapper(useWrapping=false)
        public void setProfiles(List<Profile> profiles) {
            this.profiles = profiles;
        }
    }

    public static class Profile {
        @Nullable
        private final String id;
        @Nullable
        private final ProfileActivation activation;
        @Nullable
        private final RawRepositories repositories;

        public boolean isActive(Iterable<String> activeProfiles) {
            return ProfileActivation.isActive(this.id, activeProfiles, this.activation);
        }

        public boolean isActive(String ... activeProfiles) {
            return this.isActive(Arrays.asList(activeProfiles));
        }

        public Profile(@Nullable String id, @Nullable ProfileActivation activation, @Nullable RawRepositories repositories) {
            this.id = id;
            this.activation = activation;
            this.repositories = repositories;
        }

        @Nullable
        public String getId() {
            return this.id;
        }

        @Nullable
        public ProfileActivation getActivation() {
            return this.activation;
        }

        @Nullable
        public RawRepositories getRepositories() {
            return this.repositories;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Profile)) {
                return false;
            }
            Profile other = (Profile)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            ProfileActivation this$activation = this.getActivation();
            ProfileActivation other$activation = other.getActivation();
            if (this$activation == null ? other$activation != null : !((Object)this$activation).equals(other$activation)) {
                return false;
            }
            RawRepositories this$repositories = this.getRepositories();
            RawRepositories other$repositories = other.getRepositories();
            return !(this$repositories == null ? other$repositories != null : !this$repositories.equals(other$repositories));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Profile;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            ProfileActivation $activation = this.getActivation();
            result = result * 59 + ($activation == null ? 43 : ((Object)$activation).hashCode());
            RawRepositories $repositories = this.getRepositories();
            result = result * 59 + ($repositories == null ? 43 : $repositories.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "MavenSettings.Profile(id=" + this.getId() + ", activation=" + this.getActivation() + ", repositories=" + this.getRepositories() + ")";
        }
    }

    public static class ActiveProfiles {
        @JacksonXmlProperty(localName="activeProfile")
        @JacksonXmlElementWrapper(useWrapping=false)
        private List<String> activeProfiles = Collections.emptyList();

        public List<String> getActiveProfiles() {
            return this.activeProfiles;
        }

        @JacksonXmlProperty(localName="activeProfile")
        @JacksonXmlElementWrapper(useWrapping=false)
        public void setActiveProfiles(List<String> activeProfiles) {
            this.activeProfiles = activeProfiles;
        }
    }

    public static class Mirrors {
        @JacksonXmlProperty(localName="mirror")
        @JacksonXmlElementWrapper(useWrapping=false)
        private List<Mirror> mirrors = Collections.emptyList();

        public List<Mirror> getMirrors() {
            return this.mirrors;
        }

        @JacksonXmlProperty(localName="mirror")
        @JacksonXmlElementWrapper(useWrapping=false)
        public void setMirrors(List<Mirror> mirrors) {
            this.mirrors = mirrors;
        }
    }

    public static class Servers {
        @JacksonXmlProperty(localName="server")
        @JacksonXmlElementWrapper(useWrapping=false)
        private List<Server> servers = Collections.emptyList();

        public List<Server> getServers() {
            return this.servers;
        }

        @JacksonXmlProperty(localName="server")
        @JacksonXmlElementWrapper(useWrapping=false)
        public void setServers(List<Server> servers) {
            this.servers = servers;
        }
    }

    public static class Server {
        private final String id;
        private final String username;
        private final String password;

        public Server(String id, String username, String password) {
            this.id = id;
            this.username = username;
            this.password = password;
        }

        public String getId() {
            return this.id;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Server)) {
                return false;
            }
            Server other = (Server)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            return !(this$password == null ? other$password != null : !this$password.equals(other$password));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Server;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "MavenSettings.Server(id=" + this.getId() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ")";
        }
    }

    public static class Mirror {
        @Nullable
        private final String id;
        @Nullable
        private final String url;
        @Nullable
        private final String mirrorOf;
        @Nullable
        private final Boolean releases;
        @Nullable
        private final Boolean snapshots;

        public Mirror(@Nullable String id, @Nullable String url, @Nullable String mirrorOf, @Nullable Boolean releases, @Nullable Boolean snapshots) {
            this.id = id;
            this.url = url;
            this.mirrorOf = mirrorOf;
            this.releases = releases;
            this.snapshots = snapshots;
        }

        @Nullable
        public String getId() {
            return this.id;
        }

        @Nullable
        public String getUrl() {
            return this.url;
        }

        @Nullable
        public String getMirrorOf() {
            return this.mirrorOf;
        }

        @Nullable
        public Boolean getReleases() {
            return this.releases;
        }

        @Nullable
        public Boolean getSnapshots() {
            return this.snapshots;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Mirror)) {
                return false;
            }
            Mirror other = (Mirror)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$releases = this.getReleases();
            Boolean other$releases = other.getReleases();
            if (this$releases == null ? other$releases != null : !((Object)this$releases).equals(other$releases)) {
                return false;
            }
            Boolean this$snapshots = this.getSnapshots();
            Boolean other$snapshots = other.getSnapshots();
            if (this$snapshots == null ? other$snapshots != null : !((Object)this$snapshots).equals(other$snapshots)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            String this$mirrorOf = this.getMirrorOf();
            String other$mirrorOf = other.getMirrorOf();
            return !(this$mirrorOf == null ? other$mirrorOf != null : !this$mirrorOf.equals(other$mirrorOf));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Mirror;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $releases = this.getReleases();
            result = result * 59 + ($releases == null ? 43 : ((Object)$releases).hashCode());
            Boolean $snapshots = this.getSnapshots();
            result = result * 59 + ($snapshots == null ? 43 : ((Object)$snapshots).hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            String $mirrorOf = this.getMirrorOf();
            result = result * 59 + ($mirrorOf == null ? 43 : $mirrorOf.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "MavenSettings.Mirror(id=" + this.getId() + ", url=" + this.getUrl() + ", mirrorOf=" + this.getMirrorOf() + ", releases=" + this.getReleases() + ", snapshots=" + this.getSnapshots() + ")";
        }
    }
}

