/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import com.ctc.wstx.stax.WstxInputFactory;
import com.ctc.wstx.stax.WstxOutputFactory;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlFactory;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import org.openrewrite.Parser;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.internal.RawRepositories;

public class MavenSettings {
    private static final ObjectMapper xmlMapper;
    @Nullable
    private final Profiles profiles;
    @Nullable
    private final ActiveProfiles activeProfiles;

    @JsonCreator
    MavenSettings(@JsonProperty(value="profiles") @Nullable Profiles profiles, @JsonProperty(value="activeProfiles") @Nullable ActiveProfiles activeProfiles) {
        this.profiles = profiles;
        this.activeProfiles = activeProfiles;
    }

    public static MavenSettings parse(Parser.Input source) {
        try {
            return (MavenSettings)xmlMapper.readValue(source.getSource(), MavenSettings.class);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to parse " + source.getUri(), e);
        }
    }

    public List<RawRepositories.Repository> getActiveRepositories(Collection<String> activeProfiles) {
        ArrayList<RawRepositories.Repository> activeRepositories = new ArrayList<RawRepositories.Repository>();
        if (this.profiles != null) {
            for (Profile profile : this.profiles.getProfiles()) {
                if (!profile.isActive(activeProfiles) && (this.activeProfiles == null || !profile.isActive(this.activeProfiles.getActiveProfiles())) || profile.repositories == null) continue;
                activeRepositories.addAll(profile.repositories.getRepositories());
            }
        }
        return activeRepositories;
    }

    public String toString() {
        return "MavenSettings()";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MavenSettings)) {
            return false;
        }
        MavenSettings other = (MavenSettings)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof MavenSettings;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    static {
        WstxInputFactory input = new WstxInputFactory();
        input.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
        input.setProperty("javax.xml.stream.isNamespaceAware", false);
        xmlMapper = new XmlMapper(new XmlFactory((XMLInputFactory)input, (XMLOutputFactory)new WstxOutputFactory())).disable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT).disable(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    public static class Profile {
        @Nullable
        private final String id;
        @Nullable
        private final RawRepositories repositories;

        @JsonIgnore
        public boolean isActive(Collection<String> activeProfiles) {
            if (this.id != null) {
                for (String activeProfile : activeProfiles) {
                    if (!activeProfile.trim().equals(this.id)) continue;
                    return true;
                }
            }
            return false;
        }

        @ConstructorProperties(value={"id", "repositories"})
        public Profile(String id, RawRepositories repositories) {
            this.id = id;
            this.repositories = repositories;
        }

        public String getId() {
            return this.id;
        }

        public RawRepositories getRepositories() {
            return this.repositories;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Profile)) {
                return false;
            }
            Profile other = (Profile)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            RawRepositories this$repositories = this.getRepositories();
            RawRepositories other$repositories = other.getRepositories();
            return !(this$repositories == null ? other$repositories != null : !this$repositories.equals(other$repositories));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Profile;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            RawRepositories $repositories = this.getRepositories();
            result = result * 59 + ($repositories == null ? 43 : $repositories.hashCode());
            return result;
        }

        public String toString() {
            return "MavenSettings.Profile(id=" + this.getId() + ", repositories=" + this.getRepositories() + ")";
        }
    }

    public static class ActiveProfiles {
        @JacksonXmlProperty(localName="activeProfile")
        @JacksonXmlElementWrapper(useWrapping=false)
        private List<String> activeProfiles = Collections.emptyList();

        public List<String> getActiveProfiles() {
            return this.activeProfiles;
        }

        @JacksonXmlProperty(localName="activeProfile")
        public void setActiveProfiles(List<String> activeProfiles) {
            this.activeProfiles = activeProfiles;
        }
    }

    public static class Profiles {
        @JacksonXmlProperty(localName="profile")
        @JacksonXmlElementWrapper(useWrapping=false)
        private List<Profile> profiles = Collections.emptyList();

        public List<Profile> getProfiles() {
            return this.profiles;
        }

        @JacksonXmlProperty(localName="profile")
        public void setProfiles(List<Profile> profiles) {
            this.profiles = profiles;
        }
    }
}

