/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.tree;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.openrewrite.Formatting;
import org.openrewrite.Metadata;
import org.openrewrite.SourceVisitor;
import org.openrewrite.maven.MavenSourceVisitor;
import org.openrewrite.maven.tree.Modules;
import org.openrewrite.maven.tree.Pom;
import org.openrewrite.xml.XmlSourceVisitor;
import org.openrewrite.xml.tree.Xml;

public class Maven
extends Xml.Document {
    private final transient Pom model = (Pom)this.getMetadata(Pom.class);
    private final transient Collection<Pom> modules;

    public Maven(Xml.Document document) {
        super(document.getId(), document.getSourcePath(), document.getMetadata(), document.getProlog(), document.getRoot(), document.getFormatting());
        assert (this.model != null);
        Modules modulesContainer = (Modules)this.getMetadata(Modules.class);
        this.modules = modulesContainer == null ? Collections.emptyList() : modulesContainer.getModules();
    }

    @JsonIgnore
    public Pom getModel() {
        return this.model;
    }

    @JsonIgnore
    public Collection<Pom> getModules() {
        return this.modules;
    }

    public <R> R accept(SourceVisitor<R> v) {
        if (v instanceof MavenSourceVisitor) {
            return ((MavenSourceVisitor)v).visitMaven(this);
        }
        if (v instanceof XmlSourceVisitor) {
            return (R)super.accept(v);
        }
        return (R)v.defaultTo(null);
    }

    public Maven withRoot(Xml.Tag root) {
        Xml.Document m = super.withRoot(root);
        if (m instanceof Maven) {
            return (Maven)m;
        }
        return new Maven(m);
    }

    public Maven withMetadata(Collection<Metadata> metadata) {
        Xml.Document m = super.withMetadata(metadata);
        if (m instanceof Maven) {
            return (Maven)m;
        }
        return new Maven(m);
    }

    public Maven withFormatting(Formatting formatting) {
        Xml.Document m = super.withFormatting(formatting);
        if (m instanceof Maven) {
            return (Maven)m;
        }
        return new Maven(m);
    }

    public Maven withProlog(Xml.Prolog prolog) {
        Xml.Document m = super.withProlog(prolog);
        if (m instanceof Maven) {
            return (Maven)m;
        }
        return new Maven(m);
    }

    public Maven withModel(Pom model) {
        Pom existing = (Pom)this.getMetadata(Pom.class);
        ArrayList<Pom> metadata = new ArrayList<Pom>(this.getMetadata());
        for (int i = 0; i < metadata.size(); ++i) {
            Metadata datum = (Metadata)metadata.get(i);
            if (datum != existing) continue;
            metadata.set(i, model);
        }
        return this.withMetadata(metadata);
    }
}

