/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.tree;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.Metadata;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.tree.DependencyDescriptor;
import org.openrewrite.maven.tree.DependencyManagementDependency;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.Scope;

@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class, property="@ref")
public class Pom
implements Metadata {
    private final String sourcePath;
    @Nullable
    private final String groupId;
    private final String artifactId;
    @Nullable
    private final String version;
    @Nullable
    private final String type;
    @Nullable
    private final String classifier;
    @Nullable
    private final Pom parent;
    private final Collection<Dependency> dependencies;
    private final DependencyManagement dependencyManagement;
    private final Collection<License> licenses;
    private final Collection<Repository> repositories;
    private final Map<String, String> properties;

    public Pom(@Nullable @JsonProperty(value="sourcePath") String sourcePath, @Nullable @JsonProperty(value="groupId") String groupId, @JsonProperty(value="artifactId") String artifactId, @Nullable @JsonProperty(value="version") String version, @Nullable @JsonProperty(value="type") String type, @Nullable @JsonProperty(value="classifier") String classifier, @Nullable @JsonProperty(value="parent") Pom parent, @JsonProperty(value="dependencies") Collection<Dependency> dependencies, @JsonProperty(value="dependencyManagement") DependencyManagement dependencyManagement, @JsonProperty(value="licenses") Collection<License> licenses, @JsonProperty(value="repositories") Collection<Repository> repositories, @JsonProperty(value="properties") Map<String, String> properties) {
        this.sourcePath = sourcePath;
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.type = type;
        this.classifier = classifier;
        this.parent = parent;
        this.dependencies = dependencies;
        this.dependencyManagement = dependencyManagement;
        this.licenses = licenses;
        this.repositories = repositories;
        this.properties = properties;
    }

    public Set<Dependency> getDependencies(Scope scope) {
        TreeSet<Dependency> dependenciesForScope = new TreeSet<Dependency>(Comparator.comparing(Dependency::getCoordinates));
        for (Dependency dependency : this.dependencies) {
            this.addDependenciesFromScope(scope, dependency, dependenciesForScope);
        }
        return dependenciesForScope;
    }

    private void addDependenciesFromScope(Scope scope, Dependency dep, Set<Dependency> found) {
        if (dep.getScope().isInClasspathOf(scope)) {
            found.add(dep);
            for (Dependency child : dep.getModel().getDependencies()) {
                this.addDependenciesFromScope(scope, child, found);
            }
        }
    }

    @Nullable
    public String getProperty(@Nullable String property) {
        if (property == null) {
            return null;
        }
        String key = property.replace("${", "").replace("}", "");
        String value = this.properties.get(key);
        if (value == null) {
            return this.parent == null ? null : this.parent.getProperty(key);
        }
        return value;
    }

    public String getGroupId() {
        if (this.groupId == null) {
            if (this.parent == null) {
                throw new IllegalStateException("groupId must be defined");
            }
            return this.parent.getGroupId();
        }
        return this.groupId;
    }

    public DependencyManagement getEffectiveDependencyManagement() {
        if (this.parent == null) {
            return this.dependencyManagement;
        }
        return new DependencyManagement(Stream.concat(this.dependencyManagement.getDependencies().stream(), this.parent.getEffectiveDependencyManagement().getDependencies().stream()).collect(Collectors.toList()));
    }

    @Nullable
    public String getManagedVersion(String groupId, String artifactId) {
        DependencyManagement effectiveDependencyManagement = this.getEffectiveDependencyManagement();
        for (DependencyManagementDependency dep : effectiveDependencyManagement.getDependencies()) {
            for (DependencyDescriptor dependencyDescriptor : dep.getDependencies()) {
                if (!groupId.equals(dependencyDescriptor.getGroupId()) || !artifactId.equals(dependencyDescriptor.getArtifactId())) continue;
                return dependencyDescriptor.getVersion();
            }
        }
        return null;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        if (this.version == null) {
            if (this.parent == null) {
                throw new IllegalStateException("version must be defined");
            }
            return this.parent.getVersion();
        }
        return this.version;
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    @Nullable
    public String getClassifier() {
        return this.classifier;
    }

    public String toString() {
        return "Pom{" + this.groupId + ':' + this.artifactId + ':' + this.version + ", from=" + this.sourcePath + '}';
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public Pom getParent() {
        return this.parent;
    }

    public Collection<Dependency> getDependencies() {
        return this.dependencies;
    }

    public DependencyManagement getDependencyManagement() {
        return this.dependencyManagement;
    }

    public Collection<License> getLicenses() {
        return this.licenses;
    }

    public Collection<Repository> getRepositories() {
        return this.repositories;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Pom withLicenses(Collection<License> licenses) {
        return this.licenses == licenses ? this : new Pom(this.sourcePath, this.groupId, this.artifactId, this.version, this.type, this.classifier, this.parent, this.dependencies, this.dependencyManagement, licenses, this.repositories, this.properties);
    }

    public static class DependencyManagement {
        private final Collection<DependencyManagementDependency> dependencies;

        @ConstructorProperties(value={"dependencies"})
        public DependencyManagement(Collection<DependencyManagementDependency> dependencies) {
            this.dependencies = dependencies;
        }

        public Collection<DependencyManagementDependency> getDependencies() {
            return this.dependencies;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DependencyManagement)) {
                return false;
            }
            DependencyManagement other = (DependencyManagement)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Collection<DependencyManagementDependency> this$dependencies = this.getDependencies();
            Collection<DependencyManagementDependency> other$dependencies = other.getDependencies();
            return !(this$dependencies == null ? other$dependencies != null : !((Object)this$dependencies).equals(other$dependencies));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DependencyManagement;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Collection<DependencyManagementDependency> $dependencies = this.getDependencies();
            result = result * 59 + ($dependencies == null ? 43 : ((Object)$dependencies).hashCode());
            return result;
        }

        public String toString() {
            return "Pom.DependencyManagement(dependencies=" + this.getDependencies() + ")";
        }
    }

    public static class Dependency
    implements DependencyDescriptor {
        private final Scope scope;
        @Nullable
        private final String classifier;
        private final boolean optional;
        private final Pom model;
        @Nullable
        private final String requestedVersion;
        private final Set<GroupArtifact> exclusions;

        @Override
        @JsonIgnore
        public String getGroupId() {
            return this.model.getGroupId();
        }

        @Override
        @JsonIgnore
        public String getArtifactId() {
            return this.model.getArtifactId();
        }

        @Override
        @JsonIgnore
        public String getVersion() {
            return this.model.getVersion();
        }

        @JsonIgnore
        public URI getArtifactUri() {
            return URI.create(this.model.getSourcePath()).resolve(this.getArtifactId() + '-' + this.getVersion() + (StringUtils.isBlank((String)this.classifier) ? "" : '-' + this.classifier) + ".jar").normalize();
        }

        @JsonIgnore
        public String getCoordinates() {
            return this.model.getGroupId() + ':' + this.model.getArtifactId() + ':' + this.model.getVersion() + (this.classifier == null ? "" : ':' + this.classifier);
        }

        public String toString() {
            return "Dependency {" + this.getCoordinates() + (this.optional ? ", optional" : "") + (!this.getVersion().equals(this.requestedVersion) ? ", requested=" + this.requestedVersion : "") + ", from=" + this.model.getSourcePath() + '}';
        }

        public Collection<Dependency> findDependencies(String groupId, String artifactId) {
            return this.findDependencies(d -> d.getGroupId().equals(groupId) && d.getArtifactId().equals(artifactId));
        }

        public Collection<Dependency> findDependencies(Predicate<Dependency> matcher) {
            ArrayList<Dependency> matches = new ArrayList<Dependency>();
            if (matcher.test(this)) {
                matches.add(this);
            }
            for (Dependency d : this.model.getDependencies()) {
                matches.addAll(d.findDependencies(matcher));
            }
            return matches;
        }

        @ConstructorProperties(value={"scope", "classifier", "optional", "model", "requestedVersion", "exclusions"})
        public Dependency(Scope scope, String classifier, boolean optional, Pom model, String requestedVersion, Set<GroupArtifact> exclusions) {
            this.scope = scope;
            this.classifier = classifier;
            this.optional = optional;
            this.model = model;
            this.requestedVersion = requestedVersion;
            this.exclusions = exclusions;
        }

        @Override
        public Scope getScope() {
            return this.scope;
        }

        @Override
        public String getClassifier() {
            return this.classifier;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public Pom getModel() {
            return this.model;
        }

        public String getRequestedVersion() {
            return this.requestedVersion;
        }

        @Override
        public Set<GroupArtifact> getExclusions() {
            return this.exclusions;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Dependency)) {
                return false;
            }
            Dependency other = (Dependency)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isOptional() != other.isOptional()) {
                return false;
            }
            Scope this$scope = this.getScope();
            Scope other$scope = other.getScope();
            if (this$scope == null ? other$scope != null : !((Object)((Object)this$scope)).equals((Object)other$scope)) {
                return false;
            }
            String this$classifier = this.getClassifier();
            String other$classifier = other.getClassifier();
            if (this$classifier == null ? other$classifier != null : !this$classifier.equals(other$classifier)) {
                return false;
            }
            Pom this$model = this.getModel();
            Pom other$model = other.getModel();
            if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
                return false;
            }
            String this$requestedVersion = this.getRequestedVersion();
            String other$requestedVersion = other.getRequestedVersion();
            if (this$requestedVersion == null ? other$requestedVersion != null : !this$requestedVersion.equals(other$requestedVersion)) {
                return false;
            }
            Set<GroupArtifact> this$exclusions = this.getExclusions();
            Set<GroupArtifact> other$exclusions = other.getExclusions();
            return !(this$exclusions == null ? other$exclusions != null : !((Object)this$exclusions).equals(other$exclusions));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Dependency;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isOptional() ? 79 : 97);
            Scope $scope = this.getScope();
            result = result * 59 + ($scope == null ? 43 : ((Object)((Object)$scope)).hashCode());
            String $classifier = this.getClassifier();
            result = result * 59 + ($classifier == null ? 43 : $classifier.hashCode());
            Pom $model = this.getModel();
            result = result * 59 + ($model == null ? 43 : $model.hashCode());
            String $requestedVersion = this.getRequestedVersion();
            result = result * 59 + ($requestedVersion == null ? 43 : $requestedVersion.hashCode());
            Set<GroupArtifact> $exclusions = this.getExclusions();
            result = result * 59 + ($exclusions == null ? 43 : ((Object)$exclusions).hashCode());
            return result;
        }
    }

    public static enum LicenseType {
        Apache2,
        BSD,
        CDDL,
        CreativeCommons,
        Eclipse,
        GPL,
        LGPL,
        MIT,
        Mozilla,
        PublicDomain,
        Unknown;

    }

    public static class License {
        private final String name;
        private final LicenseType type;

        public static License fromName(@Nullable String license) {
            if (license == null) {
                return new License("", LicenseType.Unknown);
            }
            switch (license) {
                case "Apache License, Version 2.0": 
                case "The Apache Software License, Version 2.0": {
                    return new License(license, LicenseType.Apache2);
                }
                case "GNU Lesser General Public License": 
                case "GNU Library General Public License": {
                    return new License(license, LicenseType.LGPL);
                }
                case "Public Domain": {
                    return new License(license, LicenseType.PublicDomain);
                }
            }
            if (license.contains("LGPL")) {
                return new License(license, LicenseType.LGPL);
            }
            if (license.contains("GPL") || license.contains("GNU General Public License")) {
                return new License(license, LicenseType.GPL);
            }
            if (license.contains("CDDL")) {
                return new License(license, LicenseType.CDDL);
            }
            if (license.contains("Creative Commons") || license.contains("CC0")) {
                return new License(license, LicenseType.CreativeCommons);
            }
            if (license.contains("BSD")) {
                return new License(license, LicenseType.BSD);
            }
            if (license.contains("MIT")) {
                return new License(license, LicenseType.MIT);
            }
            if (license.contains("Eclipse") || license.contains("EPL")) {
                return new License(license, LicenseType.Eclipse);
            }
            if (license.contains("Apache") || license.contains("ASF")) {
                return new License(license, LicenseType.Apache2);
            }
            if (license.contains("Mozilla")) {
                return new License(license, LicenseType.Mozilla);
            }
            if (license.toLowerCase().contains("GNU Lesser General Public License".toLowerCase()) || license.contains("GNU Library General Public License")) {
                return new License(license, LicenseType.LGPL);
            }
            return new License(license, LicenseType.Unknown);
        }

        @ConstructorProperties(value={"name", "type"})
        public License(String name, LicenseType type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public LicenseType getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof License)) {
                return false;
            }
            License other = (License)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            LicenseType this$type = this.getType();
            LicenseType other$type = other.getType();
            return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
        }

        protected boolean canEqual(Object other) {
            return other instanceof License;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            LicenseType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            return result;
        }

        public String toString() {
            return "Pom.License(name=" + this.getName() + ", type=" + (Object)((Object)this.getType()) + ")";
        }
    }

    public static class Repository {
        private final URL url;
        private final boolean releases;
        private final boolean snapshots;

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Repository)) {
                return false;
            }
            Repository other = (Repository)o;
            if (!other.canEqual(this)) {
                return false;
            }
            URL this$url = this.getUrl();
            URL other$url = other.getUrl();
            return !(this$url == null ? other$url != null : !((Object)this$url).equals(other$url));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Repository;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            URL $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : ((Object)$url).hashCode());
            return result;
        }

        @ConstructorProperties(value={"url", "releases", "snapshots"})
        public Repository(URL url, boolean releases, boolean snapshots) {
            this.url = url;
            this.releases = releases;
            this.snapshots = snapshots;
        }

        public URL getUrl() {
            return this.url;
        }

        public boolean isReleases() {
            return this.releases;
        }

        public boolean isSnapshots() {
            return this.snapshots;
        }

        public String toString() {
            return "Pom.Repository(url=" + this.getUrl() + ", releases=" + this.isReleases() + ", snapshots=" + this.isSnapshots() + ")";
        }
    }
}

