/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.internal;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.internal.RequestedVersion;
import org.openrewrite.maven.tree.GroupArtifact;

public class RawPom {
    @Nullable
    private final Parent parent;
    @Nullable
    private final String groupId;
    private final String artifactId;
    @Nullable
    private final String version;
    @Nullable
    private final String packaging;
    @Nullable
    private final Dependencies dependencies;
    @Nullable
    private final DependencyManagement dependencyManagement;
    @Nullable
    private final Map<String, String> properties;
    @Nullable
    private final Repositories repositories;
    @Nullable
    private final Licenses licenses;
    @Nullable
    private final Profiles profiles;

    @JsonCreator
    public RawPom(@JsonProperty(value="parent") @Nullable Parent parent, @JsonProperty(value="groupId") @Nullable String groupId, @JsonProperty(value="artifactId") String artifactId, @JsonProperty(value="version") @Nullable String version, @JsonProperty(value="packaging") @Nullable String packaging, @JsonProperty(value="dependencies") @Nullable Dependencies dependencies, @JsonProperty(value="dependencyManagement") @Nullable DependencyManagement dependencyManagement, @JsonProperty(value="properties") @Nullable Map<String, String> properties, @JsonProperty(value="repositories") @Nullable Repositories repositories, @JsonProperty(value="licenses") @Nullable Licenses licenses, @JsonProperty(value="profiles") @Nullable Profiles profiles) {
        this.parent = parent;
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.packaging = packaging;
        this.dependencies = dependencies;
        this.dependencyManagement = dependencyManagement;
        this.properties = properties;
        this.repositories = repositories;
        this.licenses = licenses;
        this.profiles = profiles;
    }

    @JsonIgnore
    public Map<String, String> getActiveProperties() {
        HashMap<String, String> activeProperties = new HashMap<String, String>();
        if (this.properties != null) {
            activeProperties.putAll(this.properties);
        }
        if (this.profiles != null) {
            for (Profile profile : this.getProfiles()) {
                if (!profile.isActive() || profile.getProperties() == null) continue;
                activeProperties.putAll(profile.getProperties());
            }
        }
        return activeProperties;
    }

    @JsonIgnore
    public List<Dependency> getActiveDependencies() {
        ArrayList<Dependency> activeDependencies = new ArrayList<Dependency>();
        if (this.dependencies != null) {
            activeDependencies.addAll(this.dependencies.getDependencies());
        }
        if (this.profiles != null) {
            for (Profile profile : this.getProfiles()) {
                if (!profile.isActive() || profile.dependencies == null) continue;
                activeDependencies.addAll(profile.dependencies);
            }
        }
        return activeDependencies;
    }

    @JsonIgnore
    public List<Repository> getRepositories() {
        return this.repositories == null ? Collections.emptyList() : this.repositories.getRepositories();
    }

    @JsonIgnore
    public List<License> getLicenses() {
        return this.licenses == null ? Collections.emptyList() : this.licenses.getLicenses();
    }

    @JsonIgnore
    public List<Profile> getProfiles() {
        return this.profiles == null ? Collections.emptyList() : this.profiles.getProfiles();
    }

    @Nullable
    public String getGroupId() {
        return this.groupId == null && this.parent != null ? this.parent.getGroupId() : this.groupId;
    }

    @Nullable
    public String getVersion() {
        return this.version == null && this.parent != null ? this.parent.getVersion() : this.version;
    }

    public String toString() {
        return "RawPom(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RawPom)) {
            return false;
        }
        RawPom other = (RawPom)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RawPom;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }

    public Parent getParent() {
        return this.parent;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public DependencyManagement getDependencyManagement() {
        return this.dependencyManagement;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public static class ProfileActivation {
        @Nullable
        private final String jdk;
        @Nullable
        private final Map<String, String> property;

        @JsonIgnore
        public boolean isActive() {
            return this.isActiveByJdk() || this.isActiveByProperty();
        }

        @JsonIgnore
        private boolean isActiveByJdk() {
            if (this.jdk == null) {
                return false;
            }
            String version = System.getProperty("java.version");
            RequestedVersion requestedVersion = new RequestedVersion(new GroupArtifact("", ""), null, this.jdk);
            if (requestedVersion.isDynamic() || requestedVersion.isRange()) {
                return requestedVersion.selectFrom(Collections.singletonList(version)) != null;
            }
            return version.startsWith(requestedVersion.nearestVersion());
        }

        @JsonIgnore
        private boolean isActiveByProperty() {
            if (this.property == null || this.property.isEmpty()) {
                return false;
            }
            for (Map.Entry<String, String> prop : this.property.entrySet()) {
                if (prop.getValue().equals(System.getenv(prop.getKey()))) continue;
                return false;
            }
            return true;
        }

        @ConstructorProperties(value={"jdk", "property"})
        public ProfileActivation(String jdk, Map<String, String> property) {
            this.jdk = jdk;
            this.property = property;
        }

        public String getJdk() {
            return this.jdk;
        }

        public Map<String, String> getProperty() {
            return this.property;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProfileActivation)) {
                return false;
            }
            ProfileActivation other = (ProfileActivation)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$jdk = this.getJdk();
            String other$jdk = other.getJdk();
            if (this$jdk == null ? other$jdk != null : !this$jdk.equals(other$jdk)) {
                return false;
            }
            Map<String, String> this$property = this.getProperty();
            Map<String, String> other$property = other.getProperty();
            return !(this$property == null ? other$property != null : !((Object)this$property).equals(other$property));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ProfileActivation;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $jdk = this.getJdk();
            result = result * 59 + ($jdk == null ? 43 : $jdk.hashCode());
            Map<String, String> $property = this.getProperty();
            result = result * 59 + ($property == null ? 43 : ((Object)$property).hashCode());
            return result;
        }

        public String toString() {
            return "RawPom.ProfileActivation(jdk=" + this.getJdk() + ", property=" + this.getProperty() + ")";
        }
    }

    public static class Profile {
        @Nullable
        private final ProfileActivation activation;
        @Nullable
        private final Map<String, String> properties;
        @Nullable
        private final List<Dependency> dependencies;

        @JsonIgnore
        public boolean isActive() {
            return this.activation != null && this.activation.isActive();
        }

        @ConstructorProperties(value={"activation", "properties", "dependencies"})
        public Profile(ProfileActivation activation, Map<String, String> properties, List<Dependency> dependencies) {
            this.activation = activation;
            this.properties = properties;
            this.dependencies = dependencies;
        }

        public ProfileActivation getActivation() {
            return this.activation;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }

        public List<Dependency> getDependencies() {
            return this.dependencies;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Profile)) {
                return false;
            }
            Profile other = (Profile)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ProfileActivation this$activation = this.getActivation();
            ProfileActivation other$activation = other.getActivation();
            if (this$activation == null ? other$activation != null : !((Object)this$activation).equals(other$activation)) {
                return false;
            }
            Map<String, String> this$properties = this.getProperties();
            Map<String, String> other$properties = other.getProperties();
            if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
                return false;
            }
            List<Dependency> this$dependencies = this.getDependencies();
            List<Dependency> other$dependencies = other.getDependencies();
            return !(this$dependencies == null ? other$dependencies != null : !((Object)this$dependencies).equals(other$dependencies));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Profile;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ProfileActivation $activation = this.getActivation();
            result = result * 59 + ($activation == null ? 43 : ((Object)$activation).hashCode());
            Map<String, String> $properties = this.getProperties();
            result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
            List<Dependency> $dependencies = this.getDependencies();
            result = result * 59 + ($dependencies == null ? 43 : ((Object)$dependencies).hashCode());
            return result;
        }

        public String toString() {
            return "RawPom.Profile(activation=" + this.getActivation() + ", properties=" + this.getProperties() + ", dependencies=" + this.getDependencies() + ")";
        }
    }

    public static class License {
        private final String name;

        @ConstructorProperties(value={"name"})
        public License(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof License)) {
                return false;
            }
            License other = (License)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof License;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public String toString() {
            return "RawPom.License(name=" + this.getName() + ")";
        }
    }

    public static class Parent {
        private final String groupId;
        private final String artifactId;
        private final String version;
        @Nullable
        private final String relativePath;

        @ConstructorProperties(value={"groupId", "artifactId", "version", "relativePath"})
        public Parent(String groupId, String artifactId, String version, String relativePath) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
            this.relativePath = relativePath;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public String getRelativePath() {
            return this.relativePath;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Parent)) {
                return false;
            }
            Parent other = (Parent)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$groupId = this.getGroupId();
            String other$groupId = other.getGroupId();
            if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
                return false;
            }
            String this$artifactId = this.getArtifactId();
            String other$artifactId = other.getArtifactId();
            if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            String this$relativePath = this.getRelativePath();
            String other$relativePath = other.getRelativePath();
            return !(this$relativePath == null ? other$relativePath != null : !this$relativePath.equals(other$relativePath));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Parent;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $groupId = this.getGroupId();
            result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
            String $artifactId = this.getArtifactId();
            result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            String $relativePath = this.getRelativePath();
            result = result * 59 + ($relativePath == null ? 43 : $relativePath.hashCode());
            return result;
        }

        public String toString() {
            return "RawPom.Parent(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ", relativePath=" + this.getRelativePath() + ")";
        }
    }

    public static class ArtifactPolicy {
        private final boolean enabled;

        @JsonCreator
        public ArtifactPolicy(@JsonProperty(value="enabled") @Nullable Boolean enabled) {
            this.enabled = enabled == null || enabled != false;
        }

        public ArtifactPolicy() {
            this(true);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ArtifactPolicy)) {
                return false;
            }
            ArtifactPolicy other = (ArtifactPolicy)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.isEnabled() == other.isEnabled();
        }

        protected boolean canEqual(Object other) {
            return other instanceof ArtifactPolicy;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            return result;
        }

        public boolean isEnabled() {
            return this.enabled;
        }
    }

    public static class Repository {
        private final String url;
        @Nullable
        private final ArtifactPolicy releases;
        @Nullable
        private final ArtifactPolicy snapshots;

        public boolean acceptsVersion(String version) {
            if (version.endsWith("-SNAPSHOT")) {
                return this.snapshots != null && this.snapshots.isEnabled();
            }
            if (this.url.equals("https://repo.spring.io/milestone")) {
                return version.matches(".*(M|RC)\\d+$");
            }
            return this.releases != null && this.releases.isEnabled();
        }

        @ConstructorProperties(value={"url", "releases", "snapshots"})
        public Repository(String url, ArtifactPolicy releases, ArtifactPolicy snapshots) {
            this.url = url;
            this.releases = releases;
            this.snapshots = snapshots;
        }

        public String getUrl() {
            return this.url;
        }

        public ArtifactPolicy getReleases() {
            return this.releases;
        }

        public ArtifactPolicy getSnapshots() {
            return this.snapshots;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Repository)) {
                return false;
            }
            Repository other = (Repository)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            ArtifactPolicy this$releases = this.getReleases();
            ArtifactPolicy other$releases = other.getReleases();
            if (this$releases == null ? other$releases != null : !((Object)this$releases).equals(other$releases)) {
                return false;
            }
            ArtifactPolicy this$snapshots = this.getSnapshots();
            ArtifactPolicy other$snapshots = other.getSnapshots();
            return !(this$snapshots == null ? other$snapshots != null : !((Object)this$snapshots).equals(other$snapshots));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Repository;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            ArtifactPolicy $releases = this.getReleases();
            result = result * 59 + ($releases == null ? 43 : ((Object)$releases).hashCode());
            ArtifactPolicy $snapshots = this.getSnapshots();
            result = result * 59 + ($snapshots == null ? 43 : ((Object)$snapshots).hashCode());
            return result;
        }

        public String toString() {
            return "RawPom.Repository(url=" + this.getUrl() + ", releases=" + this.getReleases() + ", snapshots=" + this.getSnapshots() + ")";
        }

        public Repository withUrl(String url) {
            return this.url == url ? this : new Repository(url, this.releases, this.snapshots);
        }
    }

    public static class Profiles {
        @JacksonXmlProperty(localName="profile")
        @JacksonXmlElementWrapper(useWrapping=false)
        private List<Profile> profiles = Collections.emptyList();

        public List<Profile> getProfiles() {
            return this.profiles;
        }

        @JacksonXmlProperty(localName="profile")
        public void setProfiles(List<Profile> profiles) {
            this.profiles = profiles;
        }
    }

    public static class Licenses {
        @JacksonXmlProperty(localName="license")
        @JacksonXmlElementWrapper(useWrapping=false)
        private List<License> licenses = Collections.emptyList();

        public List<License> getLicenses() {
            return this.licenses;
        }

        @JacksonXmlProperty(localName="license")
        public void setLicenses(List<License> licenses) {
            this.licenses = licenses;
        }
    }

    public static class Repositories {
        @JacksonXmlProperty(localName="repository")
        @JacksonXmlElementWrapper(useWrapping=false)
        private List<Repository> repositories = Collections.emptyList();

        public List<Repository> getRepositories() {
            return this.repositories;
        }

        @JacksonXmlProperty(localName="repository")
        public void setRepositories(List<Repository> repositories) {
            this.repositories = repositories;
        }
    }

    public static class Dependencies {
        @JacksonXmlProperty(localName="dependency")
        @JacksonXmlElementWrapper(useWrapping=false)
        private List<Dependency> dependencies = Collections.emptyList();

        public List<Dependency> getDependencies() {
            return this.dependencies;
        }

        @JacksonXmlProperty(localName="dependency")
        public void setDependencies(List<Dependency> dependencies) {
            this.dependencies = dependencies;
        }
    }

    public static class DependencyManagement {
        @Nullable
        private Dependencies dependencies;

        public Dependencies getDependencies() {
            return this.dependencies;
        }

        public void setDependencies(Dependencies dependencies) {
            this.dependencies = dependencies;
        }
    }

    public static class Dependency {
        private final String groupId;
        private final String artifactId;
        @Nullable
        private final String version;
        @Nullable
        private final String scope;
        @Nullable
        private final String type;
        @Nullable
        private final String classifier;
        @Nullable
        private final Boolean optional;
        @Nullable
        private final Set<GroupArtifact> exclusions;

        @ConstructorProperties(value={"groupId", "artifactId", "version", "scope", "type", "classifier", "optional", "exclusions"})
        public Dependency(String groupId, String artifactId, String version, String scope, String type, String classifier, Boolean optional, Set<GroupArtifact> exclusions) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
            this.scope = scope;
            this.type = type;
            this.classifier = classifier;
            this.optional = optional;
            this.exclusions = exclusions;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public String getScope() {
            return this.scope;
        }

        public String getType() {
            return this.type;
        }

        public String getClassifier() {
            return this.classifier;
        }

        public Boolean getOptional() {
            return this.optional;
        }

        public Set<GroupArtifact> getExclusions() {
            return this.exclusions;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Dependency)) {
                return false;
            }
            Dependency other = (Dependency)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$optional = this.getOptional();
            Boolean other$optional = other.getOptional();
            if (this$optional == null ? other$optional != null : !((Object)this$optional).equals(other$optional)) {
                return false;
            }
            String this$groupId = this.getGroupId();
            String other$groupId = other.getGroupId();
            if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
                return false;
            }
            String this$artifactId = this.getArtifactId();
            String other$artifactId = other.getArtifactId();
            if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            String this$scope = this.getScope();
            String other$scope = other.getScope();
            if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$classifier = this.getClassifier();
            String other$classifier = other.getClassifier();
            if (this$classifier == null ? other$classifier != null : !this$classifier.equals(other$classifier)) {
                return false;
            }
            Set<GroupArtifact> this$exclusions = this.getExclusions();
            Set<GroupArtifact> other$exclusions = other.getExclusions();
            return !(this$exclusions == null ? other$exclusions != null : !((Object)this$exclusions).equals(other$exclusions));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Dependency;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $optional = this.getOptional();
            result = result * 59 + ($optional == null ? 43 : ((Object)$optional).hashCode());
            String $groupId = this.getGroupId();
            result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
            String $artifactId = this.getArtifactId();
            result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            String $scope = this.getScope();
            result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $classifier = this.getClassifier();
            result = result * 59 + ($classifier == null ? 43 : $classifier.hashCode());
            Set<GroupArtifact> $exclusions = this.getExclusions();
            result = result * 59 + ($exclusions == null ? 43 : ((Object)$exclusions).hashCode());
            return result;
        }

        public String toString() {
            return "RawPom.Dependency(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ", scope=" + this.getScope() + ", type=" + this.getType() + ", classifier=" + this.getClassifier() + ", optional=" + this.getOptional() + ", exclusions=" + this.getExclusions() + ")";
        }
    }
}

