/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.internal;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import org.openrewrite.xml.XmlParser;

public class MavenMetadata {
    private static final ObjectMapper xmlMapper = new XmlMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    private static final XmlParser xmlParser = new XmlParser(){

        public boolean accept(URI path) {
            return super.accept(path) || path.toString().endsWith(".pom");
        }
    };
    public static final MavenMetadata EMPTY = new MavenMetadata(new Versioning(Collections.emptyList()));
    private final Versioning versioning;

    public static MavenMetadata parse(byte[] document) {
        try {
            return (MavenMetadata)xmlMapper.readValue(document, MavenMetadata.class);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @ConstructorProperties(value={"versioning"})
    public MavenMetadata(Versioning versioning) {
        this.versioning = versioning;
    }

    public Versioning getVersioning() {
        return this.versioning;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MavenMetadata)) {
            return false;
        }
        MavenMetadata other = (MavenMetadata)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Versioning this$versioning = this.getVersioning();
        Versioning other$versioning = other.getVersioning();
        return !(this$versioning == null ? other$versioning != null : !((Object)this$versioning).equals(other$versioning));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MavenMetadata;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Versioning $versioning = this.getVersioning();
        result = result * 59 + ($versioning == null ? 43 : ((Object)$versioning).hashCode());
        return result;
    }

    public String toString() {
        return "MavenMetadata(versioning=" + this.getVersioning() + ")";
    }

    public static class Versioning {
        private final Collection<String> versions;

        @ConstructorProperties(value={"versions"})
        public Versioning(Collection<String> versions) {
            this.versions = versions;
        }

        public Collection<String> getVersions() {
            return this.versions;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Versioning)) {
                return false;
            }
            Versioning other = (Versioning)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Collection<String> this$versions = this.getVersions();
            Collection<String> other$versions = other.getVersions();
            return !(this$versions == null ? other$versions != null : !((Object)this$versions).equals(other$versions));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Versioning;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Collection<String> $versions = this.getVersions();
            result = result * 59 + ($versions == null ? 43 : ((Object)$versions).hashCode());
            return result;
        }

        public String toString() {
            return "MavenMetadata.Versioning(versions=" + this.getVersions() + ")";
        }
    }
}

