/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.internal;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.io.ByteArrayInputStream;
import java.net.URI;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import okhttp3.ConnectionSpec;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.openrewrite.Parser;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.cache.CacheResult;
import org.openrewrite.maven.cache.MavenCache;
import org.openrewrite.maven.internal.MavenMetadata;
import org.openrewrite.maven.internal.RawMaven;
import org.openrewrite.maven.internal.RawPom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenDownloader {
    private static final Logger logger = LoggerFactory.getLogger(MavenDownloader.class);
    private static final OkHttpClient httpClient = new OkHttpClient.Builder().connectionSpecs(Arrays.asList(ConnectionSpec.CLEARTEXT, ConnectionSpec.MODERN_TLS, ConnectionSpec.COMPATIBLE_TLS)).build();
    private static final RawPom.Repository SUPER_POM_REPOSITORY = new RawPom.Repository("https://repo.maven.apache.org/maven2", new RawPom.ArtifactPolicy(true), new RawPom.ArtifactPolicy(false));
    private final MavenCache mavenCache;
    private final Map<String, RawMaven> projectPoms;

    public MavenDownloader(MavenCache mavenCache) {
        this(mavenCache, Collections.emptyMap());
    }

    public MavenDownloader(MavenCache mavenCache, Map<String, RawMaven> projectPoms) {
        this.mavenCache = mavenCache;
        this.projectPoms = projectPoms;
    }

    public MavenMetadata downloadMetadata(String groupId, String artifactId, List<RawPom.Repository> repositories) {
        Timer.Sample sample = Timer.start();
        return Stream.concat(repositories.stream().distinct().map(this::normalizeRepository), Stream.of(SUPER_POM_REPOSITORY)).filter(Objects::nonNull).map(repo -> {
            Timer.Builder timer = Timer.builder((String)"rewrite.maven.download").tag("group.id", groupId).tag("artifact.id", artifactId).tag("type", "metadata");
            try {
                CacheResult<MavenMetadata> result = this.mavenCache.computeMavenMetadata(URI.create(repo.getUrl()).toURL(), groupId, artifactId, () -> {
                    logger.debug("Resolving {}:{} metadata from {}", new Object[]{groupId, artifactId, repo.getUrl()});
                    String uri = repo.getUrl() + "/" + groupId.replace('.', '/') + '/' + artifactId + '/' + "maven-metadata.xml";
                    Request request = new Request.Builder().url(uri).get().build();
                    try (Response response = httpClient.newCall(request).execute();){
                        if (response.isSuccessful() && response.body() != null) {
                            byte[] responseBody = response.body().bytes();
                            MavenMetadata mavenMetadata = MavenMetadata.parse(responseBody);
                            return mavenMetadata;
                        }
                    }
                    return null;
                });
                sample.stop(this.addTagsByResult(timer, result).register((MeterRegistry)Metrics.globalRegistry));
                return result.getData();
            }
            catch (Exception e) {
                sample.stop(timer.tags(new String[]{"outcome", "error", "exception", e.getClass().getName()}).register((MeterRegistry)Metrics.globalRegistry));
                return null;
            }
        }).filter(Objects::nonNull).reduce(MavenMetadata.EMPTY, (m1, m2) -> {
            if (m1 == MavenMetadata.EMPTY) {
                if (m2 == MavenMetadata.EMPTY) {
                    return m1;
                }
                return m2;
            }
            if (m2 == MavenMetadata.EMPTY) {
                return m1;
            }
            return new MavenMetadata(new MavenMetadata.Versioning(Stream.concat(m1.getVersioning().getVersions().stream(), m2.getVersioning().getVersions().stream()).collect(Collectors.toList())));
        });
    }

    private Timer.Builder addTagsByResult(Timer.Builder timer, CacheResult<?> result) {
        switch (result.getState()) {
            case Cached: {
                timer = timer.tags(new String[]{"outcome", "cached", "exception", "none"});
                break;
            }
            case Unavailable: {
                timer = timer.tags(new String[]{"outcome", "unavailable", "exception", "none"});
                break;
            }
            case Updated: {
                timer = timer.tags(new String[]{"outcome", "downloaded", "exception", "none"});
            }
        }
        return timer;
    }

    @Nullable
    public RawMaven download(String groupId, String artifactId, String version, @Nullable String classifier, @Nullable String relativePath, @Nullable RawMaven containingPom, List<RawPom.Repository> repositories) {
        Timer.Sample sample = Timer.start();
        if (containingPom == null || !containingPom.getSourcePath().contains("http")) {
            if (!StringUtils.isBlank((String)relativePath)) {
                return Optional.ofNullable(containingPom).map(pom -> this.projectPoms.get(Paths.get(pom.getSourcePath(), new String[0]).relativize(Paths.get(relativePath, new String[0])).resolve("pom.xml").normalize().toString())).orElse(null);
            }
            for (RawMaven projectPom : this.projectPoms.values()) {
                if (!groupId.equals(projectPom.getPom().getGroupId()) || !artifactId.equals(projectPom.getPom().getArtifactId())) continue;
                return projectPom;
            }
        }
        return Stream.concat(repositories.stream().distinct().map(this::normalizeRepository), Stream.of(SUPER_POM_REPOSITORY)).filter(Objects::nonNull).filter(repo -> repo.acceptsVersion(version)).map(repo -> {
            Timer.Builder timer = Timer.builder((String)"rewrite.maven.download").tag("group.id", groupId).tag("artifact.id", artifactId).tag("type", "pom");
            try {
                CacheResult<RawMaven> result = this.mavenCache.computeMaven(URI.create(repo.getUrl()).toURL(), groupId, artifactId, version, () -> {
                    String uri = repo.getUrl() + "/" + groupId.replace('.', '/') + '/' + artifactId + '/' + version + '/' + artifactId + '-' + version + ".pom";
                    Request request = new Request.Builder().url(uri).get().build();
                    try (Response response = httpClient.newCall(request).execute();){
                        if (response.isSuccessful() && response.body() != null) {
                            byte[] responseBody = response.body().bytes();
                            RawMaven rawMaven = RawMaven.parse(new Parser.Input(URI.create(uri), () -> new ByteArrayInputStream(responseBody)), null);
                            return rawMaven;
                        }
                    }
                    return null;
                });
                sample.stop(this.addTagsByResult(timer, result).register((MeterRegistry)Metrics.globalRegistry));
                return result.getData();
            }
            catch (Exception e) {
                logger.debug("Failed to download {}:{}:{}:{}", new Object[]{groupId, artifactId, version, classifier, e});
                sample.stop(timer.tags(new String[]{"outcome", "error", "exception", e.getClass().getName()}).register((MeterRegistry)Metrics.globalRegistry));
                return null;
            }
        }).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Nullable
    private RawPom.Repository normalizeRepository(RawPom.Repository repository) {
        try {
            CacheResult<RawPom.Repository> result = this.mavenCache.computeRepository(repository, () -> {
                String url = repository.getUrl();
                Request request = new Request.Builder().url(url).head().build();
                try (Response response = httpClient.newCall(request).execute();){
                    if (url.toLowerCase().contains("http://")) {
                        RawPom.Repository repository2 = this.normalizeRepository(new RawPom.Repository(url.toLowerCase().replace("http://", "https://"), repository.getReleases(), repository.getSnapshots()));
                        return repository2;
                    }
                    if (response.isSuccessful()) {
                        RawPom.Repository repository3 = new RawPom.Repository(url, repository.getReleases(), repository.getSnapshots());
                        return repository3;
                    }
                    RawPom.Repository repository4 = null;
                    return repository4;
                }
            });
            return result.getData();
        }
        catch (Exception e) {
            return null;
        }
    }
}

