/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.openrewrite.Parser;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.cache.InMemoryCache;
import org.openrewrite.maven.cache.MavenCache;
import org.openrewrite.maven.internal.MavenDownloader;
import org.openrewrite.maven.internal.RawMaven;
import org.openrewrite.maven.internal.RawMavenResolver;
import org.openrewrite.maven.tree.Maven;
import org.openrewrite.maven.tree.Modules;
import org.openrewrite.maven.tree.Pom;

public class MavenParser
implements Parser<Maven> {
    private final MavenCache mavenCache;
    private final boolean resolveOptional;

    private MavenParser(MavenCache mavenCache, boolean resolveOptional) {
        this.mavenCache = mavenCache;
        this.resolveOptional = resolveOptional;
    }

    public List<Maven> parseInputs(Iterable<Parser.Input> sources, @Nullable URI relativeTo) {
        Collection projectPoms = StreamSupport.stream(sources.spliterator(), false).map(source -> RawMaven.parse(source, relativeTo)).collect(Collectors.toList());
        MavenDownloader downloader = new MavenDownloader(this.mavenCache, projectPoms.stream().collect(Collectors.toMap(RawMaven::getSourcePath, Function.identity())));
        List parsed = projectPoms.stream().map(raw -> new RawMavenResolver(downloader, false, this.resolveOptional).resolve((RawMaven)raw)).filter(Objects::nonNull).map(Maven::new).collect(Collectors.toCollection(ArrayList::new));
        for (int i = 0; i < parsed.size(); ++i) {
            Maven maven = (Maven)((Object)parsed.get(i));
            ArrayList<Pom> modules = new ArrayList<Pom>(0);
            for (Maven possibleModule : parsed) {
                Pom parent = possibleModule.getModel().getParent();
                if (parent == null || !parent.getGroupId().equals(maven.getModel().getGroupId()) || !parent.getArtifactId().equals(maven.getModel().getArtifactId()) || !parent.getVersion().equals(maven.getModel().getVersion())) continue;
                modules.add(possibleModule.getModel());
            }
            if (modules.isEmpty()) continue;
            parsed.set(i, (Maven)maven.setMetadata(new Modules(modules)));
        }
        return parsed;
    }

    public boolean accept(URI path) {
        return path.toString().equals("pom.xml") || path.toString().endsWith(".pom");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean resolveOptional = true;
        private MavenCache mavenCache = new InMemoryCache();

        public Builder resolveOptional(@Nullable Boolean optional) {
            this.resolveOptional = optional == null || optional != false;
            return this;
        }

        public Builder cache(MavenCache cache) {
            this.mavenCache = cache;
            return this;
        }

        public MavenParser build() {
            return new MavenParser(this.mavenCache, this.resolveOptional);
        }
    }
}

