/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.io.File;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.ChangeParentVersion;
import org.openrewrite.maven.MavenParser;
import org.openrewrite.maven.MavenRefactorVisitor;
import org.openrewrite.maven.tree.Maven;
import org.openrewrite.semver.LatestRelease;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;

public class UpgradeParentVersion
extends MavenRefactorVisitor {
    private String groupId;
    private String artifactId;
    private String toVersion;
    @Nullable
    private String metadataPattern;
    private File localRepository = MavenParser.DEFAULT_LOCAL_REPOSITORY;
    @Nullable
    private File workspaceDir;
    private VersionComparator versionComparator;

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setToVersion(String toVersion) {
        this.toVersion = toVersion;
    }

    public void setMetadataPattern(@Nullable String metadataPattern) {
        this.metadataPattern = metadataPattern;
    }

    public void setLocalRepository(File localRepository) {
        this.localRepository = localRepository;
    }

    public void setWorkspaceDir(@Nullable File workspaceDir) {
        this.workspaceDir = workspaceDir;
    }

    public UpgradeParentVersion() {
        this.setCursoringOn();
    }

    public Validated validate() {
        return Validated.required((String)"groupId", (Object)this.groupId).and(Validated.required((String)"artifactId", (Object)this.artifactId)).and(Validated.required((String)"toVersion", (Object)this.toVersion)).and(Semver.validate((String)this.toVersion, (String)this.metadataPattern)).and(Validated.test((String)"localRepository", (String)"must exist", (Object)this.localRepository, File::exists)).and(Validated.test((String)"workspaceDir", (String)"must exist if set", (Object)this.workspaceDir, w -> w == null || w.exists()));
    }

    @Override
    public Maven visitPom(Maven.Pom pom) {
        this.versionComparator = (VersionComparator)Semver.validate((String)this.toVersion, (String)this.metadataPattern).getValue();
        return super.visitPom(pom);
    }

    @Override
    public Maven visitParent(Maven.Parent parent) {
        Maven.Parent p = (Maven.Parent)this.refactor(parent, x$0 -> super.visitParent((Maven.Parent)x$0));
        Maven.Pom pom = (Maven.Pom)this.getCursor().firstEnclosing(Maven.Pom.class);
        assert (pom != null);
        List<String> newerVersions = p.getModel().getModuleVersion().getNewerVersions(pom, this.localRepository, this.workspaceDir);
        LatestRelease latestRelease = new LatestRelease(this.metadataPattern);
        Optional<String> newerVersion = newerVersions.stream().filter(v -> this.versionComparator.isValid(v)).filter(v -> latestRelease.compare(parent.getModel().getModuleVersion().getVersion(), v) < 0).max((Comparator<String>)this.versionComparator);
        if (newerVersion.isPresent()) {
            ChangeParentVersion changeParentVersion = new ChangeParentVersion();
            changeParentVersion.setGroupId(this.groupId);
            changeParentVersion.setArtifactId(this.artifactId);
            changeParentVersion.setToVersion(newerVersion.get());
            this.andThen((RefactorVisitor)changeParentVersion);
        }
        return p;
    }
}

