/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.io.File;
import java.util.Comparator;
import java.util.Optional;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.ChangeDependencyVersion;
import org.openrewrite.maven.ChangePropertyValue;
import org.openrewrite.maven.MavenParser;
import org.openrewrite.maven.MavenRefactorVisitor;
import org.openrewrite.maven.tree.Maven;
import org.openrewrite.maven.tree.MavenModel;
import org.openrewrite.semver.LatestRelease;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;

public class UpgradeDependencyVersion
extends MavenRefactorVisitor {
    private String groupId;
    @Nullable
    private String artifactId;
    private String toVersion;
    @Nullable
    private String metadataPattern;
    private File localRepository = MavenParser.DEFAULT_LOCAL_REPOSITORY;
    @Nullable
    private File workspaceDir;
    private VersionComparator versionComparator;

    public UpgradeDependencyVersion() {
        this.setCursoringOn();
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setArtifactId(@Nullable String artifactId) {
        this.artifactId = artifactId;
    }

    public void setToVersion(String toVersion) {
        this.toVersion = toVersion;
    }

    public void setMetadataPattern(@Nullable String metadataPattern) {
        this.metadataPattern = metadataPattern;
    }

    public void setLocalRepository(File localRepository) {
        this.localRepository = localRepository;
    }

    public void setWorkspaceDir(@Nullable File workspaceDir) {
        this.workspaceDir = workspaceDir;
    }

    public Validated validate() {
        return Validated.required((String)"groupId", (Object)this.groupId).and(Validated.required((String)"toVersion", (Object)this.toVersion)).and(Validated.test((String)"metadataPattern", (String)"must be a valid regular expression", (Object)this.metadataPattern, metadataPattern -> {
            try {
                if (metadataPattern != null) {
                    Pattern.compile(metadataPattern);
                }
                return true;
            }
            catch (Throwable e) {
                return false;
            }
        })).and(Semver.validate((String)this.toVersion, (String)this.metadataPattern)).and(Validated.test((String)"localRepository", (String)"must exist", (Object)this.localRepository, File::exists)).and(Validated.test((String)"workspaceDir", (String)"must exist if set", (Object)this.workspaceDir, w -> w == null || w.exists()));
    }

    public boolean isIdempotent() {
        return false;
    }

    @Override
    public Maven visitPom(Maven.Pom pom) {
        this.versionComparator = (VersionComparator)Semver.validate((String)this.toVersion, (String)this.metadataPattern).getValue();
        return super.visitPom(pom);
    }

    @Override
    public Maven visitDependency(Maven.Dependency dependency) {
        Optional<String> newerVersion;
        Maven.Dependency d = (Maven.Dependency)this.refactor(dependency, x$0 -> super.visitDependency((Maven.Dependency)x$0));
        if (this.groupId.equals(d.getGroupId()) && (this.artifactId == null || this.artifactId.equals(d.getArtifactId())) && !Maven.getPropertyKey(d.getVersion()).isPresent() && (newerVersion = this.maybeNewerVersion(d.getModel(), d.getModel().getModuleVersion().getVersion())).isPresent()) {
            ChangeDependencyVersion changeDependencyVersion = new ChangeDependencyVersion();
            changeDependencyVersion.setGroupId(this.groupId);
            changeDependencyVersion.setArtifactId(this.artifactId);
            changeDependencyVersion.setToVersion(newerVersion.get());
            this.andThen((RefactorVisitor)changeDependencyVersion);
        }
        return d;
    }

    @Override
    public Maven visitProperty(Maven.Property property) {
        Maven.Pom pom = (Maven.Pom)this.getCursor().firstEnclosing(Maven.Pom.class);
        property.findDependencies(pom, this.groupId, this.artifactId).findAny().flatMap(dependency -> this.maybeNewerVersion((MavenModel.Dependency)dependency, property.getValue())).ifPresent(newerVersion -> this.andThen((RefactorVisitor)new ChangePropertyValue.Scoped(property, (String)newerVersion)));
        return super.visitProperty(property);
    }

    @NotNull
    private Optional<String> maybeNewerVersion(MavenModel.Dependency d, String currentVersion) {
        Maven.Pom pom = (Maven.Pom)this.getCursor().firstEnclosing(Maven.Pom.class);
        assert (pom != null);
        LatestRelease latestRelease = new LatestRelease(this.metadataPattern);
        return d.getModuleVersion().getNewerVersions(pom, this.localRepository, this.workspaceDir).stream().filter(v -> this.versionComparator.isValid(v)).filter(v -> latestRelease.compare(currentVersion, v) < 0).max((Comparator<String>)this.versionComparator);
    }
}

