/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.internal;

import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tags;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.repository.WorkspaceRepository;
import org.jetbrains.annotations.NotNull;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.HTreeMap;
import org.mapdb.Serializer;
import org.openrewrite.internal.lang.Nullable;

public class CachingWorkspaceReader
implements WorkspaceReader {
    HTreeMap<Artifact, List<String>> versionsByArtifact;
    private static final Serializer<Artifact> ARTIFACT_SERIALIZER = new Serializer<Artifact>(){

        public void serialize(@NotNull DataOutput2 out, @NotNull Artifact value) throws IOException {
            out.writeUTF(value.getGroupId());
            out.writeUTF(value.getArtifactId());
            out.writeUTF(value.getClassifier());
            out.writeUTF(value.getExtension());
            out.writeUTF(value.getVersion());
        }

        public Artifact deserialize(@NotNull DataInput2 input, int available) throws IOException {
            return new DefaultArtifact(input.readUTF(), input.readUTF(), input.readUTF(), input.readUTF(), input.readUTF());
        }
    };
    private static Serializer<List<String>> LIST_SERIALIZER = new Serializer<List<String>>(){

        public void serialize(@NotNull DataOutput2 out, @NotNull List<String> value) throws IOException {
            out.writeShort(value.size());
            for (String s : value) {
                out.writeUTF(s);
            }
        }

        public List<String> deserialize(@NotNull DataInput2 input, int available) throws IOException {
            int size = input.readShort();
            ArrayList<String> list = new ArrayList<String>(size);
            for (int i = 0; i < size; ++i) {
                list.add(input.readUTF());
            }
            return list;
        }
    };

    public CachingWorkspaceReader(@Nullable File workspace) {
        if (workspace != null) {
            DB localRepositoryDiskDb = DBMaker.fileDB((File)workspace).transactionEnable().make();
            this.versionsByArtifact = localRepositoryDiskDb.hashMap("workspace.disk").keySerializer(ARTIFACT_SERIALIZER).valueSerializer(LIST_SERIALIZER).create();
            Metrics.gaugeMapSize((String)"rewrite.maven.workspace.cache.size", (Iterable)Tags.of((String)"layer", (String)"disk"), this.versionsByArtifact);
        } else {
            DB inMemoryDb = DBMaker.heapDB().make();
            this.versionsByArtifact = inMemoryDb.hashMap("workspace.inmem").keySerializer(ARTIFACT_SERIALIZER).valueSerializer(LIST_SERIALIZER).expireAfterCreate(10L, TimeUnit.MINUTES).create();
            Metrics.gaugeMapSize((String)"rewrite.maven.workspace.cache.size", (Iterable)Tags.of((String)"layer", (String)"memory"), this.versionsByArtifact);
        }
    }

    public WorkspaceRepository getRepository() {
        return new WorkspaceRepository();
    }

    public File findArtifact(Artifact artifact) {
        return null;
    }

    public List<String> findVersions(Artifact artifact) {
        return (List)this.versionsByArtifact.getOrDefault((Object)artifact, Collections.emptyList());
    }

    public void cacheVersions(Artifact artifact, List<String> versions) {
        if (!this.versionsByArtifact.containsKey((Object)artifact)) {
            this.versionsByArtifact.put((Object)artifact, versions);
        }
    }
}

