/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.Validated;
import org.openrewrite.maven.ChangeParentVersion;
import org.openrewrite.maven.MavenRefactorVisitor;
import org.openrewrite.maven.tree.Maven;
import org.openrewrite.semver.LatestRelease;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;

public class UpgradeParentVersion
extends MavenRefactorVisitor {
    private String groupId;
    private String artifactId;
    private String toVersion;
    private VersionComparator versionComparator;

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setToVersion(String toVersion) {
        this.toVersion = toVersion;
    }

    public Validated validate() {
        return Validated.required((String)"groupId", (Object)this.groupId).and(Validated.required((String)"artifactId", (Object)this.artifactId)).and(Validated.required((String)"toVersion", (Object)this.toVersion)).and(Semver.validate((String)this.toVersion));
    }

    @Override
    public Maven visitPom(Maven.Pom pom) {
        this.versionComparator = (VersionComparator)Semver.validate((String)this.toVersion).getValue();
        return super.visitPom(pom);
    }

    @Override
    public Maven visitParent(Maven.Parent parent) {
        Maven.Parent p = (Maven.Parent)this.refactor(parent, x$0 -> super.visitParent((Maven.Parent)x$0));
        List<String> newerVersions = p.getModel().getModuleVersion().getNewerVersions();
        Optional<String> newerVersion = newerVersions.stream().filter(v -> this.versionComparator.isValid(v)).filter(v -> LatestRelease.INSTANCE.compare(parent.getModel().getModuleVersion().getVersion(), v) < 0).max((Comparator<String>)this.versionComparator);
        if (newerVersion.isPresent()) {
            ChangeParentVersion changeParentVersion = new ChangeParentVersion();
            changeParentVersion.setGroupId(this.groupId);
            changeParentVersion.setArtifactId(this.artifactId);
            changeParentVersion.setToVersion(newerVersion.get());
            this.andThen((RefactorVisitor)changeParentVersion);
        }
        return p;
    }
}

