/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.openrewrite.Formatting;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.Tree;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenRefactorVisitor;
import org.openrewrite.maven.MavenTagInsertionComparator;
import org.openrewrite.maven.tree.Maven;
import org.openrewrite.maven.tree.MavenModel;
import org.openrewrite.refactor.Formatter;
import org.openrewrite.xml.XmlParser;
import org.openrewrite.xml.tree.Xml;

public class AddDependency
extends MavenRefactorVisitor {
    private String groupId;
    private String artifactId;
    @Nullable
    private String version;
    @Nullable
    private String scope;

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setVersion(@Nullable String version) {
        this.version = version;
    }

    public void setScope(@Nullable String scope) {
        this.scope = scope;
    }

    public Validated validate() {
        return Validated.required((String)"groupId", (Object)this.groupId).and(Validated.required((String)"artifactId", (Object)this.artifactId)).and(Validated.required((String)"version", (Object)this.version));
    }

    public boolean isIdempotent() {
        return false;
    }

    @Override
    public Maven visitPom(Maven.Pom pom) {
        if (pom.getModel().getDependencies().stream().map(MavenModel.Dependency::getModuleVersion).anyMatch(mvid -> mvid.getGroupId().equals(this.groupId) && mvid.getArtifactId().equals(this.artifactId))) {
            return pom;
        }
        this.andThen((RefactorVisitor)new AddDependenciesTagIfNotPresent());
        this.andThen((RefactorVisitor)new InsertDependencyInOrder());
        return pom;
    }

    private class InsertDependencyInOrder
    extends MavenRefactorVisitor {
        private InsertDependencyInOrder() {
        }

        @Override
        public Maven visitPom(Maven.Pom pom) {
            Maven.Pom p = (Maven.Pom)this.refactor(pom, x$0 -> super.visitPom((Maven.Pom)x$0));
            ArrayList<Maven.Dependency> dependencies = new ArrayList<Maven.Dependency>(pom.getDependencies());
            Formatter.Result indent = this.formatter.findIndent(0, new Tree[]{(Tree)pom.getDocument().getRoot().getChild("dependencies").get()});
            Xml.Tag dependencyTag = ((Xml.Document)new XmlParser().parse(new String[]{"<dependency>" + indent.getPrefix(2) + "<groupId>" + AddDependency.this.groupId + "</groupId>" + indent.getPrefix(2) + "<artifactId>" + AddDependency.this.artifactId + "</artifactId>" + (AddDependency.this.version == null ? "" : indent.getPrefix(2) + "<version>" + AddDependency.this.version + "</version>") + (AddDependency.this.scope == null ? "" : indent.getPrefix(2) + "<scope>" + AddDependency.this.scope + "</scope>") + indent.getPrefix(1) + "</dependency>"}).get(0)).getRoot().withFormatting(Formatting.format((String)indent.getPrefix(1)));
            Maven.Dependency toAdd = new Maven.Dependency(false, new MavenModel.Dependency(new MavenModel.ModuleVersionId(AddDependency.this.groupId, AddDependency.this.artifactId, null, AddDependency.this.version, Collections.emptyList()), AddDependency.this.version, AddDependency.this.scope), dependencyTag);
            if (dependencies.isEmpty()) {
                dependencies.add(toAdd);
            } else {
                ArrayList<Maven.Dependency> sortedDependencies = new ArrayList<Maven.Dependency>(pom.getDependencies());
                sortedDependencies.add(toAdd);
                dependencies.sort(Comparator.comparing(d -> d.getModel().getModuleVersion()));
                int addAfterIndex = -1;
                for (int i = 0; i < sortedDependencies.size(); ++i) {
                    Maven.Dependency d2 = (Maven.Dependency)sortedDependencies.get(i);
                    if (toAdd != d2) continue;
                    addAfterIndex = i - 1;
                    break;
                }
                dependencies.add(addAfterIndex + 1, toAdd);
            }
            return p.withDependencies(dependencies);
        }
    }

    private static class AddDependenciesTagIfNotPresent
    extends MavenRefactorVisitor {
        private AddDependenciesTagIfNotPresent() {
        }

        @Override
        public Maven visitPom(Maven.Pom pom) {
            Maven.Pom p = (Maven.Pom)this.refactor(pom, x$0 -> super.visitPom((Maven.Pom)x$0));
            Xml.Tag root = p.getDocument().getRoot();
            if (!root.getChild("dependencies").isPresent()) {
                MavenTagInsertionComparator insertionComparator = new MavenTagInsertionComparator(root.getChildren());
                ArrayList<Xml.Tag> content = new ArrayList<Xml.Tag>(root.getChildren());
                Formatting fmt = Formatting.format((String)this.formatter.findIndent(0, root.getChildren().toArray(new Tree[0])).getPrefix());
                content.add(new Xml.Tag(Tree.randomId(), "dependencies", Collections.emptyList(), Collections.emptyList(), new Xml.Tag.Closing(Tree.randomId(), "dependencies", "", fmt), "", fmt));
                content.sort(insertionComparator);
                return p.withDocument(p.getDocument().withRoot(root.withContent(content)));
            }
            return p;
        }
    }
}

