/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.tree;

import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openrewrite.internal.lang.Nullable;

public class MavenModel {
    @Nullable
    private final MavenModel parent;
    private final ModuleVersionId moduleVersion;
    @Nullable
    private final DependencyManagement dependencyManagement;
    private final List<Dependency> dependencies;
    private final Map<String, Set<ModuleVersionId>> transitiveDependenciesByScope;
    private final Map<String, String> properties;
    private final Collection<MavenModel> inheriting;

    public String valueOf(String value) {
        return (value = value.trim()).startsWith("${") && value.endsWith("}") ? this.properties.get(value.substring(2, value.length() - 1)) : value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MavenModel)) {
            return false;
        }
        MavenModel other = (MavenModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ModuleVersionId this$moduleVersion = this.getModuleVersion();
        ModuleVersionId other$moduleVersion = other.getModuleVersion();
        return !(this$moduleVersion == null ? other$moduleVersion != null : !((Object)this$moduleVersion).equals(other$moduleVersion));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MavenModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ModuleVersionId $moduleVersion = this.getModuleVersion();
        result = result * 59 + ($moduleVersion == null ? 43 : ((Object)$moduleVersion).hashCode());
        return result;
    }

    @ConstructorProperties(value={"parent", "moduleVersion", "dependencyManagement", "dependencies", "transitiveDependenciesByScope", "properties", "inheriting"})
    public MavenModel(MavenModel parent, ModuleVersionId moduleVersion, DependencyManagement dependencyManagement, List<Dependency> dependencies, Map<String, Set<ModuleVersionId>> transitiveDependenciesByScope, Map<String, String> properties, Collection<MavenModel> inheriting) {
        this.parent = parent;
        this.moduleVersion = moduleVersion;
        this.dependencyManagement = dependencyManagement;
        this.dependencies = dependencies;
        this.transitiveDependenciesByScope = transitiveDependenciesByScope;
        this.properties = properties;
        this.inheriting = inheriting;
    }

    public MavenModel getParent() {
        return this.parent;
    }

    public ModuleVersionId getModuleVersion() {
        return this.moduleVersion;
    }

    public DependencyManagement getDependencyManagement() {
        return this.dependencyManagement;
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public Map<String, Set<ModuleVersionId>> getTransitiveDependenciesByScope() {
        return this.transitiveDependenciesByScope;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Collection<MavenModel> getInheriting() {
        return this.inheriting;
    }

    public String toString() {
        return "MavenModel(moduleVersion=" + this.getModuleVersion() + ", transitiveDependenciesByScope=" + this.getTransitiveDependenciesByScope() + ", inheriting=" + this.getInheriting() + ")";
    }

    public MavenModel withParent(MavenModel parent) {
        return this.parent == parent ? this : new MavenModel(parent, this.moduleVersion, this.dependencyManagement, this.dependencies, this.transitiveDependenciesByScope, this.properties, this.inheriting);
    }

    public MavenModel withModuleVersion(ModuleVersionId moduleVersion) {
        return this.moduleVersion == moduleVersion ? this : new MavenModel(this.parent, moduleVersion, this.dependencyManagement, this.dependencies, this.transitiveDependenciesByScope, this.properties, this.inheriting);
    }

    public MavenModel withDependencyManagement(DependencyManagement dependencyManagement) {
        return this.dependencyManagement == dependencyManagement ? this : new MavenModel(this.parent, this.moduleVersion, dependencyManagement, this.dependencies, this.transitiveDependenciesByScope, this.properties, this.inheriting);
    }

    public MavenModel withDependencies(List<Dependency> dependencies) {
        return this.dependencies == dependencies ? this : new MavenModel(this.parent, this.moduleVersion, this.dependencyManagement, dependencies, this.transitiveDependenciesByScope, this.properties, this.inheriting);
    }

    public MavenModel withTransitiveDependenciesByScope(Map<String, Set<ModuleVersionId>> transitiveDependenciesByScope) {
        return this.transitiveDependenciesByScope == transitiveDependenciesByScope ? this : new MavenModel(this.parent, this.moduleVersion, this.dependencyManagement, this.dependencies, transitiveDependenciesByScope, this.properties, this.inheriting);
    }

    public MavenModel withProperties(Map<String, String> properties) {
        return this.properties == properties ? this : new MavenModel(this.parent, this.moduleVersion, this.dependencyManagement, this.dependencies, this.transitiveDependenciesByScope, properties, this.inheriting);
    }

    public static class DependencyManagement {
        private final List<Dependency> dependencies;

        @ConstructorProperties(value={"dependencies"})
        public DependencyManagement(List<Dependency> dependencies) {
            this.dependencies = dependencies;
        }

        public List<Dependency> getDependencies() {
            return this.dependencies;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DependencyManagement)) {
                return false;
            }
            DependencyManagement other = (DependencyManagement)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Dependency> this$dependencies = this.getDependencies();
            List<Dependency> other$dependencies = other.getDependencies();
            return !(this$dependencies == null ? other$dependencies != null : !((Object)this$dependencies).equals(other$dependencies));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DependencyManagement;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Dependency> $dependencies = this.getDependencies();
            result = result * 59 + ($dependencies == null ? 43 : ((Object)$dependencies).hashCode());
            return result;
        }

        public String toString() {
            return "MavenModel.DependencyManagement(dependencies=" + this.getDependencies() + ")";
        }

        public DependencyManagement withDependencies(List<Dependency> dependencies) {
            return this.dependencies == dependencies ? this : new DependencyManagement(dependencies);
        }
    }

    public static class ModuleVersionId
    implements Comparable<ModuleVersionId> {
        private final String groupId;
        private final String artifactId;
        @Nullable
        private final String classifier;
        private final String version;
        private final List<String> newerVersions;

        @Override
        public int compareTo(ModuleVersionId v) {
            if (!this.groupId.equals(v.groupId)) {
                return this.comparePartByPart(this.groupId, v.groupId);
            }
            if (!this.artifactId.equals(v.artifactId)) {
                return this.comparePartByPart(this.artifactId, v.artifactId);
            }
            if (this.classifier == null && v.classifier != null) {
                return -1;
            }
            if (this.classifier != null) {
                if (v.classifier == null) {
                    return 1;
                }
                if (!this.classifier.equals(v.classifier)) {
                    return this.classifier.compareTo(v.classifier);
                }
            }
            return this.version.compareTo(v.version);
        }

        private int comparePartByPart(String d1, String d2) {
            String[] d1Parts = d1.split("[.-]");
            String[] d2Parts = d2.split("[.-]");
            for (int i = 0; i < Math.min(d1Parts.length, d2Parts.length); ++i) {
                if (d1Parts[i].equals(d2Parts[i])) continue;
                return d1Parts[i].compareTo(d2Parts[i]);
            }
            return d1Parts.length - d2Parts.length;
        }

        @ConstructorProperties(value={"groupId", "artifactId", "classifier", "version", "newerVersions"})
        public ModuleVersionId(String groupId, String artifactId, String classifier, String version, List<String> newerVersions) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.classifier = classifier;
            this.version = version;
            this.newerVersions = newerVersions;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getClassifier() {
            return this.classifier;
        }

        public String getVersion() {
            return this.version;
        }

        public List<String> getNewerVersions() {
            return this.newerVersions;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ModuleVersionId)) {
                return false;
            }
            ModuleVersionId other = (ModuleVersionId)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$groupId = this.getGroupId();
            String other$groupId = other.getGroupId();
            if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
                return false;
            }
            String this$artifactId = this.getArtifactId();
            String other$artifactId = other.getArtifactId();
            if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
                return false;
            }
            String this$classifier = this.getClassifier();
            String other$classifier = other.getClassifier();
            if (this$classifier == null ? other$classifier != null : !this$classifier.equals(other$classifier)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            return !(this$version == null ? other$version != null : !this$version.equals(other$version));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ModuleVersionId;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $groupId = this.getGroupId();
            result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
            String $artifactId = this.getArtifactId();
            result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
            String $classifier = this.getClassifier();
            result = result * 59 + ($classifier == null ? 43 : $classifier.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            return result;
        }

        public String toString() {
            return "MavenModel.ModuleVersionId(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", classifier=" + this.getClassifier() + ", version=" + this.getVersion() + ")";
        }

        public ModuleVersionId withGroupId(String groupId) {
            return this.groupId == groupId ? this : new ModuleVersionId(groupId, this.artifactId, this.classifier, this.version, this.newerVersions);
        }

        public ModuleVersionId withArtifactId(String artifactId) {
            return this.artifactId == artifactId ? this : new ModuleVersionId(this.groupId, artifactId, this.classifier, this.version, this.newerVersions);
        }

        public ModuleVersionId withClassifier(String classifier) {
            return this.classifier == classifier ? this : new ModuleVersionId(this.groupId, this.artifactId, classifier, this.version, this.newerVersions);
        }

        public ModuleVersionId withVersion(String version) {
            return this.version == version ? this : new ModuleVersionId(this.groupId, this.artifactId, this.classifier, version, this.newerVersions);
        }

        public ModuleVersionId withNewerVersions(List<String> newerVersions) {
            return this.newerVersions == newerVersions ? this : new ModuleVersionId(this.groupId, this.artifactId, this.classifier, this.version, newerVersions);
        }
    }

    public static class Dependency {
        private final ModuleVersionId moduleVersion;
        private final String requestedVersion;
        private final String scope;

        @ConstructorProperties(value={"moduleVersion", "requestedVersion", "scope"})
        public Dependency(ModuleVersionId moduleVersion, String requestedVersion, String scope) {
            this.moduleVersion = moduleVersion;
            this.requestedVersion = requestedVersion;
            this.scope = scope;
        }

        public ModuleVersionId getModuleVersion() {
            return this.moduleVersion;
        }

        public String getRequestedVersion() {
            return this.requestedVersion;
        }

        public String getScope() {
            return this.scope;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Dependency)) {
                return false;
            }
            Dependency other = (Dependency)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ModuleVersionId this$moduleVersion = this.getModuleVersion();
            ModuleVersionId other$moduleVersion = other.getModuleVersion();
            if (this$moduleVersion == null ? other$moduleVersion != null : !((Object)this$moduleVersion).equals(other$moduleVersion)) {
                return false;
            }
            String this$requestedVersion = this.getRequestedVersion();
            String other$requestedVersion = other.getRequestedVersion();
            if (this$requestedVersion == null ? other$requestedVersion != null : !this$requestedVersion.equals(other$requestedVersion)) {
                return false;
            }
            String this$scope = this.getScope();
            String other$scope = other.getScope();
            return !(this$scope == null ? other$scope != null : !this$scope.equals(other$scope));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Dependency;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ModuleVersionId $moduleVersion = this.getModuleVersion();
            result = result * 59 + ($moduleVersion == null ? 43 : ((Object)$moduleVersion).hashCode());
            String $requestedVersion = this.getRequestedVersion();
            result = result * 59 + ($requestedVersion == null ? 43 : $requestedVersion.hashCode());
            String $scope = this.getScope();
            result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
            return result;
        }

        public String toString() {
            return "MavenModel.Dependency(moduleVersion=" + this.getModuleVersion() + ", requestedVersion=" + this.getRequestedVersion() + ", scope=" + this.getScope() + ")";
        }

        public Dependency withModuleVersion(ModuleVersionId moduleVersion) {
            return this.moduleVersion == moduleVersion ? this : new Dependency(moduleVersion, this.requestedVersion, this.scope);
        }

        public Dependency withRequestedVersion(String requestedVersion) {
            return this.requestedVersion == requestedVersion ? this : new Dependency(this.moduleVersion, requestedVersion, this.scope);
        }

        public Dependency withScope(String scope) {
            return this.scope == scope ? this : new Dependency(this.moduleVersion, this.requestedVersion, scope);
        }
    }
}

