/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Comparator;
import java.util.Optional;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.ChangeDependencyVersion;
import org.openrewrite.maven.MavenRefactorVisitor;
import org.openrewrite.maven.tree.Maven;
import org.openrewrite.semver.LatestRelease;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;

public class UpgradeVersion
extends MavenRefactorVisitor {
    private String groupId;
    @Nullable
    private String artifactId;
    private String toVersion;
    private VersionComparator versionComparator;

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setArtifactId(@Nullable String artifactId) {
        this.artifactId = artifactId;
    }

    public void setToVersion(String toVersion) {
        this.toVersion = toVersion;
    }

    public Validated validate() {
        return Validated.required((String)"groupId", (Object)this.groupId).and(Validated.required((String)"toVersion", (Object)this.toVersion)).and(Semver.validate((String)this.toVersion));
    }

    public boolean isIdempotent() {
        return false;
    }

    @Override
    public Maven visitPom(Maven.Pom pom) {
        this.versionComparator = (VersionComparator)Semver.validate((String)this.toVersion).getValue();
        return super.visitPom(pom);
    }

    @Override
    public Maven visitDependency(Maven.Dependency dependency) {
        Optional<String> newerVersion;
        Maven.Dependency d = (Maven.Dependency)this.refactor(dependency, x$0 -> super.visitDependency((Maven.Dependency)x$0));
        if (this.groupId.equals(d.getGroupId()) && (this.artifactId == null || this.artifactId.equals(d.getArtifactId())) && (newerVersion = d.getModel().getModuleVersion().getNewerVersions().stream().filter(v -> this.versionComparator.isValid(v)).filter(v -> LatestRelease.INSTANCE.compare(dependency.getModel().getModuleVersion().getVersion(), v) < 0).max((Comparator<String>)this.versionComparator)).isPresent()) {
            ChangeDependencyVersion changeDependencyVersion = new ChangeDependencyVersion();
            changeDependencyVersion.setGroupId(this.groupId);
            changeDependencyVersion.setArtifactId(this.artifactId);
            changeDependencyVersion.setToVersion(newerVersion.get());
            this.andThen((RefactorVisitor)changeDependencyVersion);
        }
        return d;
    }
}

