/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.DefaultModelBuilder;
import org.apache.maven.model.building.DefaultModelBuilderFactory;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingResult;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.building.ModelSource2;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.model.superpom.DefaultSuperPomProvider;
import org.apache.maven.model.superpom.SuperPomProvider;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.AbstractRepositoryListener;
import org.eclipse.aether.DefaultRepositoryCache;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryCache;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.Exclusion;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.resolution.ArtifactDescriptorPolicy;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.util.repository.SimpleArtifactDescriptorPolicy;
import org.eclipse.aether.version.Version;
import org.openrewrite.Parser;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.internal.CachingWorkspaceReader;
import org.openrewrite.maven.internal.ParentModelResolver;
import org.openrewrite.maven.tree.Maven;
import org.openrewrite.maven.tree.MavenModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MavenModuleLoader {
    private static final Logger logger = LoggerFactory.getLogger(MavenModuleLoader.class);
    private final Map<MavenModel.ModuleVersionId, MavenModel.Dependency> dependencyCache = new HashMap<MavenModel.ModuleVersionId, MavenModel.Dependency>();
    private final CachingWorkspaceReader workspaceReader;
    private final boolean resolveDependencies;
    private final File localRepository;
    private final List<RemoteRepository> remoteRepositories;

    public MavenModuleLoader(boolean resolveDependencies, File localRepository, @Nullable File workspaceDir, List<RemoteRepository> remoteRepositories) {
        this.resolveDependencies = resolveDependencies;
        this.localRepository = localRepository;
        this.remoteRepositories = remoteRepositories;
        this.workspaceReader = new CachingWorkspaceReader(workspaceDir);
    }

    public List<MavenModel> load(Iterable<Parser.Input> inputs) {
        return this.load(InputStreamModelSource.fromInputs(inputs));
    }

    private List<MavenModel> load(Collection<InputStreamModelSource> modelSources) {
        ArrayList<MavenModel> models = new ArrayList<MavenModel>();
        HashMap<MavenModel.ModuleVersionId, Collection> inheriting = new HashMap<MavenModel.ModuleVersionId, Collection>();
        for (InputStreamModelSource modelSource : modelSources) {
            MavenModel model = this.load(modelSource);
            models.add(model);
            MavenModel descendent = model;
            for (MavenModel ancestor = model.getParent(); ancestor != null; ancestor = ancestor.getParent()) {
                inheriting.computeIfAbsent(ancestor.getModuleVersion(), m -> new ArrayList()).add(descendent.withParent(null));
                descendent = ancestor;
            }
        }
        return models.stream().map(m -> new MavenModel(m.getParent(), m.getModuleVersion(), m.getDependencyManagement(), m.getDependencies(), m.getTransitiveDependenciesByScope(), m.getProperties(), inheriting.getOrDefault(m.getModuleVersion(), Collections.emptyList()))).collect(Collectors.toList());
    }

    private MavenModel load(InputStreamModelSource modelSource) {
        try {
            RepositorySystem repositorySystem = this.getRepositorySystem();
            DefaultRepositorySystemSession repositorySystemSession = this.getRepositorySystemSession(repositorySystem);
            DefaultModelBuildingRequest modelBuildingRequest = new DefaultModelBuildingRequest().setModelResolver((ModelResolver)new ParentModelResolver(repositorySystem, (RepositorySystemSession)repositorySystemSession, this.remoteRepositories)).setModelSource((ModelSource)modelSource);
            DefaultModelBuilder modelBuilder = new DefaultModelBuilderFactory(){

                protected SuperPomProvider newSuperPomProvider() {
                    NoMavenCentralSuperPomProvider superPomProvider = new NoMavenCentralSuperPomProvider();
                    superPomProvider.setModelProcessor(this.newModelProcessor());
                    return superPomProvider;
                }
            }.newInstance();
            ModelBuildingResult modelBuildingResult = modelBuilder.build((ModelBuildingRequest)modelBuildingRequest);
            return this.buildMavenModelRecursive(repositorySystem, (RepositorySystemSession)repositorySystemSession, modelBuildingResult, modelBuildingResult.getEffectiveModel());
        }
        catch (ModelBuildingException e) {
            throw new RuntimeException(e);
        }
    }

    private MavenModel buildMavenModelRecursive(RepositorySystem repositorySystem, RepositorySystemSession repositorySystemSession, ModelBuildingResult result, Model model) {
        MavenModel parent = null;
        if (model.getParent() != null) {
            Model rawParentModel = result.getRawModel(model.getParent().getId().replace(":pom", ""));
            if (rawParentModel.getGroupId() == null) {
                rawParentModel.setGroupId(model.getParent().getGroupId());
            }
            if (rawParentModel.getVersion() == null) {
                rawParentModel.setVersion(model.getParent().getVersion());
            }
            parent = this.buildMavenModelRecursive(repositorySystem, repositorySystemSession, result, rawParentModel);
        }
        Model rawModel = result.getRawModel(model.getGroupId() + ":" + model.getArtifactId() + ":" + model.getVersion());
        HashMap<String, Set<MavenModel.ModuleVersionId>> transitiveDepenenciesByScope = new HashMap<String, Set<MavenModel.ModuleVersionId>>();
        List<MavenModel.Dependency> dependencies = model.getDependencies().stream().map(dependency -> this.resolveDependency(repositorySystem, repositorySystemSession, (Dependency)dependency, model, rawModel, (Map<String, Set<MavenModel.ModuleVersionId>>)transitiveDepenenciesByScope)).collect(Collectors.toList());
        MavenModel.DependencyManagement dependencyManagement = model.getDependencyManagement() == null ? null : new MavenModel.DependencyManagement(model.getDependencyManagement().getDependencies().stream().map(dependency -> this.resolveDependency(repositorySystem, repositorySystemSession, (Dependency)dependency, model, rawModel, (Map<String, Set<MavenModel.ModuleVersionId>>)transitiveDepenenciesByScope)).collect(Collectors.toList()));
        Map<String, String> properties = model.getProperties().entrySet().stream().collect(Collectors.toMap(e -> e.getKey().toString(), e -> e.getValue().toString()));
        return new MavenModel(parent, new MavenModel.ModuleVersionId(model.getGroupId(), model.getArtifactId(), null, model.getVersion(), this.newerVersions(repositorySystem, repositorySystemSession, model, model.getGroupId(), model.getArtifactId(), model.getVersion(), "", "pom")), dependencyManagement, dependencies, transitiveDepenenciesByScope, properties, Collections.emptyList());
    }

    private List<String> newerVersions(RepositorySystem repositorySystem, RepositorySystemSession repositorySystemSession, Model model, String groupId, String artifactId, String version, String classifier, String extension) {
        DefaultArtifact newerArtifacts = new DefaultArtifact(groupId, artifactId, classifier, extension, "(" + version + ",)");
        VersionRangeRequest newerArtifactsRequest = new VersionRangeRequest();
        newerArtifactsRequest.setArtifact((Artifact)newerArtifacts);
        newerArtifactsRequest.setRepositories(this.remoteRepositoriesFromModel(model));
        try {
            VersionRangeResult newerArtifactsResult = repositorySystem.resolveVersionRange(repositorySystemSession, newerArtifactsRequest);
            List<String> versions = newerArtifactsResult.getVersions().stream().map(Version::toString).collect(Collectors.toList());
            this.workspaceReader.cacheVersions((Artifact)newerArtifacts, versions);
            return versions;
        }
        catch (VersionRangeResolutionException e) {
            return Collections.emptyList();
        }
    }

    private List<RemoteRepository> remoteRepositoriesFromModel(Model model) {
        ArrayList<RemoteRepository> remotes = new ArrayList<RemoteRepository>(this.remoteRepositories);
        model.getRepositories().forEach(repo -> remotes.add(new RemoteRepository.Builder(repo.getId(), "default", repo.getUrl().replace("http:", "https:")).build()));
        return remotes;
    }

    private MavenModel.Dependency resolveDependency(RepositorySystem repositorySystem, RepositorySystemSession repositorySystemSession, Dependency dependency, Model model, Model rawModel, Map<String, Set<MavenModel.ModuleVersionId>> transitiveDepenenciesByScope) {
        MavenModel.ModuleVersionId mvidFromDependency = new MavenModel.ModuleVersionId(dependency.getGroupId(), dependency.getArtifactId(), dependency.getClassifier(), dependency.getVersion(), Collections.emptyList());
        return this.dependencyCache.computeIfAbsent(mvidFromDependency, mvid -> {
            String requestedVersion = dependency.getVersion();
            if (rawModel != null) {
                requestedVersion = rawModel.getDependencies().stream().filter(d -> d.getGroupId().equals(dependency.getGroupId()) && d.getArtifactId().equals(dependency.getArtifactId()) && (d.getScope() == null || d.getScope().equals(dependency.getScope()))).map(Dependency::getVersion).filter(Objects::nonNull).findAny().orElse(dependency.getVersion());
                if (this.resolveDependencies) {
                    Artifact artifact = this.collectIfNecessary(repositorySystem, repositorySystemSession, model, dependency, transitiveDepenenciesByScope);
                    return new MavenModel.Dependency(new MavenModel.ModuleVersionId(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getVersion(), this.newerVersions(repositorySystem, repositorySystemSession, model, artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getClassifier(), artifact.getExtension())), requestedVersion, dependency.getScope());
                }
            }
            return new MavenModel.Dependency((MavenModel.ModuleVersionId)mvid, requestedVersion, dependency.getScope());
        });
    }

    private Artifact collectIfNecessary(RepositorySystem repositorySystem, RepositorySystemSession repositorySystemSession, Model model, Dependency dependency, Map<String, Set<MavenModel.ModuleVersionId>> transitiveDepenenciesByScope) {
        DefaultArtifact artifact = new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getClassifier(), dependency.getType(), Maven.getPropertyKey(dependency.getVersion()).map(versionProperty -> (String)model.getProperties().get(versionProperty)).orElse(dependency.getVersion()));
        if (this.resolveDependencies) {
            try {
                CollectRequest collectRequest = new CollectRequest();
                collectRequest.setRepositories(this.remoteRepositoriesFromModel(model));
                collectRequest.addDependency(new org.eclipse.aether.graph.Dependency((Artifact)artifact, dependency.getScope(), Boolean.valueOf(dependency.getOptional() != null && dependency.getOptional().equals("true")), (Collection)dependency.getExclusions().stream().map(exclusion -> new Exclusion(exclusion.getGroupId(), exclusion.getArtifactId(), null, null)).collect(Collectors.toList())));
                CollectResult collectResult = repositorySystem.collectDependencies(repositorySystemSession, collectRequest);
                DependencyNode dependencyNode = (DependencyNode)collectResult.getRoot().getChildren().iterator().next();
                artifact = dependencyNode.getArtifact();
                this.collectTransitiveDependencies(dependencyNode, transitiveDepenenciesByScope);
                logger.debug("artifact {} resolved to {}", (Object)artifact, (Object)artifact.getFile());
            }
            catch (DependencyCollectionException e) {
                logger.warn("error collecting dependencies", (Throwable)e);
            }
        }
        return artifact;
    }

    public void collectTransitiveDependencies(DependencyNode node, Map<String, Set<MavenModel.ModuleVersionId>> transitiveDepenenciesByScope) {
        Artifact dep = node.getDependency().getArtifact();
        transitiveDepenenciesByScope.computeIfAbsent(node.getDependency().getScope(), scope -> new HashSet()).add(new MavenModel.ModuleVersionId(dep.getGroupId(), dep.getArtifactId(), dep.getClassifier(), dep.getVersion(), Collections.emptyList()));
        node.getChildren().forEach(child -> this.collectTransitiveDependencies((DependencyNode)child, transitiveDepenenciesByScope));
    }

    private RepositorySystem getRepositorySystem() {
        DefaultServiceLocator serviceLocator = MavenRepositorySystemUtils.newServiceLocator();
        serviceLocator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        serviceLocator.addService(TransporterFactory.class, FileTransporterFactory.class);
        serviceLocator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        return (RepositorySystem)serviceLocator.getService(RepositorySystem.class);
    }

    private DefaultRepositorySystemSession getRepositorySystemSession(RepositorySystem system) {
        DefaultRepositorySystemSession repositorySystemSession = MavenRepositorySystemUtils.newSession();
        LocalRepository localRepository = new LocalRepository(this.localRepository.getPath());
        repositorySystemSession.setLocalRepositoryManager(system.newLocalRepositoryManager((RepositorySystemSession)repositorySystemSession, localRepository));
        repositorySystemSession.setChecksumPolicy("ignore");
        repositorySystemSession.setCache((RepositoryCache)new DefaultRepositoryCache());
        repositorySystemSession.setArtifactDescriptorPolicy((ArtifactDescriptorPolicy)new SimpleArtifactDescriptorPolicy(3));
        repositorySystemSession.setWorkspaceReader((WorkspaceReader)this.workspaceReader);
        repositorySystemSession.setRepositoryListener((RepositoryListener)new ConsoleRepositoryEventListener());
        repositorySystemSession.setReadOnly();
        return repositorySystemSession;
    }

    private static class NoMavenCentralSuperPomProvider
    extends DefaultSuperPomProvider {
        private NoMavenCentralSuperPomProvider() {
        }

        public Model getSuperModel(String version) {
            Model superModel = super.getSuperModel(version);
            superModel.getRepositories().clear();
            return superModel;
        }
    }

    static class InputStreamModelSource
    implements ModelSource2 {
        private final Path path;
        private final Supplier<InputStream> inputStream;
        private Map<Path, InputStreamModelSource> allModelSources;

        public InputStreamModelSource(Path path, Supplier<InputStream> inputStream) {
            this.path = path;
            this.inputStream = inputStream;
        }

        public ModelSource2 getRelatedSource(String relPath) {
            return this.allModelSources.get(this.path.getParent().resolve(relPath).normalize());
        }

        public URI getLocationURI() {
            return this.path.toUri();
        }

        public InputStream getInputStream() {
            return this.inputStream.get();
        }

        public String getLocation() {
            return this.path.toString();
        }

        public static Collection<InputStreamModelSource> fromInputs(Iterable<Parser.Input> inputs) {
            Map modelSources = StreamSupport.stream(inputs.spliterator(), false).map(input -> new InputStreamModelSource(input.getPath(), () -> ((Parser.Input)input).getSource())).collect(Collectors.toMap(modelSource -> modelSource.path, Function.identity(), (s1, s2) -> s1, LinkedHashMap::new));
            modelSources.values().forEach(modelSource -> {
                modelSource.allModelSources = modelSources;
            });
            return modelSources.values();
        }
    }

    private static class ConsoleRepositoryEventListener
    extends AbstractRepositoryListener {
        private ConsoleRepositoryEventListener() {
        }

        public void artifactInstalled(RepositoryEvent event) {
            logger.debug("artifact {} installed to file {}", (Object)event.getArtifact(), (Object)event.getFile());
        }

        public void artifactInstalling(RepositoryEvent event) {
            logger.debug("installing artifact {} to file {}", (Object)event.getArtifact(), (Object)event.getFile());
        }

        public void artifactResolved(RepositoryEvent event) {
            logger.debug("artifact {} resolved from repository {}", (Object)event.getArtifact(), (Object)event.getRepository());
        }

        public void artifactDownloading(RepositoryEvent event) {
            logger.debug("downloading artifact {} from repository {}", (Object)event.getArtifact(), (Object)event.getRepository());
        }

        public void artifactDownloaded(RepositoryEvent event) {
            logger.debug("downloaded artifact {} from repository {}", (Object)event.getArtifact(), (Object)event.getRepository());
        }

        public void artifactResolving(RepositoryEvent event) {
            logger.debug("resolving artifact {}", (Object)event.getArtifact());
        }
    }
}

