/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.json;

import java.nio.file.Path;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.json.AddKeyValue;
import org.openrewrite.json.JsonIsoVisitor;
import org.openrewrite.json.JsonPathMatcher;
import org.openrewrite.json.tree.Json;

public final class CopyValue
extends ScanningRecipe<Accumulator> {
    @Option(displayName="Source key path", description="A [JSONPath](https://www.rfc-editor.org/rfc/rfc9535.html) expression to locate a JSON value to copy.", example="$.source.kind")
    private final String sourceKeyPath;
    @Option(displayName="Source file path", description="The file path to the JSON file to copy the value from. If `null` then the value will be copied from any JSON file it appears within.", example="src/main/resources/application.json", required=false)
    private final @Nullable String sourceFilePath;
    @Option(displayName="Destination key path", description="A [JSONPath](https://www.rfc-editor.org/rfc/rfc9535.html) expression to locate the *parent* JSON entry.", example="'$.subjects.*' or '$.' or '$.x[1].y.*' etc.")
    private final String destinationKeyPath;
    @Option(displayName="Destination key", description="The key to create.", example="myKey")
    private final String destinationKey;
    @Option(displayName="Destination file path", description="The file path to the JSON file to copy the value to. If `null` then the value will be copied only into the same file it was found in.", example="src/main/resources/application.json", required=false)
    private final @Nullable String destinationFilePath;

    public String getDisplayName() {
        return "Copy JSON value";
    }

    public String getInstanceNameSuffix() {
        return String.format("%s`%s` to %s`%s`", this.sourceFilePath == null ? "" : this.sourceFilePath + ":", this.sourceKeyPath, this.destinationFilePath == null ? "" : this.destinationFilePath + ":", this.destinationKeyPath);
    }

    public String getDescription() {
        return "Copies a JSON value from one key to another. The existing key/value pair remains unaffected by this change. Attempts to create the new key if it does not exist.";
    }

    public Accumulator getInitialValue(ExecutionContext ctx) {
        return new Accumulator();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Accumulator acc) {
        JsonIsoVisitor<ExecutionContext> visitor = new JsonIsoVisitor<ExecutionContext>(){
            final JsonPathMatcher sourcePathMatcher;
            {
                this.sourcePathMatcher = new JsonPathMatcher(CopyValue.this.sourceKeyPath);
            }

            @Override
            public Json.Document visitDocument(Json.Document document, ExecutionContext ctx) {
                if (acc.snippet == null) {
                    return super.visitDocument(document, ctx);
                }
                return document;
            }

            @Override
            public Json.Member visitMember(Json.Member member, ExecutionContext ctx) {
                Json source = super.visitMember(member, ctx);
                if (this.sourcePathMatcher.matches(this.getCursor())) {
                    acc.snippet = member.getValue().print(this.getCursor());
                    acc.path = ((SourceFile)this.getCursor().firstEnclosingOrThrow(SourceFile.class)).getSourcePath();
                }
                return source;
            }
        };
        if (this.sourceFilePath == null) {
            return visitor;
        }
        return Preconditions.check((Recipe)new FindSourceFiles(this.sourceFilePath), (TreeVisitor)visitor);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(Accumulator acc) {
        if (acc.snippet == null) {
            return TreeVisitor.noop();
        }
        return Preconditions.check((Recipe)new FindSourceFiles(this.destinationFilePath == null ? acc.path.toString() : this.destinationFilePath), new AddKeyValue(this.destinationKeyPath, this.destinationKey, acc.snippet, false).getVisitor());
    }

    @Generated
    public CopyValue(String sourceKeyPath, @Nullable String sourceFilePath, String destinationKeyPath, String destinationKey, @Nullable String destinationFilePath) {
        this.sourceKeyPath = sourceKeyPath;
        this.sourceFilePath = sourceFilePath;
        this.destinationKeyPath = destinationKeyPath;
        this.destinationKey = destinationKey;
        this.destinationFilePath = destinationFilePath;
    }

    @Generated
    public String getSourceKeyPath() {
        return this.sourceKeyPath;
    }

    @Generated
    public @Nullable String getSourceFilePath() {
        return this.sourceFilePath;
    }

    @Generated
    public String getDestinationKeyPath() {
        return this.destinationKeyPath;
    }

    @Generated
    public String getDestinationKey() {
        return this.destinationKey;
    }

    @Generated
    public @Nullable String getDestinationFilePath() {
        return this.destinationFilePath;
    }

    @NonNull
    @Generated
    public String toString() {
        return "CopyValue(sourceKeyPath=" + this.getSourceKeyPath() + ", sourceFilePath=" + this.getSourceFilePath() + ", destinationKeyPath=" + this.getDestinationKeyPath() + ", destinationKey=" + this.getDestinationKey() + ", destinationFilePath=" + this.getDestinationFilePath() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CopyValue)) {
            return false;
        }
        CopyValue other = (CopyValue)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$sourceKeyPath = this.getSourceKeyPath();
        String other$sourceKeyPath = other.getSourceKeyPath();
        if (this$sourceKeyPath == null ? other$sourceKeyPath != null : !this$sourceKeyPath.equals(other$sourceKeyPath)) {
            return false;
        }
        String this$sourceFilePath = this.getSourceFilePath();
        String other$sourceFilePath = other.getSourceFilePath();
        if (this$sourceFilePath == null ? other$sourceFilePath != null : !this$sourceFilePath.equals(other$sourceFilePath)) {
            return false;
        }
        String this$destinationKeyPath = this.getDestinationKeyPath();
        String other$destinationKeyPath = other.getDestinationKeyPath();
        if (this$destinationKeyPath == null ? other$destinationKeyPath != null : !this$destinationKeyPath.equals(other$destinationKeyPath)) {
            return false;
        }
        String this$destinationKey = this.getDestinationKey();
        String other$destinationKey = other.getDestinationKey();
        if (this$destinationKey == null ? other$destinationKey != null : !this$destinationKey.equals(other$destinationKey)) {
            return false;
        }
        String this$destinationFilePath = this.getDestinationFilePath();
        String other$destinationFilePath = other.getDestinationFilePath();
        return !(this$destinationFilePath == null ? other$destinationFilePath != null : !this$destinationFilePath.equals(other$destinationFilePath));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof CopyValue;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $sourceKeyPath = this.getSourceKeyPath();
        result = result * 59 + ($sourceKeyPath == null ? 43 : $sourceKeyPath.hashCode());
        String $sourceFilePath = this.getSourceFilePath();
        result = result * 59 + ($sourceFilePath == null ? 43 : $sourceFilePath.hashCode());
        String $destinationKeyPath = this.getDestinationKeyPath();
        result = result * 59 + ($destinationKeyPath == null ? 43 : $destinationKeyPath.hashCode());
        String $destinationKey = this.getDestinationKey();
        result = result * 59 + ($destinationKey == null ? 43 : $destinationKey.hashCode());
        String $destinationFilePath = this.getDestinationFilePath();
        result = result * 59 + ($destinationFilePath == null ? 43 : $destinationFilePath.hashCode());
        return result;
    }

    public static class Accumulator {
        @Nullable String snippet;
        Path path;

        @Generated
        public Accumulator() {
        }

        @Generated
        public @Nullable String getSnippet() {
            return this.snippet;
        }

        @Generated
        public Path getPath() {
            return this.path;
        }

        @Generated
        public void setSnippet(@Nullable String snippet) {
            this.snippet = snippet;
        }

        @Generated
        public void setPath(Path path) {
            this.path = path;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Accumulator)) {
                return false;
            }
            Accumulator other = (Accumulator)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$snippet = this.getSnippet();
            String other$snippet = other.getSnippet();
            if (this$snippet == null ? other$snippet != null : !this$snippet.equals(other$snippet)) {
                return false;
            }
            Path this$path = this.getPath();
            Path other$path = other.getPath();
            return !(this$path == null ? other$path != null : !((Object)this$path).equals(other$path));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof Accumulator;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $snippet = this.getSnippet();
            result = result * 59 + ($snippet == null ? 43 : $snippet.hashCode());
            Path $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : ((Object)$path).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "CopyValue.Accumulator(snippet=" + this.getSnippet() + ", path=" + this.getPath() + ")";
        }
    }
}

