/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.json.style;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.json.JsonVisitor;
import org.openrewrite.json.style.TabsAndIndentsStyle;
import org.openrewrite.json.style.WrappingAndBracesStyle;
import org.openrewrite.json.tree.Json;
import org.openrewrite.json.tree.JsonValue;
import org.openrewrite.style.GeneralFormatStyle;
import org.openrewrite.style.LineWrapSetting;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.style.Style;

public class Autodetect
extends NamedStyles {
    @JsonCreator
    public Autodetect(UUID id, Collection<Style> styles) {
        super(id, "org.openrewrite.json.Autodetect", "Auto-detected", "Automatically detect styles from a repository's existing code.", Collections.emptySet(), styles);
    }

    public static Detector detector() {
        return new Detector();
    }

    public static class Detector {
        private final IndentStatistics indentStatistics = new IndentStatistics();
        private final GeneralFormatStatistics generalFormatStatistics = new GeneralFormatStatistics();
        private final WrappingStatistics wrappingStatistics = new WrappingStatistics();
        private final FindIndentJsonVisitor findIndentVisitor = new FindIndentJsonVisitor();
        private final FindLineFormatJsonVisitor findLineFormatVisitor = new FindLineFormatJsonVisitor();
        private final ClassifyWrappingJsonVisitor classifyWrappingVisitor = new ClassifyWrappingJsonVisitor();

        public Detector sample(SourceFile json) {
            if (json instanceof Json.Document) {
                this.findIndentVisitor.visit((Tree)json, this.indentStatistics);
                this.findLineFormatVisitor.visit((Tree)json, this.generalFormatStatistics);
                this.classifyWrappingVisitor.visit((Tree)json, this.wrappingStatistics);
            }
            return this;
        }

        public Autodetect build() {
            return new Autodetect(Tree.randomId(), Arrays.asList(this.indentStatistics.getTabsAndIndentsStyle(), this.generalFormatStatistics.getFormatStyle(), this.wrappingStatistics.getWrappingAndBracesStyle()));
        }
    }

    private static class ClassifyWrappingJsonVisitor
    extends JsonVisitor<WrappingStatistics> {
        private ClassifyWrappingJsonVisitor() {
        }

        @Override
        public Json visitArray(Json.Array array, WrappingStatistics wrappingStatistics) {
            for (JsonValue value : array.getValues()) {
                boolean isWrapped = value.getPrefix().getWhitespace().contains("\n");
                ((AtomicInteger)wrappingStatistics.arraysWrapped.get(isWrapped)).incrementAndGet();
            }
            return super.visitArray(array, wrappingStatistics);
        }

        @Override
        public Json visitObject(Json.JsonObject obj, WrappingStatistics wrappingStatistics) {
            for (Json member : obj.getMembers()) {
                boolean isWrapped = member.getPrefix().getWhitespace().contains("\n");
                ((AtomicInteger)wrappingStatistics.objectsWrapped.get(isWrapped)).incrementAndGet();
            }
            return super.visitObject(obj, wrappingStatistics);
        }
    }

    private static class FindIndentJsonVisitor
    extends JsonVisitor<IndentStatistics> {
        private FindIndentJsonVisitor() {
        }

        @Override
        public Json visitMember(Json.Member member, IndentStatistics stats) {
            this.measureFrequencies(member.getPrefix().getWhitespace(), stats.indentFrequencies);
            return super.visitMember(member, stats);
        }

        private void measureFrequencies(String prefix, IndentFrequencies frequencies) {
            AtomicBoolean takeWhile = new AtomicBoolean(true);
            if (prefix.chars().filter(c -> {
                takeWhile.set(takeWhile.get() && (c == 10 || c == 13));
                return takeWhile.get();
            }).count() > 0L) {
                char[] chars;
                int tabIndent = 0;
                int spaceIndent = 0;
                boolean mixed = false;
                for (char c2 : chars = prefix.toCharArray()) {
                    if (c2 == '\n' || c2 == '\r') {
                        tabIndent = 0;
                        spaceIndent = 0;
                        mixed = false;
                        continue;
                    }
                    if (mixed) continue;
                    if (c2 == ' ') {
                        if (tabIndent > 0) {
                            tabIndent = 0;
                            spaceIndent = 0;
                            mixed = true;
                            continue;
                        }
                        ++spaceIndent;
                        continue;
                    }
                    if (!Character.isWhitespace(c2)) continue;
                    if (spaceIndent > 0) {
                        tabIndent = 0;
                        spaceIndent = 0;
                        break;
                    }
                    ++tabIndent;
                }
                frequencies.spaceIndentFrequencies.merge(spaceIndent, 1L, Long::sum);
                frequencies.tabIndentFrequencies.merge(tabIndent, 1L, Long::sum);
                AtomicBoolean dropWhile = new AtomicBoolean(false);
                takeWhile.set(true);
                Map indentTypeCounts = prefix.chars().filter(c -> {
                    dropWhile.set(dropWhile.get() || c != 10 && c != 13);
                    return dropWhile.get();
                }).filter(c -> {
                    takeWhile.set(takeWhile.get() && Character.isWhitespace(c));
                    return takeWhile.get();
                }).mapToObj(c -> c == 32).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
                if (indentTypeCounts.getOrDefault(true, 0L) >= indentTypeCounts.getOrDefault(false, 0L)) {
                    frequencies.linesWithSpaceIndents++;
                } else {
                    frequencies.linesWithTabIndents++;
                }
            }
        }
    }

    private static class FindLineFormatJsonVisitor
    extends JsonVisitor<GeneralFormatStatistics> {
        private FindLineFormatJsonVisitor() {
        }

        public @Nullable Json visit(@Nullable Tree tree, GeneralFormatStatistics stats) {
            if (tree instanceof Json) {
                String prefix = ((Json)tree).getPrefix().getWhitespace();
                char[] chars = prefix.toCharArray();
                for (int i = 0; i < chars.length; ++i) {
                    char c = chars[i];
                    if (c != '\n' && c != '\r' || c != '\n') continue;
                    if (i == 0 || chars[i - 1] != '\r') {
                        stats.linesWithLFNewLines++;
                        continue;
                    }
                    stats.linesWithCRLFNewLines++;
                }
            }
            return (Json)super.visit(tree, (Object)stats);
        }
    }

    private static class IndentFrequencies {
        private final Map<Integer, Long> spaceIndentFrequencies = new HashMap<Integer, Long>();
        private final Map<Integer, Long> tabIndentFrequencies = new HashMap<Integer, Long>();
        private int linesWithSpaceIndents = 0;
        private int linesWithTabIndents = 0;

        private IndentFrequencies() {
        }

        public boolean isIndentedWithSpaces() {
            return this.linesWithSpaceIndents >= this.linesWithTabIndents;
        }

        private TabsAndIndentsStyle getTabsAndIndentsStyle() {
            boolean useTabs = !this.isIndentedWithSpaces();
            int indent = TabsAndIndentsStyle.DEFAULT.getIndentSize();
            long indentCount = 0L;
            Map<Integer, Long> indentFrequencies = useTabs ? this.tabIndentFrequencies : this.spaceIndentFrequencies;
            for (Map.Entry<Integer, Long> current : indentFrequencies.entrySet()) {
                if (current.getKey() == 0) continue;
                long currentCount = 0L;
                for (Map.Entry<Integer, Long> candidate : indentFrequencies.entrySet()) {
                    if (candidate.getKey() == 0 || candidate.getKey() % current.getKey() != 0) continue;
                    currentCount += candidate.getValue().longValue();
                }
                if (currentCount > indentCount) {
                    indent = current.getKey();
                    indentCount = currentCount;
                    continue;
                }
                if (currentCount != indentCount) continue;
                indent = Math.min(indent, current.getKey());
            }
            return new TabsAndIndentsStyle(useTabs, useTabs ? indent : 1, useTabs ? 1 : indent);
        }
    }

    private static class WrappingStatistics {
        private Map<Boolean, AtomicInteger> arraysWrapped = new HashMap<Boolean, AtomicInteger>();
        private Map<Boolean, AtomicInteger> objectsWrapped = new HashMap<Boolean, AtomicInteger>();

        private WrappingStatistics() {
            this.arraysWrapped.put(Boolean.FALSE, new AtomicInteger());
            this.arraysWrapped.put(Boolean.TRUE, new AtomicInteger());
            this.objectsWrapped.put(Boolean.FALSE, new AtomicInteger());
            this.objectsWrapped.put(Boolean.TRUE, new AtomicInteger());
        }

        private WrappingAndBracesStyle getWrappingAndBracesStyle() {
            return new WrappingAndBracesStyle(this.objectsWrapped.get(Boolean.TRUE).get() >= this.objectsWrapped.get(Boolean.FALSE).get() ? LineWrapSetting.WrapAlways : LineWrapSetting.DoNotWrap, this.arraysWrapped.get(Boolean.TRUE).get() >= this.arraysWrapped.get(Boolean.FALSE).get() ? LineWrapSetting.WrapAlways : LineWrapSetting.DoNotWrap);
        }
    }

    private static class GeneralFormatStatistics {
        private int linesWithCRLFNewLines = 0;
        private int linesWithLFNewLines = 0;

        private GeneralFormatStatistics() {
        }

        public boolean isIndentedWithLFNewLines() {
            return this.linesWithLFNewLines >= this.linesWithCRLFNewLines;
        }

        public GeneralFormatStyle getFormatStyle() {
            boolean useCRLF = !this.isIndentedWithLFNewLines();
            return new GeneralFormatStyle(useCRLF);
        }
    }

    private static class IndentStatistics {
        IndentFrequencies indentFrequencies = new IndentFrequencies();

        private IndentStatistics() {
        }

        public TabsAndIndentsStyle getTabsAndIndentsStyle() {
            return this.indentFrequencies.getTabsAndIndentsStyle();
        }
    }
}

