/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.json.format;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.TreeVisitor;
import org.openrewrite.json.JsonIsoVisitor;
import org.openrewrite.json.format.TabsAndIndentsVisitor;
import org.openrewrite.json.style.Autodetect;
import org.openrewrite.json.style.TabsAndIndentsStyle;
import org.openrewrite.json.tree.Json;
import org.openrewrite.style.Style;

public class Indents
extends Recipe {
    public String getDisplayName() {
        return "JSON indent";
    }

    public String getDescription() {
        return "Format tabs and indents in JSON.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TabsAndIndentsFromCompilationUnitStyle();
    }

    private static class TabsAndIndentsFromCompilationUnitStyle
    extends JsonIsoVisitor<ExecutionContext> {
        private TabsAndIndentsFromCompilationUnitStyle() {
        }

        @Override
        public Json.Document visitDocument(Json.Document docs, ExecutionContext ctx) {
            TabsAndIndentsStyle style = (TabsAndIndentsStyle)Style.from(TabsAndIndentsStyle.class, (SourceFile)docs, () -> (TabsAndIndentsStyle)Autodetect.detector().sample(docs).build().getStyle(TabsAndIndentsStyle.class));
            this.doAfterVisit(new TabsAndIndentsVisitor(style, null));
            return docs;
        }
    }
}

