/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.json.tree;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import lombok.Generated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.json.tree.Json;
import org.openrewrite.json.tree.Space;
import org.openrewrite.marker.Markers;

public class JsonRightPadded<T extends Json> {
    private final T element;
    private final Space after;
    private final Markers markers;

    public JsonRightPadded<T> map(UnaryOperator<T> map) {
        return this.withElement((Json)map.apply(this.element));
    }

    public static <T extends Json> List<T> getElements(List<JsonRightPadded<T>> ls) {
        ArrayList<T> list = new ArrayList<T>();
        for (JsonRightPadded<T> l : ls) {
            T elem = l.getElement();
            list.add(elem);
        }
        return list;
    }

    public static <J2 extends Json> List<JsonRightPadded<J2>> withElements(List<JsonRightPadded<J2>> before, List<J2> elements) {
        if (elements.size() == before.size()) {
            boolean hasChanges = false;
            for (int i = 0; i < before.size(); ++i) {
                if (before.get(i).getElement() == elements.get(i)) continue;
                hasChanges = true;
                break;
            }
            if (!hasChanges) {
                return before;
            }
        }
        ArrayList<JsonRightPadded<J2>> after = new ArrayList<JsonRightPadded<J2>>(elements.size());
        Map beforeById = before.stream().collect(Collectors.toMap(j -> j.getElement().getId(), Function.identity()));
        for (Json t : elements) {
            if (beforeById.get(t.getId()) != null) {
                JsonRightPadded found = (JsonRightPadded)beforeById.get(t.getId());
                after.add(found.withElement(t));
                continue;
            }
            after.add(new JsonRightPadded<Json>(t, Space.EMPTY, Markers.EMPTY));
        }
        return after;
    }

    public static <T extends Json> JsonRightPadded<T> build(T element) {
        return new JsonRightPadded<T>(element, Space.EMPTY, Markers.EMPTY);
    }

    public String toString() {
        return "JsonRightPadded(element=" + this.element.getClass().getSimpleName() + ", after=" + this.after + ')';
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JsonRightPadded)) {
            return false;
        }
        JsonRightPadded other = (JsonRightPadded)o;
        return other.canEqual(this);
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof JsonRightPadded;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public JsonRightPadded(T element, Space after, Markers markers) {
        this.element = element;
        this.after = after;
        this.markers = markers;
    }

    @Generated
    public T getElement() {
        return this.element;
    }

    @Generated
    public Space getAfter() {
        return this.after;
    }

    @Generated
    public Markers getMarkers() {
        return this.markers;
    }

    @NonNull
    @Generated
    public JsonRightPadded<T> withElement(T element) {
        return this.element == element ? this : new JsonRightPadded<T>(element, this.after, this.markers);
    }

    @NonNull
    @Generated
    public JsonRightPadded<T> withAfter(Space after) {
        return this.after == after ? this : new JsonRightPadded<T>(this.element, after, this.markers);
    }

    @NonNull
    @Generated
    public JsonRightPadded<T> withMarkers(Markers markers) {
        return this.markers == markers ? this : new JsonRightPadded<T>(this.element, this.after, markers);
    }
}

