/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.json;

import java.util.concurrent.atomic.AtomicReference;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.HasSourcePath;
import org.openrewrite.Incubating;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.json.JsonIsoVisitor;
import org.openrewrite.json.JsonPathMatcher;
import org.openrewrite.json.tree.Json;
import org.openrewrite.json.tree.Space;

public final class DeleteKey
extends Recipe {
    @Option(displayName="Key path", description="A JsonPath expression to locate a JSON entry.", example="$.subjects.kind")
    private final String keyPath;
    @Option(displayName="Optional file matcher", description="Matching files will be modified. This is a glob expression.", required=false, example="**/application-*.json")
    @Nullable
    @Incubating(since="7.11.0")
    private final String fileMatcher;

    public String getDisplayName() {
        return "Delete key";
    }

    public String getDescription() {
        return "Delete a JSON mapping entry key.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        if (this.fileMatcher != null) {
            return new HasSourcePath(this.fileMatcher);
        }
        return null;
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        final JsonPathMatcher xPathMatcher = new JsonPathMatcher(this.keyPath);
        return new JsonIsoVisitor<ExecutionContext>(){

            @Override
            public Json.JsonObject visitObject(Json.JsonObject obj, ExecutionContext executionContext) {
                Json o = super.visitObject(obj, executionContext);
                AtomicReference copyFirstPrefix = new AtomicReference();
                if (!((Json.JsonObject)(o = ((Json.JsonObject)o).withMembers(ListUtils.map(((Json.JsonObject)o).getMembers(), (i, e) -> {
                    if (xPathMatcher.matches(new Cursor(this.getCursor(), e))) {
                        if (i == 0 && this.getCursor().getParentOrThrow().getValue() instanceof Json.Array) {
                            copyFirstPrefix.set(e.getPrefix());
                        }
                        return null;
                    }
                    return e;
                })))).getMembers().isEmpty() && copyFirstPrefix.get() != null) {
                    o = ((Json.JsonObject)o).withMembers(ListUtils.mapFirst(((Json.JsonObject)o).getMembers(), e -> e.withPrefix((Space)copyFirstPrefix.get())));
                }
                return o;
            }
        };
    }

    public DeleteKey(String keyPath, @Nullable String fileMatcher) {
        this.keyPath = keyPath;
        this.fileMatcher = fileMatcher;
    }

    public String getKeyPath() {
        return this.keyPath;
    }

    @Nullable
    public String getFileMatcher() {
        return this.fileMatcher;
    }

    @NonNull
    public String toString() {
        return "DeleteKey(keyPath=" + this.getKeyPath() + ", fileMatcher=" + this.getFileMatcher() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteKey)) {
            return false;
        }
        DeleteKey other = (DeleteKey)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$keyPath = this.getKeyPath();
        String other$keyPath = other.getKeyPath();
        if (this$keyPath == null ? other$keyPath != null : !this$keyPath.equals(other$keyPath)) {
            return false;
        }
        String this$fileMatcher = this.getFileMatcher();
        String other$fileMatcher = other.getFileMatcher();
        return !(this$fileMatcher == null ? other$fileMatcher != null : !this$fileMatcher.equals(other$fileMatcher));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof DeleteKey;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $keyPath = this.getKeyPath();
        result = result * 59 + ($keyPath == null ? 43 : $keyPath.hashCode());
        String $fileMatcher = this.getFileMatcher();
        result = result * 59 + ($fileMatcher == null ? 43 : $fileMatcher.hashCode());
        return result;
    }
}

