/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript.marker;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.rpc.RpcCodec;
import org.openrewrite.rpc.RpcReceiveQueue;
import org.openrewrite.rpc.RpcSendQueue;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.style.Style;

public class PrettierStyle
extends NamedStyles
implements RpcCodec<PrettierStyle> {
    private static final String NAME = "org.openrewrite.javascript.Prettier";
    private static final String DISPLAY_NAME = "Prettier";
    private static final String DESCRIPTION = "Prettier code formatter configuration.";
    private final Map<String, Object> config;
    private final String prettierVersion;
    private final boolean ignored;

    public PrettierStyle(UUID id, Map<String, Object> config, String prettierVersion, boolean ignored) {
        super(id, NAME, DISPLAY_NAME, DESCRIPTION, Collections.emptySet(), Collections.emptyList());
        this.config = config;
        this.prettierVersion = prettierVersion;
        this.ignored = ignored;
    }

    public PrettierStyle withId(UUID id) {
        return id == this.getId() ? this : new PrettierStyle(id, this.config, this.prettierVersion, this.ignored);
    }

    public PrettierStyle withConfig(Map<String, Object> config) {
        return config == this.config ? this : new PrettierStyle(this.getId(), config, this.prettierVersion, this.ignored);
    }

    public PrettierStyle withPrettierVersion(String prettierVersion) {
        return prettierVersion.equals(this.prettierVersion) ? this : new PrettierStyle(this.getId(), this.config, prettierVersion, this.ignored);
    }

    public PrettierStyle withIgnored(boolean ignored) {
        return ignored == this.ignored ? this : new PrettierStyle(this.getId(), this.config, this.prettierVersion, ignored);
    }

    public PrettierStyle withStyles(Collection<Style> styles) {
        return this;
    }

    public void rpcSend(PrettierStyle after, RpcSendQueue q) {
        q.getAndSend((Object)after, NamedStyles::getId);
        q.getAndSend((Object)after, PrettierStyle::getConfig);
        q.getAndSend((Object)after, PrettierStyle::getPrettierVersion);
        q.getAndSend((Object)after, PrettierStyle::isIgnored);
    }

    public PrettierStyle rpcReceive(PrettierStyle before, RpcReceiveQueue q) {
        return before.withId((UUID)q.receiveAndGet((Object)before.getId(), UUID::fromString)).withConfig((Map)q.receive(before.getConfig())).withPrettierVersion((String)q.receive((Object)before.getPrettierVersion())).withIgnored((Boolean)q.receive((Object)before.isIgnored()));
    }

    @Generated
    public Map<String, Object> getConfig() {
        return this.config;
    }

    @Generated
    public String getPrettierVersion() {
        return this.prettierVersion;
    }

    @Generated
    public boolean isIgnored() {
        return this.ignored;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PrettierStyle)) {
            return false;
        }
        PrettierStyle other = (PrettierStyle)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isIgnored() != other.isIgnored()) {
            return false;
        }
        Map<String, Object> this$config = this.getConfig();
        Map<String, Object> other$config = other.getConfig();
        if (this$config == null ? other$config != null : !((Object)this$config).equals(other$config)) {
            return false;
        }
        String this$prettierVersion = this.getPrettierVersion();
        String other$prettierVersion = other.getPrettierVersion();
        return !(this$prettierVersion == null ? other$prettierVersion != null : !this$prettierVersion.equals(other$prettierVersion));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof PrettierStyle;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isIgnored() ? 79 : 97);
        Map<String, Object> $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
        String $prettierVersion = this.getPrettierVersion();
        result = result * 59 + ($prettierVersion == null ? 43 : $prettierVersion.hashCode());
        return result;
    }
}

