/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.ManagedThreadLocal;
import org.openrewrite.javascript.internal.rpc.JavaScriptValidator;
import org.openrewrite.javascript.rpc.JavaScriptRewriteRpc;
import org.openrewrite.javascript.tree.JS;
import org.openrewrite.tree.ParseError;

public class JavaScriptParser
implements Parser {
    private final JavaScriptRewriteRpc rewriteRpc;
    private static final List<String> EXTENSIONS = Collections.unmodifiableList(Arrays.asList(".js", ".jsx", ".mjs", ".cjs", ".ts", ".tsx", ".mts", ".cts"));
    private static final List<String> EXCLUSIONS = Collections.unmodifiableList(Arrays.asList(".pnp.cjs", ".pnp.loader.mjs"));

    private JavaScriptParser(JavaScriptRewriteRpc rewriteRpc) {
        this.rewriteRpc = rewriteRpc;
    }

    public Stream<SourceFile> parseInputs(Iterable<Parser.Input> sources, @Nullable Path relativeTo, ExecutionContext ctx) {
        ManagedThreadLocal.Scope scope = JavaScriptRewriteRpc.current().using((AutoCloseable)((Object)this.rewriteRpc));
        try {
            JavaScriptValidator validator = new JavaScriptValidator();
            return (Stream)this.rewriteRpc.parse(sources, relativeTo, this, ctx).map(source -> {
                try {
                    validator.visit((Tree)source, 0);
                    return source;
                }
                catch (Exception e) {
                    Optional<Parser.Input> input = StreamSupport.stream(sources.spliterator(), false).filter(i -> i.getRelativePath(relativeTo).equals(source.getSourcePath())).findFirst();
                    return ParseError.build((Parser)this, (Parser.Input)input.orElseThrow(NoSuchElementException::new), (Path)relativeTo, (ExecutionContext)ctx, (Throwable)e);
                }
            }).onClose(() -> ((ManagedThreadLocal.Scope)scope).close());
        }
        catch (Exception e) {
            scope.close();
            throw e;
        }
    }

    public boolean accept(Path path) {
        if (path.toString().contains("/dist/")) {
            return false;
        }
        String filename = path.getFileName().toString().toLowerCase();
        for (String ext : EXTENSIONS) {
            if (!filename.endsWith(ext) || EXCLUSIONS.contains(filename)) continue;
            return true;
        }
        return false;
    }

    public Path sourcePathFromSourceText(Path prefix, String sourceCode) {
        return prefix.resolve("source.ts");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Parser.Builder {
        private @Nullable JavaScriptRewriteRpc client;

        Builder() {
            super(JS.CompilationUnit.class);
        }

        public Builder rewriteRpc(JavaScriptRewriteRpc rewriteRpc) {
            this.client = rewriteRpc;
            return this;
        }

        public JavaScriptParser build() {
            return new JavaScriptParser(Objects.requireNonNull(this.client));
        }

        public String getDslName() {
            return "javascript";
        }
    }
}

