/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript;

import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypedTree;
import org.openrewrite.javascript.tree.JS;
import org.openrewrite.javascript.tree.JSX;
import org.openrewrite.javascript.tree.JsContainer;
import org.openrewrite.javascript.tree.JsLeftPadded;
import org.openrewrite.javascript.tree.JsRightPadded;
import org.openrewrite.javascript.tree.JsSpace;
import org.openrewrite.marker.Markers;

public class JavaScriptVisitor<P>
extends JavaVisitor<P> {
    public boolean isAcceptable(SourceFile sourceFile, P p) {
        return sourceFile instanceof JS.CompilationUnit;
    }

    public String getLanguage() {
        return "org/openrewrite/javascript";
    }

    public J visitCompilationUnit(J.CompilationUnit cu, P p) {
        throw new UnsupportedOperationException("JS has a different structure for its compilation unit. See JS.CompilationUnit.");
    }

    public J visitJsCompilationUnit(JS.CompilationUnit cu, P p) {
        JS.CompilationUnit c = cu;
        c = c.withPrefix(this.visitSpace(c.getPrefix(), Space.Location.COMPILATION_UNIT_PREFIX, p));
        c = c.withMarkers(this.visitMarkers(c.getMarkers(), p));
        c = c.getPadding().withImports(ListUtils.map(c.getPadding().getImports(), t -> this.visitRightPadded((JRightPadded)t, JRightPadded.Location.IMPORT, p)));
        c = c.getPadding().withStatements(ListUtils.map(c.getPadding().getStatements(), e -> this.visitRightPadded((JRightPadded)e, JRightPadded.Location.BLOCK_STATEMENT, p)));
        c = c.withEof(this.visitSpace(c.getEof(), Space.Location.COMPILATION_UNIT_EOF, p));
        return c;
    }

    public J visitAlias(JS.Alias alias, P p) {
        JS.Alias a = alias;
        a = a.withPrefix(this.visitSpace(a.getPrefix(), JsSpace.Location.ALIAS_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(a = a.withMarkers(this.visitMarkers(a.getMarkers(), p)), p);
        if (!(temp instanceof JS.Alias)) {
            return temp;
        }
        a = (JS.Alias)temp;
        a = a.getPadding().withPropertyName(Objects.requireNonNull(this.visitRightPadded(a.getPadding().getPropertyName(), JsRightPadded.Location.ALIAS_PROPERTY_NAME, p)));
        a = a.withAlias(Objects.requireNonNull((Expression)this.visitAndCast((Tree)a.getAlias(), p)));
        return a;
    }

    public J visitArrowFunction(JS.ArrowFunction arrowFunction, P p) {
        JS.ArrowFunction a = arrowFunction;
        a = a.withPrefix(this.visitSpace(a.getPrefix(), JsSpace.Location.ARROW_FUNCTION_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(a = a.withMarkers(this.visitMarkers(a.getMarkers(), p)), p);
        if (!(temp instanceof JS.ArrowFunction)) {
            return temp;
        }
        a = (JS.ArrowFunction)temp;
        a = a.withLeadingAnnotations(Objects.requireNonNull(ListUtils.map(a.getLeadingAnnotations(), ann -> (J.Annotation)this.visitAndCast((Tree)ann, p))));
        a = a.withModifiers(Objects.requireNonNull(ListUtils.map(a.getModifiers(), m -> (J.Modifier)this.visitAndCast((Tree)m, p))));
        a = a.withTypeParameters((J.TypeParameters)this.visitAndCast((Tree)a.getTypeParameters(), p));
        a = a.withLambda(Objects.requireNonNull((J.Lambda)this.visitAndCast((Tree)a.getLambda(), p)));
        a = a.withReturnTypeExpression((TypeTree)this.visitAndCast((Tree)a.getReturnTypeExpression(), p));
        return a;
    }

    public J visitAwait(JS.Await await, P p) {
        JS.Await a = await;
        a = a.withPrefix(this.visitSpace(a.getPrefix(), JsSpace.Location.AWAIT_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(a = a.withMarkers(this.visitMarkers(a.getMarkers(), p)), p);
        if (!(temp instanceof JS.Await)) {
            return temp;
        }
        a = (JS.Await)temp;
        a = a.withExpression(Objects.requireNonNull((Expression)this.visitAndCast((Tree)a.getExpression(), p)));
        return a;
    }

    public J visitBindingElement(JS.BindingElement binding, P p) {
        JS.BindingElement b = binding;
        b = b.withPrefix(this.visitSpace(b.getPrefix(), JsSpace.Location.BINDING_ELEMENT_PREFIX, p));
        b = b.withMarkers(this.visitMarkers(b.getMarkers(), p));
        b = b.withPropertyName((Expression)this.visitAndCast((Tree)b.getPropertyName(), p));
        if ((b = b.withName(Objects.requireNonNull((TypedTree)this.visitAndCast((Tree)b.getName(), p)))).getPadding().getInitializer() != null) {
            b = b.getPadding().withInitializer(this.visitLeftPadded(b.getPadding().getInitializer(), JsLeftPadded.Location.BINDING_ELEMENT_INITIALIZER, p));
        }
        b = b.withVariableType((JavaType.Variable)this.visitType((JavaType)b.getVariableType(), p));
        return b;
    }

    public J visitConditionalType(JS.ConditionalType conditionalType, P p) {
        JS.ConditionalType t = conditionalType;
        t = t.withPrefix(this.visitSpace(t.getPrefix(), JsSpace.Location.CONDITIONAL_TYPE_PREFIX, p));
        t = t.withMarkers(this.visitMarkers(t.getMarkers(), p));
        if ((t = t.withCheckType(Objects.requireNonNull((Expression)this.visitAndCast((Tree)t.getCheckType(), p)))).getCheckType() instanceof NameTree) {
            t = t.withCheckType((Expression)this.visitTypeName((NameTree)t.getCheckType(), p));
        }
        t = t.getPadding().withCondition(Objects.requireNonNull(this.visitLeftPadded(t.getPadding().getCondition(), JsLeftPadded.Location.CONDITIONAL_TYPE_CONDITION, p)));
        t = t.withType(this.visitType(t.getType(), p));
        return t;
    }

    public J visitDelete(JS.Delete delete, P p) {
        JS.Delete d = delete;
        d = d.withPrefix(this.visitSpace(d.getPrefix(), JsSpace.Location.DELETE_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(d = d.withMarkers(this.visitMarkers(d.getMarkers(), p)), p);
        if (!(temp instanceof JS.Delete)) {
            return temp;
        }
        d = (JS.Delete)temp;
        return d;
    }

    public J visitExpressionStatement(JS.ExpressionStatement statement, P p) {
        JS.ExpressionStatement es = statement;
        Statement temp = (Statement)this.visitStatement(es = (JS.ExpressionStatement)es.withMarkers(this.visitMarkers(es.getMarkers(), p)), p);
        if (!(temp instanceof JS.ExpressionStatement)) {
            return temp;
        }
        es = (JS.ExpressionStatement)temp;
        J expression = (J)this.visit((Tree)es.getExpression(), p);
        es = es.withExpression((Expression)Objects.requireNonNull(expression));
        return es;
    }

    public J visitTrailingTokenStatement(JS.TrailingTokenStatement statement, P p) {
        JS.TrailingTokenStatement st = statement;
        st = st.withPrefix(this.visitSpace(st.getPrefix(), JsSpace.Location.TRAILING_TOKEN_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(st = st.withMarkers(this.visitMarkers(st.getMarkers(), p)), p);
        if (!(temp instanceof JS.TrailingTokenStatement)) {
            return temp;
        }
        st = (JS.TrailingTokenStatement)temp;
        st = st.getPadding().withExpression(Objects.requireNonNull(this.visitRightPadded(st.getPadding().getExpression(), JsRightPadded.Location.TRAILING_TOKEN_EXPRESSION, p)));
        st = st.withType(this.visitType(st.getType(), p));
        return st;
    }

    public J visitExpressionWithTypeArguments(JS.ExpressionWithTypeArguments expressionWithTypeArguments, P p) {
        JS.ExpressionWithTypeArguments ta = expressionWithTypeArguments;
        ta = ta.withPrefix(this.visitSpace(ta.getPrefix(), JsSpace.Location.EXPR_WITH_TYPE_ARG_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(ta = ta.withMarkers(this.visitMarkers(ta.getMarkers(), p)), p);
        if (!(temp instanceof JS.ExpressionWithTypeArguments)) {
            return temp;
        }
        ta = (JS.ExpressionWithTypeArguments)temp;
        if ((ta = ta.withClazz(Objects.requireNonNull((J)this.visitAndCast((Tree)ta.getClazz(), p)))).getPadding().getTypeArguments() != null) {
            ta = ta.getPadding().withTypeArguments(this.visitContainer(ta.getPadding().getTypeArguments(), JsContainer.Location.EXPR_WITH_TYPE_ARG_PARAMETERS, p));
        }
        ta = ta.withType(this.visitType(ta.getType(), p));
        return ta;
    }

    public J visitFunctionType(JS.FunctionType functionType, P p) {
        JS.FunctionType f = functionType;
        f = f.withPrefix(this.visitSpace(f.getPrefix(), JsSpace.Location.FUNCTION_TYPE_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(f = f.withMarkers(this.visitMarkers(f.getMarkers(), p)), p);
        if (!(temp instanceof JS.FunctionType)) {
            return temp;
        }
        f = (JS.FunctionType)temp;
        f = f.withModifiers(Objects.requireNonNull(ListUtils.map(f.getModifiers(), e -> (J.Modifier)this.visitAndCast((Tree)e, p))));
        f = f.getPadding().withConstructorType(Objects.requireNonNull(this.visitLeftPadded(f.getPadding().getConstructorType(), JsLeftPadded.Location.FUNCTION_TYPE_CONSTRUCTOR, p)));
        f = f.withTypeParameters((J.TypeParameters)this.visitAndCast((Tree)f.getTypeParameters(), p));
        f = f.getPadding().withParameters(Objects.requireNonNull(this.visitContainer(f.getPadding().getParameters(), JsContainer.Location.FUNCTION_TYPE_PARAMETERS, p)));
        f = f.getPadding().withReturnType(Objects.requireNonNull(this.visitLeftPadded(f.getPadding().getReturnType(), JsLeftPadded.Location.FUNCTION_TYPE_RETURN_TYPE, p)));
        return f;
    }

    public J visitInferType(JS.InferType inferType, P p) {
        JS.InferType t = inferType;
        t = t.withPrefix(this.visitSpace(t.getPrefix(), JsSpace.Location.INFER_TYPE_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(t = t.withMarkers(this.visitMarkers(t.getMarkers(), p)), p);
        if (!(temp instanceof JS.InferType)) {
            return temp;
        }
        t = (JS.InferType)temp;
        t = t.getPadding().withTypeParameter(Objects.requireNonNull(this.visitLeftPadded(t.getPadding().getTypeParameter(), JsLeftPadded.Location.INFER_TYPE_PARAMETER, p)));
        t = t.withType(this.visitType(t.getType(), p));
        return t;
    }

    public J visitBinaryExtensions(JS.Binary binary, P p) {
        JS.Binary b = binary;
        b = b.withPrefix(this.visitSpace(b.getPrefix(), JsSpace.Location.BINARY_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(b = b.withMarkers(this.visitMarkers(b.getMarkers(), p)), p);
        if (!(temp instanceof JS.Binary)) {
            return temp;
        }
        b = (JS.Binary)temp;
        b = b.withLeft(Objects.requireNonNull((Expression)this.visitAndCast((Tree)b.getLeft(), p)));
        b = b.getPadding().withOperator(Objects.requireNonNull(this.visitLeftPadded(b.getPadding().getOperator(), JsLeftPadded.Location.BINARY_OPERATOR, p)));
        b = b.withRight(Objects.requireNonNull((Expression)this.visitAndCast((Tree)b.getRight(), p)));
        b = b.withType(this.visitType(b.getType(), p));
        return b;
    }

    public J visitImportDeclaration(JS.Import jsImport, P p) {
        JS.Import i = jsImport;
        i = i.withPrefix(this.visitSpace(i.getPrefix(), JsSpace.Location.IMPORT_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(i = i.withMarkers(this.visitMarkers(i.getMarkers(), p)), p);
        if (!(temp instanceof JS.Import)) {
            return temp;
        }
        i = (JS.Import)temp;
        i = i.withImportClause((JS.ImportClause)this.visitAndCast((Tree)i.getImportClause(), p));
        i = i.getPadding().withModuleSpecifier(this.visitLeftPadded(i.getPadding().getModuleSpecifier(), JsLeftPadded.Location.IMPORT_MODULE_SPECIFIER, p));
        i = i.withAttributes((JS.ImportAttributes)this.visitAndCast((Tree)i.getAttributes(), p));
        i = i.getPadding().withInitializer(this.visitLeftPadded(i.getPadding().getInitializer(), JsLeftPadded.Location.IMPORT_INITIALIZER, p));
        return i;
    }

    public J visitImportClause(JS.ImportClause jsImportClause, P p) {
        JS.ImportClause i = jsImportClause;
        i = i.withPrefix(this.visitSpace(i.getPrefix(), JsSpace.Location.IMPORT_CLAUSE_PREFIX, p));
        i = i.withMarkers(this.visitMarkers(i.getMarkers(), p));
        i = i.getPadding().withName(this.visitRightPadded(i.getPadding().getName(), JsRightPadded.Location.JS_IMPORT_CLAUSE_NAME, p));
        i = i.withNamedBindings((Expression)this.visitAndCast((Tree)i.getNamedBindings(), p));
        return i;
    }

    public J visitNamedImports(JS.NamedImports namedImports, P p) {
        JS.NamedImports ne = namedImports;
        ne = ne.withPrefix(this.visitSpace(ne.getPrefix(), JsSpace.Location.NAMED_IMPORTS_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(ne = ne.withMarkers(this.visitMarkers(ne.getMarkers(), p)), p);
        if (!(temp instanceof JS.NamedImports)) {
            return temp;
        }
        ne = (JS.NamedImports)temp;
        ne = ne.getPadding().withElements(Objects.requireNonNull(this.visitContainer(ne.getPadding().getElements(), JsContainer.Location.NAMED_IMPORTS_ELEMENTS, p)));
        ne = ne.withType(this.visitType(ne.getType(), p));
        return ne;
    }

    public J visitImportSpecifier(JS.ImportSpecifier jis, P p) {
        JS.ImportSpecifier i = jis;
        i = i.withPrefix(this.visitSpace(i.getPrefix(), JsSpace.Location.IMPORT_SPECIFIER_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(i = i.withMarkers(this.visitMarkers(i.getMarkers(), p)), p);
        if (!(temp instanceof JS.ImportSpecifier)) {
            return temp;
        }
        i = (JS.ImportSpecifier)temp;
        i = i.getPadding().withImportType(Objects.requireNonNull(this.visitLeftPadded(i.getPadding().getImportType(), JsLeftPadded.Location.IMPORT_SPECIFIER_IMPORT_TYPE, p)));
        i = i.withSpecifier(Objects.requireNonNull((Expression)this.visitAndCast((Tree)i.getSpecifier(), p)));
        i = i.withType(this.visitType(i.getType(), p));
        return i;
    }

    public J visitImportAttributes(JS.ImportAttributes importAttributes, P p) {
        JS.ImportAttributes i = importAttributes;
        i = i.withPrefix(this.visitSpace(i.getPrefix(), JsSpace.Location.IMPORT_ATTRIBUTES_PREFIX, p));
        i = i.withMarkers(this.visitMarkers(i.getMarkers(), p));
        i = i.getPadding().withElements(Objects.requireNonNull(this.visitContainer(i.getPadding().getElements(), JsContainer.Location.JS_IMPORT_ATTRIBUTES_ELEMENTS, p)));
        return i;
    }

    public J visitImportTypeAttributes(JS.ImportTypeAttributes importTypeAttributes, P p) {
        JS.ImportTypeAttributes i = importTypeAttributes;
        i = i.withPrefix(this.visitSpace(i.getPrefix(), JsSpace.Location.IMPORT_TYPE_ATTRIBUTES_PREFIX, p));
        i = i.withMarkers(this.visitMarkers(i.getMarkers(), p));
        i = i.getPadding().withToken(Objects.requireNonNull(this.visitRightPadded(i.getPadding().getToken(), JsRightPadded.Location.JS_IMPORT_TYPE_ATTRIBUTES_TOKEN, p)));
        i = i.getPadding().withElements(Objects.requireNonNull(this.visitContainer(i.getPadding().getElements(), JsContainer.Location.JS_IMPORT_TYPE_ATTRIBUTES_ELEMENTS, p)));
        i = i.withEnd(Objects.requireNonNull(this.visitSpace(i.getEnd(), JsSpace.Location.IMPORT_TYPE_ATTRIBUTES_END_SUFFIX, p)));
        return i;
    }

    public J visitImportAttribute(JS.ImportAttribute importAttribute, P p) {
        JS.ImportAttribute i = importAttribute;
        i = i.withPrefix(this.visitSpace(i.getPrefix(), JsSpace.Location.IMPORT_ATTRIBUTE_PREFIX, p));
        i = i.withMarkers(this.visitMarkers(i.getMarkers(), p));
        i = i.withName(Objects.requireNonNull((Expression)this.visitAndCast((Tree)i.getName(), p)));
        i = i.getPadding().withValue(Objects.requireNonNull(this.visitLeftPadded(i.getPadding().getValue(), JsLeftPadded.Location.IMPORT_ATTRIBUTE_VALUE, p)));
        return i;
    }

    public J visitLiteralType(JS.LiteralType literalType, P p) {
        JS.LiteralType type = literalType;
        type = type.withPrefix(this.visitSpace(type.getPrefix(), JsSpace.Location.LITERAL_TYPE_PREFIX, p));
        type = type.withMarkers(this.visitMarkers(type.getMarkers(), p));
        type = type.withLiteral(Objects.requireNonNull((Expression)this.visitAndCast((Tree)type.getLiteral(), p)));
        return type;
    }

    public J visitMappedType(JS.MappedType mappedType, P p) {
        JS.MappedType t = mappedType;
        t = t.withPrefix(this.visitSpace(t.getPrefix(), JsSpace.Location.MAPPED_TYPE_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(t = t.withMarkers(this.visitMarkers(t.getMarkers(), p)), p);
        if (!(temp instanceof JS.MappedType)) {
            return temp;
        }
        t = (JS.MappedType)temp;
        t = t.getPadding().withPrefixToken(this.visitLeftPadded(t.getPadding().getPrefixToken(), JsLeftPadded.Location.MAPPED_TYPE_PREFIX_TOKEN, p));
        t = t.getPadding().withHasReadonly(Objects.requireNonNull(this.visitLeftPadded(t.getPadding().getHasReadonly(), JsLeftPadded.Location.MAPPED_TYPE_READONLY, p)));
        t = t.withKeysRemapping(Objects.requireNonNull((JS.MappedType.KeysRemapping)this.visitAndCast((Tree)t.getKeysRemapping(), p)));
        t = t.getPadding().withSuffixToken(this.visitLeftPadded(t.getPadding().getSuffixToken(), JsLeftPadded.Location.MAPPED_TYPE_SUFFIX_TOKEN, p));
        t = t.getPadding().withHasQuestionToken(Objects.requireNonNull(this.visitLeftPadded(t.getPadding().getHasQuestionToken(), JsLeftPadded.Location.MAPPED_TYPE_QUESTION_TOKEN, p)));
        t = t.getPadding().withValueType(Objects.requireNonNull(this.visitContainer(t.getPadding().getValueType(), JsContainer.Location.MAPPED_TYPE_VALUE_TYPE, p)));
        return t;
    }

    public J visitMappedTypeKeysRemapping(JS.MappedType.KeysRemapping mappedTypeKeys, P p) {
        JS.MappedType.KeysRemapping m = mappedTypeKeys;
        m = m.withPrefix(this.visitSpace(m.getPrefix(), JsSpace.Location.MAPPED_TYPE_KEYS_REMAPPING_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(m = m.withMarkers(this.visitMarkers(m.getMarkers(), p)), p);
        if (!(temp instanceof JS.MappedType.KeysRemapping)) {
            return temp;
        }
        m = (JS.MappedType.KeysRemapping)temp;
        if ((m = m.getPadding().withTypeParameter(Objects.requireNonNull(this.visitRightPadded(m.getPadding().getTypeParameter(), JsRightPadded.Location.MAPPED_TYPE_KEYS_REMAPPING_TYPE_PARAMETER, p)))).getNameType() != null) {
            m = m.getPadding().withNameType(Objects.requireNonNull(this.visitRightPadded(m.getPadding().getNameType(), JsRightPadded.Location.MAPPED_TYPE_KEYS_REMAPPING_NAME_TYPE, p)));
        }
        return m;
    }

    public J visitMappedTypeParameter(JS.MappedType.Parameter parameter, P p) {
        JS.MappedType.Parameter m = parameter;
        m = m.withPrefix(this.visitSpace(m.getPrefix(), JsSpace.Location.MAPPED_TYPE_MAPPED_TYPE_PARAMETER_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(m = m.withMarkers(this.visitMarkers(m.getMarkers(), p)), p);
        if (!(temp instanceof JS.MappedType.Parameter)) {
            return temp;
        }
        m = (JS.MappedType.Parameter)temp;
        m = m.withName(Objects.requireNonNull((Expression)this.visitAndCast((Tree)m.getName(), p)));
        m = m.getPadding().withIterateType(Objects.requireNonNull(this.visitLeftPadded(m.getPadding().getIterateType(), JsLeftPadded.Location.MAPPED_TYPE_MAPPED_TYPE_PARAMETER_ITERATE, p)));
        return m;
    }

    public J visitObjectBindingPattern(JS.ObjectBindingPattern objectBindingPattern, P p) {
        JS.ObjectBindingPattern o = objectBindingPattern;
        o = o.withPrefix(this.visitSpace(o.getPrefix(), JsSpace.Location.OBJECT_BINDING_DECLARATIONS_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(o = o.withMarkers(this.visitMarkers(o.getMarkers(), p)), p);
        if (!(temp instanceof JS.ObjectBindingPattern)) {
            return temp;
        }
        o = (JS.ObjectBindingPattern)temp;
        o = o.withLeadingAnnotations(Objects.requireNonNull(ListUtils.map(o.getLeadingAnnotations(), a -> (J.Annotation)this.visitAndCast((Tree)a, p))));
        o = o.withModifiers(Objects.requireNonNull(ListUtils.map(o.getModifiers(), e -> (J.Modifier)this.visitAndCast((Tree)e, p))));
        o = o.withTypeExpression((o = o.withTypeExpression((TypeTree)this.visitAndCast((Tree)o.getTypeExpression(), p))).getTypeExpression() == null ? null : (TypeTree)this.visitTypeName((NameTree)o.getTypeExpression(), p));
        if ((o = o.getPadding().withBindings(Objects.requireNonNull(this.visitContainer(o.getPadding().getBindings(), JsContainer.Location.BINDING_ELEMENT, p)))).getPadding().getInitializer() != null) {
            o = o.getPadding().withInitializer(this.visitLeftPadded(o.getPadding().getInitializer(), JsLeftPadded.Location.BINDING_ELEMENT_INITIALIZER, p));
        }
        return o;
    }

    public J visitPropertyAssignment(JS.PropertyAssignment propertyAssignment, P p) {
        JS.PropertyAssignment pa = propertyAssignment;
        pa = pa.withPrefix(this.visitSpace(pa.getPrefix(), JsSpace.Location.PROPERTY_ASSIGNMENT_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(pa = pa.withMarkers(this.visitMarkers(pa.getMarkers(), p)), p);
        if (!(temp instanceof JS.PropertyAssignment)) {
            return temp;
        }
        pa = (JS.PropertyAssignment)temp;
        pa = pa.getPadding().withName(Objects.requireNonNull(this.visitRightPadded(pa.getPadding().getName(), JsRightPadded.Location.PROPERTY_ASSIGNMENT_NAME, p)));
        pa = pa.withInitializer((Expression)this.visitAndCast((Tree)pa.getInitializer(), p));
        return pa;
    }

    public J visitSatisfiesExpression(JS.SatisfiesExpression satisfiesExpression, P p) {
        JS.SatisfiesExpression sa = satisfiesExpression;
        sa = sa.withPrefix(this.visitSpace(sa.getPrefix(), JsSpace.Location.SATISFIES_EXPRESSION_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(sa = sa.withMarkers(this.visitMarkers(sa.getMarkers(), p)), p);
        if (!(temp instanceof JS.SatisfiesExpression)) {
            return temp;
        }
        sa = (JS.SatisfiesExpression)temp;
        sa = sa.withExpression(Objects.requireNonNull((J)this.visitAndCast((Tree)sa.getExpression(), p)));
        sa = sa.getPadding().withSatisfiesType(Objects.requireNonNull(this.visitLeftPadded(sa.getPadding().getSatisfiesType(), JsLeftPadded.Location.SATISFIES_EXPRESSION_TYPE, p)));
        return sa;
    }

    public J visitScopedVariableDeclarations(JS.ScopedVariableDeclarations scopedVariableDeclarations, P p) {
        JS.ScopedVariableDeclarations vd = scopedVariableDeclarations;
        vd = vd.withPrefix(this.visitSpace(vd.getPrefix(), JsSpace.Location.SCOPED_VARIABLE_DECLARATIONS_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(vd = vd.withMarkers(this.visitMarkers(vd.getMarkers(), p)), p);
        if (!(temp instanceof JS.ScopedVariableDeclarations)) {
            return temp;
        }
        vd = (JS.ScopedVariableDeclarations)temp;
        vd = vd.withModifiers(Objects.requireNonNull(ListUtils.map(vd.getModifiers(), e -> (J.Modifier)this.visitAndCast((Tree)e, p))));
        vd = vd.getPadding().withVariables(Objects.requireNonNull(ListUtils.map(vd.getPadding().getVariables(), e -> this.visitRightPadded((JRightPadded)e, JsRightPadded.Location.SCOPED_VARIABLE_DECLARATIONS_VARIABLE, p))));
        return vd;
    }

    public J visitStatementExpression(JS.StatementExpression expression, P p) {
        JS.StatementExpression se = expression;
        Expression temp = (Expression)this.visitExpression(se, p);
        if (!(temp instanceof JS.StatementExpression)) {
            return temp;
        }
        se = (JS.StatementExpression)temp;
        J statement = (J)this.visit((Tree)se.getStatement(), p);
        se = se.withStatement((Statement)Objects.requireNonNull(statement));
        return se;
    }

    public J visitTaggedTemplateExpression(JS.TaggedTemplateExpression taggedTemplateExpression, P p) {
        JS.TaggedTemplateExpression ta = taggedTemplateExpression;
        ta = ta.withPrefix(this.visitSpace(ta.getPrefix(), JsSpace.Location.TAGGED_TEMPLATE_EXPRESSION_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(ta = ta.withMarkers(this.visitMarkers(ta.getMarkers(), p)), p);
        if (!(temp instanceof JS.TaggedTemplateExpression)) {
            return temp;
        }
        ta = (JS.TaggedTemplateExpression)temp;
        if ((ta = ta.getPadding().withTag(this.visitRightPadded(ta.getPadding().getTag(), JsRightPadded.Location.TEMPLATE_EXPRESSION_TAG, p))).getPadding().getTypeArguments() != null) {
            ta = ta.getPadding().withTypeArguments(this.visitContainer(ta.getPadding().getTypeArguments(), JsContainer.Location.TEMPLATE_EXPRESSION_TYPE_ARG_PARAMETERS, p));
        }
        ta = ta.withTemplateExpression(Objects.requireNonNull((Expression)this.visitAndCast((Tree)ta.getTemplateExpression(), p)));
        return ta;
    }

    public J visitTemplateExpression(JS.TemplateExpression templateExpression, P p) {
        JS.TemplateExpression te = templateExpression;
        te = te.withPrefix(this.visitSpace(te.getPrefix(), JsSpace.Location.TEMPLATE_EXPRESSION_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(te = te.withMarkers(this.visitMarkers(te.getMarkers(), p)), p);
        if (!(temp instanceof JS.TemplateExpression)) {
            return temp;
        }
        te = (JS.TemplateExpression)temp;
        te = te.withHead(Objects.requireNonNull((J.Literal)this.visitAndCast((Tree)te.getHead(), p)));
        te = te.getPadding().withSpans(Objects.requireNonNull(ListUtils.map(te.getPadding().getSpans(), t -> this.visitRightPadded((JRightPadded)t, JsRightPadded.Location.TEMPLATE_EXPRESSION_TEMPLATE_SPAN, p))));
        te = te.withType(this.visitType(te.getType(), p));
        return te;
    }

    public J visitTemplateExpressionSpan(JS.TemplateExpression.Span span, P p) {
        JS.TemplateExpression.Span s = span;
        s = s.withPrefix(this.visitSpace(s.getPrefix(), JsSpace.Location.TEMPLATE_EXPRESSION_SPAN_PREFIX, p));
        s = s.withMarkers(this.visitMarkers(s.getMarkers(), p));
        s = s.withExpression(Objects.requireNonNull((J)this.visitAndCast((Tree)s.getExpression(), p)));
        s = s.withTail(Objects.requireNonNull((J.Literal)this.visitAndCast((Tree)s.getTail(), p)));
        s = s.withTail(s.getTail());
        return s;
    }

    public J visitTuple(JS.Tuple tuple, P p) {
        JS.Tuple t = tuple;
        t = t.withPrefix(this.visitSpace(t.getPrefix(), JsSpace.Location.TUPLE_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(t = t.withMarkers(this.visitMarkers(t.getMarkers(), p)), p);
        if (!(temp instanceof JS.Tuple)) {
            return temp;
        }
        t = (JS.Tuple)temp;
        t = t.getPadding().withElements(Objects.requireNonNull(this.visitContainer(t.getPadding().getElements(), JsContainer.Location.TUPLE_ELEMENT, p)));
        t = t.withType(this.visitType(t.getType(), p));
        return t;
    }

    public J visitTypeDeclaration(JS.TypeDeclaration typeDeclaration, P p) {
        JS.TypeDeclaration t = typeDeclaration;
        t = t.withPrefix(this.visitSpace(t.getPrefix(), JsSpace.Location.TYPE_DECLARATION_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(t = t.withMarkers(this.visitMarkers(t.getMarkers(), p)), p);
        if (!(temp instanceof JS.TypeDeclaration)) {
            return temp;
        }
        t = (JS.TypeDeclaration)temp;
        t = t.withModifiers(Objects.requireNonNull(ListUtils.map(t.getModifiers(), e -> (J.Modifier)this.visitAndCast((Tree)e, p))));
        t = t.getPadding().withName(Objects.requireNonNull(this.visitLeftPadded(t.getPadding().getName(), JsLeftPadded.Location.TYPE_DECLARATION_NAME, p)));
        t = t.withTypeParameters((J.TypeParameters)this.visitAndCast((Tree)t.getTypeParameters(), p));
        t = t.getPadding().withInitializer(Objects.requireNonNull(this.visitLeftPadded(t.getPadding().getInitializer(), JsLeftPadded.Location.TYPE_DECLARATION_INITIALIZER, p)));
        t = t.withType(this.visitType(t.getType(), p));
        return t;
    }

    public J visitComputedPropertyName(JS.ComputedPropertyName computedPropertyName, P p) {
        JS.ComputedPropertyName t = computedPropertyName;
        t = t.withPrefix(this.visitSpace(t.getPrefix(), JsSpace.Location.COMPUTED_PROPERTY_NAME_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(t = t.withMarkers(this.visitMarkers(t.getMarkers(), p)), p);
        if (!(temp instanceof JS.ComputedPropertyName)) {
            return temp;
        }
        t = (JS.ComputedPropertyName)temp;
        t = t.getPadding().withExpression(Objects.requireNonNull(this.visitRightPadded(t.getPadding().getExpression(), JsRightPadded.Location.COMPUTED_PROPERTY_NAME_SUFFIX, p)));
        return t;
    }

    public J visitTypeOperator(JS.TypeOperator typeOperator, P p) {
        JS.TypeOperator t = typeOperator;
        t = t.withPrefix(this.visitSpace(t.getPrefix(), JsSpace.Location.TYPE_OPERATOR_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(t = t.withMarkers(this.visitMarkers(t.getMarkers(), p)), p);
        if (!(temp instanceof JS.TypeOperator)) {
            return temp;
        }
        t = (JS.TypeOperator)temp;
        t = t.getPadding().withExpression(Objects.requireNonNull(this.visitLeftPadded(t.getPadding().getExpression(), JsLeftPadded.Location.TYPE_OPERATOR_EXPRESSION, p)));
        return t;
    }

    public J visitTypePredicate(JS.TypePredicate typePredicate, P p) {
        JS.TypePredicate t = typePredicate;
        t = t.withPrefix(this.visitSpace(t.getPrefix(), JsSpace.Location.TYPE_PREDICATE_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(t = t.withMarkers(this.visitMarkers(t.getMarkers(), p)), p);
        if (!(temp instanceof JS.TypePredicate)) {
            return temp;
        }
        t = (JS.TypePredicate)temp;
        t = t.getPadding().withAsserts(Objects.requireNonNull(this.visitLeftPadded(t.getPadding().getAsserts(), JsLeftPadded.Location.TYPE_PREDICATE_ASSERTS, p)));
        t = t.withParameterName(Objects.requireNonNull((J.Identifier)this.visitAndCast((Tree)t.getParameterName(), p)));
        t = t.getPadding().withExpression(this.visitLeftPadded(t.getPadding().getExpression(), JsLeftPadded.Location.TYPE_PREDICATE_EXPRESSION, p));
        return t;
    }

    public J visitUnion(JS.Union union, P p) {
        JS.Union u = union;
        u = u.withPrefix(this.visitSpace(u.getPrefix(), JsSpace.Location.UNION_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(u = u.withMarkers(this.visitMarkers(u.getMarkers(), p)), p);
        if (!(temp instanceof JS.Union)) {
            return temp;
        }
        u = (JS.Union)temp;
        u = u.getPadding().withTypes(Objects.requireNonNull(ListUtils.map(u.getPadding().getTypes(), t -> this.visitRightPadded((JRightPadded)t, JsRightPadded.Location.UNION_TYPE, p))));
        u = u.withType(this.visitType(u.getType(), p));
        return u;
    }

    public J visitIntersection(JS.Intersection intersection, P p) {
        JS.Intersection u = intersection;
        u = u.withPrefix(this.visitSpace(u.getPrefix(), JsSpace.Location.INTERSECTION_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(u = u.withMarkers(this.visitMarkers(u.getMarkers(), p)), p);
        if (!(temp instanceof JS.Intersection)) {
            return temp;
        }
        u = (JS.Intersection)temp;
        u = u.getPadding().withTypes(Objects.requireNonNull(ListUtils.map(u.getPadding().getTypes(), t -> this.visitRightPadded((JRightPadded)t, JsRightPadded.Location.INTERSECTION_TYPE, p))));
        u = u.withType(this.visitType(u.getType(), p));
        return u;
    }

    public J visitExportDeclaration(JS.ExportDeclaration exportDeclaration, P p) {
        JS.ExportDeclaration ed = exportDeclaration;
        ed = ed.withPrefix(this.visitSpace(ed.getPrefix(), JsSpace.Location.EXPORT_DECLARATION_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(ed = ed.withMarkers(this.visitMarkers(ed.getMarkers(), p)), p);
        if (!(temp instanceof JS.ExportDeclaration)) {
            return temp;
        }
        ed = (JS.ExportDeclaration)temp;
        ed = ed.withModifiers(Objects.requireNonNull(ListUtils.map(ed.getModifiers(), e -> (J.Modifier)this.visitAndCast((Tree)e, p))));
        ed = ed.getPadding().withTypeOnly(Objects.requireNonNull(this.visitLeftPadded(ed.getPadding().getTypeOnly(), JsLeftPadded.Location.EXPORT_DECLARATION_TYPE_ONLY, p)));
        ed = ed.withExportClause((Expression)this.visitAndCast((Tree)ed.getExportClause(), p));
        ed = ed.getPadding().withModuleSpecifier(this.visitLeftPadded(ed.getPadding().getModuleSpecifier(), JsLeftPadded.Location.EXPORT_DECLARATION_MODULE_SPECIFIER, p));
        ed = ed.withAttributes((JS.ImportAttributes)this.visitAndCast((Tree)ed.getAttributes(), p));
        return ed;
    }

    public J visitExportAssignment(JS.ExportAssignment exportAssignment, P p) {
        JS.ExportAssignment es = exportAssignment;
        es = es.withPrefix(this.visitSpace(es.getPrefix(), JsSpace.Location.EXPORT_ASSIGNMENT_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(es = es.withMarkers(this.visitMarkers(es.getMarkers(), p)), p);
        if (!(temp instanceof JS.ExportAssignment)) {
            return temp;
        }
        es = (JS.ExportAssignment)temp;
        es = es.getPadding().withExpression(Objects.requireNonNull(this.visitLeftPadded(es.getPadding().getExpression(), JsLeftPadded.Location.EXPORT_ASSIGNMENT_EXPRESSION, p)));
        return es;
    }

    public J visitNamedExports(JS.NamedExports namedExports, P p) {
        JS.NamedExports ne = namedExports;
        ne = ne.withPrefix(this.visitSpace(ne.getPrefix(), JsSpace.Location.NAMED_EXPORTS_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(ne = ne.withMarkers(this.visitMarkers(ne.getMarkers(), p)), p);
        if (!(temp instanceof JS.NamedExports)) {
            return temp;
        }
        ne = (JS.NamedExports)temp;
        ne = ne.getPadding().withElements(Objects.requireNonNull(this.visitContainer(ne.getPadding().getElements(), JsContainer.Location.NAMED_EXPORTS_ELEMENTS, p)));
        ne = ne.withType(this.visitType(ne.getType(), p));
        return ne;
    }

    public J visitExportSpecifier(JS.ExportSpecifier exportSpecifier, P p) {
        JS.ExportSpecifier es = exportSpecifier;
        es = es.withPrefix(this.visitSpace(es.getPrefix(), JsSpace.Location.EXPORT_SPECIFIER_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(es = es.withMarkers(this.visitMarkers(es.getMarkers(), p)), p);
        if (!(temp instanceof JS.ExportSpecifier)) {
            return temp;
        }
        es = (JS.ExportSpecifier)temp;
        es = es.getPadding().withTypeOnly(Objects.requireNonNull(this.visitLeftPadded(es.getPadding().getTypeOnly(), JsLeftPadded.Location.EXPORT_SPECIFIER_TYPE_ONLY, p)));
        es = es.withSpecifier(Objects.requireNonNull((Expression)this.visitAndCast((Tree)es.getSpecifier(), p)));
        es = es.withType(this.visitType(es.getType(), p));
        return es;
    }

    public J visitIndexedAccessType(JS.IndexedAccessType indexedAccessType, P p) {
        JS.IndexedAccessType iat = indexedAccessType;
        iat = iat.withPrefix(this.visitSpace(iat.getPrefix(), JsSpace.Location.INDEXED_ACCESS_TYPE_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(iat = iat.withMarkers(this.visitMarkers(iat.getMarkers(), p)), p);
        if (!(temp instanceof JS.IndexedAccessType)) {
            return temp;
        }
        iat = (JS.IndexedAccessType)temp;
        iat = iat.withObjectType(Objects.requireNonNull((TypeTree)this.visitAndCast((Tree)iat.getObjectType(), p)));
        iat = iat.withIndexType(Objects.requireNonNull((TypeTree)this.visitAndCast((Tree)iat.getIndexType(), p)));
        iat = iat.withType(this.visitType(iat.getType(), p));
        return iat;
    }

    public J visitIndexedAccessTypeIndexType(JS.IndexedAccessType.IndexType indexedAccessTypeIndexType, P p) {
        JS.IndexedAccessType.IndexType iatit = indexedAccessTypeIndexType;
        iatit = iatit.withPrefix(this.visitSpace(iatit.getPrefix(), JsSpace.Location.INDEXED_ACCESS_TYPE_INDEX_TYPE_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(iatit = iatit.withMarkers(this.visitMarkers(iatit.getMarkers(), p)), p);
        if (!(temp instanceof JS.IndexedAccessType.IndexType)) {
            return temp;
        }
        iatit = (JS.IndexedAccessType.IndexType)temp;
        iatit = iatit.getPadding().withElement(Objects.requireNonNull(this.visitRightPadded(iatit.getPadding().getElement(), JsRightPadded.Location.INDEXED_ACCESS_TYPE_INDEX_TYPE_ELEMENT, p)));
        iatit = iatit.withType(this.visitType(iatit.getType(), p));
        return iatit;
    }

    public J visitAnnotatedType(J.AnnotatedType annotatedType, P p) {
        J.AnnotatedType a = annotatedType;
        a = a.withPrefix(this.visitSpace(a.getPrefix(), Space.Location.ANNOTATED_TYPE_PREFIX, p));
        Expression temp = (Expression)this.visitExpression((Expression)(a = a.withMarkers(this.visitMarkers(a.getMarkers(), p))), p);
        if (!(temp instanceof J.AnnotatedType)) {
            return temp;
        }
        a = (J.AnnotatedType)temp;
        a = a.withAnnotations(Objects.requireNonNull(ListUtils.map((List)a.getAnnotations(), e -> (J.Annotation)this.visitAndCast((Tree)e, p))));
        a = a.withTypeExpression((TypeTree)this.visitAndCast((Tree)a.getTypeExpression(), p));
        a = a.withTypeExpression((TypeTree)this.visitTypeName((NameTree)a.getTypeExpression(), p));
        return a;
    }

    public J visitParameterizedType(J.ParameterizedType type, P p) {
        J.ParameterizedType pt = type;
        pt = pt.withPrefix(this.visitSpace(pt.getPrefix(), Space.Location.PARAMETERIZED_TYPE_PREFIX, p));
        Expression temp = (Expression)this.visitExpression((Expression)(pt = pt.withMarkers(this.visitMarkers(pt.getMarkers(), p))), p);
        if (!(temp instanceof J.ParameterizedType)) {
            return temp;
        }
        pt = (J.ParameterizedType)temp;
        if ((pt = pt.withClazz(Objects.requireNonNull((NameTree)this.visitAndCast((Tree)pt.getClazz(), p)))).getPadding().getTypeParameters() != null) {
            pt = pt.getPadding().withTypeParameters(this.visitContainer(pt.getPadding().getTypeParameters(), JContainer.Location.TYPE_PARAMETERS, p));
        }
        pt = pt.getPadding().withTypeParameters(this.visitTypeNames(pt.getPadding().getTypeParameters(), p));
        pt = pt.withType(this.visitType(pt.getType(), p));
        return pt;
    }

    private <N extends NameTree> @Nullable JLeftPadded<N> visitTypeName(@Nullable JLeftPadded<N> nameTree, P p) {
        return nameTree == null ? null : nameTree.withElement((Object)this.visitTypeName((NameTree)nameTree.getElement(), p));
    }

    private <N extends NameTree> @Nullable JRightPadded<N> visitTypeName(@Nullable JRightPadded<N> nameTree, P p) {
        return nameTree == null ? null : nameTree.withElement((Object)this.visitTypeName((NameTree)nameTree.getElement(), p));
    }

    private <J2 extends J> @Nullable JContainer<J2> visitTypeNames(@Nullable JContainer<J2> nameTrees, P p) {
        if (nameTrees == null) {
            return null;
        }
        List js = ListUtils.map((List)nameTrees.getPadding().getElements(), t -> Objects.requireNonNull(t).getElement() instanceof NameTree ? this.visitTypeName((JRightPadded)t, p) : t);
        return js == nameTrees.getPadding().getElements() ? nameTrees : JContainer.build((Space)nameTrees.getBefore(), (List)Objects.requireNonNull(js), (Markers)Markers.EMPTY);
    }

    public Space visitSpace(Space space, JsSpace.Location loc, P p) {
        return this.visitSpace(space, Space.Location.LANGUAGE_EXTENSION, p);
    }

    public <T> @Nullable JRightPadded<T> visitRightPadded(@Nullable JRightPadded<T> right, JsRightPadded.Location loc, P p) {
        return super.visitRightPadded(right, JRightPadded.Location.LANGUAGE_EXTENSION, p);
    }

    public <T> @Nullable JLeftPadded<T> visitLeftPadded(@Nullable JLeftPadded<T> left, JsLeftPadded.Location loc, P p) {
        return super.visitLeftPadded(left, JLeftPadded.Location.LANGUAGE_EXTENSION, p);
    }

    public <J2 extends J> @Nullable JContainer<J2> visitContainer(@Nullable JContainer<J2> container, JsContainer.Location loc, P p) {
        return super.visitContainer(container, JContainer.Location.LANGUAGE_EXTENSION, p);
    }

    public J visitTypeOf(JS.TypeOf typeOf, P p) {
        JS.TypeOf t = typeOf;
        t = t.withPrefix(this.visitSpace(t.getPrefix(), JsSpace.Location.TYPEOF_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(t = t.withMarkers(this.visitMarkers(t.getMarkers(), p)), p);
        if (!(temp instanceof JS.TypeOf)) {
            return temp;
        }
        t = (JS.TypeOf)temp;
        t = t.withExpression(Objects.requireNonNull((Expression)this.visitAndCast((Tree)t.getExpression(), p)));
        t = t.withType(this.visitType(t.getType(), p));
        return t;
    }

    public J visitTypeQuery(JS.TypeQuery typeQuery, P p) {
        JS.TypeQuery t = typeQuery;
        t = t.withPrefix(this.visitSpace(t.getPrefix(), JsSpace.Location.TYPE_QUERY_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(t = t.withMarkers(this.visitMarkers(t.getMarkers(), p)), p);
        if (!(temp instanceof JS.TypeQuery)) {
            return temp;
        }
        t = (JS.TypeQuery)temp;
        if ((t = t.withTypeExpression(Objects.requireNonNull((TypeTree)this.visitAndCast((Tree)t.getTypeExpression(), p)))).getPadding().getTypeArguments() != null) {
            t = t.getPadding().withTypeArguments(this.visitContainer(t.getPadding().getTypeArguments(), JsContainer.Location.TYPE_QUERY_TYPE_ARGUMENTS, p));
        }
        t = t.withType(this.visitType(t.getType(), p));
        return t;
    }

    public J visitVoid(JS.Void aVoid, P p) {
        JS.Void v = aVoid;
        v = v.withPrefix(this.visitSpace(v.getPrefix(), JsSpace.Location.VOID_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(v = v.withMarkers(this.visitMarkers(v.getMarkers(), p)), p);
        if (!(temp instanceof JS.Void)) {
            return temp;
        }
        v = (JS.Void)temp;
        v = v.withExpression(Objects.requireNonNull((Expression)this.visitAndCast((Tree)v.getExpression(), p)));
        return v;
    }

    public J visitTypeInfo(JS.TypeInfo typeInfo, P p) {
        JS.TypeInfo ti = typeInfo;
        ti = ti.withPrefix(this.visitSpace(ti.getPrefix(), JsSpace.Location.TYPE_INFO_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(ti = ti.withMarkers(this.visitMarkers(ti.getMarkers(), p)), p);
        if (!(temp instanceof JS.TypeInfo)) {
            return temp;
        }
        ti = (JS.TypeInfo)temp;
        ti = ti.withTypeIdentifier(Objects.requireNonNull((TypeTree)this.visitAndCast((Tree)ti.getTypeIdentifier(), p)));
        return ti;
    }

    public J visitComputedPropertyMethodDeclaration(JS.ComputedPropertyMethodDeclaration method, P p) {
        JS.ComputedPropertyMethodDeclaration m = method;
        m = m.withPrefix(this.visitSpace(m.getPrefix(), Space.Location.METHOD_DECLARATION_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(m = m.withMarkers(this.visitMarkers(m.getMarkers(), p)), p);
        if (!(temp instanceof JS.ComputedPropertyMethodDeclaration)) {
            return temp;
        }
        m = (JS.ComputedPropertyMethodDeclaration)temp;
        m = m.withLeadingAnnotations(Objects.requireNonNull(ListUtils.map(m.getLeadingAnnotations(), a -> (J.Annotation)this.visitAndCast((Tree)a, p))));
        m = m.withModifiers(Objects.requireNonNull(ListUtils.map(m.getModifiers(), e -> (J.Modifier)this.visitAndCast((Tree)e, p))));
        m = m.withTypeParameters((J.TypeParameters)this.visitAndCast((Tree)m.getTypeParameters(), p));
        m = m.withReturnTypeExpression((m = m.withReturnTypeExpression((TypeTree)this.visitAndCast((Tree)m.getReturnTypeExpression(), p))).getReturnTypeExpression() == null ? null : (TypeTree)this.visitTypeName((NameTree)m.getReturnTypeExpression(), p));
        m = m.withName(Objects.requireNonNull((JS.ComputedPropertyName)this.visitAndCast((Tree)m.getName(), p)));
        m = m.getPadding().withParameters((JContainer<Statement>)Objects.requireNonNull(this.visitContainer(m.getPadding().getParameters(), JContainer.Location.METHOD_DECLARATION_PARAMETERS, p)));
        m = m.withBody((J.Block)this.visitAndCast((Tree)m.getBody(), p));
        m = m.withMethodType((JavaType.Method)this.visitType((JavaType)m.getMethodType(), p));
        return m;
    }

    public J visitNamespaceDeclaration(JS.NamespaceDeclaration namespaceDeclaration, P p) {
        JS.NamespaceDeclaration ns = namespaceDeclaration;
        ns = ns.withPrefix(this.visitSpace(ns.getPrefix(), JsSpace.Location.NAMESPACE_DECLARATION_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(ns = ns.withMarkers(this.visitMarkers(ns.getMarkers(), p)), p);
        if (!(temp instanceof JS.NamespaceDeclaration)) {
            return temp;
        }
        ns = (JS.NamespaceDeclaration)temp;
        ns = ns.withModifiers(Objects.requireNonNull(ListUtils.map(ns.getModifiers(), m -> (J.Modifier)this.visitAndCast((Tree)m, p))));
        ns = ns.getPadding().withKeywordType(Objects.requireNonNull(this.visitLeftPadded(ns.getPadding().getKeywordType(), JsLeftPadded.Location.NAMESPACE_DECLARATION_KEYWORD_TYPE, p)));
        ns = ns.getPadding().withName(Objects.requireNonNull(this.visitRightPadded(ns.getPadding().getName(), JsRightPadded.Location.NAMESPACE_DECLARATION_NAME, p)));
        ns = ns.withBody((J.Block)this.visitAndCast((Tree)ns.getBody(), p));
        return ns;
    }

    public J visitTypeLiteral(JS.TypeLiteral typeLiteral, P p) {
        JS.TypeLiteral t = typeLiteral;
        t = t.withPrefix(this.visitSpace(t.getPrefix(), JsSpace.Location.TYPE_LITERAL_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(t = t.withMarkers(this.visitMarkers(t.getMarkers(), p)), p);
        if (!(temp instanceof JS.TypeLiteral)) {
            return temp;
        }
        t = (JS.TypeLiteral)temp;
        t = t.withMembers(Objects.requireNonNull((J.Block)this.visitAndCast((Tree)t.getMembers(), p)));
        t = t.withType(this.visitType(t.getType(), p));
        return t;
    }

    public J visitImportType(JS.ImportType importType, P p) {
        JS.ImportType t = importType;
        t = t.withPrefix(this.visitSpace(t.getPrefix(), JsSpace.Location.IMPORT_TYPE_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(t = t.withMarkers(this.visitMarkers(t.getMarkers(), p)), p);
        if (!(temp instanceof JS.ImportType)) {
            return temp;
        }
        t = (JS.ImportType)temp;
        t = t.getPadding().withHasTypeof(Objects.requireNonNull(this.visitRightPadded(t.getPadding().getHasTypeof(), JsRightPadded.Location.IMPORT_TYPE_TYPEOF, p)));
        t = t.getPadding().withArgumentAndAttributes(Objects.requireNonNull(this.visitContainer(t.getPadding().getArgumentAndAttributes(), JsContainer.Location.IMPORT_TYPE_ARGUMENTS_AND_ATTRIBUTES, p)));
        if ((t = t.getPadding().withQualifier(this.visitLeftPadded(t.getPadding().getQualifier(), JsLeftPadded.Location.IMPORT_TYPE_QUALIFIER, p))).getPadding().getTypeArguments() != null) {
            t = t.getPadding().withTypeArguments(this.visitContainer(t.getPadding().getTypeArguments(), JsContainer.Location.IMPORT_TYPE_TYPE_ARGUMENTS, p));
        }
        return t;
    }

    public J visitIndexSignatureDeclaration(JS.IndexSignatureDeclaration indexSignatureDeclaration, P p) {
        JS.IndexSignatureDeclaration isd = indexSignatureDeclaration;
        isd = isd.withPrefix(this.visitSpace(isd.getPrefix(), JsSpace.Location.INDEXED_SIGNATURE_DECLARATION_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(isd = isd.withMarkers(this.visitMarkers(isd.getMarkers(), p)), p);
        if (!(temp instanceof JS.IndexSignatureDeclaration)) {
            return temp;
        }
        isd = (JS.IndexSignatureDeclaration)temp;
        isd = isd.withModifiers(Objects.requireNonNull(ListUtils.map(isd.getModifiers(), e -> (J.Modifier)this.visitAndCast((Tree)e, p))));
        isd = isd.getPadding().withParameters(Objects.requireNonNull(this.visitContainer(isd.getPadding().getParameters(), JsContainer.Location.INDEXED_SIGNATURE_DECLARATION_PARAMETERS, p)));
        isd = isd.getPadding().withTypeExpression(Objects.requireNonNull(this.visitLeftPadded(isd.getPadding().getTypeExpression(), JsLeftPadded.Location.INDEXED_SIGNATURE_DECLARATION_TYPE_EXPRESSION, p)));
        isd = isd.withType(this.visitType(isd.getType(), p));
        return isd;
    }

    public J visitForOfLoop(JS.ForOfLoop forOfLoop, P p) {
        JS.ForOfLoop f = forOfLoop;
        f = f.withPrefix(this.visitSpace(f.getPrefix(), JsSpace.Location.FOR_OF_LOOP_PREFIX, p));
        Statement temp = (Statement)this.visitStatement((Statement)(f = f.withMarkers(this.visitMarkers(f.getMarkers(), p))), p);
        if (!(temp instanceof JS.ForOfLoop)) {
            return temp;
        }
        f = (JS.ForOfLoop)temp;
        f = f.withLoop(Objects.requireNonNull((J.ForEachLoop)this.visitAndCast((Tree)f.getLoop(), p)));
        return f;
    }

    public J visitForInLoop(JS.ForInLoop forInLoop, P p) {
        JS.ForInLoop f = forInLoop;
        f = f.withPrefix(this.visitSpace(f.getPrefix(), JsSpace.Location.FOR_IN_LOOP_PREFIX, p));
        Statement temp = (Statement)this.visitStatement((Statement)(f = f.withMarkers(this.visitMarkers(f.getMarkers(), p))), p);
        if (!(temp instanceof JS.ForInLoop)) {
            return temp;
        }
        f = (JS.ForInLoop)temp;
        f = f.withControl(Objects.requireNonNull((J.ForEachLoop.Control)this.visitAndCast((Tree)f.getControl(), p)));
        f = f.getPadding().withBody(Objects.requireNonNull(this.visitRightPadded(f.getPadding().getBody(), JsRightPadded.Location.FOR_BODY, p)));
        return f;
    }

    public J visitArrayBindingPattern(JS.ArrayBindingPattern arrayBindingPattern, P p) {
        JS.ArrayBindingPattern c = arrayBindingPattern;
        c = c.withPrefix(this.visitSpace(c.getPrefix(), JsSpace.Location.ARRAY_BINDING_PATTERN_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(c = c.withMarkers(this.visitMarkers(c.getMarkers(), p)), p);
        if (!(temp instanceof JS.ArrayBindingPattern)) {
            return temp;
        }
        c = (JS.ArrayBindingPattern)temp;
        c = c.getPadding().withElements(Objects.requireNonNull(this.visitContainer(c.getPadding().getElements(), JsContainer.Location.ARRAY_BINDING_PATTERN_ELEMENTS, p)));
        return c;
    }

    public J visitAssignmentOperationExtensions(JS.AssignmentOperation assignOp, P p) {
        JS.AssignmentOperation a = assignOp;
        a = a.withPrefix(this.visitSpace(a.getPrefix(), JsSpace.Location.ASSIGNMENT_OPERATION_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(a = a.withMarkers(this.visitMarkers(a.getMarkers(), p)), p);
        if (!(temp instanceof JS.AssignmentOperation)) {
            return temp;
        }
        a = (JS.AssignmentOperation)temp;
        Expression temp2 = (Expression)this.visitExpression(a, p);
        if (!(temp2 instanceof JS.AssignmentOperation)) {
            return temp2;
        }
        a = (JS.AssignmentOperation)temp2;
        a = a.withVariable(Objects.requireNonNull((Expression)this.visitAndCast((Tree)a.getVariable(), p)));
        a = a.getPadding().withOperator(Objects.requireNonNull(this.visitLeftPadded(a.getPadding().getOperator(), JsLeftPadded.Location.ASSIGNMENT_OPERATION_OPERATOR, p)));
        a = a.withAssignment(Objects.requireNonNull((Expression)this.visitAndCast((Tree)a.getAssignment(), p)));
        a = a.withType(this.visitType(a.getType(), p));
        return a;
    }

    public J visitTypeTreeExpression(JS.TypeTreeExpression typeTreeExpression, P p) {
        JS.TypeTreeExpression a = typeTreeExpression;
        a = a.withPrefix(this.visitSpace(a.getPrefix(), JsSpace.Location.TYPE_TREE_EXPRESSION_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(a = a.withMarkers(this.visitMarkers(a.getMarkers(), p)), p);
        if (!(temp instanceof JS.TypeTreeExpression)) {
            return temp;
        }
        a = (JS.TypeTreeExpression)temp;
        a = a.withExpression(Objects.requireNonNull((Expression)this.visitAndCast((Tree)a.getExpression(), p)));
        a = a.withType(this.visitType(a.getType(), p));
        return a;
    }

    public J visitWithStatement(JS.WithStatement withStatement, P p) {
        JS.WithStatement w = withStatement;
        w = w.withPrefix(this.visitSpace(w.getPrefix(), JsSpace.Location.WITH_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(w = w.withMarkers(this.visitMarkers(w.getMarkers(), p)), p);
        if (!(temp instanceof JS.WithStatement)) {
            return temp;
        }
        w = (JS.WithStatement)temp;
        w = w.withExpression((J.ControlParentheses<Expression>)Objects.requireNonNull((J.ControlParentheses)this.visitAndCast((Tree)w.getExpression(), p)));
        w = w.getPadding().withBody(Objects.requireNonNull(this.visitRightPadded(w.getPadding().getBody(), JsRightPadded.Location.WITH_BODY, p)));
        return w;
    }

    public J visitJsxTag(JSX.Tag tag, P p) {
        JSX.Tag t = tag;
        t = t.withPrefix(this.visitSpace(t.getPrefix(), Space.Location.LANGUAGE_EXTENSION, p));
        Expression temp = (Expression)this.visitExpression(t = t.withMarkers(this.visitMarkers(t.getMarkers(), p)), p);
        if (!(temp instanceof JSX.Tag)) {
            return temp;
        }
        t = (JSX.Tag)temp;
        t = t.getPadding().withOpenName((JLeftPadded<NameTree>)Objects.requireNonNull(this.visitLeftPadded(t.getPadding().getOpenName(), JLeftPadded.Location.LANGUAGE_EXTENSION, p)));
        t = t.withAfterName(this.visitSpace(t.getAfterName(), Space.Location.LANGUAGE_EXTENSION, p));
        if ((t = t.getPadding().withAttributes(Objects.requireNonNull(ListUtils.map(t.getPadding().getAttributes(), attr -> this.visitRightPadded((JRightPadded)attr, JRightPadded.Location.LANGUAGE_EXTENSION, p))))).isSelfClosing()) {
            t = t.withSelfClosing(this.visitSpace(Objects.requireNonNull(t.getSelfClosing()), Space.Location.LANGUAGE_EXTENSION, p));
        } else if (t.hasChildren()) {
            t = t.withChildren(ListUtils.map(t.getChildren(), child -> (Expression)this.visitAndCast((Tree)child, p)));
            t = t.getPadding().withClosingName((JLeftPadded<J>)Objects.requireNonNull(this.visitLeftPadded(t.getPadding().getClosingName(), JLeftPadded.Location.LANGUAGE_EXTENSION, p)));
            t = t.withAfterClosingName(this.visitSpace(Objects.requireNonNull(t.getAfterClosingName()), Space.Location.LANGUAGE_EXTENSION, p));
        }
        t = (JSX.Tag)t.withType(this.visitType(t.getType(), p));
        return t;
    }

    public J visitJsxAttribute(JSX.Attribute attribute, P p) {
        JSX.Attribute a = attribute;
        a = a.withPrefix(this.visitSpace(a.getPrefix(), Space.Location.LANGUAGE_EXTENSION, p));
        a = a.withMarkers(this.visitMarkers(a.getMarkers(), p));
        if ((a = a.withKey(Objects.requireNonNull((NameTree)this.visitAndCast((Tree)a.getKey(), p)))).getPadding().getValue() != null) {
            a = a.getPadding().withValue((JLeftPadded<Expression>)this.visitLeftPadded(a.getPadding().getValue(), JLeftPadded.Location.LANGUAGE_EXTENSION, p));
        }
        return a;
    }

    public J visitJsxSpreadAttribute(JSX.SpreadAttribute spreadAttribute, P p) {
        JSX.SpreadAttribute s = spreadAttribute;
        s = s.withPrefix(this.visitSpace(s.getPrefix(), Space.Location.LANGUAGE_EXTENSION, p));
        s = s.withMarkers(this.visitMarkers(s.getMarkers(), p));
        s = s.withDots(this.visitSpace(s.getDots(), Space.Location.LANGUAGE_EXTENSION, p));
        s = s.getPadding().withExpression((JRightPadded<Expression>)Objects.requireNonNull(this.visitRightPadded(s.getPadding().getExpression(), JRightPadded.Location.LANGUAGE_EXTENSION, p)));
        return s;
    }

    public J visitJsxEmbeddedExpression(JSX.EmbeddedExpression embeddedExpression, P p) {
        JSX.EmbeddedExpression e = embeddedExpression;
        e = e.withPrefix(this.visitSpace(e.getPrefix(), Space.Location.LANGUAGE_EXTENSION, p));
        Expression temp = (Expression)this.visitExpression(e = e.withMarkers(this.visitMarkers(e.getMarkers(), p)), p);
        if (!(temp instanceof JSX.EmbeddedExpression)) {
            return temp;
        }
        e = (JSX.EmbeddedExpression)temp;
        e = e.getPadding().withExpression((JRightPadded<Expression>)Objects.requireNonNull(this.visitRightPadded(e.getPadding().getExpression(), JRightPadded.Location.LANGUAGE_EXTENSION, p)));
        return e;
    }

    public J visitJsxNamespacedName(JSX.NamespacedName namespacedName, P p) {
        JSX.NamespacedName n = namespacedName;
        n = n.withPrefix(this.visitSpace(n.getPrefix(), Space.Location.LANGUAGE_EXTENSION, p));
        n = n.withMarkers(this.visitMarkers(n.getMarkers(), p));
        n = n.withNamespace(Objects.requireNonNull((J.Identifier)this.visitAndCast((Tree)n.getNamespace(), p)));
        n = n.getPadding().withName((JLeftPadded<J.Identifier>)Objects.requireNonNull(this.visitLeftPadded(n.getPadding().getName(), JLeftPadded.Location.LANGUAGE_EXTENSION, p)));
        return n;
    }
}

