/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript.tree;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.beans.Transient;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Checksum;
import org.openrewrite.Cursor;
import org.openrewrite.FileAttributes;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.config.Environment;
import org.openrewrite.internal.ManagedThreadLocal;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaPrinter;
import org.openrewrite.java.JavaTypeVisitor;
import org.openrewrite.java.internal.TypesInUse;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.CoordinateBuilder;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Loop;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.java.tree.TypedTree;
import org.openrewrite.java.tree.VariableDeclarator;
import org.openrewrite.javascript.JavaScriptVisitor;
import org.openrewrite.javascript.internal.rpc.JavaScriptReceiver;
import org.openrewrite.javascript.internal.rpc.JavaScriptSender;
import org.openrewrite.javascript.rpc.JavaScriptRewriteRpc;
import org.openrewrite.marker.Markers;
import org.openrewrite.rpc.RpcReceiveQueue;
import org.openrewrite.rpc.RpcSendQueue;
import org.openrewrite.rpc.request.Print;

public interface JS
extends J {
    default public <R extends Tree, P> R accept(TreeVisitor<R, P> v, P p) {
        return (R)this.acceptJavaScript((JavaScriptVisitor)v.adapt(JavaScriptVisitor.class), p);
    }

    default public <P> boolean isAcceptable(TreeVisitor<?, P> v, P p) {
        return v.isAdaptableTo(JavaScriptVisitor.class);
    }

    default public <P> @Nullable J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
        return (J)v.defaultValue((Tree)this, p);
    }

    public Space getPrefix();

    default public List<Comment> getComments() {
        return this.getPrefix().getComments();
    }

    default public void rpcSend(J after, RpcSendQueue q) {
        new JavaScriptSender().visit((Tree)after, q);
    }

    default public J rpcReceive(J before, RpcReceiveQueue q) {
        return (J)new JavaScriptReceiver().visitNonNull((Tree)before, q);
    }

    public static final class TypeTreeExpression
    implements JS,
    Expression,
    TypeTree {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression expression;

        public @Nullable JavaType getType() {
            return this.expression.getType();
        }

        public TypeTreeExpression withType(@Nullable JavaType type) {
            return this.expression.getType() == type ? this : new TypeTreeExpression(this.id, this.prefix, this.markers, (Expression)this.expression.withType(type));
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitTypeTreeExpression(this, p);
        }

        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public Expression getExpression() {
            return this.expression;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TypeTreeExpression)) {
                return false;
            }
            TypeTreeExpression other = (TypeTreeExpression)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public TypeTreeExpression(UUID id, Space prefix, Markers markers, Expression expression) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.expression = expression;
        }

        @NonNull
        @Generated
        public TypeTreeExpression withId(UUID id) {
            return this.id == id ? this : new TypeTreeExpression(id, this.prefix, this.markers, this.expression);
        }

        @NonNull
        @Generated
        public TypeTreeExpression withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new TypeTreeExpression(this.id, prefix, this.markers, this.expression);
        }

        @NonNull
        @Generated
        public TypeTreeExpression withMarkers(Markers markers) {
            return this.markers == markers ? this : new TypeTreeExpression(this.id, this.prefix, markers, this.expression);
        }

        @NonNull
        @Generated
        public TypeTreeExpression withExpression(Expression expression) {
            return this.expression == expression ? this : new TypeTreeExpression(this.id, this.prefix, this.markers, expression);
        }
    }

    public static final class AssignmentOperation
    implements JS,
    Statement,
    Expression,
    TypedTree {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression variable;
        private final JLeftPadded<Type> operator;
        private final Expression assignment;
        private final @Nullable JavaType type;

        public Type getOperator() {
            return (Type)((Object)this.operator.getElement());
        }

        public AssignmentOperation withOperator(Type operator) {
            return this.getPadding().withOperator((JLeftPadded<Type>)this.operator.withElement((Object)operator));
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitAssignmentOperationExtensions(this, p);
        }

        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        @Transient
        public List<J> getSideEffects() {
            return Collections.singletonList(this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed((TreeVisitor)new JavaPrinter());
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AssignmentOperation)) {
                return false;
            }
            AssignmentOperation other = (AssignmentOperation)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public AssignmentOperation(UUID id, Space prefix, Markers markers, Expression variable, JLeftPadded<Type> operator, Expression assignment, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.variable = variable;
            this.operator = operator;
            this.assignment = assignment;
            this.type = type;
        }

        @Generated
        private AssignmentOperation(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Expression variable, JLeftPadded<Type> operator, Expression assignment, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.variable = variable;
            this.operator = operator;
            this.assignment = assignment;
            this.type = type;
        }

        @NonNull
        @Generated
        public AssignmentOperation withId(UUID id) {
            return this.id == id ? this : new AssignmentOperation(this.padding, id, this.prefix, this.markers, this.variable, this.operator, this.assignment, this.type);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public AssignmentOperation withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new AssignmentOperation(this.padding, this.id, prefix, this.markers, this.variable, this.operator, this.assignment, this.type);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public AssignmentOperation withMarkers(Markers markers) {
            return this.markers == markers ? this : new AssignmentOperation(this.padding, this.id, this.prefix, markers, this.variable, this.operator, this.assignment, this.type);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public AssignmentOperation withVariable(Expression variable) {
            return this.variable == variable ? this : new AssignmentOperation(this.padding, this.id, this.prefix, this.markers, variable, this.operator, this.assignment, this.type);
        }

        @Generated
        public Expression getVariable() {
            return this.variable;
        }

        @NonNull
        @Generated
        public AssignmentOperation withAssignment(Expression assignment) {
            return this.assignment == assignment ? this : new AssignmentOperation(this.padding, this.id, this.prefix, this.markers, this.variable, this.operator, assignment, this.type);
        }

        @Generated
        public Expression getAssignment() {
            return this.assignment;
        }

        @NonNull
        @Generated
        public AssignmentOperation withType(@Nullable JavaType type) {
            return this.type == type ? this : new AssignmentOperation(this.padding, this.id, this.prefix, this.markers, this.variable, this.operator, this.assignment, type);
        }

        @Generated
        public @Nullable JavaType getType() {
            return this.type;
        }

        public static enum Type {
            QuestionQuestion,
            And,
            Or,
            Power,
            Exp;

        }

        public static class Padding {
            private final AssignmentOperation t;

            public JLeftPadded<Type> getOperator() {
                return this.t.operator;
            }

            public AssignmentOperation withOperator(JLeftPadded<Type> operator) {
                return this.t.operator == operator ? this.t : new AssignmentOperation(this.t.id, this.t.prefix, this.t.markers, this.t.variable, operator, this.t.assignment, this.t.type);
            }

            @Generated
            public Padding(AssignmentOperation t) {
                this.t = t;
            }
        }
    }

    public static final class IndexedAccessType
    implements JS,
    Expression,
    TypeTree {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final TypeTree objectType;
        private final TypeTree indexType;
        private final @Nullable JavaType type;

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitIndexedAccessType(this, p);
        }

        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IndexedAccessType)) {
                return false;
            }
            IndexedAccessType other = (IndexedAccessType)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public IndexedAccessType(UUID id, Space prefix, Markers markers, TypeTree objectType, TypeTree indexType, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.objectType = objectType;
            this.indexType = indexType;
            this.type = type;
        }

        @NonNull
        @Generated
        public IndexedAccessType withId(UUID id) {
            return this.id == id ? this : new IndexedAccessType(id, this.prefix, this.markers, this.objectType, this.indexType, this.type);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public IndexedAccessType withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new IndexedAccessType(this.id, prefix, this.markers, this.objectType, this.indexType, this.type);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public IndexedAccessType withMarkers(Markers markers) {
            return this.markers == markers ? this : new IndexedAccessType(this.id, this.prefix, markers, this.objectType, this.indexType, this.type);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public IndexedAccessType withObjectType(TypeTree objectType) {
            return this.objectType == objectType ? this : new IndexedAccessType(this.id, this.prefix, this.markers, objectType, this.indexType, this.type);
        }

        @Generated
        public TypeTree getObjectType() {
            return this.objectType;
        }

        @NonNull
        @Generated
        public IndexedAccessType withIndexType(TypeTree indexType) {
            return this.indexType == indexType ? this : new IndexedAccessType(this.id, this.prefix, this.markers, this.objectType, indexType, this.type);
        }

        @Generated
        public TypeTree getIndexType() {
            return this.indexType;
        }

        @NonNull
        @Generated
        public IndexedAccessType withType(@Nullable JavaType type) {
            return this.type == type ? this : new IndexedAccessType(this.id, this.prefix, this.markers, this.objectType, this.indexType, type);
        }

        @Generated
        public @Nullable JavaType getType() {
            return this.type;
        }

        public static final class IndexType
        implements JS,
        Expression,
        TypeTree {
            private transient @Nullable WeakReference<Padding> padding;
            private final UUID id;
            private final Space prefix;
            private final Markers markers;
            private final JRightPadded<TypeTree> element;
            private final @Nullable JavaType type;

            public TypeTree getElement() {
                return (TypeTree)this.element.getElement();
            }

            public IndexType withElement(TypeTree element) {
                return this.getPadding().withElement((JRightPadded<TypeTree>)JRightPadded.withElement(this.element, (Object)element));
            }

            @Override
            public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
                return v.visitIndexedAccessTypeIndexType(this, p);
            }

            public CoordinateBuilder.Expression getCoordinates() {
                return new CoordinateBuilder.Expression((J)this);
            }

            public Padding getPadding() {
                Padding p;
                if (this.padding == null) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                } else {
                    p = (Padding)this.padding.get();
                    if (p == null || p.t != this) {
                        p = new Padding(this);
                        this.padding = new WeakReference<Padding>(p);
                    }
                }
                return p;
            }

            @Generated
            public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof IndexType)) {
                    return false;
                }
                IndexType other = (IndexType)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @Generated
            public IndexType(UUID id, Space prefix, Markers markers, JRightPadded<TypeTree> element, @Nullable JavaType type) {
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.element = element;
                this.type = type;
            }

            @Generated
            private IndexType(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JRightPadded<TypeTree> element, @Nullable JavaType type) {
                this.padding = padding;
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.element = element;
                this.type = type;
            }

            @NonNull
            @Generated
            public IndexType withId(UUID id) {
                return this.id == id ? this : new IndexType(this.padding, id, this.prefix, this.markers, this.element, this.type);
            }

            @Generated
            public UUID getId() {
                return this.id;
            }

            @NonNull
            @Generated
            public IndexType withPrefix(Space prefix) {
                return this.prefix == prefix ? this : new IndexType(this.padding, this.id, prefix, this.markers, this.element, this.type);
            }

            @Override
            @Generated
            public Space getPrefix() {
                return this.prefix;
            }

            @NonNull
            @Generated
            public IndexType withMarkers(Markers markers) {
                return this.markers == markers ? this : new IndexType(this.padding, this.id, this.prefix, markers, this.element, this.type);
            }

            @Generated
            public Markers getMarkers() {
                return this.markers;
            }

            @NonNull
            @Generated
            public IndexType withType(@Nullable JavaType type) {
                return this.type == type ? this : new IndexType(this.padding, this.id, this.prefix, this.markers, this.element, type);
            }

            @Generated
            public @Nullable JavaType getType() {
                return this.type;
            }

            public static class Padding {
                private final IndexType t;

                public JRightPadded<TypeTree> getElement() {
                    return this.t.element;
                }

                public IndexType withElement(JRightPadded<TypeTree> element) {
                    return this.t.element == element ? this.t : new IndexType(this.t.id, this.t.prefix, this.t.markers, element, this.t.type);
                }

                @Generated
                public Padding(IndexType t) {
                    this.t = t;
                }
            }
        }
    }

    public static final class ExportSpecifier
    implements JS,
    Expression,
    TypedTree {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JLeftPadded<Boolean> typeOnly;
        private final Expression specifier;
        private final @Nullable JavaType type;

        public boolean isTypeOnly() {
            return (Boolean)this.typeOnly.getElement();
        }

        public ExportSpecifier withTypeOnly(boolean isTypeOnly) {
            return this.getPadding().withTypeOnly((JLeftPadded<Boolean>)JLeftPadded.withElement(this.typeOnly, (Object)isTypeOnly));
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitExportSpecifier(this, p);
        }

        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExportSpecifier)) {
                return false;
            }
            ExportSpecifier other = (ExportSpecifier)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public ExportSpecifier(UUID id, Space prefix, Markers markers, JLeftPadded<Boolean> typeOnly, Expression specifier, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.typeOnly = typeOnly;
            this.specifier = specifier;
            this.type = type;
        }

        @Generated
        private ExportSpecifier(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JLeftPadded<Boolean> typeOnly, Expression specifier, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.typeOnly = typeOnly;
            this.specifier = specifier;
            this.type = type;
        }

        @NonNull
        @Generated
        public ExportSpecifier withId(UUID id) {
            return this.id == id ? this : new ExportSpecifier(this.padding, id, this.prefix, this.markers, this.typeOnly, this.specifier, this.type);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public ExportSpecifier withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ExportSpecifier(this.padding, this.id, prefix, this.markers, this.typeOnly, this.specifier, this.type);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public ExportSpecifier withMarkers(Markers markers) {
            return this.markers == markers ? this : new ExportSpecifier(this.padding, this.id, this.prefix, markers, this.typeOnly, this.specifier, this.type);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public ExportSpecifier withSpecifier(Expression specifier) {
            return this.specifier == specifier ? this : new ExportSpecifier(this.padding, this.id, this.prefix, this.markers, this.typeOnly, specifier, this.type);
        }

        @Generated
        public Expression getSpecifier() {
            return this.specifier;
        }

        @NonNull
        @Generated
        public ExportSpecifier withType(@Nullable JavaType type) {
            return this.type == type ? this : new ExportSpecifier(this.padding, this.id, this.prefix, this.markers, this.typeOnly, this.specifier, type);
        }

        @Generated
        public @Nullable JavaType getType() {
            return this.type;
        }

        public static class Padding {
            private final ExportSpecifier t;

            public JLeftPadded<Boolean> getTypeOnly() {
                return this.t.typeOnly;
            }

            public ExportSpecifier withTypeOnly(JLeftPadded<Boolean> typeOnly) {
                return this.t.typeOnly == typeOnly ? this.t : new ExportSpecifier(this.t.id, this.t.prefix, this.t.markers, typeOnly, this.t.specifier, this.t.type);
            }

            @Generated
            public Padding(ExportSpecifier t) {
                this.t = t;
            }
        }
    }

    public static final class NamedExports
    implements JS,
    Expression {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JContainer<Expression> elements;
        private final @Nullable JavaType type;

        public List<Expression> getElements() {
            return this.elements.getElements();
        }

        public NamedExports withElements(List<Expression> elements) {
            return this.getPadding().withElements((JContainer<Expression>)JContainer.withElements(this.elements, elements));
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitNamedExports(this, p);
        }

        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NamedExports)) {
                return false;
            }
            NamedExports other = (NamedExports)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public NamedExports(UUID id, Space prefix, Markers markers, JContainer<Expression> elements, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.elements = elements;
            this.type = type;
        }

        @Generated
        private NamedExports(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JContainer<Expression> elements, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.elements = elements;
            this.type = type;
        }

        @NonNull
        @Generated
        public NamedExports withId(UUID id) {
            return this.id == id ? this : new NamedExports(this.padding, id, this.prefix, this.markers, this.elements, this.type);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public NamedExports withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new NamedExports(this.padding, this.id, prefix, this.markers, this.elements, this.type);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public NamedExports withMarkers(Markers markers) {
            return this.markers == markers ? this : new NamedExports(this.padding, this.id, this.prefix, markers, this.elements, this.type);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public NamedExports withType(@Nullable JavaType type) {
            return this.type == type ? this : new NamedExports(this.padding, this.id, this.prefix, this.markers, this.elements, type);
        }

        @Generated
        public @Nullable JavaType getType() {
            return this.type;
        }

        public static class Padding {
            private final NamedExports t;

            public JContainer<Expression> getElements() {
                return this.t.elements;
            }

            public NamedExports withElements(JContainer<Expression> elements) {
                return this.t.elements == elements ? this.t : new NamedExports(this.t.id, this.t.prefix, this.t.markers, elements, this.t.type);
            }

            @Generated
            public Padding(NamedExports t) {
                this.t = t;
            }
        }
    }

    public static final class ExportAssignment
    implements JS,
    Statement {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final boolean exportEquals;
        private final JLeftPadded<Expression> expression;

        public Expression getExpression() {
            return (Expression)this.expression.getElement();
        }

        public ExportAssignment withExpression(Expression expression) {
            return this.getPadding().withExpression((JLeftPadded<Expression>)JLeftPadded.withElement(this.expression, (Object)expression));
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitExportAssignment(this, p);
        }

        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExportAssignment)) {
                return false;
            }
            ExportAssignment other = (ExportAssignment)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public ExportAssignment(UUID id, Space prefix, Markers markers, boolean exportEquals, JLeftPadded<Expression> expression) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.exportEquals = exportEquals;
            this.expression = expression;
        }

        @Generated
        private ExportAssignment(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, boolean exportEquals, JLeftPadded<Expression> expression) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.exportEquals = exportEquals;
            this.expression = expression;
        }

        @NonNull
        @Generated
        public ExportAssignment withId(UUID id) {
            return this.id == id ? this : new ExportAssignment(this.padding, id, this.prefix, this.markers, this.exportEquals, this.expression);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public ExportAssignment withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ExportAssignment(this.padding, this.id, prefix, this.markers, this.exportEquals, this.expression);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public ExportAssignment withMarkers(Markers markers) {
            return this.markers == markers ? this : new ExportAssignment(this.padding, this.id, this.prefix, markers, this.exportEquals, this.expression);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public ExportAssignment withExportEquals(boolean exportEquals) {
            return this.exportEquals == exportEquals ? this : new ExportAssignment(this.padding, this.id, this.prefix, this.markers, exportEquals, this.expression);
        }

        @Generated
        public boolean isExportEquals() {
            return this.exportEquals;
        }

        public static class Padding {
            private final ExportAssignment t;

            public JLeftPadded<Expression> getExpression() {
                return this.t.expression;
            }

            public ExportAssignment withExpression(JLeftPadded<Expression> expression) {
                return this.t.expression == expression ? this.t : new ExportAssignment(this.t.id, this.t.prefix, this.t.markers, this.t.exportEquals, expression);
            }

            @Generated
            public Padding(ExportAssignment t) {
                this.t = t;
            }
        }
    }

    public static final class ExportDeclaration
    implements JS,
    Statement {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<J.Modifier> modifiers;
        private final JLeftPadded<Boolean> typeOnly;
        private final @Nullable Expression exportClause;
        private final @Nullable JLeftPadded<Expression> moduleSpecifier;
        private final @Nullable ImportAttributes attributes;

        public boolean isTypeOnly() {
            return (Boolean)this.typeOnly.getElement();
        }

        public ExportDeclaration withTypeOnly(boolean importType) {
            return this.getPadding().withTypeOnly((JLeftPadded<Boolean>)JLeftPadded.withElement(this.typeOnly, (Object)importType));
        }

        public @Nullable Expression getModuleSpecifier() {
            return this.moduleSpecifier != null ? (Expression)this.moduleSpecifier.getElement() : null;
        }

        public ExportDeclaration withModuleSpecifier(@Nullable Expression moduleSpecifier) {
            return this.getPadding().withModuleSpecifier((JLeftPadded<Expression>)JLeftPadded.withElement(this.moduleSpecifier, (Object)moduleSpecifier));
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitExportDeclaration(this, p);
        }

        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExportDeclaration)) {
                return false;
            }
            ExportDeclaration other = (ExportDeclaration)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public ExportDeclaration(UUID id, Space prefix, Markers markers, List<J.Modifier> modifiers, JLeftPadded<Boolean> typeOnly, @Nullable Expression exportClause, @Nullable JLeftPadded<Expression> moduleSpecifier, @Nullable ImportAttributes attributes) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.modifiers = modifiers;
            this.typeOnly = typeOnly;
            this.exportClause = exportClause;
            this.moduleSpecifier = moduleSpecifier;
            this.attributes = attributes;
        }

        @Generated
        private ExportDeclaration(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, List<J.Modifier> modifiers, JLeftPadded<Boolean> typeOnly, @Nullable Expression exportClause, @Nullable JLeftPadded<Expression> moduleSpecifier, @Nullable ImportAttributes attributes) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.modifiers = modifiers;
            this.typeOnly = typeOnly;
            this.exportClause = exportClause;
            this.moduleSpecifier = moduleSpecifier;
            this.attributes = attributes;
        }

        @NonNull
        @Generated
        public ExportDeclaration withId(UUID id) {
            return this.id == id ? this : new ExportDeclaration(this.padding, id, this.prefix, this.markers, this.modifiers, this.typeOnly, this.exportClause, this.moduleSpecifier, this.attributes);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public ExportDeclaration withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ExportDeclaration(this.padding, this.id, prefix, this.markers, this.modifiers, this.typeOnly, this.exportClause, this.moduleSpecifier, this.attributes);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public ExportDeclaration withMarkers(Markers markers) {
            return this.markers == markers ? this : new ExportDeclaration(this.padding, this.id, this.prefix, markers, this.modifiers, this.typeOnly, this.exportClause, this.moduleSpecifier, this.attributes);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public ExportDeclaration withModifiers(List<J.Modifier> modifiers) {
            return this.modifiers == modifiers ? this : new ExportDeclaration(this.padding, this.id, this.prefix, this.markers, modifiers, this.typeOnly, this.exportClause, this.moduleSpecifier, this.attributes);
        }

        @Generated
        public List<J.Modifier> getModifiers() {
            return this.modifiers;
        }

        @NonNull
        @Generated
        public ExportDeclaration withExportClause(@Nullable Expression exportClause) {
            return this.exportClause == exportClause ? this : new ExportDeclaration(this.padding, this.id, this.prefix, this.markers, this.modifiers, this.typeOnly, exportClause, this.moduleSpecifier, this.attributes);
        }

        @Generated
        public @Nullable Expression getExportClause() {
            return this.exportClause;
        }

        @NonNull
        @Generated
        public ExportDeclaration withAttributes(@Nullable ImportAttributes attributes) {
            return this.attributes == attributes ? this : new ExportDeclaration(this.padding, this.id, this.prefix, this.markers, this.modifiers, this.typeOnly, this.exportClause, this.moduleSpecifier, attributes);
        }

        @Generated
        public @Nullable ImportAttributes getAttributes() {
            return this.attributes;
        }

        public static class Padding {
            private final ExportDeclaration t;

            public JLeftPadded<Boolean> getTypeOnly() {
                return this.t.typeOnly;
            }

            public ExportDeclaration withTypeOnly(JLeftPadded<Boolean> typeOnly) {
                return this.t.typeOnly == typeOnly ? this.t : new ExportDeclaration(this.t.id, this.t.prefix, this.t.markers, this.t.modifiers, typeOnly, this.t.exportClause, (JLeftPadded<Expression>)this.t.moduleSpecifier, this.t.attributes);
            }

            public @Nullable JLeftPadded<Expression> getModuleSpecifier() {
                return this.t.moduleSpecifier;
            }

            public ExportDeclaration withModuleSpecifier(@Nullable JLeftPadded<Expression> moduleSpecifier) {
                return this.t.moduleSpecifier == moduleSpecifier ? this.t : new ExportDeclaration(this.t.id, this.t.prefix, this.t.markers, this.t.modifiers, (JLeftPadded<Boolean>)this.t.typeOnly, this.t.exportClause, moduleSpecifier, this.t.attributes);
            }

            @Generated
            public Padding(ExportDeclaration t) {
                this.t = t;
            }
        }
    }

    public static final class BindingElement
    implements JS,
    Statement,
    Expression,
    TypeTree {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final @Nullable JRightPadded<Expression> propertyName;
        private final TypedTree name;
        private final @Nullable JLeftPadded<Expression> initializer;
        private final // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable JavaType.Variable variableType;

        public @Nullable Expression getPropertyName() {
            return this.propertyName == null ? null : (Expression)this.propertyName.getElement();
        }

        public BindingElement withPropertyName(@Nullable Expression propertyName) {
            return this.getPadding().withPropertyName((JRightPadded<Expression>)JRightPadded.withElement(this.propertyName, (Object)propertyName));
        }

        public @Nullable Expression getInitializer() {
            return this.initializer == null ? null : (Expression)this.initializer.getElement();
        }

        public BindingElement withInitializer(@Nullable Expression initializer) {
            return this.getPadding().withInitializer((JLeftPadded<Expression>)JLeftPadded.withElement(this.initializer, (Object)initializer));
        }

        public @Nullable JavaType getType() {
            return this.variableType != null ? this.variableType.getType() : null;
        }

        public BindingElement withType(@Nullable JavaType type) {
            return this.variableType != null ? this.withVariableType(this.variableType.withType(type)) : this;
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitBindingElement(this, p);
        }

        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BindingElement)) {
                return false;
            }
            BindingElement other = (BindingElement)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public BindingElement(UUID id, Space prefix, Markers markers, @Nullable JRightPadded<Expression> propertyName, TypedTree name, @Nullable JLeftPadded<Expression> initializer, // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable JavaType.Variable variableType) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.propertyName = propertyName;
            this.name = name;
            this.initializer = initializer;
            this.variableType = variableType;
        }

        @Generated
        private BindingElement(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, @Nullable JRightPadded<Expression> propertyName, TypedTree name, @Nullable JLeftPadded<Expression> initializer, // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable JavaType.Variable variableType) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.propertyName = propertyName;
            this.name = name;
            this.initializer = initializer;
            this.variableType = variableType;
        }

        @NonNull
        @Generated
        public BindingElement withId(UUID id) {
            return this.id == id ? this : new BindingElement(this.padding, id, this.prefix, this.markers, this.propertyName, this.name, this.initializer, this.variableType);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public BindingElement withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new BindingElement(this.padding, this.id, prefix, this.markers, this.propertyName, this.name, this.initializer, this.variableType);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public BindingElement withMarkers(Markers markers) {
            return this.markers == markers ? this : new BindingElement(this.padding, this.id, this.prefix, markers, this.propertyName, this.name, this.initializer, this.variableType);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public BindingElement withName(TypedTree name) {
            return this.name == name ? this : new BindingElement(this.padding, this.id, this.prefix, this.markers, this.propertyName, name, this.initializer, this.variableType);
        }

        @Generated
        public TypedTree getName() {
            return this.name;
        }

        @NonNull
        @Generated
        public BindingElement withVariableType(// Could not load outer class - annotation placement on inner may be incorrect
        @Nullable JavaType.Variable variableType) {
            return this.variableType == variableType ? this : new BindingElement(this.padding, this.id, this.prefix, this.markers, this.propertyName, this.name, this.initializer, variableType);
        }

        @Generated
        public // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable JavaType.Variable getVariableType() {
            return this.variableType;
        }

        public static class Padding {
            private final BindingElement t;

            public @Nullable JRightPadded<Expression> getPropertyName() {
                return this.t.propertyName;
            }

            public BindingElement withPropertyName(@Nullable JRightPadded<Expression> propertyName) {
                return this.t.propertyName == propertyName ? this.t : new BindingElement(this.t.id, this.t.prefix, this.t.markers, propertyName, this.t.name, (JLeftPadded<Expression>)this.t.initializer, this.t.variableType);
            }

            public @Nullable JLeftPadded<Expression> getInitializer() {
                return this.t.initializer;
            }

            public BindingElement withInitializer(@Nullable JLeftPadded<Expression> initializer) {
                return this.t.initializer == initializer ? this.t : new BindingElement(this.t.id, this.t.prefix, this.t.markers, (JRightPadded<Expression>)this.t.propertyName, this.t.name, initializer, this.t.variableType);
            }

            @Generated
            public Padding(BindingElement t) {
                this.t = t;
            }
        }
    }

    public static final class ArrayBindingPattern
    implements JS,
    Expression,
    TypedTree,
    VariableDeclarator {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JContainer<Expression> elements;
        private final @Nullable JavaType type;

        public List<Expression> getElements() {
            return this.elements.getElements();
        }

        public ArrayBindingPattern withElements(List<Expression> elements) {
            return this.getPadding().withElements((JContainer<Expression>)JContainer.withElements(this.elements, elements));
        }

        public List<J.Identifier> getNames() {
            ArrayList<J.Identifier> list = new ArrayList<J.Identifier>();
            for (Expression e : this.elements.getElements()) {
                if (!(e instanceof J.Identifier)) continue;
                list.add((J.Identifier)e);
            }
            return list;
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitArrayBindingPattern(this, p);
        }

        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.abp != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ArrayBindingPattern)) {
                return false;
            }
            ArrayBindingPattern other = (ArrayBindingPattern)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public ArrayBindingPattern(UUID id, Space prefix, Markers markers, JContainer<Expression> elements, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.elements = elements;
            this.type = type;
        }

        @Generated
        private ArrayBindingPattern(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JContainer<Expression> elements, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.elements = elements;
            this.type = type;
        }

        @NonNull
        @Generated
        public ArrayBindingPattern withId(UUID id) {
            return this.id == id ? this : new ArrayBindingPattern(this.padding, id, this.prefix, this.markers, this.elements, this.type);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public ArrayBindingPattern withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ArrayBindingPattern(this.padding, this.id, prefix, this.markers, this.elements, this.type);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public ArrayBindingPattern withMarkers(Markers markers) {
            return this.markers == markers ? this : new ArrayBindingPattern(this.padding, this.id, this.prefix, markers, this.elements, this.type);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public ArrayBindingPattern withType(@Nullable JavaType type) {
            return this.type == type ? this : new ArrayBindingPattern(this.padding, this.id, this.prefix, this.markers, this.elements, type);
        }

        @Generated
        public @Nullable JavaType getType() {
            return this.type;
        }

        public static class Padding {
            private final ArrayBindingPattern abp;

            public JContainer<Expression> getElements() {
                return this.abp.elements;
            }

            public ArrayBindingPattern withElements(JContainer<Expression> elements) {
                return this.abp.elements == elements ? this.abp : new ArrayBindingPattern(this.abp.id, this.abp.prefix, this.abp.markers, elements, this.abp.type);
            }

            @Generated
            public Padding(ArrayBindingPattern abp) {
                this.abp = abp;
            }
        }
    }

    public static final class IndexSignatureDeclaration
    implements JS,
    Statement,
    TypedTree {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<J.Modifier> modifiers;
        private final JContainer<J> parameters;
        private final JLeftPadded<Expression> typeExpression;
        private final @Nullable JavaType type;

        public List<J> getParameters() {
            return this.parameters.getElements();
        }

        public IndexSignatureDeclaration withParameters(List<J> parameters) {
            return this.getPadding().withParameters((JContainer<J>)JContainer.withElements(this.parameters, parameters));
        }

        public Expression getTypeExpression() {
            return (Expression)this.typeExpression.getElement();
        }

        public IndexSignatureDeclaration withTypeExpression(Expression typeExpression) {
            return this.getPadding().withTypeExpression((JLeftPadded<Expression>)JLeftPadded.withElement(this.typeExpression, (Object)typeExpression));
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitIndexSignatureDeclaration(this, p);
        }

        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.isd != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IndexSignatureDeclaration)) {
                return false;
            }
            IndexSignatureDeclaration other = (IndexSignatureDeclaration)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public IndexSignatureDeclaration(UUID id, Space prefix, Markers markers, List<J.Modifier> modifiers, JContainer<J> parameters, JLeftPadded<Expression> typeExpression, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.modifiers = modifiers;
            this.parameters = parameters;
            this.typeExpression = typeExpression;
            this.type = type;
        }

        @Generated
        private IndexSignatureDeclaration(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, List<J.Modifier> modifiers, JContainer<J> parameters, JLeftPadded<Expression> typeExpression, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.modifiers = modifiers;
            this.parameters = parameters;
            this.typeExpression = typeExpression;
            this.type = type;
        }

        @NonNull
        @Generated
        public IndexSignatureDeclaration withId(UUID id) {
            return this.id == id ? this : new IndexSignatureDeclaration(this.padding, id, this.prefix, this.markers, this.modifiers, this.parameters, this.typeExpression, this.type);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public IndexSignatureDeclaration withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new IndexSignatureDeclaration(this.padding, this.id, prefix, this.markers, this.modifiers, this.parameters, this.typeExpression, this.type);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public IndexSignatureDeclaration withMarkers(Markers markers) {
            return this.markers == markers ? this : new IndexSignatureDeclaration(this.padding, this.id, this.prefix, markers, this.modifiers, this.parameters, this.typeExpression, this.type);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public List<J.Modifier> getModifiers() {
            return this.modifiers;
        }

        @NonNull
        @Generated
        public IndexSignatureDeclaration withModifiers(List<J.Modifier> modifiers) {
            return this.modifiers == modifiers ? this : new IndexSignatureDeclaration(this.padding, this.id, this.prefix, this.markers, modifiers, this.parameters, this.typeExpression, this.type);
        }

        @NonNull
        @Generated
        public IndexSignatureDeclaration withType(@Nullable JavaType type) {
            return this.type == type ? this : new IndexSignatureDeclaration(this.padding, this.id, this.prefix, this.markers, this.modifiers, this.parameters, this.typeExpression, type);
        }

        @Generated
        public @Nullable JavaType getType() {
            return this.type;
        }

        public static class Padding {
            private final IndexSignatureDeclaration isd;

            public JContainer<J> getParameters() {
                return this.isd.parameters;
            }

            public IndexSignatureDeclaration withParameters(JContainer<J> parameters) {
                return this.isd.parameters == parameters ? this.isd : new IndexSignatureDeclaration(this.isd.id, this.isd.prefix, this.isd.markers, this.isd.modifiers, parameters, (JLeftPadded<Expression>)this.isd.typeExpression, this.isd.type);
            }

            public JLeftPadded<Expression> getTypeExpression() {
                return this.isd.typeExpression;
            }

            public IndexSignatureDeclaration withTypeExpression(JLeftPadded<Expression> typeExpression) {
                return this.isd.typeExpression == typeExpression ? this.isd : new IndexSignatureDeclaration(this.isd.id, this.isd.prefix, this.isd.markers, this.isd.modifiers, (JContainer<J>)this.isd.parameters, typeExpression, this.isd.type);
            }

            @Generated
            public Padding(IndexSignatureDeclaration isd) {
                this.isd = isd;
            }
        }
    }

    public static final class TypeLiteral
    implements JS,
    Expression,
    TypeTree {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final J.Block members;
        private final @Nullable JavaType type;

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitTypeLiteral(this, p);
        }

        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public J.Block getMembers() {
            return this.members;
        }

        @Generated
        public @Nullable JavaType getType() {
            return this.type;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TypeLiteral)) {
                return false;
            }
            TypeLiteral other = (TypeLiteral)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public TypeLiteral(UUID id, Space prefix, Markers markers, J.Block members, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.members = members;
            this.type = type;
        }

        @NonNull
        @Generated
        public TypeLiteral withId(UUID id) {
            return this.id == id ? this : new TypeLiteral(id, this.prefix, this.markers, this.members, this.type);
        }

        @NonNull
        @Generated
        public TypeLiteral withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new TypeLiteral(this.id, prefix, this.markers, this.members, this.type);
        }

        @NonNull
        @Generated
        public TypeLiteral withMarkers(Markers markers) {
            return this.markers == markers ? this : new TypeLiteral(this.id, this.prefix, markers, this.members, this.type);
        }

        @NonNull
        @Generated
        public TypeLiteral withMembers(J.Block members) {
            return this.members == members ? this : new TypeLiteral(this.id, this.prefix, this.markers, members, this.type);
        }

        @NonNull
        @Generated
        public TypeLiteral withType(@Nullable JavaType type) {
            return this.type == type ? this : new TypeLiteral(this.id, this.prefix, this.markers, this.members, type);
        }
    }

    public static final class NamespaceDeclaration
    implements JS,
    Statement {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<J.Modifier> modifiers;
        private final JLeftPadded<KeywordType> keywordType;
        private final JRightPadded<Expression> name;
        private final // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.Block body;

        public KeywordType getKeywordType() {
            return (KeywordType)((Object)this.keywordType.getElement());
        }

        public NamespaceDeclaration withKeywordType(KeywordType kt) {
            return this.getPadding().withKeywordType((JLeftPadded<KeywordType>)JLeftPadded.withElement(this.keywordType, (Object)((Object)kt)));
        }

        public Expression getName() {
            return (Expression)this.name.getElement();
        }

        public NamespaceDeclaration withName(Expression expression) {
            return this.getPadding().withName((JRightPadded<Expression>)JRightPadded.withElement(this.name, (Object)expression));
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitNamespaceDeclaration(this, p);
        }

        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NamespaceDeclaration)) {
                return false;
            }
            NamespaceDeclaration other = (NamespaceDeclaration)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public NamespaceDeclaration(UUID id, Space prefix, Markers markers, List<J.Modifier> modifiers, JLeftPadded<KeywordType> keywordType, JRightPadded<Expression> name, // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.Block body) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.modifiers = modifiers;
            this.keywordType = keywordType;
            this.name = name;
            this.body = body;
        }

        @Generated
        private NamespaceDeclaration(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, List<J.Modifier> modifiers, JLeftPadded<KeywordType> keywordType, JRightPadded<Expression> name, // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.Block body) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.modifiers = modifiers;
            this.keywordType = keywordType;
            this.name = name;
            this.body = body;
        }

        @NonNull
        @Generated
        public NamespaceDeclaration withId(UUID id) {
            return this.id == id ? this : new NamespaceDeclaration(this.padding, id, this.prefix, this.markers, this.modifiers, this.keywordType, this.name, this.body);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public NamespaceDeclaration withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new NamespaceDeclaration(this.padding, this.id, prefix, this.markers, this.modifiers, this.keywordType, this.name, this.body);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public NamespaceDeclaration withMarkers(Markers markers) {
            return this.markers == markers ? this : new NamespaceDeclaration(this.padding, this.id, this.prefix, markers, this.modifiers, this.keywordType, this.name, this.body);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public NamespaceDeclaration withModifiers(List<J.Modifier> modifiers) {
            return this.modifiers == modifiers ? this : new NamespaceDeclaration(this.padding, this.id, this.prefix, this.markers, modifiers, this.keywordType, this.name, this.body);
        }

        @Generated
        public List<J.Modifier> getModifiers() {
            return this.modifiers;
        }

        @NonNull
        @Generated
        public NamespaceDeclaration withBody(// Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.Block body) {
            return this.body == body ? this : new NamespaceDeclaration(this.padding, this.id, this.prefix, this.markers, this.modifiers, this.keywordType, this.name, body);
        }

        @Generated
        public // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.Block getBody() {
            return this.body;
        }

        public static enum KeywordType {
            Namespace,
            Module,
            Empty;

        }

        public static class Padding {
            private final NamespaceDeclaration t;

            public NamespaceDeclaration withName(JRightPadded<Expression> name) {
                return this.t.name == name ? this.t : new NamespaceDeclaration(this.t.id, this.t.prefix, this.t.markers, this.t.modifiers, (JLeftPadded<KeywordType>)this.t.keywordType, name, this.t.body);
            }

            public JRightPadded<Expression> getName() {
                return this.t.name;
            }

            public JLeftPadded<KeywordType> getKeywordType() {
                return this.t.keywordType;
            }

            public NamespaceDeclaration withKeywordType(JLeftPadded<KeywordType> keywordType) {
                return this.t.keywordType == keywordType ? this.t : new NamespaceDeclaration(this.t.id, this.t.prefix, this.t.markers, this.t.modifiers, keywordType, (JRightPadded<Expression>)this.t.name, this.t.body);
            }

            @Generated
            public Padding(NamespaceDeclaration t) {
                this.t = t;
            }
        }
    }

    public static final class ForInLoop
    implements JS,
    Loop {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final J.ForEachLoop.Control control;
        private final JRightPadded<Statement> body;

        public Statement getBody() {
            return (Statement)this.body.getElement();
        }

        public ForInLoop withBody(Statement body) {
            return this.getPadding().withBody((JRightPadded<Statement>)this.body.withElement((Object)body));
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitForInLoop(this, p);
        }

        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ForInLoop)) {
                return false;
            }
            ForInLoop other = (ForInLoop)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public ForInLoop(UUID id, Space prefix, Markers markers, J.ForEachLoop.Control control, JRightPadded<Statement> body) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.control = control;
            this.body = body;
        }

        @Generated
        private ForInLoop(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, J.ForEachLoop.Control control, JRightPadded<Statement> body) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.control = control;
            this.body = body;
        }

        @NonNull
        @Generated
        public ForInLoop withId(UUID id) {
            return this.id == id ? this : new ForInLoop(this.padding, id, this.prefix, this.markers, this.control, this.body);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public ForInLoop withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ForInLoop(this.padding, this.id, prefix, this.markers, this.control, this.body);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public ForInLoop withMarkers(Markers markers) {
            return this.markers == markers ? this : new ForInLoop(this.padding, this.id, this.prefix, markers, this.control, this.body);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public ForInLoop withControl(J.ForEachLoop.Control control) {
            return this.control == control ? this : new ForInLoop(this.padding, this.id, this.prefix, this.markers, control, this.body);
        }

        @Generated
        public J.ForEachLoop.Control getControl() {
            return this.control;
        }

        public static class Padding {
            private final ForInLoop t;

            public JRightPadded<Statement> getBody() {
                return this.t.body;
            }

            public ForInLoop withBody(JRightPadded<Statement> body) {
                return this.t.body == body ? this.t : new ForInLoop(this.t.id, this.t.prefix, this.t.markers, this.t.control, body);
            }

            @Generated
            public Padding(ForInLoop t) {
                this.t = t;
            }
        }
    }

    public static final class ForOfLoop
    implements JS,
    Loop {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final @Nullable Space await;
        private final J.ForEachLoop loop;

        public Statement getBody() {
            return this.loop.getBody();
        }

        public ForOfLoop withBody(Statement body) {
            return this.withLoop(this.loop.withBody(body));
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitForOfLoop(this, p);
        }

        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        @NonNull
        @Generated
        public String toString() {
            return "JS.ForOfLoop(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", await=" + this.getAwait() + ", loop=" + this.getLoop() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ForOfLoop)) {
                return false;
            }
            ForOfLoop other = (ForOfLoop)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        @Generated
        public ForOfLoop(UUID id, Space prefix, Markers markers, @Nullable Space await, J.ForEachLoop loop) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.await = await;
            this.loop = loop;
        }

        @NonNull
        @Generated
        public ForOfLoop withId(UUID id) {
            return this.id == id ? this : new ForOfLoop(id, this.prefix, this.markers, this.await, this.loop);
        }

        @NonNull
        @Generated
        public ForOfLoop withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ForOfLoop(this.id, prefix, this.markers, this.await, this.loop);
        }

        @NonNull
        @Generated
        public ForOfLoop withMarkers(Markers markers) {
            return this.markers == markers ? this : new ForOfLoop(this.id, this.prefix, markers, this.await, this.loop);
        }

        @NonNull
        @Generated
        public ForOfLoop withAwait(@Nullable Space await) {
            return this.await == await ? this : new ForOfLoop(this.id, this.prefix, this.markers, await, this.loop);
        }

        @NonNull
        @Generated
        public ForOfLoop withLoop(J.ForEachLoop loop) {
            return this.loop == loop ? this : new ForOfLoop(this.id, this.prefix, this.markers, this.await, loop);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public @Nullable Space getAwait() {
            return this.await;
        }

        @Generated
        public J.ForEachLoop getLoop() {
            return this.loop;
        }
    }

    public static final class ComputedPropertyMethodDeclaration
    implements JS,
    Statement,
    TypedTree {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<J.Annotation> leadingAnnotations;
        private final List<J.Modifier> modifiers;
        private final // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.TypeParameters typeParameters;
        private final @Nullable TypeTree returnTypeExpression;
        private final ComputedPropertyName name;
        private final JContainer<Statement> parameters;
        private final // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.Block body;
        private final // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable JavaType.Method methodType;

        public List<Statement> getParameters() {
            return this.parameters.getElements();
        }

        public ComputedPropertyMethodDeclaration withParameters(List<Statement> parameters) {
            return this.getPadding().withParameters((JContainer<Statement>)JContainer.withElements(this.parameters, parameters));
        }

        public ComputedPropertyMethodDeclaration withMethodType(// Could not load outer class - annotation placement on inner may be incorrect
        @Nullable JavaType.Method type) {
            if (type == this.methodType) {
                return this;
            }
            return new ComputedPropertyMethodDeclaration(this.id, this.prefix, this.markers, this.leadingAnnotations, this.modifiers, this.typeParameters, this.returnTypeExpression, this.name, this.parameters, this.body, type);
        }

        public @Nullable JavaType getType() {
            return this.methodType == null ? null : this.methodType.getReturnType();
        }

        public ComputedPropertyMethodDeclaration withType(@Nullable JavaType type) {
            throw new UnsupportedOperationException("To change the return type of this method declaration, use withMethodType(..)");
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitComputedPropertyMethodDeclaration(this, p);
        }

        public boolean isAbstract() {
            return this.body == null;
        }

        public boolean isConstructor() {
            return this.getReturnTypeExpression() == null;
        }

        public boolean hasModifier(J.Modifier.Type modifier) {
            return J.Modifier.hasModifier(this.getModifiers(), (J.Modifier.Type)modifier);
        }

        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        public String toString() {
            return "ComputedPropertyMethodDeclaration{" + (this.getMethodType() == null ? "unknown" : this.getMethodType()) + "}";
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ComputedPropertyMethodDeclaration)) {
                return false;
            }
            ComputedPropertyMethodDeclaration other = (ComputedPropertyMethodDeclaration)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public ComputedPropertyMethodDeclaration(UUID id, Space prefix, Markers markers, List<J.Annotation> leadingAnnotations, List<J.Modifier> modifiers, // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.TypeParameters typeParameters, @Nullable TypeTree returnTypeExpression, ComputedPropertyName name, JContainer<Statement> parameters, // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.Block body, // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable JavaType.Method methodType) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.leadingAnnotations = leadingAnnotations;
            this.modifiers = modifiers;
            this.typeParameters = typeParameters;
            this.returnTypeExpression = returnTypeExpression;
            this.name = name;
            this.parameters = parameters;
            this.body = body;
            this.methodType = methodType;
        }

        @Generated
        private ComputedPropertyMethodDeclaration(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, List<J.Annotation> leadingAnnotations, List<J.Modifier> modifiers, // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.TypeParameters typeParameters, @Nullable TypeTree returnTypeExpression, ComputedPropertyName name, JContainer<Statement> parameters, // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.Block body, // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable JavaType.Method methodType) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.leadingAnnotations = leadingAnnotations;
            this.modifiers = modifiers;
            this.typeParameters = typeParameters;
            this.returnTypeExpression = returnTypeExpression;
            this.name = name;
            this.parameters = parameters;
            this.body = body;
            this.methodType = methodType;
        }

        @Generated
        public // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.TypeParameters getTypeParameters() {
            return this.typeParameters;
        }

        @Generated
        public void setPadding(@Nullable WeakReference<Padding> padding) {
            this.padding = padding;
        }

        @NonNull
        @Generated
        public ComputedPropertyMethodDeclaration withId(UUID id) {
            return this.id == id ? this : new ComputedPropertyMethodDeclaration(this.padding, id, this.prefix, this.markers, this.leadingAnnotations, this.modifiers, this.typeParameters, this.returnTypeExpression, this.name, this.parameters, this.body, this.methodType);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public ComputedPropertyMethodDeclaration withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ComputedPropertyMethodDeclaration(this.padding, this.id, prefix, this.markers, this.leadingAnnotations, this.modifiers, this.typeParameters, this.returnTypeExpression, this.name, this.parameters, this.body, this.methodType);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public ComputedPropertyMethodDeclaration withMarkers(Markers markers) {
            return this.markers == markers ? this : new ComputedPropertyMethodDeclaration(this.padding, this.id, this.prefix, markers, this.leadingAnnotations, this.modifiers, this.typeParameters, this.returnTypeExpression, this.name, this.parameters, this.body, this.methodType);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public ComputedPropertyMethodDeclaration withLeadingAnnotations(List<J.Annotation> leadingAnnotations) {
            return this.leadingAnnotations == leadingAnnotations ? this : new ComputedPropertyMethodDeclaration(this.padding, this.id, this.prefix, this.markers, leadingAnnotations, this.modifiers, this.typeParameters, this.returnTypeExpression, this.name, this.parameters, this.body, this.methodType);
        }

        @Generated
        public List<J.Annotation> getLeadingAnnotations() {
            return this.leadingAnnotations;
        }

        @NonNull
        @Generated
        public ComputedPropertyMethodDeclaration withModifiers(List<J.Modifier> modifiers) {
            return this.modifiers == modifiers ? this : new ComputedPropertyMethodDeclaration(this.padding, this.id, this.prefix, this.markers, this.leadingAnnotations, modifiers, this.typeParameters, this.returnTypeExpression, this.name, this.parameters, this.body, this.methodType);
        }

        @Generated
        public List<J.Modifier> getModifiers() {
            return this.modifiers;
        }

        @NonNull
        @Generated
        public ComputedPropertyMethodDeclaration withTypeParameters(// Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.TypeParameters typeParameters) {
            return this.typeParameters == typeParameters ? this : new ComputedPropertyMethodDeclaration(this.padding, this.id, this.prefix, this.markers, this.leadingAnnotations, this.modifiers, typeParameters, this.returnTypeExpression, this.name, this.parameters, this.body, this.methodType);
        }

        @NonNull
        @Generated
        public ComputedPropertyMethodDeclaration withReturnTypeExpression(@Nullable TypeTree returnTypeExpression) {
            return this.returnTypeExpression == returnTypeExpression ? this : new ComputedPropertyMethodDeclaration(this.padding, this.id, this.prefix, this.markers, this.leadingAnnotations, this.modifiers, this.typeParameters, returnTypeExpression, this.name, this.parameters, this.body, this.methodType);
        }

        @Generated
        public @Nullable TypeTree getReturnTypeExpression() {
            return this.returnTypeExpression;
        }

        @NonNull
        @Generated
        public ComputedPropertyMethodDeclaration withName(ComputedPropertyName name) {
            return this.name == name ? this : new ComputedPropertyMethodDeclaration(this.padding, this.id, this.prefix, this.markers, this.leadingAnnotations, this.modifiers, this.typeParameters, this.returnTypeExpression, name, this.parameters, this.body, this.methodType);
        }

        @Generated
        public ComputedPropertyName getName() {
            return this.name;
        }

        @NonNull
        @Generated
        public ComputedPropertyMethodDeclaration withBody(// Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.Block body) {
            return this.body == body ? this : new ComputedPropertyMethodDeclaration(this.padding, this.id, this.prefix, this.markers, this.leadingAnnotations, this.modifiers, this.typeParameters, this.returnTypeExpression, this.name, this.parameters, body, this.methodType);
        }

        @Generated
        public // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.Block getBody() {
            return this.body;
        }

        @Generated
        public // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable JavaType.Method getMethodType() {
            return this.methodType;
        }

        public static class Padding {
            private final ComputedPropertyMethodDeclaration t;

            public JContainer<Statement> getParameters() {
                return this.t.parameters;
            }

            public ComputedPropertyMethodDeclaration withParameters(JContainer<Statement> parameters) {
                return this.t.parameters == parameters ? this.t : new ComputedPropertyMethodDeclaration(this.t.id, this.t.prefix, this.t.markers, this.t.leadingAnnotations, this.t.modifiers, this.t.typeParameters, this.t.returnTypeExpression, this.t.name, parameters, this.t.body, this.t.methodType);
            }

            @Generated
            public Padding(ComputedPropertyMethodDeclaration t) {
                this.t = t;
            }
        }
    }

    public static final class TypeInfo
    implements JS,
    Expression,
    TypeTree {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final TypeTree typeIdentifier;

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitTypeInfo(this, p);
        }

        public @Nullable JavaType getType() {
            return this.typeIdentifier.getType();
        }

        public TypeInfo withType(@Nullable JavaType type) {
            return this.typeIdentifier.getType() == type ? this : new TypeInfo(this.id, this.prefix, this.markers, (TypeTree)this.typeIdentifier.withType(type));
        }

        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public TypeTree getTypeIdentifier() {
            return this.typeIdentifier;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TypeInfo)) {
                return false;
            }
            TypeInfo other = (TypeInfo)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public TypeInfo(UUID id, Space prefix, Markers markers, TypeTree typeIdentifier) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.typeIdentifier = typeIdentifier;
        }

        @NonNull
        @Generated
        public TypeInfo withId(UUID id) {
            return this.id == id ? this : new TypeInfo(id, this.prefix, this.markers, this.typeIdentifier);
        }

        @NonNull
        @Generated
        public TypeInfo withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new TypeInfo(this.id, prefix, this.markers, this.typeIdentifier);
        }

        @NonNull
        @Generated
        public TypeInfo withMarkers(Markers markers) {
            return this.markers == markers ? this : new TypeInfo(this.id, this.prefix, markers, this.typeIdentifier);
        }

        @NonNull
        @Generated
        public TypeInfo withTypeIdentifier(TypeTree typeIdentifier) {
            return this.typeIdentifier == typeIdentifier ? this : new TypeInfo(this.id, this.prefix, this.markers, typeIdentifier);
        }
    }

    public static final class Void
    implements JS,
    Expression,
    Statement {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression expression;

        public JavaType getType() {
            return JavaType.Primitive.Void;
        }

        public <T extends J> T withType(@Nullable JavaType type) {
            return (T)this;
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitVoid(this, p);
        }

        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Void)) {
                return false;
            }
            Void other = (Void)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public Void(UUID id, Space prefix, Markers markers, Expression expression) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.expression = expression;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public Expression getExpression() {
            return this.expression;
        }

        @NonNull
        @Generated
        public String toString() {
            return "JS.Void(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", expression=" + this.getExpression() + ")";
        }

        @NonNull
        @Generated
        public Void withId(UUID id) {
            return this.id == id ? this : new Void(id, this.prefix, this.markers, this.expression);
        }

        @NonNull
        @Generated
        public Void withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Void(this.id, prefix, this.markers, this.expression);
        }

        @NonNull
        @Generated
        public Void withMarkers(Markers markers) {
            return this.markers == markers ? this : new Void(this.id, this.prefix, markers, this.expression);
        }

        @NonNull
        @Generated
        public Void withExpression(Expression expression) {
            return this.expression == expression ? this : new Void(this.id, this.prefix, this.markers, expression);
        }
    }

    public static final class Intersection
    implements JS,
    Expression,
    TypeTree {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<JRightPadded<Expression>> types;
        private final @Nullable JavaType type;

        public List<Expression> getTypes() {
            return JRightPadded.getElements(this.types);
        }

        public Intersection withTypes(List<Expression> types) {
            return this.getPadding().withTypes(JRightPadded.withElements(this.types, types));
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitIntersection(this, p);
        }

        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Intersection)) {
                return false;
            }
            Intersection other = (Intersection)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public Intersection(UUID id, Space prefix, Markers markers, List<JRightPadded<Expression>> types, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.types = types;
            this.type = type;
        }

        @Generated
        private Intersection(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, List<JRightPadded<Expression>> types, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.types = types;
            this.type = type;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public @Nullable JavaType getType() {
            return this.type;
        }

        @Generated
        public void setPadding(@Nullable WeakReference<Padding> padding) {
            this.padding = padding;
        }

        @NonNull
        @Generated
        public String toString() {
            return "JS.Intersection(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", types=" + this.getTypes() + ", type=" + this.getType() + ")";
        }

        @NonNull
        @Generated
        public Intersection withId(UUID id) {
            return this.id == id ? this : new Intersection(this.padding, id, this.prefix, this.markers, this.types, this.type);
        }

        @NonNull
        @Generated
        public Intersection withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Intersection(this.padding, this.id, prefix, this.markers, this.types, this.type);
        }

        @NonNull
        @Generated
        public Intersection withMarkers(Markers markers) {
            return this.markers == markers ? this : new Intersection(this.padding, this.id, this.prefix, markers, this.types, this.type);
        }

        @NonNull
        @Generated
        public Intersection withType(@Nullable JavaType type) {
            return this.type == type ? this : new Intersection(this.padding, this.id, this.prefix, this.markers, this.types, type);
        }

        public static class Padding {
            private final Intersection t;

            public List<JRightPadded<Expression>> getTypes() {
                return this.t.types;
            }

            public Intersection withTypes(List<JRightPadded<Expression>> types) {
                return this.t.types == types ? this.t : new Intersection(this.t.id, this.t.prefix, this.t.markers, types, this.t.type);
            }

            @Generated
            public Padding(Intersection t) {
                this.t = t;
            }
        }
    }

    public static final class Union
    implements JS,
    Expression,
    TypeTree {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<JRightPadded<Expression>> types;
        private final @Nullable JavaType type;

        public List<Expression> getTypes() {
            return JRightPadded.getElements(this.types);
        }

        public Union withTypes(List<Expression> types) {
            return this.getPadding().withTypes(JRightPadded.withElements(this.types, types));
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitUnion(this, p);
        }

        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Union)) {
                return false;
            }
            Union other = (Union)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public Union(UUID id, Space prefix, Markers markers, List<JRightPadded<Expression>> types, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.types = types;
            this.type = type;
        }

        @Generated
        private Union(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, List<JRightPadded<Expression>> types, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.types = types;
            this.type = type;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public @Nullable JavaType getType() {
            return this.type;
        }

        @Generated
        public void setPadding(@Nullable WeakReference<Padding> padding) {
            this.padding = padding;
        }

        @NonNull
        @Generated
        public String toString() {
            return "JS.Union(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", types=" + this.getTypes() + ", type=" + this.getType() + ")";
        }

        @NonNull
        @Generated
        public Union withId(UUID id) {
            return this.id == id ? this : new Union(this.padding, id, this.prefix, this.markers, this.types, this.type);
        }

        @NonNull
        @Generated
        public Union withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Union(this.padding, this.id, prefix, this.markers, this.types, this.type);
        }

        @NonNull
        @Generated
        public Union withMarkers(Markers markers) {
            return this.markers == markers ? this : new Union(this.padding, this.id, this.prefix, markers, this.types, this.type);
        }

        @NonNull
        @Generated
        public Union withType(@Nullable JavaType type) {
            return this.type == type ? this : new Union(this.padding, this.id, this.prefix, this.markers, this.types, type);
        }

        public static class Padding {
            private final Union t;

            public List<JRightPadded<Expression>> getTypes() {
                return this.t.types;
            }

            public Union withTypes(List<JRightPadded<Expression>> types) {
                return this.t.types == types ? this.t : new Union(this.t.id, this.t.prefix, this.t.markers, types, this.t.type);
            }

            @Generated
            public Padding(Union t) {
                this.t = t;
            }
        }
    }

    public static final class TypePredicate
    implements JS,
    Expression,
    TypeTree {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JLeftPadded<Boolean> asserts;
        private final J.Identifier parameterName;
        private final @Nullable JLeftPadded<Expression> expression;
        private final @Nullable JavaType type;

        public boolean isAsserts() {
            return (Boolean)this.asserts.getElement();
        }

        public TypePredicate withAsserts(boolean asserts) {
            return this.getPadding().withAsserts((JLeftPadded<Boolean>)this.asserts.withElement((Object)asserts));
        }

        public @Nullable Expression getExpression() {
            return this.expression != null ? (Expression)this.expression.getElement() : null;
        }

        public TypePredicate withExpression(@Nullable Expression expression) {
            return this.getPadding().withExpression((JLeftPadded<Expression>)JLeftPadded.withElement(this.expression, (Object)expression));
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitTypePredicate(this, p);
        }

        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TypePredicate)) {
                return false;
            }
            TypePredicate other = (TypePredicate)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public TypePredicate(UUID id, Space prefix, Markers markers, JLeftPadded<Boolean> asserts, J.Identifier parameterName, @Nullable JLeftPadded<Expression> expression, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.asserts = asserts;
            this.parameterName = parameterName;
            this.expression = expression;
            this.type = type;
        }

        @Generated
        private TypePredicate(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JLeftPadded<Boolean> asserts, J.Identifier parameterName, @Nullable JLeftPadded<Expression> expression, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.asserts = asserts;
            this.parameterName = parameterName;
            this.expression = expression;
            this.type = type;
        }

        @NonNull
        @Generated
        public TypePredicate withId(UUID id) {
            return this.id == id ? this : new TypePredicate(this.padding, id, this.prefix, this.markers, this.asserts, this.parameterName, this.expression, this.type);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public TypePredicate withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new TypePredicate(this.padding, this.id, prefix, this.markers, this.asserts, this.parameterName, this.expression, this.type);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public TypePredicate withMarkers(Markers markers) {
            return this.markers == markers ? this : new TypePredicate(this.padding, this.id, this.prefix, markers, this.asserts, this.parameterName, this.expression, this.type);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public TypePredicate withParameterName(J.Identifier parameterName) {
            return this.parameterName == parameterName ? this : new TypePredicate(this.padding, this.id, this.prefix, this.markers, this.asserts, parameterName, this.expression, this.type);
        }

        @Generated
        public J.Identifier getParameterName() {
            return this.parameterName;
        }

        @Generated
        public @Nullable JavaType getType() {
            return this.type;
        }

        @NonNull
        @Generated
        public TypePredicate withType(@Nullable JavaType type) {
            return this.type == type ? this : new TypePredicate(this.padding, this.id, this.prefix, this.markers, this.asserts, this.parameterName, this.expression, type);
        }

        public static class Padding {
            private final TypePredicate t;

            public JLeftPadded<Boolean> getAsserts() {
                return this.t.asserts;
            }

            public TypePredicate withAsserts(JLeftPadded<Boolean> asserts) {
                return this.t.asserts == asserts ? this.t : new TypePredicate(this.t.id, this.t.prefix, this.t.markers, asserts, this.t.parameterName, (JLeftPadded<Expression>)this.t.expression, this.t.type);
            }

            public @Nullable JLeftPadded<Expression> getExpression() {
                return this.t.expression;
            }

            public TypePredicate withExpression(@Nullable JLeftPadded<Expression> expression) {
                return this.t.expression == expression ? this.t : new TypePredicate(this.t.id, this.t.prefix, this.t.markers, (JLeftPadded<Boolean>)this.t.asserts, this.t.parameterName, expression, this.t.type);
            }

            @Generated
            public Padding(TypePredicate t) {
                this.t = t;
            }
        }
    }

    public static final class TypeOperator
    implements JS,
    Expression,
    TypeTree {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Type operator;
        private final JLeftPadded<Expression> expression;

        public Expression getExpression() {
            return (Expression)this.expression.getElement();
        }

        public TypeOperator withExpression(Expression expression) {
            return this.getPadding().withExpression((JLeftPadded<Expression>)this.expression.withElement((Object)expression));
        }

        public @Nullable JavaType getType() {
            return ((Expression)this.expression.getElement()).getType();
        }

        public TypeOperator withType(@Nullable JavaType type) {
            return type == this.getType() ? this : this.getPadding().withExpression((JLeftPadded<Expression>)this.expression.withElement((Object)((Expression)((Expression)this.expression.getElement()).withType(type))));
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitTypeOperator(this, p);
        }

        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TypeOperator)) {
                return false;
            }
            TypeOperator other = (TypeOperator)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public TypeOperator(UUID id, Space prefix, Markers markers, Type operator, JLeftPadded<Expression> expression) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.operator = operator;
            this.expression = expression;
        }

        @Generated
        private TypeOperator(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Type operator, JLeftPadded<Expression> expression) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.operator = operator;
            this.expression = expression;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public Type getOperator() {
            return this.operator;
        }

        @Generated
        public void setPadding(@Nullable WeakReference<Padding> padding) {
            this.padding = padding;
        }

        @NonNull
        @Generated
        public String toString() {
            return "JS.TypeOperator(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", operator=" + (Object)((Object)this.getOperator()) + ", expression=" + this.getExpression() + ")";
        }

        @NonNull
        @Generated
        public TypeOperator withId(UUID id) {
            return this.id == id ? this : new TypeOperator(this.padding, id, this.prefix, this.markers, this.operator, this.expression);
        }

        @NonNull
        @Generated
        public TypeOperator withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new TypeOperator(this.padding, this.id, prefix, this.markers, this.operator, this.expression);
        }

        @NonNull
        @Generated
        public TypeOperator withMarkers(Markers markers) {
            return this.markers == markers ? this : new TypeOperator(this.padding, this.id, this.prefix, markers, this.operator, this.expression);
        }

        @NonNull
        @Generated
        public TypeOperator withOperator(Type operator) {
            return this.operator == operator ? this : new TypeOperator(this.padding, this.id, this.prefix, this.markers, operator, this.expression);
        }

        public static enum Type {
            ReadOnly,
            KeyOf,
            Unique;

        }

        public static class Padding {
            private final TypeOperator t;

            public JLeftPadded<Expression> getExpression() {
                return this.t.expression;
            }

            public TypeOperator withExpression(JLeftPadded<Expression> expression) {
                return this.t.expression == expression ? this.t : new TypeOperator(this.t.id, this.t.prefix, this.t.markers, this.t.operator, expression);
            }

            @Generated
            public Padding(TypeOperator t) {
                this.t = t;
            }
        }
    }

    public static final class ComputedPropertyName
    implements JS,
    Expression,
    TypeTree,
    VariableDeclarator {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JRightPadded<Expression> expression;

        public Expression getExpression() {
            return (Expression)this.expression.getElement();
        }

        public ComputedPropertyName withExpression(Expression expression) {
            return this.getPadding().withExpression((JRightPadded<Expression>)this.expression.withElement((Object)expression));
        }

        public @Nullable JavaType getType() {
            return ((Expression)this.expression.getElement()).getType();
        }

        public ComputedPropertyName withType(@Nullable JavaType type) {
            return type == this.getType() ? this : this.getPadding().withExpression((JRightPadded<Expression>)this.expression.withElement((Object)((Expression)((Expression)this.expression.getElement()).withType(type))));
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitComputedPropertyName(this, p);
        }

        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public List<J.Identifier> getNames() {
            return Collections.emptyList();
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ComputedPropertyName)) {
                return false;
            }
            ComputedPropertyName other = (ComputedPropertyName)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public ComputedPropertyName(UUID id, Space prefix, Markers markers, JRightPadded<Expression> expression) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.expression = expression;
        }

        @Generated
        private ComputedPropertyName(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JRightPadded<Expression> expression) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.expression = expression;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public void setPadding(@Nullable WeakReference<Padding> padding) {
            this.padding = padding;
        }

        @NonNull
        @Generated
        public String toString() {
            return "JS.ComputedPropertyName(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", expression=" + this.getExpression() + ")";
        }

        @NonNull
        @Generated
        public ComputedPropertyName withId(UUID id) {
            return this.id == id ? this : new ComputedPropertyName(this.padding, id, this.prefix, this.markers, this.expression);
        }

        @NonNull
        @Generated
        public ComputedPropertyName withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ComputedPropertyName(this.padding, this.id, prefix, this.markers, this.expression);
        }

        @NonNull
        @Generated
        public ComputedPropertyName withMarkers(Markers markers) {
            return this.markers == markers ? this : new ComputedPropertyName(this.padding, this.id, this.prefix, markers, this.expression);
        }

        public static class Padding {
            private final ComputedPropertyName t;

            public JRightPadded<Expression> getExpression() {
                return this.t.expression;
            }

            public ComputedPropertyName withExpression(JRightPadded<Expression> expression) {
                return this.t.expression == expression ? this.t : new ComputedPropertyName(this.t.id, this.t.prefix, this.t.markers, expression);
            }

            @Generated
            public Padding(ComputedPropertyName t) {
                this.t = t;
            }
        }
    }

    public static final class TypeQuery
    implements JS,
    Expression,
    TypeTree {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final TypeTree typeExpression;
        private final @Nullable JContainer<Expression> typeArguments;
        private final @Nullable JavaType type;

        public @Nullable List<Expression> getTypeArguments() {
            return this.typeArguments == null ? null : this.typeArguments.getElements();
        }

        public TypeQuery withTypeArguments(@Nullable List<Expression> typeParameters) {
            return this.getPadding().withTypeArguments((JContainer<Expression>)JContainer.withElementsNullable(this.typeArguments, typeParameters));
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitTypeQuery(this, p);
        }

        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TypeQuery)) {
                return false;
            }
            TypeQuery other = (TypeQuery)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public TypeQuery(UUID id, Space prefix, Markers markers, TypeTree typeExpression, @Nullable JContainer<Expression> typeArguments, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.typeExpression = typeExpression;
            this.typeArguments = typeArguments;
            this.type = type;
        }

        @Generated
        private TypeQuery(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, TypeTree typeExpression, @Nullable JContainer<Expression> typeArguments, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.typeExpression = typeExpression;
            this.typeArguments = typeArguments;
            this.type = type;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public TypeTree getTypeExpression() {
            return this.typeExpression;
        }

        @Generated
        public @Nullable JavaType getType() {
            return this.type;
        }

        @NonNull
        @Generated
        public TypeQuery withId(UUID id) {
            return this.id == id ? this : new TypeQuery(this.padding, id, this.prefix, this.markers, this.typeExpression, this.typeArguments, this.type);
        }

        @NonNull
        @Generated
        public TypeQuery withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new TypeQuery(this.padding, this.id, prefix, this.markers, this.typeExpression, this.typeArguments, this.type);
        }

        @NonNull
        @Generated
        public TypeQuery withMarkers(Markers markers) {
            return this.markers == markers ? this : new TypeQuery(this.padding, this.id, this.prefix, markers, this.typeExpression, this.typeArguments, this.type);
        }

        @NonNull
        @Generated
        public TypeQuery withTypeExpression(TypeTree typeExpression) {
            return this.typeExpression == typeExpression ? this : new TypeQuery(this.padding, this.id, this.prefix, this.markers, typeExpression, this.typeArguments, this.type);
        }

        @NonNull
        @Generated
        public TypeQuery withType(@Nullable JavaType type) {
            return this.type == type ? this : new TypeQuery(this.padding, this.id, this.prefix, this.markers, this.typeExpression, this.typeArguments, type);
        }

        public static class Padding {
            private final TypeQuery t;

            public @Nullable JContainer<Expression> getTypeArguments() {
                return this.t.typeArguments;
            }

            public TypeQuery withTypeArguments(@Nullable JContainer<Expression> typeArguments) {
                return this.t.typeArguments == typeArguments ? this.t : new TypeQuery(this.t.id, this.t.prefix, this.t.markers, this.t.typeExpression, typeArguments, this.t.type);
            }

            @Generated
            public Padding(TypeQuery t) {
                this.t = t;
            }
        }
    }

    public static final class TypeOf
    implements JS,
    Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression expression;
        private final @Nullable JavaType type;

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitTypeOf(this, p);
        }

        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public Expression getExpression() {
            return this.expression;
        }

        @Generated
        public @Nullable JavaType getType() {
            return this.type;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TypeOf)) {
                return false;
            }
            TypeOf other = (TypeOf)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public TypeOf(UUID id, Space prefix, Markers markers, Expression expression, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.expression = expression;
            this.type = type;
        }

        @NonNull
        @Generated
        public TypeOf withId(UUID id) {
            return this.id == id ? this : new TypeOf(id, this.prefix, this.markers, this.expression, this.type);
        }

        @NonNull
        @Generated
        public TypeOf withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new TypeOf(this.id, prefix, this.markers, this.expression, this.type);
        }

        @NonNull
        @Generated
        public TypeOf withMarkers(Markers markers) {
            return this.markers == markers ? this : new TypeOf(this.id, this.prefix, markers, this.expression, this.type);
        }

        @NonNull
        @Generated
        public TypeOf withExpression(Expression expression) {
            return this.expression == expression ? this : new TypeOf(this.id, this.prefix, this.markers, expression, this.type);
        }

        @NonNull
        @Generated
        public TypeOf withType(@Nullable JavaType type) {
            return this.type == type ? this : new TypeOf(this.id, this.prefix, this.markers, this.expression, type);
        }
    }

    public static final class TypeDeclaration
    implements JS,
    Statement,
    TypedTree {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<J.Modifier> modifiers;
        private final JLeftPadded<J.Identifier> name;
        private final // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.TypeParameters typeParameters;
        private final JLeftPadded<Expression> initializer;
        private final @Nullable JavaType type;

        public J.Identifier getName() {
            return (J.Identifier)this.name.getElement();
        }

        public TypeDeclaration withName(J.Identifier name) {
            return this.getPadding().withName((JLeftPadded<J.Identifier>)JLeftPadded.withElement(this.name, (Object)name));
        }

        public Expression getInitializer() {
            return (Expression)this.initializer.getElement();
        }

        public TypeDeclaration withInitializer(Expression initializer) {
            return this.getPadding().withInitializer((JLeftPadded<Expression>)JLeftPadded.withElement(this.initializer, (Object)initializer));
        }

        public @Nullable JavaType getType() {
            return this.type;
        }

        public TypeDeclaration withType(@Nullable JavaType javaType) {
            return this.type == javaType ? this : new TypeDeclaration(this.id, this.prefix, this.markers, this.modifiers, this.name, this.typeParameters, this.initializer, javaType);
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitTypeDeclaration(this, p);
        }

        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TypeDeclaration)) {
                return false;
            }
            TypeDeclaration other = (TypeDeclaration)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public TypeDeclaration(UUID id, Space prefix, Markers markers, List<J.Modifier> modifiers, JLeftPadded<J.Identifier> name, // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.TypeParameters typeParameters, JLeftPadded<Expression> initializer, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.modifiers = modifiers;
            this.name = name;
            this.typeParameters = typeParameters;
            this.initializer = initializer;
            this.type = type;
        }

        @Generated
        private TypeDeclaration(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, List<J.Modifier> modifiers, JLeftPadded<J.Identifier> name, // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.TypeParameters typeParameters, JLeftPadded<Expression> initializer, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.modifiers = modifiers;
            this.name = name;
            this.typeParameters = typeParameters;
            this.initializer = initializer;
            this.type = type;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public List<J.Modifier> getModifiers() {
            return this.modifiers;
        }

        @Generated
        public // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.TypeParameters getTypeParameters() {
            return this.typeParameters;
        }

        @Generated
        public void setPadding(@Nullable WeakReference<Padding> padding) {
            this.padding = padding;
        }

        @NonNull
        @Generated
        public String toString() {
            return "JS.TypeDeclaration(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", modifiers=" + this.getModifiers() + ", name=" + this.getName() + ", typeParameters=" + this.getTypeParameters() + ", initializer=" + this.getInitializer() + ", type=" + this.getType() + ")";
        }

        @NonNull
        @Generated
        public TypeDeclaration withId(UUID id) {
            return this.id == id ? this : new TypeDeclaration(this.padding, id, this.prefix, this.markers, this.modifiers, this.name, this.typeParameters, this.initializer, this.type);
        }

        @NonNull
        @Generated
        public TypeDeclaration withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new TypeDeclaration(this.padding, this.id, prefix, this.markers, this.modifiers, this.name, this.typeParameters, this.initializer, this.type);
        }

        @NonNull
        @Generated
        public TypeDeclaration withMarkers(Markers markers) {
            return this.markers == markers ? this : new TypeDeclaration(this.padding, this.id, this.prefix, markers, this.modifiers, this.name, this.typeParameters, this.initializer, this.type);
        }

        @NonNull
        @Generated
        public TypeDeclaration withModifiers(List<J.Modifier> modifiers) {
            return this.modifiers == modifiers ? this : new TypeDeclaration(this.padding, this.id, this.prefix, this.markers, modifiers, this.name, this.typeParameters, this.initializer, this.type);
        }

        @NonNull
        @Generated
        public TypeDeclaration withTypeParameters(// Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.TypeParameters typeParameters) {
            return this.typeParameters == typeParameters ? this : new TypeDeclaration(this.padding, this.id, this.prefix, this.markers, this.modifiers, this.name, typeParameters, this.initializer, this.type);
        }

        public static class Padding {
            private final TypeDeclaration t;

            public JLeftPadded<Expression> getInitializer() {
                return this.t.initializer;
            }

            public TypeDeclaration withInitializer(JLeftPadded<Expression> initializer) {
                return this.t.initializer == initializer ? this.t : new TypeDeclaration(this.t.id, this.t.prefix, this.t.markers, this.t.modifiers, (JLeftPadded<J.Identifier>)this.t.name, this.t.typeParameters, initializer, this.t.type);
            }

            public JLeftPadded<J.Identifier> getName() {
                return this.t.name;
            }

            public TypeDeclaration withName(JLeftPadded<J.Identifier> name) {
                return this.t.name == name ? this.t : new TypeDeclaration(this.t.id, this.t.prefix, this.t.markers, this.t.modifiers, name, this.t.typeParameters, (JLeftPadded<Expression>)this.t.initializer, this.t.type);
            }

            @Generated
            public Padding(TypeDeclaration t) {
                this.t = t;
            }
        }
    }

    public static final class Tuple
    implements JS,
    Expression,
    TypeTree {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JContainer<J> elements;
        private final @Nullable JavaType type;

        public List<J> getElements() {
            return this.elements.getElements();
        }

        public Tuple withElements(List<J> elements) {
            return this.getPadding().withElements((JContainer<J>)JContainer.withElements(this.elements, elements));
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitTuple(this, p);
        }

        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Tuple)) {
                return false;
            }
            Tuple other = (Tuple)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public Tuple(UUID id, Space prefix, Markers markers, JContainer<J> elements, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.elements = elements;
            this.type = type;
        }

        @Generated
        private Tuple(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JContainer<J> elements, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.elements = elements;
            this.type = type;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public @Nullable JavaType getType() {
            return this.type;
        }

        @Generated
        public void setPadding(@Nullable WeakReference<Padding> padding) {
            this.padding = padding;
        }

        @NonNull
        @Generated
        public String toString() {
            return "JS.Tuple(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", elements=" + this.getElements() + ", type=" + this.getType() + ")";
        }

        @NonNull
        @Generated
        public Tuple withId(UUID id) {
            return this.id == id ? this : new Tuple(this.padding, id, this.prefix, this.markers, this.elements, this.type);
        }

        @NonNull
        @Generated
        public Tuple withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Tuple(this.padding, this.id, prefix, this.markers, this.elements, this.type);
        }

        @NonNull
        @Generated
        public Tuple withMarkers(Markers markers) {
            return this.markers == markers ? this : new Tuple(this.padding, this.id, this.prefix, markers, this.elements, this.type);
        }

        @NonNull
        @Generated
        public Tuple withType(@Nullable JavaType type) {
            return this.type == type ? this : new Tuple(this.padding, this.id, this.prefix, this.markers, this.elements, type);
        }

        public static class Padding {
            private final Tuple t;

            public JContainer<J> getElements() {
                return this.t.elements;
            }

            public Tuple withElements(JContainer<J> elements) {
                return this.t.elements == elements ? this.t : new Tuple(this.t.id, this.t.prefix, this.t.markers, elements, this.t.type);
            }

            @Generated
            public Padding(Tuple t) {
                this.t = t;
            }
        }
    }

    public static final class TemplateExpression
    implements JS,
    Statement,
    Expression,
    TypeTree {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final J.Literal head;
        private final List<JRightPadded<Span>> spans;
        private final @Nullable JavaType type;

        public List<Span> getSpans() {
            return JRightPadded.getElements(this.spans);
        }

        public TemplateExpression withSpans(List<Span> spans) {
            return this.getPadding().withSpans(JRightPadded.withElements(this.spans, spans));
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitTemplateExpression(this, p);
        }

        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public J.Literal getHead() {
            return this.head;
        }

        @Generated
        public @Nullable JavaType getType() {
            return this.type;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TemplateExpression)) {
                return false;
            }
            TemplateExpression other = (TemplateExpression)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public TemplateExpression(UUID id, Space prefix, Markers markers, J.Literal head, List<JRightPadded<Span>> spans, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.head = head;
            this.spans = spans;
            this.type = type;
        }

        @Generated
        private TemplateExpression(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, J.Literal head, List<JRightPadded<Span>> spans, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.head = head;
            this.spans = spans;
            this.type = type;
        }

        @NonNull
        @Generated
        public TemplateExpression withId(UUID id) {
            return this.id == id ? this : new TemplateExpression(this.padding, id, this.prefix, this.markers, this.head, this.spans, this.type);
        }

        @NonNull
        @Generated
        public TemplateExpression withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new TemplateExpression(this.padding, this.id, prefix, this.markers, this.head, this.spans, this.type);
        }

        @NonNull
        @Generated
        public TemplateExpression withMarkers(Markers markers) {
            return this.markers == markers ? this : new TemplateExpression(this.padding, this.id, this.prefix, markers, this.head, this.spans, this.type);
        }

        @NonNull
        @Generated
        public TemplateExpression withHead(J.Literal head) {
            return this.head == head ? this : new TemplateExpression(this.padding, this.id, this.prefix, this.markers, head, this.spans, this.type);
        }

        @NonNull
        @Generated
        public TemplateExpression withType(@Nullable JavaType type) {
            return this.type == type ? this : new TemplateExpression(this.padding, this.id, this.prefix, this.markers, this.head, this.spans, type);
        }

        public static class Padding {
            private final TemplateExpression t;

            public List<JRightPadded<Span>> getSpans() {
                return this.t.spans;
            }

            public TemplateExpression withSpans(List<JRightPadded<Span>> spans) {
                return this.t.spans == spans ? this.t : new TemplateExpression(this.t.id, this.t.prefix, this.t.markers, this.t.head, spans, this.t.type);
            }

            @Generated
            public Padding(TemplateExpression t) {
                this.t = t;
            }
        }

        public static final class Span
        implements JS {
            private final UUID id;
            private final Space prefix;
            private final Markers markers;
            private final J expression;
            private final J.Literal tail;

            @Override
            public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
                return v.visitTemplateExpressionSpan(this, p);
            }

            @Generated
            public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Span)) {
                    return false;
                }
                Span other = (Span)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @Generated
            public Span(UUID id, Space prefix, Markers markers, J expression, J.Literal tail) {
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.expression = expression;
                this.tail = tail;
            }

            @NonNull
            @Generated
            public Span withId(UUID id) {
                return this.id == id ? this : new Span(id, this.prefix, this.markers, this.expression, this.tail);
            }

            @Generated
            public UUID getId() {
                return this.id;
            }

            @NonNull
            @Generated
            public Span withPrefix(Space prefix) {
                return this.prefix == prefix ? this : new Span(this.id, prefix, this.markers, this.expression, this.tail);
            }

            @Override
            @Generated
            public Space getPrefix() {
                return this.prefix;
            }

            @NonNull
            @Generated
            public Span withMarkers(Markers markers) {
                return this.markers == markers ? this : new Span(this.id, this.prefix, markers, this.expression, this.tail);
            }

            @Generated
            public Markers getMarkers() {
                return this.markers;
            }

            @NonNull
            @Generated
            public Span withExpression(J expression) {
                return this.expression == expression ? this : new Span(this.id, this.prefix, this.markers, expression, this.tail);
            }

            @Generated
            public J getExpression() {
                return this.expression;
            }

            @NonNull
            @Generated
            public Span withTail(J.Literal tail) {
                return this.tail == tail ? this : new Span(this.id, this.prefix, this.markers, this.expression, tail);
            }

            @Generated
            public J.Literal getTail() {
                return this.tail;
            }
        }
    }

    public static final class TaggedTemplateExpression
    implements JS,
    Statement,
    Expression {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final @Nullable JRightPadded<Expression> tag;
        private final @Nullable JContainer<Expression> typeArguments;
        private final Expression templateExpression;
        private final @Nullable JavaType type;

        public @Nullable Expression getTag() {
            return this.tag == null ? null : (Expression)this.tag.getElement();
        }

        public TaggedTemplateExpression withTag(@Nullable Expression tag) {
            return this.getPadding().withTag((JRightPadded<Expression>)JRightPadded.withElement(this.tag, (Object)tag));
        }

        public @Nullable List<Expression> getTypeArguments() {
            return this.typeArguments == null ? null : this.typeArguments.getElements();
        }

        public TaggedTemplateExpression withTypeArguments(@Nullable List<Expression> typeParameters) {
            return this.getPadding().withTypeArguments((JContainer<Expression>)JContainer.withElementsNullable(this.typeArguments, typeParameters));
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitTaggedTemplateExpression(this, p);
        }

        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public Expression getTemplateExpression() {
            return this.templateExpression;
        }

        @Generated
        public @Nullable JavaType getType() {
            return this.type;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TaggedTemplateExpression)) {
                return false;
            }
            TaggedTemplateExpression other = (TaggedTemplateExpression)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public TaggedTemplateExpression(UUID id, Space prefix, Markers markers, @Nullable JRightPadded<Expression> tag, @Nullable JContainer<Expression> typeArguments, Expression templateExpression, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.tag = tag;
            this.typeArguments = typeArguments;
            this.templateExpression = templateExpression;
            this.type = type;
        }

        @Generated
        private TaggedTemplateExpression(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, @Nullable JRightPadded<Expression> tag, @Nullable JContainer<Expression> typeArguments, Expression templateExpression, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.tag = tag;
            this.typeArguments = typeArguments;
            this.templateExpression = templateExpression;
            this.type = type;
        }

        @NonNull
        @Generated
        public TaggedTemplateExpression withId(UUID id) {
            return this.id == id ? this : new TaggedTemplateExpression(this.padding, id, this.prefix, this.markers, this.tag, this.typeArguments, this.templateExpression, this.type);
        }

        @NonNull
        @Generated
        public TaggedTemplateExpression withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new TaggedTemplateExpression(this.padding, this.id, prefix, this.markers, this.tag, this.typeArguments, this.templateExpression, this.type);
        }

        @NonNull
        @Generated
        public TaggedTemplateExpression withMarkers(Markers markers) {
            return this.markers == markers ? this : new TaggedTemplateExpression(this.padding, this.id, this.prefix, markers, this.tag, this.typeArguments, this.templateExpression, this.type);
        }

        @NonNull
        @Generated
        public TaggedTemplateExpression withTemplateExpression(Expression templateExpression) {
            return this.templateExpression == templateExpression ? this : new TaggedTemplateExpression(this.padding, this.id, this.prefix, this.markers, this.tag, this.typeArguments, templateExpression, this.type);
        }

        @NonNull
        @Generated
        public TaggedTemplateExpression withType(@Nullable JavaType type) {
            return this.type == type ? this : new TaggedTemplateExpression(this.padding, this.id, this.prefix, this.markers, this.tag, this.typeArguments, this.templateExpression, type);
        }

        public static class Padding {
            private final TaggedTemplateExpression t;

            public @Nullable JRightPadded<Expression> getTag() {
                return this.t.tag;
            }

            public TaggedTemplateExpression withTag(@Nullable JRightPadded<Expression> tag) {
                return this.t.tag == tag ? this.t : new TaggedTemplateExpression(this.t.id, this.t.prefix, this.t.markers, tag, (JContainer<Expression>)this.t.typeArguments, this.t.templateExpression, this.t.type);
            }

            public @Nullable JContainer<Expression> getTypeArguments() {
                return this.t.typeArguments;
            }

            public TaggedTemplateExpression withTypeArguments(@Nullable JContainer<Expression> typeArguments) {
                return this.t.typeArguments == typeArguments ? this.t : new TaggedTemplateExpression(this.t.id, this.t.prefix, this.t.markers, (JRightPadded<Expression>)this.t.tag, typeArguments, this.t.templateExpression, this.t.type);
            }

            @Generated
            public Padding(TaggedTemplateExpression t) {
                this.t = t;
            }
        }
    }

    public static final class WithStatement
    implements JS,
    Statement {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final J.ControlParentheses<Expression> expression;
        private final JRightPadded<Statement> body;

        public Statement getBody() {
            return (Statement)this.body.getElement();
        }

        public WithStatement withBody(Statement body) {
            return this.getPadding().withBody((JRightPadded<Statement>)this.body.withElement((Object)body));
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitWithStatement(this, p);
        }

        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WithStatement)) {
                return false;
            }
            WithStatement other = (WithStatement)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public WithStatement(UUID id, Space prefix, Markers markers, J.ControlParentheses<Expression> expression, JRightPadded<Statement> body) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.expression = expression;
            this.body = body;
        }

        @Generated
        private WithStatement(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, J.ControlParentheses<Expression> expression, JRightPadded<Statement> body) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.expression = expression;
            this.body = body;
        }

        @NonNull
        @Generated
        public WithStatement withId(UUID id) {
            return this.id == id ? this : new WithStatement(this.padding, id, this.prefix, this.markers, this.expression, this.body);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public WithStatement withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new WithStatement(this.padding, this.id, prefix, this.markers, this.expression, this.body);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public WithStatement withMarkers(Markers markers) {
            return this.markers == markers ? this : new WithStatement(this.padding, this.id, this.prefix, markers, this.expression, this.body);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public WithStatement withExpression(J.ControlParentheses<Expression> expression) {
            return this.expression == expression ? this : new WithStatement(this.padding, this.id, this.prefix, this.markers, expression, this.body);
        }

        @Generated
        public J.ControlParentheses<Expression> getExpression() {
            return this.expression;
        }

        public static class Padding {
            private final WithStatement t;

            public JRightPadded<Statement> getBody() {
                return this.t.body;
            }

            public WithStatement withBody(JRightPadded<Statement> body) {
                return this.t.body == body ? this.t : new WithStatement(this.t.id, this.t.prefix, this.t.markers, (J.ControlParentheses<Expression>)this.t.expression, body);
            }

            @Generated
            public Padding(WithStatement t) {
                this.t = t;
            }
        }
    }

    public static final class StatementExpression
    implements JS,
    Expression,
    Statement {
        private final UUID id;
        private final Statement statement;

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitStatementExpression(this, p);
        }

        public <J2 extends J> J2 withPrefix(Space space) {
            return (J2)this.withStatement((Statement)this.statement.withPrefix(space));
        }

        @Override
        public Space getPrefix() {
            return this.statement.getPrefix();
        }

        public <J2 extends Tree> J2 withMarkers(Markers markers) {
            return (J2)this.withStatement((Statement)this.statement.withMarkers(markers));
        }

        public Markers getMarkers() {
            return this.statement.getMarkers();
        }

        public @Nullable JavaType getType() {
            return null;
        }

        public StatementExpression withType(@Nullable JavaType type) {
            return this;
        }

        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public Statement getStatement() {
            return this.statement;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            return o instanceof StatementExpression;
        }

        @Generated
        public int hashCode() {
            boolean result = true;
            return 1;
        }

        @Generated
        public StatementExpression(UUID id, Statement statement) {
            this.id = id;
            this.statement = statement;
        }

        @NonNull
        @Generated
        public StatementExpression withId(UUID id) {
            return this.id == id ? this : new StatementExpression(id, this.statement);
        }

        @NonNull
        @Generated
        public StatementExpression withStatement(Statement statement) {
            return this.statement == statement ? this : new StatementExpression(this.id, statement);
        }
    }

    public static class ScopedVariableDeclarations
    implements JS,
    Statement {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<J.Modifier> modifiers;
        private final List<JRightPadded<J>> variables;

        public List<J> getVariables() {
            return JRightPadded.getElements(this.variables);
        }

        public ScopedVariableDeclarations withVariables(List<J> variables) {
            return this.getPadding().withVariables(JRightPadded.withElements(this.variables, variables));
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitScopedVariableDeclarations(this, p);
        }

        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScopedVariableDeclarations)) {
                return false;
            }
            ScopedVariableDeclarations other = (ScopedVariableDeclarations)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof ScopedVariableDeclarations;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public ScopedVariableDeclarations(UUID id, Space prefix, Markers markers, List<J.Modifier> modifiers, List<JRightPadded<J>> variables) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.modifiers = modifiers;
            this.variables = variables;
        }

        @Generated
        private ScopedVariableDeclarations(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, List<J.Modifier> modifiers, List<JRightPadded<J>> variables) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.modifiers = modifiers;
            this.variables = variables;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public ScopedVariableDeclarations withId(UUID id) {
            return this.id == id ? this : new ScopedVariableDeclarations(this.padding, id, this.prefix, this.markers, this.modifiers, this.variables);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public ScopedVariableDeclarations withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ScopedVariableDeclarations(this.padding, this.id, prefix, this.markers, this.modifiers, this.variables);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public ScopedVariableDeclarations withMarkers(Markers markers) {
            return this.markers == markers ? this : new ScopedVariableDeclarations(this.padding, this.id, this.prefix, markers, this.modifiers, this.variables);
        }

        @NonNull
        @Generated
        public ScopedVariableDeclarations withModifiers(List<J.Modifier> modifiers) {
            return this.modifiers == modifiers ? this : new ScopedVariableDeclarations(this.padding, this.id, this.prefix, this.markers, modifiers, this.variables);
        }

        @Generated
        public List<J.Modifier> getModifiers() {
            return this.modifiers;
        }

        public static class Padding {
            private final ScopedVariableDeclarations t;

            public List<JRightPadded<J>> getVariables() {
                return this.t.variables;
            }

            public ScopedVariableDeclarations withVariables(List<JRightPadded<J>> variables) {
                return this.t.variables == variables ? this.t : new ScopedVariableDeclarations(this.t.id, this.t.prefix, this.t.markers, this.t.modifiers, variables);
            }

            @Generated
            public Padding(ScopedVariableDeclarations t) {
                this.t = t;
            }
        }
    }

    public static final class SatisfiesExpression
    implements JS,
    Expression {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final J expression;
        private final JLeftPadded<Expression> satisfiesType;
        private final @Nullable JavaType type;

        public Expression getSatisfiesType() {
            return (Expression)this.satisfiesType.getElement();
        }

        public SatisfiesExpression withSatisfiesType(Expression expression) {
            return this.getPadding().withSatisfiesType((JLeftPadded<Expression>)this.satisfiesType.withElement((Object)expression));
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitSatisfiesExpression(this, p);
        }

        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SatisfiesExpression)) {
                return false;
            }
            SatisfiesExpression other = (SatisfiesExpression)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public SatisfiesExpression(UUID id, Space prefix, Markers markers, J expression, JLeftPadded<Expression> satisfiesType, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.expression = expression;
            this.satisfiesType = satisfiesType;
            this.type = type;
        }

        @Generated
        private SatisfiesExpression(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, J expression, JLeftPadded<Expression> satisfiesType, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.expression = expression;
            this.satisfiesType = satisfiesType;
            this.type = type;
        }

        @NonNull
        @Generated
        public SatisfiesExpression withId(UUID id) {
            return this.id == id ? this : new SatisfiesExpression(this.padding, id, this.prefix, this.markers, this.expression, this.satisfiesType, this.type);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public SatisfiesExpression withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new SatisfiesExpression(this.padding, this.id, prefix, this.markers, this.expression, this.satisfiesType, this.type);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public SatisfiesExpression withMarkers(Markers markers) {
            return this.markers == markers ? this : new SatisfiesExpression(this.padding, this.id, this.prefix, markers, this.expression, this.satisfiesType, this.type);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public SatisfiesExpression withExpression(J expression) {
            return this.expression == expression ? this : new SatisfiesExpression(this.padding, this.id, this.prefix, this.markers, expression, this.satisfiesType, this.type);
        }

        @Generated
        public J getExpression() {
            return this.expression;
        }

        @Generated
        public @Nullable JavaType getType() {
            return this.type;
        }

        @NonNull
        @Generated
        public SatisfiesExpression withType(@Nullable JavaType type) {
            return this.type == type ? this : new SatisfiesExpression(this.padding, this.id, this.prefix, this.markers, this.expression, this.satisfiesType, type);
        }

        public static class Padding {
            private final SatisfiesExpression t;

            public JLeftPadded<Expression> getSatisfiesType() {
                return this.t.satisfiesType;
            }

            public SatisfiesExpression withSatisfiesType(JLeftPadded<Expression> satisfiesType) {
                return this.t.satisfiesType == satisfiesType ? this.t : new SatisfiesExpression(this.t.id, this.t.prefix, this.t.markers, this.t.expression, satisfiesType, this.t.type);
            }

            @Generated
            public Padding(SatisfiesExpression t) {
                this.t = t;
            }
        }
    }

    public static final class PropertyAssignment
    implements JS,
    Statement,
    TypedTree {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JRightPadded<Expression> name;
        private final AssigmentToken assigmentToken;
        private final @Nullable Expression initializer;

        public Expression getName() {
            return (Expression)this.name.getElement();
        }

        public PropertyAssignment withName(Expression property) {
            return this.getPadding().withName((JRightPadded<Expression>)JRightPadded.withElement(this.name, (Object)property));
        }

        public @Nullable JavaType getType() {
            return this.initializer == null ? null : this.initializer.getType();
        }

        public PropertyAssignment withType(@Nullable JavaType type) {
            return this.initializer == null || this.initializer.getType() == type ? this : new PropertyAssignment(this.id, this.prefix, this.markers, this.name, this.assigmentToken, (Expression)this.initializer.withType(type));
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitPropertyAssignment(this, p);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public AssigmentToken getAssigmentToken() {
            return this.assigmentToken;
        }

        @Generated
        public @Nullable Expression getInitializer() {
            return this.initializer;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PropertyAssignment)) {
                return false;
            }
            PropertyAssignment other = (PropertyAssignment)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public PropertyAssignment(UUID id, Space prefix, Markers markers, JRightPadded<Expression> name, AssigmentToken assigmentToken, @Nullable Expression initializer) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.name = name;
            this.assigmentToken = assigmentToken;
            this.initializer = initializer;
        }

        @Generated
        private PropertyAssignment(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JRightPadded<Expression> name, AssigmentToken assigmentToken, @Nullable Expression initializer) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.name = name;
            this.assigmentToken = assigmentToken;
            this.initializer = initializer;
        }

        @NonNull
        @Generated
        public PropertyAssignment withId(UUID id) {
            return this.id == id ? this : new PropertyAssignment(this.padding, id, this.prefix, this.markers, this.name, this.assigmentToken, this.initializer);
        }

        @NonNull
        @Generated
        public PropertyAssignment withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new PropertyAssignment(this.padding, this.id, prefix, this.markers, this.name, this.assigmentToken, this.initializer);
        }

        @NonNull
        @Generated
        public PropertyAssignment withMarkers(Markers markers) {
            return this.markers == markers ? this : new PropertyAssignment(this.padding, this.id, this.prefix, markers, this.name, this.assigmentToken, this.initializer);
        }

        @NonNull
        @Generated
        public PropertyAssignment withAssigmentToken(AssigmentToken assigmentToken) {
            return this.assigmentToken == assigmentToken ? this : new PropertyAssignment(this.padding, this.id, this.prefix, this.markers, this.name, assigmentToken, this.initializer);
        }

        @NonNull
        @Generated
        public PropertyAssignment withInitializer(@Nullable Expression initializer) {
            return this.initializer == initializer ? this : new PropertyAssignment(this.padding, this.id, this.prefix, this.markers, this.name, this.assigmentToken, initializer);
        }

        public static enum AssigmentToken {
            Colon,
            Equals,
            Empty;

        }

        public static class Padding {
            private final PropertyAssignment t;

            public JRightPadded<Expression> getName() {
                return this.t.name;
            }

            public PropertyAssignment withName(JRightPadded<Expression> target) {
                return this.t.name == target ? this.t : new PropertyAssignment(this.t.id, this.t.prefix, this.t.markers, target, this.t.assigmentToken, this.t.initializer);
            }

            @Generated
            public Padding(PropertyAssignment t) {
                this.t = t;
            }
        }
    }

    public static final class ObjectBindingPattern
    implements JS,
    Expression,
    TypedTree,
    VariableDeclarator {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<J.Annotation> leadingAnnotations;
        private final List<J.Modifier> modifiers;
        private final @Nullable TypeTree typeExpression;
        private final JContainer<J> bindings;
        private final @Nullable JLeftPadded<Expression> initializer;

        public List<J> getBindings() {
            return this.bindings.getElements();
        }

        public List<J.Identifier> getNames() {
            ArrayList<J.Identifier> list = new ArrayList<J.Identifier>();
            for (J j : this.bindings.getElements()) {
                if (!(j instanceof J.Identifier)) continue;
                list.add((J.Identifier)j);
            }
            return list;
        }

        public ObjectBindingPattern withBindings(List<J> bindings) {
            return this.getPadding().withBindings((JContainer<J>)JContainer.withElements(this.bindings, bindings));
        }

        public @Nullable Expression getInitializer() {
            return this.initializer == null ? null : (Expression)this.initializer.getElement();
        }

        public ObjectBindingPattern withInitializer(@Nullable Expression initializer) {
            return this.getPadding().withInitializer((JLeftPadded<Expression>)JLeftPadded.withElement(this.initializer, (Object)initializer));
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitObjectBindingPattern(this, p);
        }

        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public List<J.Annotation> getAllAnnotations() {
            ArrayList<J.Annotation> allAnnotations = new ArrayList<J.Annotation>(this.leadingAnnotations);
            for (J.Modifier modifier : this.modifiers) {
                allAnnotations.addAll(modifier.getAnnotations());
            }
            if (this.typeExpression != null && this.typeExpression instanceof J.AnnotatedType) {
                allAnnotations.addAll(((J.AnnotatedType)this.typeExpression).getAnnotations());
            }
            return allAnnotations;
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable JavaType.FullyQualified getTypeAsFullyQualified() {
            return this.typeExpression == null ? null : TypeUtils.asFullyQualified((JavaType)this.typeExpression.getType());
        }

        public @Nullable JavaType getType() {
            return this.typeExpression == null ? null : this.typeExpression.getType();
        }

        public ObjectBindingPattern withType(@Nullable JavaType type) {
            return this.typeExpression == null ? this : this.withTypeExpression((TypeTree)this.typeExpression.withType(type));
        }

        public boolean hasModifier(J.Modifier.Type modifier) {
            return J.Modifier.hasModifier(this.getModifiers(), (J.Modifier.Type)modifier);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ObjectBindingPattern)) {
                return false;
            }
            ObjectBindingPattern other = (ObjectBindingPattern)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public ObjectBindingPattern(UUID id, Space prefix, Markers markers, List<J.Annotation> leadingAnnotations, List<J.Modifier> modifiers, @Nullable TypeTree typeExpression, JContainer<J> bindings, @Nullable JLeftPadded<Expression> initializer) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.leadingAnnotations = leadingAnnotations;
            this.modifiers = modifiers;
            this.typeExpression = typeExpression;
            this.bindings = bindings;
            this.initializer = initializer;
        }

        @Generated
        private ObjectBindingPattern(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, List<J.Annotation> leadingAnnotations, List<J.Modifier> modifiers, @Nullable TypeTree typeExpression, JContainer<J> bindings, @Nullable JLeftPadded<Expression> initializer) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.leadingAnnotations = leadingAnnotations;
            this.modifiers = modifiers;
            this.typeExpression = typeExpression;
            this.bindings = bindings;
            this.initializer = initializer;
        }

        @NonNull
        @Generated
        public ObjectBindingPattern withId(UUID id) {
            return this.id == id ? this : new ObjectBindingPattern(this.padding, id, this.prefix, this.markers, this.leadingAnnotations, this.modifiers, this.typeExpression, this.bindings, this.initializer);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public ObjectBindingPattern withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ObjectBindingPattern(this.padding, this.id, prefix, this.markers, this.leadingAnnotations, this.modifiers, this.typeExpression, this.bindings, this.initializer);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public ObjectBindingPattern withMarkers(Markers markers) {
            return this.markers == markers ? this : new ObjectBindingPattern(this.padding, this.id, this.prefix, markers, this.leadingAnnotations, this.modifiers, this.typeExpression, this.bindings, this.initializer);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public ObjectBindingPattern withLeadingAnnotations(List<J.Annotation> leadingAnnotations) {
            return this.leadingAnnotations == leadingAnnotations ? this : new ObjectBindingPattern(this.padding, this.id, this.prefix, this.markers, leadingAnnotations, this.modifiers, this.typeExpression, this.bindings, this.initializer);
        }

        @Generated
        public List<J.Annotation> getLeadingAnnotations() {
            return this.leadingAnnotations;
        }

        @NonNull
        @Generated
        public ObjectBindingPattern withModifiers(List<J.Modifier> modifiers) {
            return this.modifiers == modifiers ? this : new ObjectBindingPattern(this.padding, this.id, this.prefix, this.markers, this.leadingAnnotations, modifiers, this.typeExpression, this.bindings, this.initializer);
        }

        @Generated
        public List<J.Modifier> getModifiers() {
            return this.modifiers;
        }

        @NonNull
        @Generated
        public ObjectBindingPattern withTypeExpression(@Nullable TypeTree typeExpression) {
            return this.typeExpression == typeExpression ? this : new ObjectBindingPattern(this.padding, this.id, this.prefix, this.markers, this.leadingAnnotations, this.modifiers, typeExpression, this.bindings, this.initializer);
        }

        @Generated
        public @Nullable TypeTree getTypeExpression() {
            return this.typeExpression;
        }

        public static class Padding {
            private final ObjectBindingPattern t;

            public JContainer<J> getBindings() {
                return this.t.bindings;
            }

            public ObjectBindingPattern withBindings(JContainer<J> bindings) {
                return this.t.bindings == bindings ? this.t : new ObjectBindingPattern(this.t.id, this.t.prefix, this.t.markers, this.t.leadingAnnotations, this.t.modifiers, this.t.typeExpression, bindings, (JLeftPadded<Expression>)this.t.initializer);
            }

            public @Nullable JLeftPadded<Expression> getInitializer() {
                return this.t.initializer;
            }

            public ObjectBindingPattern withInitializer(@Nullable JLeftPadded<Expression> initializer) {
                return this.t.initializer == initializer ? this.t : new ObjectBindingPattern(this.t.id, this.t.prefix, this.t.markers, this.t.leadingAnnotations, this.t.modifiers, this.t.typeExpression, (JContainer<J>)this.t.bindings, initializer);
            }

            @Generated
            public Padding(ObjectBindingPattern t) {
                this.t = t;
            }
        }
    }

    public static class MappedType
    implements JS,
    Expression,
    TypeTree {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final @Nullable JLeftPadded<// Could not load outer class - annotation placement on inner may be incorrect
        J.Literal> prefixToken;
        private final JLeftPadded<Boolean> hasReadonly;
        private final KeysRemapping keysRemapping;
        private final @Nullable JLeftPadded<// Could not load outer class - annotation placement on inner may be incorrect
        J.Literal> suffixToken;
        private final JLeftPadded<Boolean> hasQuestionToken;
        private final JContainer<TypeTree> valueType;
        private final @Nullable JavaType type;

        public // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.Literal getPrefixToken() {
            return this.prefixToken == null ? null : (J.Literal)this.prefixToken.getElement();
        }

        public MappedType withPrefixToken(// Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.Literal prefixToken) {
            return this.getPadding().withPrefixToken((JLeftPadded<J.Literal>)JLeftPadded.withElement(this.prefixToken, (Object)prefixToken));
        }

        public boolean isHasReadonly() {
            return (Boolean)this.hasReadonly.getElement();
        }

        public MappedType withHasReadonly(boolean hasReadonly) {
            return this.getPadding().withHasReadonly((JLeftPadded<Boolean>)this.hasReadonly.withElement((Object)hasReadonly));
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.Literal getSuffixToken() {
            return this.suffixToken == null ? null : (J.Literal)this.suffixToken.getElement();
        }

        public MappedType withSuffixToken(// Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.Literal suffixToken) {
            return this.getPadding().withSuffixToken((JLeftPadded<J.Literal>)JLeftPadded.withElement(this.suffixToken, (Object)suffixToken));
        }

        public boolean isHasQuestionToken() {
            return (Boolean)this.hasQuestionToken.getElement();
        }

        public MappedType withHasQuestionToken(boolean hasQuestionToken) {
            return this.getPadding().withHasQuestionToken((JLeftPadded<Boolean>)this.hasQuestionToken.withElement((Object)hasQuestionToken));
        }

        public List<TypeTree> getValueType() {
            return this.valueType.getElements();
        }

        public MappedType withValueType(List<TypeTree> valueType) {
            return this.getPadding().withValueType((JContainer<TypeTree>)JContainer.withElements(this.valueType, valueType));
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitMappedType(this, p);
        }

        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MappedType)) {
                return false;
            }
            MappedType other = (MappedType)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof MappedType;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public MappedType(UUID id, Space prefix, Markers markers, @Nullable JLeftPadded<// Could not load outer class - annotation placement on inner may be incorrect
        J.Literal> prefixToken, JLeftPadded<Boolean> hasReadonly, KeysRemapping keysRemapping, @Nullable JLeftPadded<// Could not load outer class - annotation placement on inner may be incorrect
        J.Literal> suffixToken, JLeftPadded<Boolean> hasQuestionToken, JContainer<TypeTree> valueType, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.prefixToken = prefixToken;
            this.hasReadonly = hasReadonly;
            this.keysRemapping = keysRemapping;
            this.suffixToken = suffixToken;
            this.hasQuestionToken = hasQuestionToken;
            this.valueType = valueType;
            this.type = type;
        }

        @Generated
        private MappedType(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, @Nullable JLeftPadded<// Could not load outer class - annotation placement on inner may be incorrect
        J.Literal> prefixToken, JLeftPadded<Boolean> hasReadonly, KeysRemapping keysRemapping, @Nullable JLeftPadded<// Could not load outer class - annotation placement on inner may be incorrect
        J.Literal> suffixToken, JLeftPadded<Boolean> hasQuestionToken, JContainer<TypeTree> valueType, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.prefixToken = prefixToken;
            this.hasReadonly = hasReadonly;
            this.keysRemapping = keysRemapping;
            this.suffixToken = suffixToken;
            this.hasQuestionToken = hasQuestionToken;
            this.valueType = valueType;
            this.type = type;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public MappedType withId(UUID id) {
            return this.id == id ? this : new MappedType(this.padding, id, this.prefix, this.markers, this.prefixToken, this.hasReadonly, this.keysRemapping, this.suffixToken, this.hasQuestionToken, this.valueType, this.type);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public MappedType withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new MappedType(this.padding, this.id, prefix, this.markers, this.prefixToken, this.hasReadonly, this.keysRemapping, this.suffixToken, this.hasQuestionToken, this.valueType, this.type);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public MappedType withMarkers(Markers markers) {
            return this.markers == markers ? this : new MappedType(this.padding, this.id, this.prefix, markers, this.prefixToken, this.hasReadonly, this.keysRemapping, this.suffixToken, this.hasQuestionToken, this.valueType, this.type);
        }

        @Generated
        public KeysRemapping getKeysRemapping() {
            return this.keysRemapping;
        }

        @NonNull
        @Generated
        public MappedType withKeysRemapping(KeysRemapping keysRemapping) {
            return this.keysRemapping == keysRemapping ? this : new MappedType(this.padding, this.id, this.prefix, this.markers, this.prefixToken, this.hasReadonly, keysRemapping, this.suffixToken, this.hasQuestionToken, this.valueType, this.type);
        }

        @Generated
        public @Nullable JavaType getType() {
            return this.type;
        }

        @NonNull
        @Generated
        public MappedType withType(@Nullable JavaType type) {
            return this.type == type ? this : new MappedType(this.padding, this.id, this.prefix, this.markers, this.prefixToken, this.hasReadonly, this.keysRemapping, this.suffixToken, this.hasQuestionToken, this.valueType, type);
        }

        public static final class KeysRemapping
        implements JS,
        Statement {
            private transient @Nullable WeakReference<Padding> padding;
            private final UUID id;
            private final Space prefix;
            private final Markers markers;
            private final JRightPadded<Parameter> typeParameter;
            private final @Nullable JRightPadded<Expression> nameType;

            public Parameter getTypeParameter() {
                return (Parameter)this.typeParameter.getElement();
            }

            public KeysRemapping withTypeParameter(Parameter typeParameter) {
                return this.getPadding().withTypeParameter((JRightPadded<Parameter>)JRightPadded.withElement(this.typeParameter, (Object)typeParameter));
            }

            public @Nullable Expression getNameType() {
                return this.nameType == null ? null : (Expression)this.nameType.getElement();
            }

            public KeysRemapping withNameType(@Nullable Expression element) {
                return this.getPadding().withNameType((JRightPadded<Expression>)JRightPadded.withElement(this.nameType, (Object)element));
            }

            @Override
            public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
                return v.visitMappedTypeKeysRemapping(this, p);
            }

            public CoordinateBuilder.Statement getCoordinates() {
                return new CoordinateBuilder.Statement((Statement)this);
            }

            public Padding getPadding() {
                Padding p;
                if (this.padding == null) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                } else {
                    p = (Padding)this.padding.get();
                    if (p == null || p.t != this) {
                        p = new Padding(this);
                        this.padding = new WeakReference<Padding>(p);
                    }
                }
                return p;
            }

            @Generated
            public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof KeysRemapping)) {
                    return false;
                }
                KeysRemapping other = (KeysRemapping)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @Generated
            public KeysRemapping(UUID id, Space prefix, Markers markers, JRightPadded<Parameter> typeParameter, @Nullable JRightPadded<Expression> nameType) {
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.typeParameter = typeParameter;
                this.nameType = nameType;
            }

            @Generated
            private KeysRemapping(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JRightPadded<Parameter> typeParameter, @Nullable JRightPadded<Expression> nameType) {
                this.padding = padding;
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.typeParameter = typeParameter;
                this.nameType = nameType;
            }

            @NonNull
            @Generated
            public KeysRemapping withId(UUID id) {
                return this.id == id ? this : new KeysRemapping(this.padding, id, this.prefix, this.markers, this.typeParameter, this.nameType);
            }

            @Generated
            public UUID getId() {
                return this.id;
            }

            @NonNull
            @Generated
            public KeysRemapping withPrefix(Space prefix) {
                return this.prefix == prefix ? this : new KeysRemapping(this.padding, this.id, prefix, this.markers, this.typeParameter, this.nameType);
            }

            @Override
            @Generated
            public Space getPrefix() {
                return this.prefix;
            }

            @NonNull
            @Generated
            public KeysRemapping withMarkers(Markers markers) {
                return this.markers == markers ? this : new KeysRemapping(this.padding, this.id, this.prefix, markers, this.typeParameter, this.nameType);
            }

            @Generated
            public Markers getMarkers() {
                return this.markers;
            }

            public static class Padding {
                private final KeysRemapping t;

                public JRightPadded<Parameter> getTypeParameter() {
                    return this.t.typeParameter;
                }

                public KeysRemapping withTypeParameter(JRightPadded<Parameter> typeParameter) {
                    return this.t.typeParameter == typeParameter ? this.t : new KeysRemapping(this.t.id, this.t.prefix, this.t.markers, typeParameter, (JRightPadded<Expression>)this.t.nameType);
                }

                public @Nullable JRightPadded<Expression> getNameType() {
                    return this.t.nameType;
                }

                public KeysRemapping withNameType(@Nullable JRightPadded<Expression> nameType) {
                    return this.t.nameType == nameType ? this.t : new KeysRemapping(this.t.id, this.t.prefix, this.t.markers, (JRightPadded<Parameter>)this.t.typeParameter, nameType);
                }

                @Generated
                public Padding(KeysRemapping t) {
                    this.t = t;
                }
            }
        }

        public static class Padding {
            private final MappedType t;

            public @Nullable JLeftPadded<// Could not load outer class - annotation placement on inner may be incorrect
            J.Literal> getPrefixToken() {
                return this.t.prefixToken;
            }

            public MappedType withPrefixToken(@Nullable JLeftPadded<// Could not load outer class - annotation placement on inner may be incorrect
            J.Literal> prefixToken) {
                return this.t.prefixToken == prefixToken ? this.t : new MappedType(this.t.id, this.t.prefix, this.t.markers, prefixToken, (JLeftPadded<Boolean>)this.t.hasReadonly, this.t.keysRemapping, (JLeftPadded<J.Literal>)this.t.suffixToken, (JLeftPadded<Boolean>)this.t.hasQuestionToken, (JContainer<TypeTree>)this.t.valueType, this.t.type);
            }

            public JLeftPadded<Boolean> getHasReadonly() {
                return this.t.hasReadonly;
            }

            public MappedType withHasReadonly(JLeftPadded<Boolean> hasReadonly) {
                return this.t.hasReadonly == hasReadonly ? this.t : new MappedType(this.t.id, this.t.prefix, this.t.markers, (JLeftPadded<J.Literal>)this.t.prefixToken, hasReadonly, this.t.keysRemapping, (JLeftPadded<J.Literal>)this.t.suffixToken, (JLeftPadded<Boolean>)this.t.hasQuestionToken, (JContainer<TypeTree>)this.t.valueType, this.t.type);
            }

            public @Nullable JLeftPadded<// Could not load outer class - annotation placement on inner may be incorrect
            J.Literal> getSuffixToken() {
                return this.t.suffixToken;
            }

            public MappedType withSuffixToken(@Nullable JLeftPadded<// Could not load outer class - annotation placement on inner may be incorrect
            J.Literal> suffixToken) {
                return this.t.suffixToken == suffixToken ? this.t : new MappedType(this.t.id, this.t.prefix, this.t.markers, (JLeftPadded<J.Literal>)this.t.prefixToken, (JLeftPadded<Boolean>)this.t.hasReadonly, this.t.keysRemapping, suffixToken, (JLeftPadded<Boolean>)this.t.hasQuestionToken, (JContainer<TypeTree>)this.t.valueType, this.t.type);
            }

            public JLeftPadded<Boolean> getHasQuestionToken() {
                return this.t.hasQuestionToken;
            }

            public MappedType withHasQuestionToken(JLeftPadded<Boolean> hasQuestionToken) {
                return this.t.hasQuestionToken == hasQuestionToken ? this.t : new MappedType(this.t.id, this.t.prefix, this.t.markers, (JLeftPadded<J.Literal>)this.t.prefixToken, (JLeftPadded<Boolean>)this.t.hasReadonly, this.t.keysRemapping, (JLeftPadded<J.Literal>)this.t.suffixToken, hasQuestionToken, (JContainer<TypeTree>)this.t.valueType, this.t.type);
            }

            public JContainer<TypeTree> getValueType() {
                return this.t.valueType;
            }

            public MappedType withValueType(JContainer<TypeTree> valueType) {
                return this.t.valueType == valueType ? this.t : new MappedType(this.t.id, this.t.prefix, this.t.markers, (JLeftPadded<J.Literal>)this.t.prefixToken, (JLeftPadded<Boolean>)this.t.hasReadonly, this.t.keysRemapping, (JLeftPadded<J.Literal>)this.t.suffixToken, (JLeftPadded<Boolean>)this.t.hasQuestionToken, valueType, this.t.type);
            }

            @Generated
            public Padding(MappedType t) {
                this.t = t;
            }
        }

        public static final class Parameter
        implements JS,
        Statement {
            private transient @Nullable WeakReference<Padding> padding;
            private final UUID id;
            private final Space prefix;
            private final Markers markers;
            private final Expression name;
            private final JLeftPadded<TypeTree> iterateType;

            public TypeTree getIterateType() {
                return (TypeTree)this.iterateType.getElement();
            }

            public Parameter withIterateType(TypeTree element) {
                return this.getPadding().withIterateType((JLeftPadded<TypeTree>)JLeftPadded.withElement(this.iterateType, (Object)element));
            }

            @Override
            public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
                return v.visitMappedTypeParameter(this, p);
            }

            public CoordinateBuilder.Statement getCoordinates() {
                return new CoordinateBuilder.Statement((Statement)this);
            }

            public Padding getPadding() {
                Padding p;
                if (this.padding == null) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                } else {
                    p = (Padding)this.padding.get();
                    if (p == null || p.t != this) {
                        p = new Padding(this);
                        this.padding = new WeakReference<Padding>(p);
                    }
                }
                return p;
            }

            @Generated
            public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Parameter)) {
                    return false;
                }
                Parameter other = (Parameter)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @Generated
            public Parameter(UUID id, Space prefix, Markers markers, Expression name, JLeftPadded<TypeTree> iterateType) {
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.name = name;
                this.iterateType = iterateType;
            }

            @Generated
            private Parameter(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Expression name, JLeftPadded<TypeTree> iterateType) {
                this.padding = padding;
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.name = name;
                this.iterateType = iterateType;
            }

            @NonNull
            @Generated
            public Parameter withId(UUID id) {
                return this.id == id ? this : new Parameter(this.padding, id, this.prefix, this.markers, this.name, this.iterateType);
            }

            @Generated
            public UUID getId() {
                return this.id;
            }

            @NonNull
            @Generated
            public Parameter withPrefix(Space prefix) {
                return this.prefix == prefix ? this : new Parameter(this.padding, this.id, prefix, this.markers, this.name, this.iterateType);
            }

            @Override
            @Generated
            public Space getPrefix() {
                return this.prefix;
            }

            @NonNull
            @Generated
            public Parameter withMarkers(Markers markers) {
                return this.markers == markers ? this : new Parameter(this.padding, this.id, this.prefix, markers, this.name, this.iterateType);
            }

            @Generated
            public Markers getMarkers() {
                return this.markers;
            }

            @NonNull
            @Generated
            public Parameter withName(Expression name) {
                return this.name == name ? this : new Parameter(this.padding, this.id, this.prefix, this.markers, name, this.iterateType);
            }

            @Generated
            public Expression getName() {
                return this.name;
            }

            public static class Padding {
                private final Parameter t;

                public JLeftPadded<TypeTree> getIterateType() {
                    return this.t.iterateType;
                }

                public Parameter withIterateType(JLeftPadded<TypeTree> iterateType) {
                    return this.t.iterateType == iterateType ? this.t : new Parameter(this.t.id, this.t.prefix, this.t.markers, this.t.name, iterateType);
                }

                @Generated
                public Padding(Parameter t) {
                    this.t = t;
                }
            }
        }
    }

    public static final class LiteralType
    implements JS,
    Expression,
    TypeTree {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression literal;
        private final JavaType type;

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitLiteralType(this, p);
        }

        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LiteralType)) {
                return false;
            }
            LiteralType other = (LiteralType)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Expression this$literal = this.getLiteral();
            Expression other$literal = other.getLiteral();
            if (this$literal == null ? other$literal != null : !this$literal.equals(other$literal)) {
                return false;
            }
            JavaType this$type = this.getType();
            JavaType other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Expression $literal = this.getLiteral();
            result = result * 59 + ($literal == null ? 43 : $literal.hashCode());
            JavaType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public Expression getLiteral() {
            return this.literal;
        }

        @Generated
        public JavaType getType() {
            return this.type;
        }

        @NonNull
        @Generated
        public String toString() {
            return "JS.LiteralType(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", literal=" + this.getLiteral() + ", type=" + this.getType() + ")";
        }

        @Generated
        public LiteralType(UUID id, Space prefix, Markers markers, Expression literal, JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.literal = literal;
            this.type = type;
        }

        @NonNull
        @Generated
        public LiteralType withId(UUID id) {
            return this.id == id ? this : new LiteralType(id, this.prefix, this.markers, this.literal, this.type);
        }

        @NonNull
        @Generated
        public LiteralType withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new LiteralType(this.id, prefix, this.markers, this.literal, this.type);
        }

        @NonNull
        @Generated
        public LiteralType withMarkers(Markers markers) {
            return this.markers == markers ? this : new LiteralType(this.id, this.prefix, markers, this.literal, this.type);
        }

        @NonNull
        @Generated
        public LiteralType withLiteral(Expression literal) {
            return this.literal == literal ? this : new LiteralType(this.id, this.prefix, this.markers, literal, this.type);
        }

        @NonNull
        @Generated
        public LiteralType withType(JavaType type) {
            return this.type == type ? this : new LiteralType(this.id, this.prefix, this.markers, this.literal, type);
        }
    }

    public static final class Binary
    implements JS,
    Expression,
    TypedTree {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression left;
        private final JLeftPadded<Type> operator;
        private final Expression right;
        private final @Nullable JavaType type;

        public Type getOperator() {
            return (Type)((Object)this.operator.getElement());
        }

        public Binary withOperator(Type operator) {
            return this.getPadding().withOperator((JLeftPadded<Type>)this.operator.withElement((Object)operator));
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitBinaryExtensions(this, p);
        }

        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Binary)) {
                return false;
            }
            Binary other = (Binary)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public Binary(UUID id, Space prefix, Markers markers, Expression left, JLeftPadded<Type> operator, Expression right, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.left = left;
            this.operator = operator;
            this.right = right;
            this.type = type;
        }

        @Generated
        private Binary(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Expression left, JLeftPadded<Type> operator, Expression right, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.left = left;
            this.operator = operator;
            this.right = right;
            this.type = type;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public Expression getLeft() {
            return this.left;
        }

        @Generated
        public Expression getRight() {
            return this.right;
        }

        @Generated
        public @Nullable JavaType getType() {
            return this.type;
        }

        @Generated
        public void setPadding(@Nullable WeakReference<Padding> padding) {
            this.padding = padding;
        }

        @NonNull
        @Generated
        public String toString() {
            return "JS.Binary(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", left=" + this.getLeft() + ", operator=" + (Object)((Object)this.getOperator()) + ", right=" + this.getRight() + ", type=" + this.getType() + ")";
        }

        @NonNull
        @Generated
        public Binary withId(UUID id) {
            return this.id == id ? this : new Binary(this.padding, id, this.prefix, this.markers, this.left, this.operator, this.right, this.type);
        }

        @NonNull
        @Generated
        public Binary withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Binary(this.padding, this.id, prefix, this.markers, this.left, this.operator, this.right, this.type);
        }

        @NonNull
        @Generated
        public Binary withMarkers(Markers markers) {
            return this.markers == markers ? this : new Binary(this.padding, this.id, this.prefix, markers, this.left, this.operator, this.right, this.type);
        }

        @NonNull
        @Generated
        public Binary withLeft(Expression left) {
            return this.left == left ? this : new Binary(this.padding, this.id, this.prefix, this.markers, left, this.operator, this.right, this.type);
        }

        @NonNull
        @Generated
        public Binary withRight(Expression right) {
            return this.right == right ? this : new Binary(this.padding, this.id, this.prefix, this.markers, this.left, this.operator, right, this.type);
        }

        @NonNull
        @Generated
        public Binary withType(@Nullable JavaType type) {
            return this.type == type ? this : new Binary(this.padding, this.id, this.prefix, this.markers, this.left, this.operator, this.right, type);
        }

        public static enum Type {
            As,
            IdentityEquals,
            IdentityNotEquals,
            In,
            QuestionQuestion,
            Comma;

        }

        public static class Padding {
            private final Binary t;

            public JLeftPadded<Type> getOperator() {
                return this.t.operator;
            }

            public Binary withOperator(JLeftPadded<Type> operator) {
                return this.t.operator == operator ? this.t : new Binary(this.t.id, this.t.prefix, this.t.markers, this.t.left, operator, this.t.right, this.t.type);
            }

            @Generated
            public Padding(Binary t) {
                this.t = t;
            }
        }
    }

    public static final class ImportAttribute
    implements JS,
    Statement {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression name;
        private final JLeftPadded<Expression> value;

        public Expression getValue() {
            return (Expression)this.value.getElement();
        }

        public ImportAttribute withValue(Expression value) {
            return this.getPadding().withValue((JLeftPadded<Expression>)JLeftPadded.withElement(this.value, (Object)value));
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitImportAttribute(this, p);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ImportAttribute)) {
                return false;
            }
            ImportAttribute other = (ImportAttribute)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public ImportAttribute(UUID id, Space prefix, Markers markers, Expression name, JLeftPadded<Expression> value) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.name = name;
            this.value = value;
        }

        @Generated
        private ImportAttribute(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Expression name, JLeftPadded<Expression> value) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.name = name;
            this.value = value;
        }

        @NonNull
        @Generated
        public ImportAttribute withId(UUID id) {
            return this.id == id ? this : new ImportAttribute(this.padding, id, this.prefix, this.markers, this.name, this.value);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public ImportAttribute withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ImportAttribute(this.padding, this.id, prefix, this.markers, this.name, this.value);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public ImportAttribute withMarkers(Markers markers) {
            return this.markers == markers ? this : new ImportAttribute(this.padding, this.id, this.prefix, markers, this.name, this.value);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public ImportAttribute withName(Expression name) {
            return this.name == name ? this : new ImportAttribute(this.padding, this.id, this.prefix, this.markers, name, this.value);
        }

        @Generated
        public Expression getName() {
            return this.name;
        }

        public static class Padding {
            private final ImportAttribute t;

            public JLeftPadded<Expression> getValue() {
                return this.t.value;
            }

            public ImportAttribute withValue(JLeftPadded<Expression> value) {
                return this.t.value == value ? this.t : new ImportAttribute(this.t.id, this.t.prefix, this.t.markers, this.t.name, value);
            }

            @Generated
            public Padding(ImportAttribute t) {
                this.t = t;
            }
        }
    }

    public static final class ImportTypeAttributes
    implements JS {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JRightPadded<Expression> token;
        private final JContainer<ImportAttribute> elements;
        private final Space end;

        public Expression getToken() {
            return (Expression)this.token.getElement();
        }

        public ImportTypeAttributes withToken(Expression token) {
            return this.getPadding().withToken((JRightPadded<Expression>)JRightPadded.withElement(this.token, (Object)token));
        }

        public List<ImportAttribute> getElements() {
            return this.elements.getElements();
        }

        public ImportTypeAttributes withElements(List<ImportAttribute> elements) {
            return this.getPadding().withElements((JContainer<ImportAttribute>)JContainer.withElements(this.elements, elements));
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitImportTypeAttributes(this, p);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ImportTypeAttributes)) {
                return false;
            }
            ImportTypeAttributes other = (ImportTypeAttributes)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public ImportTypeAttributes(UUID id, Space prefix, Markers markers, JRightPadded<Expression> token, JContainer<ImportAttribute> elements, Space end) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.token = token;
            this.elements = elements;
            this.end = end;
        }

        @Generated
        private ImportTypeAttributes(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JRightPadded<Expression> token, JContainer<ImportAttribute> elements, Space end) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.token = token;
            this.elements = elements;
            this.end = end;
        }

        @NonNull
        @Generated
        public ImportTypeAttributes withId(UUID id) {
            return this.id == id ? this : new ImportTypeAttributes(this.padding, id, this.prefix, this.markers, this.token, this.elements, this.end);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public ImportTypeAttributes withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ImportTypeAttributes(this.padding, this.id, prefix, this.markers, this.token, this.elements, this.end);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public ImportTypeAttributes withMarkers(Markers markers) {
            return this.markers == markers ? this : new ImportTypeAttributes(this.padding, this.id, this.prefix, markers, this.token, this.elements, this.end);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public Space getEnd() {
            return this.end;
        }

        @NonNull
        @Generated
        public ImportTypeAttributes withEnd(Space end) {
            return this.end == end ? this : new ImportTypeAttributes(this.padding, this.id, this.prefix, this.markers, this.token, this.elements, end);
        }

        public static class Padding {
            private final ImportTypeAttributes t;

            public JRightPadded<Expression> getToken() {
                return this.t.token;
            }

            public ImportTypeAttributes withToken(JRightPadded<Expression> token) {
                return this.t.token == token ? this.t : new ImportTypeAttributes(this.t.id, this.t.prefix, this.t.markers, token, (JContainer<ImportAttribute>)this.t.elements, this.t.end);
            }

            public JContainer<ImportAttribute> getElements() {
                return this.t.elements;
            }

            public ImportTypeAttributes withElements(JContainer<ImportAttribute> elements) {
                return this.t.elements == elements ? this.t : new ImportTypeAttributes(this.t.id, this.t.prefix, this.t.markers, (JRightPadded<Expression>)this.t.token, elements, this.t.end);
            }

            @Generated
            public Padding(ImportTypeAttributes t) {
                this.t = t;
            }
        }
    }

    public static final class ImportAttributes
    implements JS {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Token token;
        private final JContainer<Statement> elements;

        public List<Statement> getElements() {
            return this.elements.getElements();
        }

        public ImportAttributes withElements(List<Statement> elements) {
            return this.getPadding().withElements((JContainer<Statement>)JContainer.withElements(this.elements, elements));
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitImportAttributes(this, p);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ImportAttributes)) {
                return false;
            }
            ImportAttributes other = (ImportAttributes)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public ImportAttributes(UUID id, Space prefix, Markers markers, Token token, JContainer<Statement> elements) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.token = token;
            this.elements = elements;
        }

        @Generated
        private ImportAttributes(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Token token, JContainer<Statement> elements) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.token = token;
            this.elements = elements;
        }

        @NonNull
        @Generated
        public ImportAttributes withId(UUID id) {
            return this.id == id ? this : new ImportAttributes(this.padding, id, this.prefix, this.markers, this.token, this.elements);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public ImportAttributes withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ImportAttributes(this.padding, this.id, prefix, this.markers, this.token, this.elements);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public ImportAttributes withMarkers(Markers markers) {
            return this.markers == markers ? this : new ImportAttributes(this.padding, this.id, this.prefix, markers, this.token, this.elements);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public ImportAttributes withToken(Token token) {
            return this.token == token ? this : new ImportAttributes(this.padding, this.id, this.prefix, this.markers, token, this.elements);
        }

        @Generated
        public Token getToken() {
            return this.token;
        }

        public static enum Token {
            With,
            Assert;

        }

        public static class Padding {
            private final ImportAttributes t;

            public JContainer<Statement> getElements() {
                return this.t.elements;
            }

            public ImportAttributes withElements(JContainer<Statement> elements) {
                return this.t.elements == elements ? this.t : new ImportAttributes(this.t.id, this.t.prefix, this.t.markers, this.t.token, elements);
            }

            @Generated
            public Padding(ImportAttributes t) {
                this.t = t;
            }
        }
    }

    public static final class ImportSpecifier
    implements JS,
    Expression,
    TypedTree {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JLeftPadded<Boolean> importType;
        private final Expression specifier;
        private final @Nullable JavaType type;

        public boolean getImportType() {
            return (Boolean)this.importType.getElement();
        }

        public ImportSpecifier withImportType(boolean importType) {
            return this.getPadding().withImportType((JLeftPadded<Boolean>)JLeftPadded.withElement(this.importType, (Object)importType));
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitImportSpecifier(this, p);
        }

        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ImportSpecifier)) {
                return false;
            }
            ImportSpecifier other = (ImportSpecifier)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public ImportSpecifier(UUID id, Space prefix, Markers markers, JLeftPadded<Boolean> importType, Expression specifier, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.importType = importType;
            this.specifier = specifier;
            this.type = type;
        }

        @Generated
        private ImportSpecifier(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JLeftPadded<Boolean> importType, Expression specifier, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.importType = importType;
            this.specifier = specifier;
            this.type = type;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public Expression getSpecifier() {
            return this.specifier;
        }

        @Generated
        public @Nullable JavaType getType() {
            return this.type;
        }

        @Generated
        public void setPadding(@Nullable WeakReference<Padding> padding) {
            this.padding = padding;
        }

        @NonNull
        @Generated
        public String toString() {
            return "JS.ImportSpecifier(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", importType=" + this.getImportType() + ", specifier=" + this.getSpecifier() + ", type=" + this.getType() + ")";
        }

        @NonNull
        @Generated
        public ImportSpecifier withId(UUID id) {
            return this.id == id ? this : new ImportSpecifier(this.padding, id, this.prefix, this.markers, this.importType, this.specifier, this.type);
        }

        @NonNull
        @Generated
        public ImportSpecifier withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ImportSpecifier(this.padding, this.id, prefix, this.markers, this.importType, this.specifier, this.type);
        }

        @NonNull
        @Generated
        public ImportSpecifier withMarkers(Markers markers) {
            return this.markers == markers ? this : new ImportSpecifier(this.padding, this.id, this.prefix, markers, this.importType, this.specifier, this.type);
        }

        @NonNull
        @Generated
        public ImportSpecifier withSpecifier(Expression specifier) {
            return this.specifier == specifier ? this : new ImportSpecifier(this.padding, this.id, this.prefix, this.markers, this.importType, specifier, this.type);
        }

        @NonNull
        @Generated
        public ImportSpecifier withType(@Nullable JavaType type) {
            return this.type == type ? this : new ImportSpecifier(this.padding, this.id, this.prefix, this.markers, this.importType, this.specifier, type);
        }

        public static class Padding {
            private final ImportSpecifier t;

            public JLeftPadded<Boolean> getImportType() {
                return this.t.importType;
            }

            public ImportSpecifier withImportType(JLeftPadded<Boolean> importType) {
                return this.t.importType == importType ? this.t : new ImportSpecifier(this.t.id, this.t.prefix, this.t.markers, importType, this.t.specifier, this.t.type);
            }

            @Generated
            public Padding(ImportSpecifier t) {
                this.t = t;
            }
        }
    }

    public static final class NamedImports
    implements JS,
    Expression {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JContainer<ImportSpecifier> elements;
        private final @Nullable JavaType type;

        public List<ImportSpecifier> getElements() {
            return this.elements.getElements();
        }

        public NamedImports withElements(List<ImportSpecifier> elements) {
            return this.getPadding().withElements((JContainer<ImportSpecifier>)JContainer.withElements(this.elements, elements));
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitNamedImports(this, p);
        }

        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NamedImports)) {
                return false;
            }
            NamedImports other = (NamedImports)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public NamedImports(UUID id, Space prefix, Markers markers, JContainer<ImportSpecifier> elements, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.elements = elements;
            this.type = type;
        }

        @Generated
        private NamedImports(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JContainer<ImportSpecifier> elements, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.elements = elements;
            this.type = type;
        }

        @NonNull
        @Generated
        public NamedImports withId(UUID id) {
            return this.id == id ? this : new NamedImports(this.padding, id, this.prefix, this.markers, this.elements, this.type);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public NamedImports withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new NamedImports(this.padding, this.id, prefix, this.markers, this.elements, this.type);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public NamedImports withMarkers(Markers markers) {
            return this.markers == markers ? this : new NamedImports(this.padding, this.id, this.prefix, markers, this.elements, this.type);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public NamedImports withType(@Nullable JavaType type) {
            return this.type == type ? this : new NamedImports(this.padding, this.id, this.prefix, this.markers, this.elements, type);
        }

        @Generated
        public @Nullable JavaType getType() {
            return this.type;
        }

        public static class Padding {
            private final NamedImports t;

            public JContainer<ImportSpecifier> getElements() {
                return this.t.elements;
            }

            public NamedImports withElements(JContainer<ImportSpecifier> elements) {
                return this.t.elements == elements ? this.t : new NamedImports(this.t.id, this.t.prefix, this.t.markers, elements, this.t.type);
            }

            @Generated
            public Padding(NamedImports t) {
                this.t = t;
            }
        }
    }

    public static class ImportClause
    implements JS {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final boolean typeOnly;
        private final @Nullable JRightPadded<// Could not load outer class - annotation placement on inner may be incorrect
        J.Identifier> name;
        private final @Nullable Expression namedBindings;

        public // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.Identifier getName() {
            return this.name == null ? null : (J.Identifier)this.name.getElement();
        }

        public ImportClause withName(// Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.Identifier name) {
            return this.getPadding().withName((JRightPadded<J.Identifier>)JRightPadded.withElement(this.name, (Object)name));
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitImportClause(this, p);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ImportClause)) {
                return false;
            }
            ImportClause other = (ImportClause)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof ImportClause;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public ImportClause(UUID id, Space prefix, Markers markers, boolean typeOnly, @Nullable JRightPadded<// Could not load outer class - annotation placement on inner may be incorrect
        J.Identifier> name, @Nullable Expression namedBindings) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.typeOnly = typeOnly;
            this.name = name;
            this.namedBindings = namedBindings;
        }

        @Generated
        private ImportClause(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, boolean typeOnly, @Nullable JRightPadded<// Could not load outer class - annotation placement on inner may be incorrect
        J.Identifier> name, @Nullable Expression namedBindings) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.typeOnly = typeOnly;
            this.name = name;
            this.namedBindings = namedBindings;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public ImportClause withId(UUID id) {
            return this.id == id ? this : new ImportClause(this.padding, id, this.prefix, this.markers, this.typeOnly, this.name, this.namedBindings);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public ImportClause withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ImportClause(this.padding, this.id, prefix, this.markers, this.typeOnly, this.name, this.namedBindings);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public ImportClause withMarkers(Markers markers) {
            return this.markers == markers ? this : new ImportClause(this.padding, this.id, this.prefix, markers, this.typeOnly, this.name, this.namedBindings);
        }

        @Generated
        public boolean isTypeOnly() {
            return this.typeOnly;
        }

        @NonNull
        @Generated
        public ImportClause withTypeOnly(boolean typeOnly) {
            return this.typeOnly == typeOnly ? this : new ImportClause(this.padding, this.id, this.prefix, this.markers, typeOnly, this.name, this.namedBindings);
        }

        @NonNull
        @Generated
        public ImportClause withNamedBindings(@Nullable Expression namedBindings) {
            return this.namedBindings == namedBindings ? this : new ImportClause(this.padding, this.id, this.prefix, this.markers, this.typeOnly, this.name, namedBindings);
        }

        @Generated
        public @Nullable Expression getNamedBindings() {
            return this.namedBindings;
        }

        public static class Padding {
            private final ImportClause t;

            public @Nullable JRightPadded<// Could not load outer class - annotation placement on inner may be incorrect
            J.Identifier> getName() {
                return this.t.name;
            }

            public ImportClause withName(@Nullable JRightPadded<// Could not load outer class - annotation placement on inner may be incorrect
            J.Identifier> name) {
                return this.t.name == name ? this.t : new ImportClause(this.t.id, this.t.prefix, this.t.markers, this.t.typeOnly, name, this.t.namedBindings);
            }

            @Generated
            public Padding(ImportClause t) {
                this.t = t;
            }
        }
    }

    public static class Import
    implements JS,
    Statement {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final @Nullable ImportClause importClause;
        private final @Nullable JLeftPadded<Expression> moduleSpecifier;
        private final @Nullable ImportAttributes attributes;
        private final @Nullable JLeftPadded<Expression> initializer;

        public @Nullable Expression getModuleSpecifier() {
            return this.moduleSpecifier != null ? (Expression)this.moduleSpecifier.getElement() : null;
        }

        public Import withModuleSpecifier(@Nullable Expression moduleSpecifier) {
            return this.getPadding().withModuleSpecifier((JLeftPadded<Expression>)JLeftPadded.withElement(this.moduleSpecifier, (Object)moduleSpecifier));
        }

        public @Nullable Expression getInitializer() {
            return this.initializer != null ? (Expression)this.initializer.getElement() : null;
        }

        public Import withInitializer(@Nullable Expression initializer) {
            return this.getPadding().withInitializer((JLeftPadded<Expression>)JLeftPadded.withElement(this.initializer, (Object)initializer));
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitImportDeclaration(this, p);
        }

        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Import)) {
                return false;
            }
            Import other = (Import)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof Import;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public Import(UUID id, Space prefix, Markers markers, @Nullable ImportClause importClause, @Nullable JLeftPadded<Expression> moduleSpecifier, @Nullable ImportAttributes attributes, @Nullable JLeftPadded<Expression> initializer) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.importClause = importClause;
            this.moduleSpecifier = moduleSpecifier;
            this.attributes = attributes;
            this.initializer = initializer;
        }

        @Generated
        private Import(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, @Nullable ImportClause importClause, @Nullable JLeftPadded<Expression> moduleSpecifier, @Nullable ImportAttributes attributes, @Nullable JLeftPadded<Expression> initializer) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.importClause = importClause;
            this.moduleSpecifier = moduleSpecifier;
            this.attributes = attributes;
            this.initializer = initializer;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public Import withId(UUID id) {
            return this.id == id ? this : new Import(this.padding, id, this.prefix, this.markers, this.importClause, this.moduleSpecifier, this.attributes, this.initializer);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public Import withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Import(this.padding, this.id, prefix, this.markers, this.importClause, this.moduleSpecifier, this.attributes, this.initializer);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public Import withMarkers(Markers markers) {
            return this.markers == markers ? this : new Import(this.padding, this.id, this.prefix, markers, this.importClause, this.moduleSpecifier, this.attributes, this.initializer);
        }

        @NonNull
        @Generated
        public Import withImportClause(@Nullable ImportClause importClause) {
            return this.importClause == importClause ? this : new Import(this.padding, this.id, this.prefix, this.markers, importClause, this.moduleSpecifier, this.attributes, this.initializer);
        }

        @Generated
        public @Nullable ImportClause getImportClause() {
            return this.importClause;
        }

        @NonNull
        @Generated
        public Import withAttributes(@Nullable ImportAttributes attributes) {
            return this.attributes == attributes ? this : new Import(this.padding, this.id, this.prefix, this.markers, this.importClause, this.moduleSpecifier, attributes, this.initializer);
        }

        @Generated
        public @Nullable ImportAttributes getAttributes() {
            return this.attributes;
        }

        public static class Padding {
            private final Import t;

            public @Nullable JLeftPadded<Expression> getModuleSpecifier() {
                return this.t.moduleSpecifier;
            }

            public Import withModuleSpecifier(@Nullable JLeftPadded<Expression> moduleSpecifier) {
                return this.t.moduleSpecifier == moduleSpecifier ? this.t : new Import(this.t.id, this.t.prefix, this.t.markers, this.t.importClause, moduleSpecifier, this.t.attributes, (JLeftPadded<Expression>)this.t.initializer);
            }

            public @Nullable JLeftPadded<Expression> getInitializer() {
                return this.t.initializer;
            }

            public Import withInitializer(@Nullable JLeftPadded<Expression> initializer) {
                return this.t.initializer == initializer ? this.t : new Import(this.t.id, this.t.prefix, this.t.markers, this.t.importClause, (JLeftPadded<Expression>)this.t.moduleSpecifier, this.t.attributes, initializer);
            }

            @Generated
            public Padding(Import t) {
                this.t = t;
            }
        }
    }

    public static class ImportType
    implements JS,
    Expression,
    TypeTree {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JRightPadded<Boolean> hasTypeof;
        private final @Nullable JContainer<J> argumentAndAttributes;
        private final @Nullable JLeftPadded<Expression> qualifier;
        private final @Nullable JContainer<Expression> typeArguments;
        private final @Nullable JavaType type;

        public boolean isHasTypeof() {
            return (Boolean)this.hasTypeof.getElement();
        }

        public ImportType withHasTypeof(boolean hasTypeof) {
            return this.getPadding().withHasTypeof((JRightPadded<Boolean>)this.hasTypeof.withElement((Object)hasTypeof));
        }

        public List<J> getArgumentAndAttributes() {
            return this.argumentAndAttributes != null ? this.argumentAndAttributes.getElements() : Collections.emptyList();
        }

        public ImportType withArgumentAndAttributes(@Nullable List<J> argumentAndAttributes) {
            return this.getPadding().withArgumentAndAttributes((JContainer<J>)JContainer.withElementsNullable(this.argumentAndAttributes, argumentAndAttributes));
        }

        public @Nullable Expression getQualifier() {
            return this.qualifier == null ? null : (Expression)this.qualifier.getElement();
        }

        public ImportType withQualifier(@Nullable Expression qualifier) {
            return this.getPadding().withQualifier((JLeftPadded<Expression>)JLeftPadded.withElement(this.qualifier, (Object)qualifier));
        }

        public @Nullable List<Expression> getTypeArguments() {
            return this.typeArguments == null ? null : this.typeArguments.getElements();
        }

        public ImportType withTypeArguments(@Nullable List<Expression> typeArguments) {
            return this.getPadding().withTypeArguments((JContainer<Expression>)JContainer.withElementsNullable(this.typeArguments, typeArguments));
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitImportType(this, p);
        }

        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ImportType)) {
                return false;
            }
            ImportType other = (ImportType)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof ImportType;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public ImportType(UUID id, Space prefix, Markers markers, JRightPadded<Boolean> hasTypeof, @Nullable JContainer<J> argumentAndAttributes, @Nullable JLeftPadded<Expression> qualifier, @Nullable JContainer<Expression> typeArguments, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.hasTypeof = hasTypeof;
            this.argumentAndAttributes = argumentAndAttributes;
            this.qualifier = qualifier;
            this.typeArguments = typeArguments;
            this.type = type;
        }

        @Generated
        private ImportType(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JRightPadded<Boolean> hasTypeof, @Nullable JContainer<J> argumentAndAttributes, @Nullable JLeftPadded<Expression> qualifier, @Nullable JContainer<Expression> typeArguments, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.hasTypeof = hasTypeof;
            this.argumentAndAttributes = argumentAndAttributes;
            this.qualifier = qualifier;
            this.typeArguments = typeArguments;
            this.type = type;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public ImportType withId(UUID id) {
            return this.id == id ? this : new ImportType(this.padding, id, this.prefix, this.markers, this.hasTypeof, this.argumentAndAttributes, this.qualifier, this.typeArguments, this.type);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public ImportType withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ImportType(this.padding, this.id, prefix, this.markers, this.hasTypeof, this.argumentAndAttributes, this.qualifier, this.typeArguments, this.type);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public ImportType withMarkers(Markers markers) {
            return this.markers == markers ? this : new ImportType(this.padding, this.id, this.prefix, markers, this.hasTypeof, this.argumentAndAttributes, this.qualifier, this.typeArguments, this.type);
        }

        @Generated
        public @Nullable JavaType getType() {
            return this.type;
        }

        @NonNull
        @Generated
        public ImportType withType(@Nullable JavaType type) {
            return this.type == type ? this : new ImportType(this.padding, this.id, this.prefix, this.markers, this.hasTypeof, this.argumentAndAttributes, this.qualifier, this.typeArguments, type);
        }

        public static class Padding {
            private final ImportType t;

            public JRightPadded<Boolean> getHasTypeof() {
                return this.t.hasTypeof;
            }

            public ImportType withHasTypeof(JRightPadded<Boolean> hasTypeof) {
                return this.t.hasTypeof == hasTypeof ? this.t : new ImportType(this.t.id, this.t.prefix, this.t.markers, hasTypeof, (JContainer<J>)this.t.argumentAndAttributes, (JLeftPadded<Expression>)this.t.qualifier, (JContainer<Expression>)this.t.typeArguments, this.t.type);
            }

            public @Nullable JContainer<J> getArgumentAndAttributes() {
                return this.t.argumentAndAttributes;
            }

            public ImportType withArgumentAndAttributes(@Nullable JContainer<J> argumentAndAttributes) {
                return this.t.argumentAndAttributes == argumentAndAttributes ? this.t : new ImportType(this.t.id, this.t.prefix, this.t.markers, (JRightPadded<Boolean>)this.t.hasTypeof, argumentAndAttributes, (JLeftPadded<Expression>)this.t.qualifier, (JContainer<Expression>)this.t.typeArguments, this.t.type);
            }

            public @Nullable JLeftPadded<Expression> getQualifier() {
                return this.t.qualifier;
            }

            public ImportType withQualifier(@Nullable JLeftPadded<Expression> qualifier) {
                return this.t.qualifier == qualifier ? this.t : new ImportType(this.t.id, this.t.prefix, this.t.markers, (JRightPadded<Boolean>)this.t.hasTypeof, (JContainer<J>)this.t.argumentAndAttributes, qualifier, (JContainer<Expression>)this.t.typeArguments, this.t.type);
            }

            public @Nullable JContainer<Expression> getTypeArguments() {
                return this.t.typeArguments;
            }

            public ImportType withTypeArguments(@Nullable JContainer<Expression> typeArguments) {
                return this.t.typeArguments == typeArguments ? this.t : new ImportType(this.t.id, this.t.prefix, this.t.markers, (JRightPadded<Boolean>)this.t.hasTypeof, (JContainer<J>)this.t.argumentAndAttributes, (JLeftPadded<Expression>)this.t.qualifier, typeArguments, this.t.type);
            }

            @Generated
            public Padding(ImportType t) {
                this.t = t;
            }
        }
    }

    public static final class InferType
    implements JS,
    TypeTree,
    Expression {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JLeftPadded<J> typeParameter;
        private final @Nullable JavaType type;

        public J getTypeParameter() {
            return (J)this.typeParameter.getElement();
        }

        public InferType withTypeParameter(J typeParameter) {
            return this.getPadding().withTypeParameter((JLeftPadded<J>)JLeftPadded.withElement(this.typeParameter, (Object)typeParameter));
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitInferType(this, p);
        }

        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InferType)) {
                return false;
            }
            InferType other = (InferType)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public InferType(UUID id, Space prefix, Markers markers, JLeftPadded<J> typeParameter, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.typeParameter = typeParameter;
            this.type = type;
        }

        @Generated
        private InferType(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JLeftPadded<J> typeParameter, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.typeParameter = typeParameter;
            this.type = type;
        }

        @NonNull
        @Generated
        public InferType withId(UUID id) {
            return this.id == id ? this : new InferType(this.padding, id, this.prefix, this.markers, this.typeParameter, this.type);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public InferType withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new InferType(this.padding, this.id, prefix, this.markers, this.typeParameter, this.type);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public InferType withMarkers(Markers markers) {
            return this.markers == markers ? this : new InferType(this.padding, this.id, this.prefix, markers, this.typeParameter, this.type);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public @Nullable JavaType getType() {
            return this.type;
        }

        @NonNull
        @Generated
        public InferType withType(@Nullable JavaType type) {
            return this.type == type ? this : new InferType(this.padding, this.id, this.prefix, this.markers, this.typeParameter, type);
        }

        public static class Padding {
            private final InferType t;

            public JLeftPadded<J> getTypeParameter() {
                return this.t.typeParameter;
            }

            public InferType withTypeParameter(JLeftPadded<J> typeParameter) {
                return this.t.typeParameter == typeParameter ? this.t : new InferType(this.t.id, this.t.prefix, this.t.markers, typeParameter, this.t.type);
            }

            @Generated
            public Padding(InferType t) {
                this.t = t;
            }
        }
    }

    public static class FunctionType
    implements JS,
    Expression,
    TypeTree {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<J.Modifier> modifiers;
        private final JLeftPadded<Boolean> constructorType;
        private final // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.TypeParameters typeParameters;
        private final JContainer<Statement> parameters;
        private final JLeftPadded<Expression> returnType;
        private final @Nullable JavaType type;

        public boolean isConstructorType() {
            return (Boolean)this.constructorType.getElement();
        }

        public FunctionType withConstructorType(boolean constructor) {
            return this.getPadding().withConstructorType((JLeftPadded<Boolean>)this.constructorType.withElement((Object)constructor));
        }

        public List<Statement> getParameters() {
            return this.parameters.getElements();
        }

        public FunctionType withParameters(List<Statement> parameters) {
            return this.getPadding().withParameters((JContainer<Statement>)JContainer.withElements(this.parameters, parameters));
        }

        public Expression getReturnType() {
            return (Expression)this.returnType.getElement();
        }

        public FunctionType withReturnType(Expression returnType) {
            return this.getPadding().withReturnType((JLeftPadded<Expression>)JLeftPadded.withElement(this.returnType, (Object)returnType));
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitFunctionType(this, p);
        }

        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FunctionType)) {
                return false;
            }
            FunctionType other = (FunctionType)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof FunctionType;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public FunctionType(UUID id, Space prefix, Markers markers, List<J.Modifier> modifiers, JLeftPadded<Boolean> constructorType, // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.TypeParameters typeParameters, JContainer<Statement> parameters, JLeftPadded<Expression> returnType, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.modifiers = modifiers;
            this.constructorType = constructorType;
            this.typeParameters = typeParameters;
            this.parameters = parameters;
            this.returnType = returnType;
            this.type = type;
        }

        @Generated
        private FunctionType(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, List<J.Modifier> modifiers, JLeftPadded<Boolean> constructorType, // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.TypeParameters typeParameters, JContainer<Statement> parameters, JLeftPadded<Expression> returnType, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.modifiers = modifiers;
            this.constructorType = constructorType;
            this.typeParameters = typeParameters;
            this.parameters = parameters;
            this.returnType = returnType;
            this.type = type;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public FunctionType withId(UUID id) {
            return this.id == id ? this : new FunctionType(this.padding, id, this.prefix, this.markers, this.modifiers, this.constructorType, this.typeParameters, this.parameters, this.returnType, this.type);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public FunctionType withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new FunctionType(this.padding, this.id, prefix, this.markers, this.modifiers, this.constructorType, this.typeParameters, this.parameters, this.returnType, this.type);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public FunctionType withMarkers(Markers markers) {
            return this.markers == markers ? this : new FunctionType(this.padding, this.id, this.prefix, markers, this.modifiers, this.constructorType, this.typeParameters, this.parameters, this.returnType, this.type);
        }

        @Generated
        public List<J.Modifier> getModifiers() {
            return this.modifiers;
        }

        @NonNull
        @Generated
        public FunctionType withModifiers(List<J.Modifier> modifiers) {
            return this.modifiers == modifiers ? this : new FunctionType(this.padding, this.id, this.prefix, this.markers, modifiers, this.constructorType, this.typeParameters, this.parameters, this.returnType, this.type);
        }

        @Generated
        public // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.TypeParameters getTypeParameters() {
            return this.typeParameters;
        }

        @NonNull
        @Generated
        public FunctionType withTypeParameters(// Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.TypeParameters typeParameters) {
            return this.typeParameters == typeParameters ? this : new FunctionType(this.padding, this.id, this.prefix, this.markers, this.modifiers, this.constructorType, typeParameters, this.parameters, this.returnType, this.type);
        }

        @Generated
        public @Nullable JavaType getType() {
            return this.type;
        }

        @NonNull
        @Generated
        public FunctionType withType(@Nullable JavaType type) {
            return this.type == type ? this : new FunctionType(this.padding, this.id, this.prefix, this.markers, this.modifiers, this.constructorType, this.typeParameters, this.parameters, this.returnType, type);
        }

        public static class Padding {
            private final FunctionType t;

            public JLeftPadded<Boolean> getConstructorType() {
                return this.t.constructorType;
            }

            public FunctionType withConstructorType(JLeftPadded<Boolean> constructor) {
                return this.t.constructorType == constructor ? this.t : new FunctionType(this.t.id, this.t.prefix, this.t.markers, this.t.modifiers, constructor, this.t.typeParameters, (JContainer<Statement>)this.t.parameters, (JLeftPadded<Expression>)this.t.returnType, this.t.type);
            }

            public JContainer<Statement> getParameters() {
                return this.t.parameters;
            }

            public FunctionType withParameters(JContainer<Statement> parameters) {
                return this.t.parameters == parameters ? this.t : new FunctionType(this.t.id, this.t.prefix, this.t.markers, this.t.modifiers, (JLeftPadded<Boolean>)this.t.constructorType, this.t.typeParameters, parameters, (JLeftPadded<Expression>)this.t.returnType, this.t.type);
            }

            public JLeftPadded<Expression> getReturnType() {
                return this.t.returnType;
            }

            public FunctionType withReturnType(JLeftPadded<Expression> returnType) {
                return this.t.returnType == returnType ? this.t : new FunctionType(this.t.id, this.t.prefix, this.t.markers, this.t.modifiers, (JLeftPadded<Boolean>)this.t.constructorType, this.t.typeParameters, (JContainer<Statement>)this.t.parameters, returnType, this.t.type);
            }

            @Generated
            public Padding(FunctionType t) {
                this.t = t;
            }
        }
    }

    public static final class ExpressionWithTypeArguments
    implements JS,
    TypeTree,
    Expression {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final J clazz;
        private final @Nullable JContainer<Expression> typeArguments;
        private final @Nullable JavaType type;

        public @Nullable List<Expression> getTypeArguments() {
            return this.typeArguments == null ? null : this.typeArguments.getElements();
        }

        public ExpressionWithTypeArguments withTypeArguments(@Nullable List<Expression> typeParameters) {
            return this.getPadding().withTypeArguments((JContainer<Expression>)JContainer.withElementsNullable(this.typeArguments, typeParameters));
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitExpressionWithTypeArguments(this, p);
        }

        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed((TreeVisitor)new JavaPrinter());
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExpressionWithTypeArguments)) {
                return false;
            }
            ExpressionWithTypeArguments other = (ExpressionWithTypeArguments)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public ExpressionWithTypeArguments(UUID id, Space prefix, Markers markers, J clazz, @Nullable JContainer<Expression> typeArguments, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.clazz = clazz;
            this.typeArguments = typeArguments;
            this.type = type;
        }

        @Generated
        private ExpressionWithTypeArguments(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, J clazz, @Nullable JContainer<Expression> typeArguments, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.clazz = clazz;
            this.typeArguments = typeArguments;
            this.type = type;
        }

        @NonNull
        @Generated
        public ExpressionWithTypeArguments withId(UUID id) {
            return this.id == id ? this : new ExpressionWithTypeArguments(this.padding, id, this.prefix, this.markers, this.clazz, this.typeArguments, this.type);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public ExpressionWithTypeArguments withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ExpressionWithTypeArguments(this.padding, this.id, prefix, this.markers, this.clazz, this.typeArguments, this.type);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public ExpressionWithTypeArguments withMarkers(Markers markers) {
            return this.markers == markers ? this : new ExpressionWithTypeArguments(this.padding, this.id, this.prefix, markers, this.clazz, this.typeArguments, this.type);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public ExpressionWithTypeArguments withClazz(J clazz) {
            return this.clazz == clazz ? this : new ExpressionWithTypeArguments(this.padding, this.id, this.prefix, this.markers, clazz, this.typeArguments, this.type);
        }

        @Generated
        public J getClazz() {
            return this.clazz;
        }

        @NonNull
        @Generated
        public ExpressionWithTypeArguments withType(@Nullable JavaType type) {
            return this.type == type ? this : new ExpressionWithTypeArguments(this.padding, this.id, this.prefix, this.markers, this.clazz, this.typeArguments, type);
        }

        @Generated
        public @Nullable JavaType getType() {
            return this.type;
        }

        public static class Padding {
            private final ExpressionWithTypeArguments t;

            public @Nullable JContainer<Expression> getTypeArguments() {
                return this.t.typeArguments;
            }

            public ExpressionWithTypeArguments withTypeArguments(@Nullable JContainer<Expression> typeArguments) {
                return this.t.typeArguments == typeArguments ? this.t : new ExpressionWithTypeArguments(this.t.id, this.t.prefix, this.t.markers, this.t.clazz, typeArguments, this.t.type);
            }

            @Generated
            public Padding(ExpressionWithTypeArguments t) {
                this.t = t;
            }
        }
    }

    public static final class TrailingTokenStatement
    implements JS,
    Expression,
    Statement {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JRightPadded<J> expression;
        private final @Nullable JavaType type;

        public J getExpression() {
            return (J)this.expression.getElement();
        }

        public TrailingTokenStatement withExpression(J expression) {
            return this.getPadding().withExpression((JRightPadded<J>)JRightPadded.withElement(this.expression, (Object)expression));
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitTrailingTokenStatement(this, p);
        }

        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            return o instanceof TrailingTokenStatement;
        }

        @Generated
        public int hashCode() {
            boolean result = true;
            return 1;
        }

        @Generated
        public TrailingTokenStatement(UUID id, Space prefix, Markers markers, JRightPadded<J> expression, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.expression = expression;
            this.type = type;
        }

        @Generated
        private TrailingTokenStatement(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JRightPadded<J> expression, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.expression = expression;
            this.type = type;
        }

        @NonNull
        @Generated
        public TrailingTokenStatement withId(UUID id) {
            return this.id == id ? this : new TrailingTokenStatement(this.padding, id, this.prefix, this.markers, this.expression, this.type);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public TrailingTokenStatement withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new TrailingTokenStatement(this.padding, this.id, prefix, this.markers, this.expression, this.type);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public TrailingTokenStatement withMarkers(Markers markers) {
            return this.markers == markers ? this : new TrailingTokenStatement(this.padding, this.id, this.prefix, markers, this.expression, this.type);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public TrailingTokenStatement withType(@Nullable JavaType type) {
            return this.type == type ? this : new TrailingTokenStatement(this.padding, this.id, this.prefix, this.markers, this.expression, type);
        }

        @Generated
        public @Nullable JavaType getType() {
            return this.type;
        }

        public static class Padding {
            private final TrailingTokenStatement t;

            public JRightPadded<J> getExpression() {
                return this.t.expression;
            }

            public TrailingTokenStatement withExpression(JRightPadded<J> expression) {
                return this.t.expression == expression ? this.t : new TrailingTokenStatement(this.t.id, this.t.prefix, this.t.markers, expression, this.t.type);
            }

            @Generated
            public Padding(TrailingTokenStatement t) {
                this.t = t;
            }
        }
    }

    public static final class ExpressionStatement
    implements JS,
    Expression,
    Statement {
        private final UUID id;
        private final Expression expression;

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitExpressionStatement(this, p);
        }

        public <J2 extends J> J2 withPrefix(Space space) {
            return (J2)this.withExpression((Expression)this.expression.withPrefix(space));
        }

        @Override
        public Space getPrefix() {
            return this.expression.getPrefix();
        }

        public <J2 extends Tree> J2 withMarkers(Markers markers) {
            return (J2)this.withExpression((Expression)this.expression.withMarkers(markers));
        }

        public Markers getMarkers() {
            return this.expression.getMarkers();
        }

        public @Nullable JavaType getType() {
            return this.expression.getType();
        }

        public ExpressionStatement withType(@Nullable JavaType type) {
            return this.withExpression((Expression)this.expression.withType(type));
        }

        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public Expression getExpression() {
            return this.expression;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            return o instanceof ExpressionStatement;
        }

        @Generated
        public int hashCode() {
            boolean result = true;
            return 1;
        }

        @Generated
        public ExpressionStatement(UUID id, Expression expression) {
            this.id = id;
            this.expression = expression;
        }

        @NonNull
        @Generated
        public ExpressionStatement withId(UUID id) {
            return this.id == id ? this : new ExpressionStatement(id, this.expression);
        }

        @NonNull
        @Generated
        public ExpressionStatement withExpression(Expression expression) {
            return this.expression == expression ? this : new ExpressionStatement(this.id, expression);
        }
    }

    public static final class Delete
    implements JS,
    Expression,
    Statement {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression expression;

        public @Nullable JavaType getType() {
            return this.expression.getType();
        }

        public Delete withType(@Nullable JavaType type) {
            return this.withExpression((Expression)this.expression.withType(type));
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitDelete(this, p);
        }

        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Delete)) {
                return false;
            }
            Delete other = (Delete)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public Delete(UUID id, Space prefix, Markers markers, Expression expression) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.expression = expression;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public Expression getExpression() {
            return this.expression;
        }

        @NonNull
        @Generated
        public String toString() {
            return "JS.Delete(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", expression=" + this.getExpression() + ")";
        }

        @NonNull
        @Generated
        public Delete withId(UUID id) {
            return this.id == id ? this : new Delete(id, this.prefix, this.markers, this.expression);
        }

        @NonNull
        @Generated
        public Delete withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Delete(this.id, prefix, this.markers, this.expression);
        }

        @NonNull
        @Generated
        public Delete withMarkers(Markers markers) {
            return this.markers == markers ? this : new Delete(this.id, this.prefix, markers, this.expression);
        }

        @NonNull
        @Generated
        public Delete withExpression(Expression expression) {
            return this.expression == expression ? this : new Delete(this.id, this.prefix, this.markers, expression);
        }
    }

    public static final class ConditionalType
    implements JS,
    TypeTree,
    Expression {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression checkType;
        private final JLeftPadded<J.Ternary> condition;
        private final @Nullable JavaType type;

        public J.Ternary getCondition() {
            return (J.Ternary)this.condition.getElement();
        }

        public ConditionalType withCondition(J.Ternary condition) {
            return this.getPadding().withCondition((JLeftPadded<J.Ternary>)JLeftPadded.withElement(this.condition, (Object)condition));
        }

        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitConditionalType(this, p);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConditionalType)) {
                return false;
            }
            ConditionalType other = (ConditionalType)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public ConditionalType(UUID id, Space prefix, Markers markers, Expression checkType, JLeftPadded<J.Ternary> condition, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.checkType = checkType;
            this.condition = condition;
            this.type = type;
        }

        @Generated
        private ConditionalType(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Expression checkType, JLeftPadded<J.Ternary> condition, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.checkType = checkType;
            this.condition = condition;
            this.type = type;
        }

        @NonNull
        @Generated
        public ConditionalType withId(UUID id) {
            return this.id == id ? this : new ConditionalType(this.padding, id, this.prefix, this.markers, this.checkType, this.condition, this.type);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public ConditionalType withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ConditionalType(this.padding, this.id, prefix, this.markers, this.checkType, this.condition, this.type);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public ConditionalType withMarkers(Markers markers) {
            return this.markers == markers ? this : new ConditionalType(this.padding, this.id, this.prefix, markers, this.checkType, this.condition, this.type);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public ConditionalType withCheckType(Expression checkType) {
            return this.checkType == checkType ? this : new ConditionalType(this.padding, this.id, this.prefix, this.markers, checkType, this.condition, this.type);
        }

        @Generated
        public Expression getCheckType() {
            return this.checkType;
        }

        @NonNull
        @Generated
        public ConditionalType withType(@Nullable JavaType type) {
            return this.type == type ? this : new ConditionalType(this.padding, this.id, this.prefix, this.markers, this.checkType, this.condition, type);
        }

        @Generated
        public @Nullable JavaType getType() {
            return this.type;
        }

        public static class Padding {
            private final ConditionalType t;

            public JLeftPadded<J.Ternary> getCondition() {
                return this.t.condition;
            }

            public ConditionalType withCondition(JLeftPadded<J.Ternary> condition) {
                return this.t.condition == condition ? this.t : new ConditionalType(this.t.id, this.t.prefix, this.t.markers, this.t.checkType, condition, this.t.type);
            }

            @Generated
            public Padding(ConditionalType t) {
                this.t = t;
            }
        }
    }

    public static final class Await
    implements JS,
    Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression expression;
        private final @Nullable JavaType type;

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitAwait(this, p);
        }

        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public Expression getExpression() {
            return this.expression;
        }

        @Generated
        public @Nullable JavaType getType() {
            return this.type;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Await)) {
                return false;
            }
            Await other = (Await)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public Await(UUID id, Space prefix, Markers markers, Expression expression, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.expression = expression;
            this.type = type;
        }

        @NonNull
        @Generated
        public Await withId(UUID id) {
            return this.id == id ? this : new Await(id, this.prefix, this.markers, this.expression, this.type);
        }

        @NonNull
        @Generated
        public Await withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Await(this.id, prefix, this.markers, this.expression, this.type);
        }

        @NonNull
        @Generated
        public Await withMarkers(Markers markers) {
            return this.markers == markers ? this : new Await(this.id, this.prefix, markers, this.expression, this.type);
        }

        @NonNull
        @Generated
        public Await withExpression(Expression expression) {
            return this.expression == expression ? this : new Await(this.id, this.prefix, this.markers, expression, this.type);
        }

        @NonNull
        @Generated
        public Await withType(@Nullable JavaType type) {
            return this.type == type ? this : new Await(this.id, this.prefix, this.markers, this.expression, type);
        }
    }

    public static final class ArrowFunction
    implements JS,
    Statement,
    Expression,
    TypedTree {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<J.Annotation> leadingAnnotations;
        private final List<J.Modifier> modifiers;
        private final // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.TypeParameters typeParameters;
        private final J.Lambda lambda;
        private final @Nullable TypeTree returnTypeExpression;

        public @Nullable JavaType getType() {
            return this.lambda.getType();
        }

        public ArrowFunction withType(@Nullable JavaType type) {
            return this.withLambda(this.lambda.withType(type));
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitArrowFunction(this, p);
        }

        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public List<J.Annotation> getLeadingAnnotations() {
            return this.leadingAnnotations;
        }

        @Generated
        public List<J.Modifier> getModifiers() {
            return this.modifiers;
        }

        @Generated
        public // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.TypeParameters getTypeParameters() {
            return this.typeParameters;
        }

        @Generated
        public J.Lambda getLambda() {
            return this.lambda;
        }

        @Generated
        public @Nullable TypeTree getReturnTypeExpression() {
            return this.returnTypeExpression;
        }

        @NonNull
        @Generated
        public String toString() {
            return "JS.ArrowFunction(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", leadingAnnotations=" + this.getLeadingAnnotations() + ", modifiers=" + this.getModifiers() + ", typeParameters=" + this.getTypeParameters() + ", lambda=" + this.getLambda() + ", returnTypeExpression=" + this.getReturnTypeExpression() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ArrowFunction)) {
                return false;
            }
            ArrowFunction other = (ArrowFunction)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        @Generated
        public ArrowFunction(UUID id, Space prefix, Markers markers, List<J.Annotation> leadingAnnotations, List<J.Modifier> modifiers, // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.TypeParameters typeParameters, J.Lambda lambda, @Nullable TypeTree returnTypeExpression) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.leadingAnnotations = leadingAnnotations;
            this.modifiers = modifiers;
            this.typeParameters = typeParameters;
            this.lambda = lambda;
            this.returnTypeExpression = returnTypeExpression;
        }

        @NonNull
        @Generated
        public ArrowFunction withId(UUID id) {
            return this.id == id ? this : new ArrowFunction(id, this.prefix, this.markers, this.leadingAnnotations, this.modifiers, this.typeParameters, this.lambda, this.returnTypeExpression);
        }

        @NonNull
        @Generated
        public ArrowFunction withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ArrowFunction(this.id, prefix, this.markers, this.leadingAnnotations, this.modifiers, this.typeParameters, this.lambda, this.returnTypeExpression);
        }

        @NonNull
        @Generated
        public ArrowFunction withMarkers(Markers markers) {
            return this.markers == markers ? this : new ArrowFunction(this.id, this.prefix, markers, this.leadingAnnotations, this.modifiers, this.typeParameters, this.lambda, this.returnTypeExpression);
        }

        @NonNull
        @Generated
        public ArrowFunction withLeadingAnnotations(List<J.Annotation> leadingAnnotations) {
            return this.leadingAnnotations == leadingAnnotations ? this : new ArrowFunction(this.id, this.prefix, this.markers, leadingAnnotations, this.modifiers, this.typeParameters, this.lambda, this.returnTypeExpression);
        }

        @NonNull
        @Generated
        public ArrowFunction withModifiers(List<J.Modifier> modifiers) {
            return this.modifiers == modifiers ? this : new ArrowFunction(this.id, this.prefix, this.markers, this.leadingAnnotations, modifiers, this.typeParameters, this.lambda, this.returnTypeExpression);
        }

        @NonNull
        @Generated
        public ArrowFunction withTypeParameters(// Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.TypeParameters typeParameters) {
            return this.typeParameters == typeParameters ? this : new ArrowFunction(this.id, this.prefix, this.markers, this.leadingAnnotations, this.modifiers, typeParameters, this.lambda, this.returnTypeExpression);
        }

        @NonNull
        @Generated
        public ArrowFunction withLambda(J.Lambda lambda) {
            return this.lambda == lambda ? this : new ArrowFunction(this.id, this.prefix, this.markers, this.leadingAnnotations, this.modifiers, this.typeParameters, lambda, this.returnTypeExpression);
        }

        @NonNull
        @Generated
        public ArrowFunction withReturnTypeExpression(@Nullable TypeTree returnTypeExpression) {
            return this.returnTypeExpression == returnTypeExpression ? this : new ArrowFunction(this.id, this.prefix, this.markers, this.leadingAnnotations, this.modifiers, this.typeParameters, this.lambda, returnTypeExpression);
        }
    }

    public static final class Alias
    implements JS,
    Expression {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JRightPadded<J.Identifier> propertyName;
        private final Expression alias;

        public J.Identifier getPropertyName() {
            return (J.Identifier)this.propertyName.getElement();
        }

        public Alias withPropertyName(J.Identifier propertyName) {
            return this.getPadding().withPropertyName((JRightPadded<J.Identifier>)this.propertyName.withElement((Object)propertyName));
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitAlias(this, p);
        }

        public @Nullable JavaType getType() {
            return ((J.Identifier)this.propertyName.getElement()).getType();
        }

        public Alias withType(@Nullable JavaType type) {
            return this.withPropertyName(((J.Identifier)this.propertyName.getElement()).withType(type));
        }

        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Alias)) {
                return false;
            }
            Alias other = (Alias)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public Alias(UUID id, Space prefix, Markers markers, JRightPadded<J.Identifier> propertyName, Expression alias) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.propertyName = propertyName;
            this.alias = alias;
        }

        @Generated
        private Alias(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JRightPadded<J.Identifier> propertyName, Expression alias) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.propertyName = propertyName;
            this.alias = alias;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public Expression getAlias() {
            return this.alias;
        }

        @Generated
        public void setPadding(@Nullable WeakReference<Padding> padding) {
            this.padding = padding;
        }

        @NonNull
        @Generated
        public String toString() {
            return "JS.Alias(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", propertyName=" + this.getPropertyName() + ", alias=" + this.getAlias() + ")";
        }

        @NonNull
        @Generated
        public Alias withId(UUID id) {
            return this.id == id ? this : new Alias(this.padding, id, this.prefix, this.markers, this.propertyName, this.alias);
        }

        @NonNull
        @Generated
        public Alias withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Alias(this.padding, this.id, prefix, this.markers, this.propertyName, this.alias);
        }

        @NonNull
        @Generated
        public Alias withMarkers(Markers markers) {
            return this.markers == markers ? this : new Alias(this.padding, this.id, this.prefix, markers, this.propertyName, this.alias);
        }

        @NonNull
        @Generated
        public Alias withAlias(Expression alias) {
            return this.alias == alias ? this : new Alias(this.padding, this.id, this.prefix, this.markers, this.propertyName, alias);
        }

        public static class Padding {
            private final Alias t;

            public JRightPadded<J.Identifier> getPropertyName() {
                return this.t.propertyName;
            }

            public Alias withPropertyName(JRightPadded<J.Identifier> propertyName) {
                return this.t.propertyName == propertyName ? this.t : new Alias(this.t.id, this.t.prefix, this.t.markers, propertyName, this.t.alias);
            }

            @Generated
            public Padding(Alias t) {
                this.t = t;
            }
        }
    }

    public static final class CompilationUnit
    implements JS,
    JavaSourceFile,
    SourceFile {
        private transient @Nullable SoftReference<TypesInUse> typesInUse;
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Path sourcePath;
        private final @Nullable FileAttributes fileAttributes;
        private final @Nullable String charsetName;
        private final boolean charsetBomMarked;
        private final @Nullable Checksum checksum;
        private final List<JRightPadded<J.Import>> imports;
        private final List<JRightPadded<Statement>> statements;
        private final Space eof;

        public Charset getCharset() {
            return this.charsetName == null ? StandardCharsets.UTF_8 : Charset.forName(this.charsetName);
        }

        public SourceFile withCharset(Charset charset) {
            return this.withCharsetName(charset.name());
        }

        public List<J.Import> getImports() {
            return JRightPadded.getElements(this.imports);
        }

        public CompilationUnit withImports(List<J.Import> imports) {
            return this.getPadding().withImports(JRightPadded.withElements(this.imports, imports));
        }

        public List<Statement> getStatements() {
            return JRightPadded.getElements(this.statements);
        }

        public CompilationUnit withStatements(List<Statement> statements) {
            return this.getPadding().withStatements(JRightPadded.withElements(this.statements, statements));
        }

        @Transient
        public List<J.ClassDeclaration> getClasses() {
            return this.statements.stream().map(JRightPadded::getElement).filter(J.ClassDeclaration.class::isInstance).map(J.ClassDeclaration.class::cast).collect(Collectors.toList());
        }

        public JavaSourceFile withClasses(List<J.ClassDeclaration> classes) {
            return this;
        }

        @Override
        public <P> J acceptJavaScript(JavaScriptVisitor<P> v, P p) {
            return v.visitJsCompilationUnit(this, p);
        }

        public <P> TreeVisitor<?, PrintOutputCapture<P>> printer(final Cursor cursor) {
            return new TreeVisitor<Tree, PrintOutputCapture<P>>(){

                public Tree visit(@Nullable Tree tree, PrintOutputCapture<P> p, Cursor parent) {
                    try (ManagedThreadLocal.Scope scope = JavaScriptRewriteRpc.current().requireOrCreate(JavaScriptRewriteRpc.bundledInstallation(Environment.builder().build())::build);){
                        Tree tree2 = (Tree)scope.map(rpc -> {
                            Print.MarkerPrinter mappedMarkerPrinter = Print.MarkerPrinter.from((PrintOutputCapture.MarkerPrinter)p.getMarkerPrinter());
                            p.append(rpc.print(tree, cursor, mappedMarkerPrinter));
                            return tree;
                        });
                        return tree2;
                    }
                }
            };
        }

        @Transient
        public TypesInUse getTypesInUse() {
            TypesInUse cache;
            if (this.typesInUse == null) {
                cache = TypesInUse.build((JavaSourceFile)this);
                this.typesInUse = new SoftReference<TypesInUse>(cache);
            } else {
                cache = this.typesInUse.get();
                if (cache == null || cache.getCu() != this) {
                    cache = TypesInUse.build((JavaSourceFile)this);
                    this.typesInUse = new SoftReference<TypesInUse>(cache);
                }
            }
            return cache;
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.Package getPackageDeclaration() {
            return null;
        }

        public JavaSourceFile withPackageDeclaration(J.Package pkg) {
            throw new IllegalStateException("JavaScript does not support package declarations");
        }

        public <S, T extends S> T service(Class<S> service) {
            String serviceName = service.getName();
            try {
                return (T)super.service(service);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Transient
        public long getWeight(final Predicate<Object> uniqueIdentity) {
            AtomicInteger n = new AtomicInteger();
            new JavaScriptVisitor<AtomicInteger>(){
                final JavaTypeVisitor<AtomicInteger> typeVisitor = new JavaTypeVisitor<AtomicInteger>(){

                    public JavaType visit(@Nullable JavaType javaType, AtomicInteger n) {
                        if (javaType != null && uniqueIdentity.test(javaType)) {
                            n.incrementAndGet();
                            return super.visitNonNull(javaType, (Object)n);
                        }
                        return javaType;
                    }
                };

                public J preVisit(J tree, AtomicInteger n) {
                    n.incrementAndGet();
                    return tree;
                }

                public @Nullable JavaType visitType(@Nullable JavaType javaType, AtomicInteger n) {
                    return this.typeVisitor.visit(javaType, (Object)n);
                }
            }.visit((Tree)this, n);
            return n.get();
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @NonNull
        @Generated
        public String toString() {
            return "JS.CompilationUnit(typesInUse=" + this.getTypesInUse() + ", padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", sourcePath=" + this.getSourcePath() + ", fileAttributes=" + this.getFileAttributes() + ", charsetName=" + this.charsetName + ", charsetBomMarked=" + this.isCharsetBomMarked() + ", checksum=" + this.getChecksum() + ", imports=" + this.getImports() + ", statements=" + this.getStatements() + ", eof=" + this.getEof() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CompilationUnit)) {
                return false;
            }
            CompilationUnit other = (CompilationUnit)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public CompilationUnit(UUID id, Space prefix, Markers markers, Path sourcePath, @Nullable FileAttributes fileAttributes, @Nullable String charsetName, boolean charsetBomMarked, @Nullable Checksum checksum, List<JRightPadded<J.Import>> imports, List<JRightPadded<Statement>> statements, Space eof) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.sourcePath = sourcePath;
            this.fileAttributes = fileAttributes;
            this.charsetName = charsetName;
            this.charsetBomMarked = charsetBomMarked;
            this.checksum = checksum;
            this.imports = imports;
            this.statements = statements;
            this.eof = eof;
        }

        @Generated
        private CompilationUnit(@Nullable SoftReference<TypesInUse> typesInUse, @Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Path sourcePath, @Nullable FileAttributes fileAttributes, @Nullable String charsetName, boolean charsetBomMarked, @Nullable Checksum checksum, List<JRightPadded<J.Import>> imports, List<JRightPadded<Statement>> statements, Space eof) {
            this.typesInUse = typesInUse;
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.sourcePath = sourcePath;
            this.fileAttributes = fileAttributes;
            this.charsetName = charsetName;
            this.charsetBomMarked = charsetBomMarked;
            this.checksum = checksum;
            this.imports = imports;
            this.statements = statements;
            this.eof = eof;
        }

        @NonNull
        @Generated
        public CompilationUnit withId(UUID id) {
            return this.id == id ? this : new CompilationUnit(this.typesInUse, this.padding, id, this.prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.imports, this.statements, this.eof);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @NonNull
        @Generated
        public CompilationUnit withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.imports, this.statements, this.eof);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @NonNull
        @Generated
        public CompilationUnit withMarkers(Markers markers) {
            return this.markers == markers ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.imports, this.statements, this.eof);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @NonNull
        @Generated
        public CompilationUnit withSourcePath(Path sourcePath) {
            return this.sourcePath == sourcePath ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, this.markers, sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.imports, this.statements, this.eof);
        }

        @Generated
        public Path getSourcePath() {
            return this.sourcePath;
        }

        @NonNull
        @Generated
        public CompilationUnit withFileAttributes(@Nullable FileAttributes fileAttributes) {
            return this.fileAttributes == fileAttributes ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, this.markers, this.sourcePath, fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.imports, this.statements, this.eof);
        }

        @Generated
        public @Nullable FileAttributes getFileAttributes() {
            return this.fileAttributes;
        }

        @NonNull
        @Generated
        private CompilationUnit withCharsetName(@Nullable String charsetName) {
            return this.charsetName == charsetName ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, this.markers, this.sourcePath, this.fileAttributes, charsetName, this.charsetBomMarked, this.checksum, this.imports, this.statements, this.eof);
        }

        @NonNull
        @Generated
        public CompilationUnit withCharsetBomMarked(boolean charsetBomMarked) {
            return this.charsetBomMarked == charsetBomMarked ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, charsetBomMarked, this.checksum, this.imports, this.statements, this.eof);
        }

        @Generated
        public boolean isCharsetBomMarked() {
            return this.charsetBomMarked;
        }

        @NonNull
        @Generated
        public CompilationUnit withChecksum(@Nullable Checksum checksum) {
            return this.checksum == checksum ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, checksum, this.imports, this.statements, this.eof);
        }

        @Generated
        public @Nullable Checksum getChecksum() {
            return this.checksum;
        }

        @NonNull
        @Generated
        public CompilationUnit withEof(Space eof) {
            return this.eof == eof ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.imports, this.statements, eof);
        }

        @Generated
        public Space getEof() {
            return this.eof;
        }

        public static class Padding
        implements JavaSourceFile.Padding {
            private final CompilationUnit t;

            public List<JRightPadded<J.Import>> getImports() {
                return this.t.imports;
            }

            public CompilationUnit withImports(List<JRightPadded<J.Import>> imports) {
                return this.t.imports == imports ? this.t : new CompilationUnit(this.t.id, this.t.prefix, this.t.markers, this.t.sourcePath, this.t.fileAttributes, this.t.charsetName, this.t.charsetBomMarked, null, imports, this.t.statements, this.t.eof);
            }

            public List<JRightPadded<Statement>> getStatements() {
                return this.t.statements;
            }

            public CompilationUnit withStatements(List<JRightPadded<Statement>> statements) {
                return this.t.statements == statements ? this.t : new CompilationUnit(this.t.id, this.t.prefix, this.t.markers, this.t.sourcePath, this.t.fileAttributes, this.t.charsetName, this.t.charsetBomMarked, this.t.checksum, this.t.imports, statements, this.t.eof);
            }

            @Generated
            public Padding(CompilationUnit t) {
                this.t = t;
            }
        }
    }
}

